/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.inmemory.spring;

import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.config.EmbeddingStoreConfig;
import com.tencent.supersonic.common.util.ContextUtils;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.inmemory.spring.EmbeddingStoreProperties;
import dev.langchain4j.inmemory.spring.Properties;
import dev.langchain4j.store.embedding.BaseEmbeddingStoreFactory;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class InMemoryEmbeddingStoreFactory
extends BaseEmbeddingStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(InMemoryEmbeddingStoreFactory.class);
    public static final String PERSISTENT_FILE_PRE = "InMemory.";
    private Properties properties;

    public InMemoryEmbeddingStoreFactory(EmbeddingStoreConfig storeConfig) {
        this(InMemoryEmbeddingStoreFactory.createPropertiesFromConfig(storeConfig));
    }

    public InMemoryEmbeddingStoreFactory(Properties properties) {
        this.properties = properties;
    }

    private static Properties createPropertiesFromConfig(EmbeddingStoreConfig storeConfig) {
        Properties properties = new Properties();
        EmbeddingStoreProperties embeddingStore = new EmbeddingStoreProperties();
        BeanUtils.copyProperties((Object)storeConfig, (Object)embeddingStore);
        properties.setEmbeddingStore(embeddingStore);
        return properties;
    }

    public synchronized EmbeddingStore createEmbeddingStore(String collectionName) {
        InMemoryEmbeddingStore<Object> embeddingStore = this.reloadFromPersistFile(collectionName);
        if (Objects.isNull(embeddingStore)) {
            embeddingStore = new InMemoryEmbeddingStore();
        }
        return embeddingStore;
    }

    private InMemoryEmbeddingStore<TextSegment> reloadFromPersistFile(String collectionName) {
        Path filePath = this.getPersistPath(collectionName);
        if (Objects.isNull(filePath)) {
            return null;
        }
        InMemoryEmbeddingStore<TextSegment> embeddingStore = null;
        try {
            EmbeddingConfig embeddingConfig = ContextUtils.getBean(EmbeddingConfig.class);
            if (Files.exists(filePath, new LinkOption[0]) && !collectionName.equals(embeddingConfig.getMetaCollectionName()) && !collectionName.equals(embeddingConfig.getText2sqlCollectionName())) {
                embeddingStore = InMemoryEmbeddingStore.fromFile(filePath);
                embeddingStore.entries = new CopyOnWriteArraySet(embeddingStore.entries);
                log.info("embeddingStore reload from file:{}", (Object)filePath);
            }
        }
        catch (Exception e) {
            log.error("load persistFile error, persistFile:" + filePath, (Throwable)e);
        }
        return embeddingStore;
    }

    public synchronized void persistFile() {
        if (MapUtils.isEmpty(BaseEmbeddingStoreFactory.collectionNameToStore)) {
            return;
        }
        for (Map.Entry entry : collectionNameToStore.entrySet()) {
            Path filePath = this.getPersistPath((String)entry.getKey());
            if (Objects.isNull(filePath)) continue;
            try {
                Path directoryPath = filePath.getParent();
                if (!Files.exists(directoryPath, new LinkOption[0])) {
                    Files.createDirectories(directoryPath, new FileAttribute[0]);
                }
                if (!(entry.getValue() instanceof InMemoryEmbeddingStore)) continue;
                InMemoryEmbeddingStore inMemoryEmbeddingStore = (InMemoryEmbeddingStore)entry.getValue();
                inMemoryEmbeddingStore.serializeToFile(filePath);
            }
            catch (Exception e) {
                log.error("persistFile error, persistFile:" + filePath, (Throwable)e);
            }
        }
    }

    private Path getPersistPath(String collectionName) {
        String persistFile = PERSISTENT_FILE_PRE + collectionName;
        String persistPath = this.properties.getEmbeddingStore().getPersistPath();
        if (StringUtils.isEmpty((CharSequence)persistPath)) {
            return null;
        }
        return Paths.get(persistPath, persistFile);
    }
}

