/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import dev.ai4j.openai4j.chat.ChatCompletionModel;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.model.zhipu.ZhipuAiClient;
import dev.langchain4j.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.model.zhipu.shared.Usage;
import dev.langchain4j.model.zhipu.spi.ZhipuAiChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ZhipuAiChatModel
implements ChatLanguageModel {
    private final String baseUrl;
    private final Double temperature;
    private final Double topP;
    private final String model;
    private final Integer maxRetries;
    private final Integer maxToken;
    private final ZhipuAiClient client;

    public ZhipuAiChatModel(String baseUrl, String apiKey, Double temperature, Double topP, String model, Integer maxRetries, Integer maxToken, Boolean logRequests, Boolean logResponses) {
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/");
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.model = (String)Utils.getOrDefault((Object)model, (Object)ChatCompletionModel.GPT_4.toString());
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.maxToken = (Integer)Utils.getOrDefault((Object)maxToken, (Object)512);
        this.client = ZhipuAiClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public static ZhipuAiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiChatModelBuilderFactory factories = (ZhipuAiChatModelBuilderFactory)iterator.next();
            return (ZhipuAiChatModelBuilder)factories.get();
        }
        return new ZhipuAiChatModelBuilder();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, (ToolSpecification)null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(this.model).maxTokens(this.maxToken).stream(Boolean.valueOf(false)).topP(this.topP).toolChoice(ToolChoiceMode.AUTO).messages(DefaultZhipuAiHelper.toZhipuAiMessages(messages));
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            requestBuilder.tools(DefaultZhipuAiHelper.toTools(toolSpecifications));
        }
        ChatCompletionResponse response = (ChatCompletionResponse)RetryUtils.withRetry(() -> this.client.chatCompletion(requestBuilder.build()), (int)this.maxRetries);
        return Response.from((Object)DefaultZhipuAiHelper.aiMessageFrom((ChatCompletionResponse)response), (TokenUsage)DefaultZhipuAiHelper.tokenUsageFrom((Usage)response.getUsage()), (FinishReason)DefaultZhipuAiHelper.finishReasonFrom((String)((ChatCompletionChoice)response.getChoices().get(0)).getFinishReason()));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, toolSpecification != null ? Collections.singletonList(toolSpecification) : null);
    }

    public static class ZhipuAiChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Double temperature;
        private Double topP;
        private String model;
        private Integer maxRetries;
        private Integer maxToken;
        private Boolean logRequests;
        private Boolean logResponses;

        public ZhipuAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ZhipuAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ZhipuAiChatModelBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ZhipuAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ZhipuAiChatModelBuilder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }

        public ZhipuAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiChatModel build() {
            return new ZhipuAiChatModel(this.baseUrl, this.apiKey, this.temperature, this.topP, this.model, this.maxRetries, this.maxToken, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "ZhipuAiChatModel.ZhipuAiChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", temperature=" + this.temperature + ", topP=" + this.topP + ", model=" + this.model + ", maxRetries=" + this.maxRetries + ", maxToken=" + this.maxToken + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

