/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.provider;

import com.tencent.supersonic.common.config.ChatModelConfig;
import com.tencent.supersonic.common.config.EmbeddingModelConfig;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.dashscope.QwenChatModel;
import dev.langchain4j.model.dashscope.QwenEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.provider.ModelFactory;
import dev.langchain4j.provider.ModelProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class DashscopeModelFactory
implements ModelFactory,
InitializingBean {
    public static final String PROVIDER = "DASHSCOPE";

    @Override
    public ChatLanguageModel createChatModel(ChatModelConfig modelConfig) {
        return QwenChatModel.builder().baseUrl(modelConfig.getBaseUrl()).apiKey(modelConfig.getApiKey()).modelName(modelConfig.getModelName()).temperature(Float.valueOf(modelConfig.getTemperature() == null ? 0.0f : modelConfig.getTemperature().floatValue())).build();
    }

    @Override
    public EmbeddingModel createEmbeddingModel(EmbeddingModelConfig embeddingModelConfig) {
        return QwenEmbeddingModel.builder().apiKey(embeddingModelConfig.getApiKey()).modelName(embeddingModelConfig.getModelName()).build();
    }

    public void afterPropertiesSet() {
        ModelProvider.add(PROVIDER, this);
    }
}

