/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.provider;

import com.tencent.supersonic.common.config.ChatModelConfig;
import com.tencent.supersonic.common.config.EmbeddingModelConfig;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.AllMiniLmL6V2QuantizedEmbeddingModel;
import dev.langchain4j.model.embedding.BgeSmallZhEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.S2OnnxEmbeddingModel;
import dev.langchain4j.provider.ModelFactory;
import dev.langchain4j.provider.ModelProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class InMemoryModelFactory
implements ModelFactory,
InitializingBean {
    public static final String PROVIDER = "IN_MEMORY";

    @Override
    public ChatLanguageModel createChatModel(ChatModelConfig modelConfig) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EmbeddingModel createEmbeddingModel(EmbeddingModelConfig embeddingModel) {
        String modelPath = embeddingModel.getModelPath();
        String vocabularyPath = embeddingModel.getVocabularyPath();
        if (StringUtils.isNotBlank((CharSequence)modelPath) && StringUtils.isNotBlank((CharSequence)vocabularyPath)) {
            return new S2OnnxEmbeddingModel(modelPath, vocabularyPath);
        }
        String modelName = embeddingModel.getModelName();
        if ("bge-small-zh".equalsIgnoreCase(modelName)) {
            return new BgeSmallZhEmbeddingModel();
        }
        if ("all-minilm-l6-v2-q".equalsIgnoreCase(modelName)) {
            return new AllMiniLmL6V2QuantizedEmbeddingModel();
        }
        return new BgeSmallZhEmbeddingModel();
    }

    public void afterPropertiesSet() {
        ModelProvider.add(PROVIDER, this);
    }
}

