/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.provider;

import com.tencent.supersonic.common.config.ChatModelConfig;
import com.tencent.supersonic.common.config.EmbeddingModelConfig;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.localai.LocalAiChatModel;
import dev.langchain4j.model.localai.LocalAiEmbeddingModel;
import dev.langchain4j.provider.ModelFactory;
import dev.langchain4j.provider.ModelProvider;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class LocalAiModelFactory
implements ModelFactory,
InitializingBean {
    public static final String PROVIDER = "LOCAL_AI";

    @Override
    public ChatLanguageModel createChatModel(ChatModelConfig modelConfig) {
        return LocalAiChatModel.builder().baseUrl(modelConfig.getBaseUrl()).modelName(modelConfig.getModelName()).temperature(modelConfig.getTemperature()).timeout(Duration.ofSeconds(modelConfig.getTimeOut())).build();
    }

    @Override
    public EmbeddingModel createEmbeddingModel(EmbeddingModelConfig embeddingModel) {
        return LocalAiEmbeddingModel.builder().baseUrl(embeddingModel.getBaseUrl()).modelName(embeddingModel.getModelName()).build();
    }

    public void afterPropertiesSet() {
        ModelProvider.add(PROVIDER, this);
    }
}

