/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.provider;

import com.tencent.supersonic.common.config.ChatModelConfig;
import com.tencent.supersonic.common.config.EmbeddingModelConfig;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import dev.langchain4j.provider.ModelFactory;
import dev.langchain4j.provider.ModelProvider;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OllamaModelFactory
implements ModelFactory,
InitializingBean {
    public static final String PROVIDER = "OLLAMA";

    @Override
    public ChatLanguageModel createChatModel(ChatModelConfig modelConfig) {
        return OllamaChatModel.builder().baseUrl(modelConfig.getBaseUrl()).modelName(modelConfig.getModelName()).temperature(modelConfig.getTemperature()).timeout(Duration.ofSeconds(modelConfig.getTimeOut())).build();
    }

    @Override
    public EmbeddingModel createEmbeddingModel(EmbeddingModelConfig embeddingModelConfig) {
        return OllamaEmbeddingModel.builder().baseUrl(embeddingModelConfig.getBaseUrl()).modelName(embeddingModelConfig.getModelName()).maxRetries(embeddingModelConfig.getMaxRetries()).logRequests(embeddingModelConfig.getLogRequests()).logResponses(embeddingModelConfig.getLogResponses()).build();
    }

    public void afterPropertiesSet() {
        ModelProvider.add(PROVIDER, this);
    }
}

