/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.provider;

import com.tencent.supersonic.common.config.ChatModelConfig;
import com.tencent.supersonic.common.config.EmbeddingModelConfig;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.provider.ModelFactory;
import dev.langchain4j.provider.ModelProvider;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OpenAiModelFactory
implements ModelFactory,
InitializingBean {
    public static final String PROVIDER = "OPEN_AI";

    @Override
    public ChatLanguageModel createChatModel(ChatModelConfig modelConfig) {
        return OpenAiChatModel.builder().baseUrl(modelConfig.getBaseUrl()).modelName(modelConfig.getModelName()).apiKey(modelConfig.keyDecrypt()).temperature(modelConfig.getTemperature()).timeout(Duration.ofSeconds(modelConfig.getTimeOut())).build();
    }

    @Override
    public EmbeddingModel createEmbeddingModel(EmbeddingModelConfig embeddingModel) {
        return OpenAiEmbeddingModel.builder().baseUrl(embeddingModel.getBaseUrl()).apiKey(embeddingModel.getApiKey()).modelName(embeddingModel.getModelName()).maxRetries(embeddingModel.getMaxRetries()).logRequests(embeddingModel.getLogRequests()).logResponses(embeddingModel.getLogResponses()).build();
    }

    public void afterPropertiesSet() {
        ModelProvider.add(PROVIDER, this);
    }
}

