/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.dto.PurchaseContractContentItemDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.service.PurchaseContractContentItemService;
import com.els.modules.contract.service.PurchaseContractHeadRpcService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseContractHeadSingleServiceImpl
implements PurchaseContractHeadRpcService {
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Autowired
    private PurchaseContractItemService purchaseContractItemService;
    @Autowired
    private PurchaseContractContentItemService purchaseContractContentItemService;

    public void delMain(String id) {
        this.purchaseContractHeadService.delMain(id);
    }

    public void delBatchMain(List<String> idList) {
        this.purchaseContractHeadService.delBatchMain(idList);
    }

    public void publish(String id) {
        this.purchaseContractHeadService.publish(id);
    }

    public void upgradeVersion(String id) {
        this.purchaseContractHeadService.upgradeVersion(id);
    }

    public void updateStatus(PurchaseContractHeadDTO contractBuyHead) {
        this.purchaseContractHeadService.updateStatus((PurchaseContractHead)SysUtil.copyProperties((Object)contractBuyHead, PurchaseContractHead.class));
    }

    public PurchaseContractHeadDTO getById(String id) {
        return (PurchaseContractHeadDTO)SysUtil.copyProperties((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)), PurchaseContractHeadDTO.class);
    }

    public PurchaseContractHeadDTO getByNumber(String contractNumber) {
        QueryWrapper contractHeadQueryWrapper = new QueryWrapper();
        contractHeadQueryWrapper.eq((Object)"contract_number", (Object)contractNumber);
        contractHeadQueryWrapper.last(" limit 1");
        PurchaseContractHead head = (PurchaseContractHead)this.purchaseContractHeadService.getOne((Wrapper)contractHeadQueryWrapper);
        PurchaseContractHeadDTO headDTO = null;
        if (head != null) {
            headDTO = new PurchaseContractHeadDTO();
            BeanUtils.copyProperties((Object)head, (Object)headDTO);
        }
        return headDTO;
    }

    public List<PurchaseContractItemDTO> getItemListByMainId(String id) {
        return SysUtil.copyProperties((List)this.purchaseContractItemService.selectByMainId(id), PurchaseContractItemDTO.class);
    }

    public List<PurchaseContractContentItemDTO> getContentItemListByMainId(String id) {
        return SysUtil.copyProperties((List)this.purchaseContractContentItemService.selectByMainId(id), PurchaseContractContentItemDTO.class);
    }

    public void updateEntityById(PurchaseContractHeadDTO purchaseContractHeadDTO) {
        this.purchaseContractHeadService.updateById(SysUtil.copyProperties((Object)purchaseContractHeadDTO, PurchaseContractHead.class));
    }

    public JSONObject listContractItem(Integer pageNo, Integer pageSize, String elsAccount, String toElsAccount, String company, String purchaseOrg, String payWay, String paymentClause, String keyword, String currency) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        String sql = "SELECT contract_number FROM purchase_contract_head WHERE els_account = '" + TenantContext.getTenant() + "' ";
        if (!StringUtils.isEmpty((CharSequence)keyword)) {
            sql = sql + "  AND contract_number = '" + keyword + "'";
        }
        sql = sql + "  AND to_els_account = '" + toElsAccount + "' AND company = '" + company;
        if (!StringUtils.isEmpty((CharSequence)purchaseOrg)) {
            sql = sql + "' AND purchase_org = '" + purchaseOrg;
        }
        sql = sql + "' AND (is_deleted IS NULL OR is_deleted = '0')";
        wrapper.inSql((Object)"contract_number", sql);
        wrapper.eq((Object)"contract_status", (Object)"6");
        wrapper.eq((Object)"currency", (Object)currency);
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)wrapper);
        return JSONObject.parseObject((String)JSON.toJSONString((Object)pageList));
    }

    public List<PurchaseContractHeadDTO> selectTenderContractBySubpackageId(String subpackageId, List<String> supplierAccountList) {
        List purchaseContractHeadList = this.purchaseContractHeadService.selectTenderContractBySubpackageId(subpackageId, supplierAccountList);
        ArrayList purchaseContractHeadDTOS = SysUtil.copyProperties((List)purchaseContractHeadList, PurchaseContractHeadDTO.class);
        return purchaseContractHeadDTOS;
    }
}

