/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.rpc.service.impl;

import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.exchange.rpc.dto.BpExchangeRateDTO;
import com.els.modules.exchange.rpc.srevice.BpExchangeRateRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.service.PurchaseInformationRecordsRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractInvokeMainDataRpcServiceImpl
implements ContractInvokeMainDataRpcService {
    @Resource
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;
    @Resource
    private BpExchangeRateRpcService bpExchangeRateRpcService;
    @Resource
    private PurchaseInformationRecordsRpcService purchaseInformationRecordsRpcService;
    @Autowired(required=false)
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;

    public PurchaseMaterialHeadDTO getMaterialHeadByNumber(String materialNumber) {
        return this.purchaseMaterialHeadRpcService.getMaterialHeadByNumber(materialNumber);
    }

    public List<PurchaseMaterialHeadDTO> listByMaterialNumbers(List<String> materialNumberList) {
        return this.purchaseMaterialHeadRpcService.listByMaterialNumbers(materialNumberList);
    }

    public List<PurchaseMaterialHeadDTO> listByMaterialIds(List<String> materialIdsList) {
        return this.purchaseMaterialHeadRpcService.listByMaterialIds(materialIdsList);
    }

    public List<PurchaseInformationRecordsDTO> generatePrice(TemplateHeadDTO templateHeadDTO, PurchaseContractHead head, List<PurchaseContractItem> contractItems) {
        PurchaseContractHeadDTO purchaseContractHeadDTO = (PurchaseContractHeadDTO)SysUtil.copyProperties((Object)head, PurchaseContractHeadDTO.class);
        ArrayList itemDTOList = SysUtil.copyProperties(contractItems, PurchaseContractItemDTO.class);
        return this.purchaseInformationRecordsRpcService.generatePrice(templateHeadDTO, purchaseContractHeadDTO, (List)itemDTOList);
    }

    public PurchaseOrganizationInfoDTO selectByElsAccountAndCode(String elsAccount, String orgCategoryCode, String orgCode) {
        return this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(elsAccount, orgCategoryCode, orgCode);
    }

    public PurchaseOrganizationInfoDTO selectById(String id) {
        return this.purchaseOrganizationInfoRpcService.selectById(id);
    }

    public List<PurchaseOrganizationInfoDTO> listByElsAccountAndCode(String elsAccount, List<String> orgCodeList) {
        return this.purchaseOrganizationInfoRpcService.listByElsAccountAndCode(elsAccount, orgCodeList);
    }

    public Map<String, String> listDeptOrganization(List<String> ids) {
        return this.purchaseOrganizationInfoRpcService.listDeptOrganization(ids);
    }

    public Map<String, String> getDeptOrganization(String elsAccount) {
        return this.purchaseOrganizationInfoRpcService.getDeptOrganization(elsAccount);
    }

    public boolean checkOrgCode(String orgCode) {
        return this.purchaseOrganizationInfoRpcService.checkOrgCode(orgCode);
    }

    public List<BpExchangeRateDTO> getEffectiveRateByCurrencys(List<String> currencyList) {
        return this.bpExchangeRateRpcService.getEffectiveRateByCurrencys(currencyList);
    }
}

