/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.util.PermissionDataQueryUtil;
import com.els.modules.api.service.ContractTodoListRpcService;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.service.PurchaseContractHeadHisService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.service.SaleContractPromiseService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ContractTodoListSingleServiceImpl
implements ContractTodoListRpcService {
    @Lazy
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private PurchaseContractHeadHisService purchaseContractHeadHisService;
    @Resource
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Lazy
    @Resource
    private SaleContractHeadService saleContractHeadService;
    @Lazy
    @Resource
    private SaleContractPromiseService saleContractPromiseService;
    @Autowired
    private PermissionDataQueryUtil permissionDataQueryUtil;

    public Integer countPurchaseContractHeadList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new PurchaseContractHead(), new HashMap());
        String accountNumber = this.permissionDataQueryUtil.getAccount(accountBusinessType);
        if (!StrUtil.isBlank((CharSequence)accountNumber)) {
            queryWrapper.eq((Object)"create_by", (Object)accountNumber);
        }
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"contract_status", statusList);
        queryWrapper.ne((Object)"contract_type", (Object)"3");
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        int count = this.purchaseContractHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countPurchaseContractHeadHisList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new PurchaseContractHead(), new HashMap());
        String accountNumber = this.permissionDataQueryUtil.getAccount(accountBusinessType);
        if (!StrUtil.isBlank((CharSequence)accountNumber)) {
            queryWrapper.eq((Object)"create_by", (Object)accountNumber);
        }
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"contract_status", statusList);
        queryWrapper.eq((Object)"contract_type", (Object)"3");
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        int count = this.purchaseContractHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countPurchaseContractPromiseList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new PurchaseContractPromise(), new HashMap());
        queryWrapper.in((Object)"promise_status", statusList);
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        String promiseType = "promisePurchase";
        if (statusList.contains("1")) {
            promiseType = "promiseSale";
        } else if (statusList.contains("4")) {
            promiseType = "promisePurchase";
            String accountNumber = this.permissionDataQueryUtil.getAccount(accountBusinessType);
            if (!StrUtil.isBlank((CharSequence)accountNumber)) {
                queryWrapper.eq((Object)"create_by", (Object)accountNumber);
            }
        }
        queryWrapper.exists("select 1 from purchase_contract_head where purchase_contract_head.contract_number = purchase_contract_promise.contract_number and els_account = '" + elsAccount + "' and promise_type = '" + promiseType + "' and is_deleted = '0'");
        return this.purchaseContractPromiseService.count((Wrapper)queryWrapper);
    }

    public Integer countSaleContractHeadList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new SaleContractHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"contract_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        int count = this.saleContractHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleContractPromiseList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new SaleContractPromise(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"promise_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        String promiseType = "promisePurchase";
        if (statusList.contains("1")) {
            promiseType = "promisePurchase";
        } else if (statusList.contains("4")) {
            promiseType = "promiseSale";
        }
        queryWrapper.exists("select 1 from sale_contract_head where sale_contract_head.contract_number = sale_contract_promise.contract_number and els_account = '" + elsAccount + "' and promise_type = '" + promiseType + "' and is_deleted = '0'");
        int count = this.saleContractPromiseService.count((Wrapper)queryWrapper);
        return count;
    }
}

