/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseContractPromiseServiceImpl
extends BaseServiceImpl<PurchaseContractPromiseMapper, PurchaseContractPromise>
implements PurchaseContractPromiseService {
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public List<PurchaseContractPromise> selectByMainId(String mainId) {
        return this.purchaseContractPromiseMapper.selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void savePurchaseContractPromise(PurchaseContractPromise purchaseContractPromise) {
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)purchaseContractPromise);
            purchaseContractPromise.setPromiseNumber(nextCode);
        }
        purchaseContractPromise.setBusAccount(TenantContext.getTenant());
        super.setHeadDefaultValue((BaseEntity)purchaseContractPromise);
        String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
        if ("0".equals(purchaseContractPromise.getAudit())) {
            auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        }
        purchaseContractPromise.setAuditStatus(auditStatus);
        ((PurchaseContractPromiseMapper)this.baseMapper).insert((Object)purchaseContractPromise);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updatePurchaseContractPromise(PurchaseContractPromise purchaseContractPromise) {
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getFlowId())) {
            String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
            if ("0".equals(purchaseContractPromise.getAudit())) {
                auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
            }
            purchaseContractPromise.setAuditStatus(auditStatus);
        }
        ((PurchaseContractPromiseMapper)this.baseMapper).updateById((Object)purchaseContractPromise);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delPurchaseContractPromise(String id) {
        ((PurchaseContractPromiseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchPurchaseContractPromise(List<String> idList) {
        ((PurchaseContractPromiseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishEvent(PurchaseContractPromise purchaseContractPromise) {
        PurchaseContractPromise purchaseContractPromise1 = (PurchaseContractPromise)((Object)this.purchaseContractPromiseMapper.selectById((Serializable)((Object)purchaseContractPromise.getId())));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseContractPromise1.getHeadId()), (String)"\u8bf7\u9009\u62e9\u5408\u540c");
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)purchaseContractPromise1.getHeadId())));
        SaleContractPromise saleContractPromise = new SaleContractPromise();
        BeanUtil.copyProperties((Object)((Object)purchaseContractPromise), (Object)((Object)saleContractPromise), (String[])new String[0]);
        if ("1".equals(purchaseContractPromise.getSupplierConfirm())) {
            saleContractPromise.setPromiseStatus(ContractPromiseStatusEnum.CONTRACT_PROMISE_CONFIRMING.getValue());
        } else {
            saleContractPromise.setPromiseStatus(ContractPromiseStatusEnum.CONFIRMED.getValue());
        }
        saleContractPromise.setHeadId(purchaseContractHead.getRelationId());
        saleContractPromise.setElsAccount(purchaseContractHead.getToElsAccount());
        saleContractPromise.setToElsAccount(purchaseContractHead.getElsAccount());
        if (ContractPromiseStatusEnum.REFUND.getValue().equals(purchaseContractPromise1.getPromiseStatus())) {
            this.saleContractPromiseService.updateById((Object)saleContractPromise);
        } else {
            saleContractPromise.setId(IdWorker.getIdStr());
            this.saleContractPromiseService.save((Object)saleContractPromise);
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getFlowId())) {
            String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
            if ("0".equals(purchaseContractPromise.getAudit())) {
                auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
            }
            purchaseContractPromise.setAuditStatus(auditStatus);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseContractPromise.getId())).set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CONTRACT_PROMISE_CONFIRMING.getValue())).set(PurchaseContractPromise::getAuditStatus, (Object)purchaseContractPromise.getAuditStatus())).update();
    }
}

