/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.contract.controller.PurchaseContractHeadHisController;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.enumerate.ContractPromiseTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.excel.PurchaseContractHeadExportServiceImpl;
import com.els.modules.contract.rpc.service.ContractInvokeOrderRpcService;
import com.els.modules.contract.service.ContractItemCustom1Service;
import com.els.modules.contract.service.ContractItemCustom2Service;
import com.els.modules.contract.service.ContractItemCustom3Service;
import com.els.modules.contract.service.ContractItemCustom4Service;
import com.els.modules.contract.service.ContractItemCustom5Service;
import com.els.modules.contract.service.PurchaseContractContentItemService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractItemService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.utils.PdfUtil;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/contract/purchaseContractHead"})
@Api(tags={"\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd"})
public class PurchaseContractHeadController
extends BaseController<PurchaseContractHead, PurchaseContractHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractHeadController.class);
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Autowired
    private PurchaseContractItemService purchaseContractItemService;
    @Autowired
    private PurchaseContractContentItemService purchaseContractContentItemService;
    @Autowired
    private PurchaseContractHeadHisController purchaseContractHeadHisController;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ContractInvokeOrderRpcService contractInvokeOrderRpcService;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private ContractItemCustom1Service contractItemCustom1Service;
    @Autowired
    private ContractItemCustom2Service contractItemCustom2Service;
    @Autowired
    private ContractItemCustom3Service contractItemCustom3Service;
    @Autowired
    private ContractItemCustom4Service contractItemCustom4Service;
    @Autowired
    private ContractItemCustom5Service contractItemCustom5Service;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="contract")
    public Result<?> queryPageList(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().ne(PurchaseContractHead::getContractType, (Object)"3");
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/listSimple"})
    @PermissionDataView(businessType="contract")
    public Result<?> listSimple(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(PurchaseContractHead::getContractType, (Object)"3");
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5a23\u8bf2\u59de", notes="\u5a23\u8bf2\u59de")
    @PostMapping(value={"/add"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u5a23\u8bf2\u59de")
    @RequiresPermissions(value={"purchaseContractHead:add"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> add(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.saveMain(purchaseContractHead, purchaseContractHeadPage.getPurchaseContractItemList(), purchaseContractHeadPage.getPurchaseContractContentItemList(), purchaseContractHeadPage.getPurchaseAttachmentList(), purchaseContractHeadPage.getPurchaseContractPromiseList(), purchaseContractHeadPage.getContractItemCustom1List(), purchaseContractHeadPage.getContractItemCustom2List(), purchaseContractHeadPage.getContractItemCustom3List(), purchaseContractHeadPage.getContractItemCustom4List(), purchaseContractHeadPage.getContractItemCustom5List());
        return Result.ok((Object)((Object)purchaseContractHead));
    }

    @ApiOperation(value="\u947e\u5cf0\u5f47\u6d93\u3084\u91dc\u935a\u581d\u6093\u93c2\u56e8\u6e70\u9428\u52eb\u608e\u935a\u5c7e\u6783\u93c8\ufffd", notes="\u947e\u5cf0\u5f47\u6d93\u3084\u91dc\u935a\u581d\u6093\u93c2\u56e8\u6e70\u9428\u52eb\u608e\u935a\u5c7e\u6783\u93c8\ufffd")
    @GetMapping(value={"/diffContractContent"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> diffContractContent(@RequestParam(name="id", required=true) String id, @RequestParam(name="newId", required=true) String newId, @RequestParam(name="type", required=true) String type) {
        PurchaseContractContentItem purchaseContractContentItem = new PurchaseContractContentItem();
        purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
        purchaseContractContentItem.setOriginalContent(this.purchaseContractHeadHisController.getHtmlById(id).toString());
        if ("head".equals(type)) {
            purchaseContractContentItem.setItemContent(this.purchaseContractHeadHisController.getHtmlById(newId).toString());
        } else {
            purchaseContractContentItem.setItemContent(this.getHtmlById(newId).toString());
        }
        return Result.ok((Object)((Object)purchaseContractContentItem));
    }

    @ApiOperation(value="\u7f02\u682c\u7deb", notes="\u7f02\u682c\u7deb")
    @PostMapping(value={"/edit"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u7f02\u682c\u7deb")
    @RequiresPermissions(value={"purchaseContractHead:edit"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> edit(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.updateMain(purchaseContractHead, purchaseContractHeadPage.getPurchaseContractItemList(), purchaseContractHeadPage.getPurchaseContractContentItemList(), purchaseContractHeadPage.getPurchaseAttachmentList(), purchaseContractHeadPage.getPurchaseContractPromiseList(), purchaseContractHeadPage.getContractItemCustom1List(), purchaseContractHeadPage.getContractItemCustom2List(), purchaseContractHeadPage.getContractItemCustom3List(), purchaseContractHeadPage.getContractItemCustom4List(), purchaseContractHeadPage.getContractItemCustom5List());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u6d63\u6ec3\u7c3e", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u6d63\u6ec3\u7c3e")
    @PostMapping(value={"/cancel"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u6d63\u6ec3\u7c3e")
    @RequiresPermissions(value={"purchaseContractHead:cancel"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> cancel(@RequestBody PurchaseContractHeadVO head) {
        head.setContractStatus(ContractStatusEnum.CANCEL.getValue());
        this.purchaseContractHeadService.updateStatus(head);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u8930\u6393\u3002", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u8930\u6393\u3002")
    @PostMapping(value={"/archive"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u8930\u6393\u3002")
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> archive(@RequestBody PurchaseContractHeadVO head) {
        head.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
        this.purchaseContractHeadService.updateStatus(head);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093-\u9352\u6d98\u7f13\u7481\u3220\u5d1f", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u9352\u6d98\u7f13\u7481\u3220\u5d1f")
    @PostMapping(value={"/createOrderByItems"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u9352\u6d98\u7f13\u7481\u3220\u5d1f")
    public Result<?> createOrderByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseOrderHeadDTO> orderHeadDTOList = this.purchaseContractHeadService.createOrderByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseOrderHeadDTO purchaseOrderHeadVO : orderHeadDTOList) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getOrderNumber());
        }
        return Result.ok((String)("\u675e\ue103\ue179\u9357\u66df\u579a\u9354\ufffd,\u93b4\u612c\u59db\u675e\ue103\ue179\u9357\u66de\u5d1f\u93c1\ufffd:" + orderHeadDTOList.size() + ",\u9357\u66de\u5f7f\u9352\u55d7\u57c6\u6d93\ufffd:" + stringBuffer.toString()));
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093-\u9352\u6d98\u7f13\u705e\u30e7\u5bb3\u9357\ufffd", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u9352\u6d98\u7f13\u705e\u30e7\u5bb3\u9357\ufffd")
    @PostMapping(value={"/createPromiseByItems"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u9352\u6d98\u7f13\u705e\u30e7\u5bb3\u9357\ufffd")
    public Result<?> createPromiseByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseContractPromiseVO> orderHeadDTOList = this.purchaseContractHeadService.createPromiseByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseContractPromiseVO purchaseOrderHeadVO : orderHeadDTOList) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getPromiseNumber());
        }
        return Result.ok((String)("\u675e\ue100\u9971\u7efe\ufe40\u5d1f\u93b4\u612c\u59db,\u93b4\u612c\u59db\u675e\ue100\u9971\u7efe\ufe40\u5d1f\u9357\u66df\u669f:" + orderHeadDTOList.size() + ",\u9357\u66de\u5f7f\u9352\u55d7\u57c6\u6d93\ufffd:" + stringBuffer.toString()));
    }

    @ApiOperation(value="\u95ab\u6c33\u7e43id\u9352\u72bb\u6ace", notes="\u95ab\u6c33\u7e43id\u9352\u72bb\u6ace")
    @GetMapping(value={"/delete"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u9352\u72bb\u6ace")
    @RequiresPermissions(value={"purchaseContractHead:delete"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u93b5\u5f52\u567a\u9352\u72bb\u6ace")
    @ApiOperation(value="\u93b5\u5f52\u567a\u9352\u72bb\u6ace", notes="\u93b5\u5f52\u567a\u9352\u72bb\u6ace")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseContractHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u95ab\u6c33\u7e43id\u93cc\u30e8\ue1d7", notes="\u95ab\u6c33\u7e43id\u93cc\u30e8\ue1d7")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        PurchaseContractHeadVO purchaseContractHeadVO = new PurchaseContractHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHead), (Object)((Object)purchaseContractHeadVO));
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemService.selectByMainId(id);
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemService.selectByMainId(id);
        purchaseContractHeadVO.setPurchaseContractContentItemList(purchaseContractContentItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        List<PurchaseContractPromise> purchaseContractPromiseList = this.purchaseContractPromiseService.selectByMainId(id);
        List<PurchaseContractPromise> collect1 = purchaseContractPromiseList.parallelStream().filter(item -> ContractPromiseStatusEnum.CONFIRMED.getValue().equals(item.getPromiseStatus())).collect(Collectors.toList());
        purchaseContractHeadVO.setPurchaseContractPromiseList(collect1);
        List<ContractItemCustom1> contractItemCustom1List = this.contractItemCustom1Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom1List(contractItemCustom1List);
        List<ContractItemCustom2> contractItemCustom2List = this.contractItemCustom2Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom2List(contractItemCustom2List);
        List<ContractItemCustom3> contractItemCustom3List = this.contractItemCustom3Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom3List(contractItemCustom3List);
        List<ContractItemCustom4> contractItemCustom4List = this.contractItemCustom4Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom4List(contractItemCustom4List);
        List<ContractItemCustom5> contractItemCustom5List = this.contractItemCustom5Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom5List(contractItemCustom5List);
        if (ContractPromiseTypeEnum.ORDER.getValue().equals(purchaseContractHead.getPromiseType()) && !CollectionUtils.isEmpty(purchaseContractItemList)) {
            List<String> collect = purchaseContractItemList.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            List<PurchaseOrderItemDTO> purchaseOrderItemDTOList = this.contractInvokeOrderRpcService.listItemBySourceItemId(collect);
            purchaseContractHeadVO.setOrderItemList(purchaseOrderItemDTOList);
        }
        purchaseContractHeadVO.setPurchaseContractItemList(purchaseContractItemList);
        this.calculateTraget(purchaseContractHeadVO);
        return Result.ok((Object)((Object)purchaseContractHeadVO));
    }

    private void calculateTraget(PurchaseContractHeadVO purchaseContractHeadVO) {
        String contractType = purchaseContractHeadVO.getContractType();
        String promiseType = purchaseContractHeadVO.getPromiseType();
        if (StringUtils.isBlank((CharSequence)contractType) || StringUtils.isBlank((CharSequence)promiseType)) {
            return;
        }
        List<PurchaseContractPromise> promiseList = purchaseContractHeadVO.getPurchaseContractPromiseList();
        if (ContractTypeEnum.NORMAL.getValue().equals(contractType)) {
            if (ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType)) {
                List<PurchaseOrderItemDTO> orderItemList = purchaseContractHeadVO.getOrderItemList();
                if (!CollectionUtils.isEmpty(orderItemList)) {
                    BigDecimal reduce = orderItemList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
                }
            } else if (!CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        } else if (ContractTypeEnum.FRAME.getValue().equals(contractType)) {
            if (ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType)) {
                List<PurchaseOrderItemDTO> orderItemList = purchaseContractHeadVO.getOrderItemList();
                if (!CollectionUtils.isEmpty(orderItemList)) {
                    Object reduce;
                    for (PurchaseContractItem purchaseContractItem : purchaseContractHeadVO.getPurchaseContractItemList()) {
                        BigDecimal total = BigDecimal.ZERO;
                        if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHeadVO.getTargetType())) {
                            BigDecimal amount = orderItemList.parallelStream().filter(item -> purchaseContractItem.getId().equals(item.getSourceItemId())).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            purchaseContractItem.setTargetQuantityAlready(amount);
                            continue;
                        }
                        BigDecimal quantity = orderItemList.parallelStream().filter(item -> purchaseContractItem.getId().equals(item.getSourceItemId())).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractItem.setTargetQuantityAlready(quantity);
                    }
                    if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHeadVO.getTargetType())) {
                        reduce = orderItemList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractHeadVO.setTargetQuantityAlready(((BigDecimal)reduce).toString());
                    } else {
                        reduce = orderItemList.parallelStream().filter(item -> item.getQuantity() != null).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractHeadVO.setTargetQuantityAlready(((BigDecimal)reduce).toString());
                    }
                }
            } else if (!CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        }
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u95ab\u6c33\u7e43id\u947e\u5cf0\u5f47\u68f0\u52ee\ue74d\u93c1\u7248\u5d41", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u95ab\u6c33\u7e43id\u947e\u5cf0\u5f47\u68f0\u52ee\ue74d\u93c1\u7248\u5d41")
    @GetMapping(value={"/getPreviewData"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> getPreviewData(@RequestParam(name="id", required=true) String id) {
        return Result.ok((Object)this.getHtmlById(id));
    }

    private StringBuilder getHtmlById(String id) {
        Result<?> result = this.queryById(id);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText(result);
        PurchaseContractHeadVO purchaseContractHeadVO = (PurchaseContractHeadVO)((Object)JSON.parseObject((String)result.getResult().toString(), PurchaseContractHeadVO.class));
        JSONObject jsonObject = (JSONObject)result.getResult();
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemList"));
        param.put("pageBreak", "<div style=\"page-break-after:always; \"></div>");
        List<PurchaseContractContentItem> contractBuyContentItemList = purchaseContractHeadVO.getPurchaseContractContentItemList();
        if (CollectionUtils.isEmpty(contractBuyContentItemList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_saveBeforePreview", (String)"\u7487\u8702\u7e5a\u701b\u6a3b\u6f6f\u5a06\u6350\ue511\u935a\u5ea8\ue569\u7459\ufffd"));
        }
        int index = 0;
        StringBuilder html = new StringBuilder();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        PurchaseContractHead contractBuyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        String waterMark = contractBuyHead.getWaterMark();
        boolean b = waterMark != null && !"0".equals(waterMark);
        String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), b, contractBuyHead.getWaterMarkComment(), null);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u93c2\u56e6\u6b22\u6d93\u5b2d\u6d47\u6fb6\u8fab\u89e6" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u95ab\u6c33\u7e43id\u9357\u56e9\u9a87\u9417\u581f\u6e70", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u95ab\u6c33\u7e43id\u947e\u5cf0\u5f47\u68f0\u52ee\ue74d\u93c1\u7248\u5d41")
    @GetMapping(value={"/upgradeVersion"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u9417\u581f\u6e70\u9359\u6a3b\u6d3f")
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> upgradeVersion(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.upgradeVersion(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u95ab\u6c33\u7e43id\u9359\u621d\u7af7\u6e1a\u6d98\u7c32\u935f\ufffd", notes="\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\ufffd-\u95ab\u6c33\u7e43id\u9359\u621d\u7af7\u6e1a\u6d98\u7c32\u935f\ufffd")
    @GetMapping(value={"/publish"})
    @AutoLog(busModule="\u935a\u581d\u6093\u7ee0\uff04\u608a", value="\u9359\u621d\u7af7")
    @RequiresPermissions(value={"purchaseContractHead:publish"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> publish(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.publish(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u95ab\u6c33\u7e43\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\u78c7d\u93cc\u30e8\ue1d7\u95b2\u56ea\u5598\u935a\u581d\u6093\u741b\ufffd", notes="\u95ab\u6c33\u7e43\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\u78c7d\u93cc\u30e8\ue1d7\u95b2\u56ea\u5598\u935a\u581d\u6093\u741b\ufffd")
    @GetMapping(value={"/queryPurchaseContractItemByMainId"})
    public Result<?> queryPurchaseContractItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemService.selectByMainId(id);
        return Result.ok(purchaseContractItemList);
    }

    @ApiOperation(value="\u95ab\u6c33\u7e43\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\u78c7d\u93cc\u30e8\ue1d7\u95b2\u56ea\u5598\u935a\u581d\u6093\u93c9\u2103\ue0d9\u741b\ufffd", notes="\u95ab\u6c33\u7e43\u95b2\u56ea\u5598\u935a\u581d\u6093\u6fb6\u78c7d\u93cc\u30e8\ue1d7\u95b2\u56ea\u5598\u935a\u581d\u6093\u93c9\u2103\ue0d9\u741b\ufffd")
    @GetMapping(value={"/queryPurchaseContractContentItemByMainId"})
    public Result<?> queryPurchaseContractContentItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemService.selectByMainId(id);
        return Result.ok(purchaseContractContentItemList);
    }

    @ApiOperation(value="\u95ab\u6c33\u7e43\u9352\u6944\u3003\u6924\u7538\u3009\u7edb\u70ac\u669f\u95b2\u5fd4\u7161\u7487\ufffd", notes="\u9352\u6944\u3003\u6924\u7538\u3009\u7edb\u70ac\u669f\u95b2\u5fd4\u7161\u7487\ufffd")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"contract_status", "count(0) as participateQuantity"}).lambda().ne(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.groupBy((Object)"contract_status");
        List list = ((PurchaseContractHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseContractHead::getContractStatus, PurchaseContractHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u934f\u3129\u5134"), "contractStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "contractStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u95ab\u6c33\u7e43\u9352\u6944\u3003\u6924\u7538\u3009\u7edb\u70ac\u669f\u95b2\u5fd4\u7161\u7487\ufffd", notes="\u9352\u6944\u3003\u6924\u7538\u3009\u7edb\u70ac\u669f\u95b2\u5fd4\u7161\u7487\ufffd")
    @GetMapping(value={"/countsimple"})
    public Result<?> queryTabsCountSimple(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"contract_status", "count(0) as participateSimpleQuantity"}).lambda().eq(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.groupBy((Object)"contract_status");
        List simple_list = ((PurchaseContractHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = simple_list.stream().collect(Collectors.toMap(PurchaseContractHead::getContractStatus, PurchaseContractHead::getParticipateSimpleQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u934f\u3129\u5134"), "contractStatus", null, all));
        List srmReviewStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        for (DictDTO status : srmReviewStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "contractStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @GetMapping(value={"/exportXls"})
    @RequiresPermissions(value={"purchaseContractHead:export"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseContractHeadExportServiceImpl.class);
    }
}

