/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import cn.hutool.core.util.StrUtil;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.ClassUtils;

public class PdfUtil {
    public static String htmlToPdf(String fileRootPath, String html, final String fileName, boolean water, final String waterString, PageSize pageSize) throws Exception {
        File saveDirFile;
        if (fileRootPath == null) {
            fileRootPath = "D:\\pdf";
        }
        if (StrUtil.isBlank((CharSequence)html)) {
            return null;
        }
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        if (!(saveDirFile = new File(fileRootPath)).exists()) {
            saveDirFile.mkdirs();
        }
        String filePath = fileRootPath + "/" + fileName + ".pdf";
        PdfWriter pdfWriter = new PdfWriter(new File(fileRootPath + "/", FilenameUtils.getName((String)(fileName + ".pdf"))));
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pageSize);
        ConverterProperties pro = new ConverterProperties();
        DefaultFontProvider fontProvider = new DefaultFontProvider();
        fontProvider.addSystemFonts();
        pro.setFontProvider((FontProvider)fontProvider);
        IEventHandler handlerStartPage = new IEventHandler(){

            public void handleEvent(Event event) {
                PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                PdfDocument pdf = docEvent.getDocument();
                PdfPage page = docEvent.getPage();
                PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                int height = (int)page.getPageSize().getHeight();
                int width = (int)page.getPageSize().getWidth();
                Rectangle rect = new Rectangle((float)width / 2.0f - 10.0f, 10.0f, 36.0f, 32.0f);
                Canvas canvas = new Canvas(pdfCanvas, rect);
                canvas.add((IBlockElement)new Paragraph(String.valueOf(pdf.getNumberOfPages())).setFontSize(12.0f));
                canvas.showTextAligned("NO.:" + fileName, (float)width - 170.0f, (float)height - 25.0f, TextAlignment.LEFT);
                canvas.close();
            }
        };
        pdfDocument.addEventHandler("StartPdfPage", handlerStartPage);
        if (water) {
            IEventHandler handlerEndPage = new IEventHandler(){

                public void handleEvent(Event event) {
                    PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                    PdfDocument pdf = docEvent.getDocument();
                    PdfPage page = docEvent.getPage();
                    PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                    PdfFont font = null;
                    try {
                        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
                        font = PdfFontFactory.createFont((String)(path + "static/simfang.ttf"), (String)"Identity-H", (boolean)false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ((Canvas)((Canvas)((Canvas)((Canvas)new Canvas(pdfCanvas, pdf, page.getPageSize()).setFontSize(36.0f)).setOpacity(Float.valueOf(0.2f))).setFont(font)).setFontColor((Color)new DeviceRgb(255, 0, 0))).showTextAligned(new Paragraph(waterString), 298.0f, 421.0f, pdf.getPageNumber(page), TextAlignment.CENTER, VerticalAlignment.MIDDLE, 45.0f);
                }
            };
            pdfDocument.addEventHandler("EndPdfPage", handlerEndPage);
        }
        HtmlConverter.convertToPdf((String)html.replaceAll("\u922b\ufffd", ""), (PdfDocument)pdfDocument, (ConverterProperties)pro);
        return filePath;
    }

    public static String changeTemplate(String html) {
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        return newHtml.toString();
    }

    public static void main(String[] args) throws Exception {
        String html = "<h4>${zh_index}\u9286\u4f7a\u58bf\u93c2\u6b10\u7afb\u9357\u66de\u57aa\u741b\ufffd</h4>\r\n<table style=\"border-collapse: collapse; width: 99.1736%; height: 40px;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">\u9417\u2542\u67a1\u7f02\u682b\u721c</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">\u9417\u2542\u67a1\u93bb\u5fda\u582a</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">\u7459\u52ec\u7278</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">\u93c1\u4f34\u567a</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">\u9357\u66da\u73af</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">\u95b2\u6226\ue582</td>\r\n</tr>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">${(item.materialCode)!''}</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">${(item.materialDesc)!''}</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">${(item.materialSpec)!''}</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">${(item.quantity)!''}</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">${(item.price)!''}</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">${(item.taxAmount)!''}</td>\r\n</tr>\r\n</tbody>\r\n</table>";
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        System.out.println(head);
        System.out.println("----------------------------------------");
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        System.out.println(center);
        System.out.println("----------------------------------------");
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        System.out.println(last);
        System.out.println("----------------------------------------");
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        System.out.println(newHtml);
    }
}

