/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractContentItemHis;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractHeadHis;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractItemHis;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.entity.SaleContractContentItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.enumerate.ContractPromiseSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.mapper.ContractItemCustom1Mapper;
import com.els.modules.contract.mapper.ContractItemCustom2Mapper;
import com.els.modules.contract.mapper.ContractItemCustom3Mapper;
import com.els.modules.contract.mapper.ContractItemCustom4Mapper;
import com.els.modules.contract.mapper.ContractItemCustom5Mapper;
import com.els.modules.contract.mapper.PurchaseContractContentItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractContentItemMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadHisMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractItemMapper;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.mapper.SaleContractContentItemMapper;
import com.els.modules.contract.mapper.SaleContractHeadMapper;
import com.els.modules.contract.mapper.SaleContractItemMapper;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeOrderRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeSupplierRpcService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseContractHeadServiceImpl
extends BaseServiceImpl<PurchaseContractHeadMapper, PurchaseContractHead>
implements PurchaseContractHeadService {
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Resource
    private PurchaseContractItemMapper purchaseContractItemMapper;
    @Resource
    private PurchaseContractContentItemMapper purchaseContractContentItemMapper;
    @Resource
    private PurchaseContractHeadHisMapper purchaseContractHeadHisMapper;
    @Resource
    private PurchaseContractItemHisMapper purchaseContractItemHisMapper;
    @Resource
    private PurchaseContractContentItemHisMapper purchaseContractContentItemHisMapper;
    @Resource
    private SaleContractHeadMapper saleContractHeadMapper;
    @Resource
    private SaleContractItemMapper saleContractItemMapper;
    @Resource
    private SaleContractContentItemMapper saleContractContentItemMapper;
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Resource
    private ContractItemCustom1Mapper contractItemCustom1Mapper;
    @Resource
    private ContractItemCustom2Mapper contractItemCustom2Mapper;
    @Resource
    private ContractItemCustom3Mapper contractItemCustom3Mapper;
    @Resource
    private ContractItemCustom4Mapper contractItemCustom4Mapper;
    @Resource
    private ContractItemCustom5Mapper contractItemCustom5Mapper;
    @Autowired
    private ContractInvokeOrderRpcService contractInvokeOrderRpcService;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private ContractInvokeSupplierRpcService contractInvokeSupplierRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseContractHead.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractNumber", (Object)purchaseContractHead);
            purchaseContractHead.setContractNumber(nextCode);
        }
        purchaseContractHead.setBusAccount(TenantContext.getTenant());
        super.setHeadDefaultValue((BaseEntity)purchaseContractHead);
        this.calculateAmount(purchaseContractHead, purchaseContractItemList, contractItemCustom1List);
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        this.purchaseContractHeadMapper.insert((Object)purchaseContractHead);
        this.insertData(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
    }

    private void calculateAmount(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<ContractItemCustom1> contractItemCustom1List) {
        if (CollectionUtil.isNotEmpty(purchaseContractItemList)) {
            BigDecimal taxAmount = new BigDecimal(0L);
            BigDecimal netAmount = new BigDecimal(0L);
            BigDecimal targetQuantity = new BigDecimal(0L);
            for (PurchaseContractItem item : purchaseContractItemList) {
                if (item.getPrice() != null && item.getQuantity() != null) {
                    BigDecimal temAmount = item.getPrice().multiply(item.getQuantity()).setScale(4, 4);
                    item.setTaxAmount(temAmount);
                    taxAmount = taxAmount.add(temAmount).setScale(4, 4);
                }
                if (item.getPrice() != null && item.getQuantity() != null && item.getTaxRate() != null) {
                    BigDecimal tax = BigDecimal.valueOf(1.0 - Double.valueOf(item.getTaxRate()) / 100.0);
                    BigDecimal netPrice = item.getPrice().multiply(tax).setScale(4, 4);
                    BigDecimal temAmount = netPrice.multiply(item.getQuantity()).setScale(4, 4);
                    item.setNetPrice(netPrice);
                    item.setNetAmount(temAmount);
                    netAmount = netAmount.add(temAmount).setScale(4, 4);
                }
                targetQuantity = purchaseContractItemList.parallelStream().filter(i -> i.getTargetQuantity() != null).map(PurchaseContractItem::getTargetQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            purchaseContractHead.setTotalNetAmount(netAmount);
            purchaseContractHead.setTotalTaxAmount(taxAmount);
            purchaseContractHead.setTargetQuantity(targetQuantity.toString());
        }
        if (CollectionUtil.isEmpty(purchaseContractItemList) && CollectionUtil.isNotEmpty(contractItemCustom1List)) {
            BigDecimal targetQuantity = new BigDecimal(0L);
            targetQuantity = contractItemCustom1List.parallelStream().filter(i -> i.getAmount() != null).map(ContractItemCustom1::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseContractHead.setTargetQuantity(targetQuantity.toString());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseContractHead.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractNumber", (Object)purchaseContractHead);
            purchaseContractHead.setContractNumber(nextCode);
        }
        this.calculateAmount(purchaseContractHead, purchaseContractItemList, contractItemCustom1List);
        int count = this.purchaseContractHeadMapper.updateById((Object)purchaseContractHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseContractItemMapper.deleteByMainId(purchaseContractHead.getId());
        this.purchaseContractContentItemMapper.deleteByMainId(purchaseContractHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractHead.getId());
        this.purchaseContractPromiseMapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom1Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom2Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom3Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom4Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom5Mapper.deleteByMainId(purchaseContractHead.getId());
        this.insertData(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
    }

    private void insertData(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        int count;
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            count = 1;
            for (PurchaseContractItem purchaseContractItem : purchaseContractItemList) {
                purchaseContractItem.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractItem, (BaseEntity)purchaseContractHead);
                purchaseContractItem.setElsAccount(TenantContext.getTenant());
                purchaseContractItem.setItemNumber(String.valueOf(count));
                ++count;
            }
            if (!purchaseContractItemList.isEmpty()) {
                this.purchaseContractItemMapper.insertBatchSomeColumn(purchaseContractItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseContractContentItemList)) {
            count = 1;
            for (PurchaseContractContentItem purchaseContractContentItem : purchaseContractContentItemList) {
                purchaseContractContentItem.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractContentItem, (BaseEntity)purchaseContractHead);
                purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
                purchaseContractContentItem.setItemNumber(count);
                ++count;
            }
            if (!purchaseContractContentItemList.isEmpty()) {
                this.purchaseContractContentItemMapper.insertBatchSomeColumn(purchaseContractContentItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setHeadId(purchaseContractHead.getId());
                attachment.setRelationId(IdWorker.getIdStr());
                attachment.setUploadElsAccount(purchaseContractHead.getElsAccount());
                attachment.setBusinessType("contract");
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)purchaseContractHead);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            for (PurchaseContractPromise entity : purchaseContractPromiseList) {
                entity.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractHead);
                entity.setElsAccount(TenantContext.getTenant());
            }
            if (!purchaseContractPromiseList.isEmpty()) {
                this.purchaseContractPromiseMapper.insertBatchSomeColumn(purchaseContractPromiseList);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 entity : contractItemCustom1List) {
                BigDecimal divide;
                entity.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractHead);
                entity.setContractNumber(purchaseContractHead.getContractNumber());
                entity.setElsAccount(TenantContext.getTenant());
                if (!CollectionUtil.isNotEmpty(purchaseContractItemList)) continue;
                if (ContractTypeEnum.NORMAL.getValue().equals(purchaseContractHead.getContractType())) {
                    if (entity.getAmount() == null || purchaseContractHead.getTotalTaxAmount() == null || purchaseContractHead.getTotalTaxAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                    divide = entity.getAmount().divide(purchaseContractHead.getTotalTaxAmount(), 3, 4);
                    entity.setPerformanceRatio(divide.multiply(new BigDecimal(100)) + "%");
                    continue;
                }
                if (!ContractTypeEnum.FRAME.getValue().equals(purchaseContractHead.getContractType()) || entity.getAmount() == null || purchaseContractHead.getTargetQuantity() == null || new BigDecimal(purchaseContractHead.getTargetQuantity()).compareTo(BigDecimal.ZERO) == 0) continue;
                divide = entity.getAmount().divide(new BigDecimal(purchaseContractHead.getTargetQuantity()), 3, 4);
                entity.setPerformanceRatio(divide.multiply(new BigDecimal(100)) + "%");
            }
            if (!contractItemCustom1List.isEmpty()) {
                this.contractItemCustom1Mapper.insertBatchSomeColumn(contractItemCustom1List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom2List)) {
            for (ContractItemCustom2 entity : contractItemCustom2List) {
                entity.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractHead);
                entity.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom2List.isEmpty()) {
                this.contractItemCustom2Mapper.insertBatchSomeColumn(contractItemCustom2List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom3List)) {
            for (ContractItemCustom3 entity : contractItemCustom3List) {
                entity.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractHead);
                entity.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom3List.isEmpty()) {
                this.contractItemCustom3Mapper.insertBatchSomeColumn(contractItemCustom3List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom4List)) {
            for (ContractItemCustom4 entity : contractItemCustom4List) {
                entity.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractHead);
                entity.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom4List.isEmpty()) {
                this.contractItemCustom4Mapper.insertBatchSomeColumn(contractItemCustom4List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom5List)) {
            for (ContractItemCustom5 entity : contractItemCustom5List) {
                entity.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractHead);
                entity.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom5List.isEmpty()) {
                this.contractItemCustom5Mapper.insertBatchSomeColumn(contractItemCustom5List);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseContractItemMapper.deleteByMainId(id);
        this.purchaseContractContentItemMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseContractPromiseMapper.deleteByMainId(id);
        this.contractItemCustom1Mapper.deleteByMainId(id);
        this.contractItemCustom2Mapper.deleteByMainId(id);
        this.contractItemCustom3Mapper.deleteByMainId(id);
        this.contractItemCustom4Mapper.deleteByMainId(id);
        this.contractItemCustom5Mapper.deleteByMainId(id);
        this.purchaseContractHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseContractItemMapper.deleteByMainId(serializable.toString());
            this.purchaseContractContentItemMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseContractPromiseMapper.deleteByMainId(serializable.toString());
            this.contractItemCustom1Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom2Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom3Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom4Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom5Mapper.deleteByMainId(serializable.toString());
            this.purchaseContractHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        PurchaseContractHead buyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseContractContentItem> contractBuyContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        List<PurchaseContractItem> contractBuyItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseContractHead updateBuyHead = new PurchaseContractHead();
        updateBuyHead.setContractStatus(ContractStatusEnum.CONTRACT_CONFIRMING.getValue());
        updateBuyHead.setId(id);
        int count = this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        SaleContractHead saleHead = new SaleContractHead();
        BeanUtils.copyProperties((Object)((Object)buyHead), (Object)((Object)saleHead));
        saleHead.setContractStatus(ContractStatusEnum.CONTRACT_CONFIRMING.getValue());
        saleHead.setRelationId(id);
        if (StrUtil.isBlank((CharSequence)buyHead.getRelationId())) {
            saleHead.setId(null);
            saleHead.setElsAccount(buyHead.getToElsAccount());
            saleHead.setToElsAccount(buyHead.getElsAccount());
            this.saleContractHeadMapper.insert((Object)saleHead);
        } else {
            saleHead.setId(buyHead.getRelationId());
            saleHead.setToElsAccount(buyHead.getElsAccount());
            saleHead.setElsAccount(buyHead.getToElsAccount());
            this.saleContractHeadMapper.updateById((Object)saleHead);
            this.saleContractContentItemMapper.deleteByMainId(buyHead.getRelationId());
            this.saleContractItemMapper.deleteByMainId(buyHead.getRelationId());
        }
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleHead.getId());
        ArrayList<Object> saleContentItemList = new ArrayList<Object>();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            SaleContractContentItem saleItem = new SaleContractContentItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleContentItemList.add((Object)saleItem);
        }
        if (!saleContentItemList.isEmpty()) {
            this.saleContractContentItemMapper.insertBatchSomeColumn(saleContentItemList);
        }
        ArrayList<SaleContractItem> saleItemList = new ArrayList<SaleContractItem>();
        for (PurchaseContractItem item : contractBuyItemList) {
            SaleContractItem saleItem = new SaleContractItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItemList.add(saleItem);
        }
        if (!saleItemList.isEmpty()) {
            this.saleContractItemMapper.insertBatchSomeColumn(saleItemList);
        }
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            ArrayList<SaleAttachmentDTO> saleAttachmentArrayList = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : purchaseAttachmentList) {
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(purchaseAttachment.getRelationId());
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(buyHead.getToElsAccount());
                saleAttachment.setHeadId(saleHead.getId());
                saleAttachmentArrayList.add(saleAttachment);
            }
            if (CollectionUtil.isNotEmpty(saleAttachmentArrayList)) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentArrayList);
            }
        }
        String urlParam = "id=" + saleHead.getId();
        if (Integer.parseInt(buyHead.getContractType()) == 1) {
            super.sendMsg(buyHead.getElsAccount(), buyHead.getToElsAccount(), (Object)buyHead, urlParam, "contract", "publish");
        } else {
            super.sendMsg(buyHead.getElsAccount(), buyHead.getToElsAccount(), (Object)buyHead, urlParam, "contractSimple", "publish");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void upgradeVersion(String id) {
        PurchaseContractHead buyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseContractContentItem> contractBuyContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        List<PurchaseContractItem> contractBuyItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseContractHead updateHead = new PurchaseContractHead();
        updateHead.setId(id);
        updateHead.setContractStatus(ContractStatusEnum.CHANGE_UN_PUBLISH.getValue());
        updateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        updateHead.setFlowId("");
        String contractVersion = buyHead.getContractVersion();
        if (StrUtil.isBlank((CharSequence)contractVersion)) {
            int version = 1;
            updateHead.setContractVersion(String.valueOf(version));
        } else {
            updateHead.setContractVersion(contractVersion);
        }
        PurchaseContractHeadHis buyHeadHis = new PurchaseContractHeadHis();
        BeanUtils.copyProperties((Object)((Object)buyHead), (Object)((Object)buyHeadHis));
        buyHeadHis.setId(null);
        buyHeadHis.setContractId(id);
        updateHead.setContractVersion(String.valueOf(Integer.parseInt(updateHead.getContractVersion()) + 1));
        this.purchaseContractHeadMapper.updateById((Object)updateHead);
        this.purchaseContractHeadHisMapper.insert((Object)buyHeadHis);
        ArrayList<PurchaseContractContentItemHis> contentItemHisList = new ArrayList<PurchaseContractContentItemHis>();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            PurchaseContractContentItemHis itemHis = new PurchaseContractContentItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(buyHeadHis.getId());
            contentItemHisList.add(itemHis);
        }
        if (!contentItemHisList.isEmpty()) {
            this.purchaseContractContentItemHisMapper.insertBatchSomeColumn(contentItemHisList);
        }
        ArrayList<PurchaseContractItemHis> itemHisList = new ArrayList<PurchaseContractItemHis>();
        for (PurchaseContractItem item : contractBuyItemList) {
            PurchaseContractItemHis itemHis = new PurchaseContractItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(buyHeadHis.getId());
            itemHisList.add(itemHis);
        }
        if (!itemHisList.isEmpty()) {
            this.purchaseContractItemHisMapper.insertBatchSomeColumn(itemHisList);
        }
        if (!CollectionUtils.isEmpty((Collection)purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setHeadId(buyHeadHis.getId());
                attachment.setUploadElsAccount(buyHeadHis.getElsAccount());
                attachment.setBusinessType("contract");
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)buyHeadHis);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseContractHead head) {
        PurchaseContractHead updateBuyHead = new PurchaseContractHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setContractStatus(head.getContractStatus());
        this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(SaleContractHead::getRelationId, (Object)head.getId())).set(SaleContractHead::getContractStatus, (Object)head.getContractStatus());
        this.saleContractHeadMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseOrderHeadDTO> createOrderByItems(PurchaseContractHeadVO headVO) {
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        List<PurchaseContractItem> collect = purchaseContractItemList.parallelStream().filter(p -> !"order".equals(p.getSourceType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw new ELSBootException("\u4e3a\u60a8\u8fc7\u6ee4\u6389\u6765\u6e90\u4e3a\u8ba2\u5355\u7684\u884c\u540e,\u884c\u9879\u76ee\u4e3a\u7a7a");
        }
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)((PurchaseContractItem)((Object)collect.get(0))).getHeadId())));
        List<String> idList = collect.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List<PurchaseOrderItemDTO> purchaseOrderItemDTOList = this.contractInvokeOrderRpcService.listItemBySourceItemId(idList);
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = new PurchaseOrderHeadDTO();
        List<PurchaseOrderItemDTO> purchaseOrderItemDTOListNew = this.contractToOrderOnItem(byId, collect, purchaseOrderItemDTOList);
        ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanDTOS = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
        if (CollectionUtil.isNotEmpty(purchaseOrderItemDTOListNew)) {
            int deliveryItemCount = 1;
            for (PurchaseOrderItemDTO orderItem : purchaseOrderItemDTOListNew) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderItem.getJit()) && !"0".equals(orderItem.getJit())) continue;
                PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
                orderDeliveryPlan.setItemNumber(String.valueOf(deliveryItemCount));
                orderDeliveryPlan.setOrderItemNumber(orderItem.getItemNumber());
                orderDeliveryPlan.setQuantity(orderItem.getQuantity());
                orderDeliveryPlan.setPlanDeliveryQuantity(orderItem.getQuantity());
                orderDeliveryPlan.setPlanDeliveryDate(orderItem.getRequireDate());
                orderDeliveryPlan.setRequireDate(orderItem.getRequireDate());
                ++deliveryItemCount;
                purchaseOrderDeliveryPlanDTOS.add(orderDeliveryPlan);
            }
        }
        BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseOrderHeadDTO);
        purchaseOrderHeadDTO.setTemplateAccount(headVO.getTemplateAccount());
        purchaseOrderHeadDTO.setTemplateName(headVO.getTemplateName());
        purchaseOrderHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        purchaseOrderHeadDTO.setTemplateVersion(headVO.getTemplateVersion());
        purchaseOrderHeadDTO.setContractNumber(byId.getContractNumber());
        purchaseOrderHeadDTO.setContractName(byId.getContractName());
        if (ContractTargetTypeEnum.MONEY.getValue().equals(byId.getTargetType())) {
            purchaseOrderHeadDTO.setSourceType(OrderSourceTypeEnum.AMOUNT_CONTRACT.getValue());
        } else {
            purchaseOrderHeadDTO.setSourceType(OrderSourceTypeEnum.WORTH_CONTRACT.getValue());
        }
        purchaseOrderHeadDTO.setId(null);
        purchaseOrderHeadDTO.setRelationId(null);
        purchaseOrderHeadDTO.setCreateBy(null);
        purchaseOrderHeadDTO.setCreateTime(null);
        purchaseOrderHeadDTO.setUpdateBy(null);
        purchaseOrderHeadDTO.setUpdateTime(null);
        SupplierMasterDataDTO byAccount = this.contractInvokeSupplierRpcService.getByAccount(byId.getElsAccount(), byId.getToElsAccount());
        if (byAccount != null) {
            purchaseOrderHeadDTO.setIsTeamwork(byAccount.getNeedCoordination());
        }
        purchaseOrderHeadDTO = this.contractInvokeOrderRpcService.contractCreateOrder(purchaseOrderHeadDTO, purchaseOrderItemDTOListNew, purchaseOrderDeliveryPlanDTOS);
        return Arrays.asList(purchaseOrderHeadDTO);
    }

    private List<PurchaseOrderItemDTO> contractToOrderOnItem(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItems, List<PurchaseOrderItemDTO> purchaseOrderItemDTOList) {
        ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
        int count = 1;
        List<String> collect = purchaseContractItems.parallelStream().map(PurchaseContractItem::getMaterialNumber).distinct().collect(Collectors.toList());
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.contractInvokeMainDataRpcService.listByMaterialNumbers(collect);
        Map collect1 = purchaseMaterialHeadDTOS.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
        for (PurchaseContractItem purchaseContractItem : purchaseContractItems) {
            BigDecimal targetQuantity = purchaseContractItem.getTargetQuantity();
            BigDecimal targetQuantityArry = BigDecimal.ZERO;
            targetQuantityArry = ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHead.getTargetType()) ? purchaseOrderItemDTOList.parallelStream().filter(p -> purchaseContractItem.getId().equals(p.getSourceItemId())).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : purchaseOrderItemDTOList.parallelStream().filter(p -> purchaseContractItem.getId().equals(p.getSourceItemId())).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurchaseOrderItemDTO purchaseOrderItemDTO = new PurchaseOrderItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)purchaseOrderItemDTO);
            PurchaseMaterialHeadDTO materialHeadDTO = (PurchaseMaterialHeadDTO)collect1.get(purchaseContractItem.getMaterialNumber());
            purchaseOrderItemDTO.setCateCode(materialHeadDTO.getCateCode());
            purchaseOrderItemDTO.setCateName(materialHeadDTO.getCateName());
            purchaseOrderItemDTO.setMaterialGroup(materialHeadDTO.getMaterialGroup());
            purchaseOrderItemDTO.setMaterialSpec(materialHeadDTO.getMaterialSpec());
            purchaseOrderItemDTO.setPurchaseCycle(materialHeadDTO.getPurchaseCycle());
            purchaseOrderItemDTO.setOrderUnit(materialHeadDTO.getOrderUnit());
            purchaseOrderItemDTO.setJit(materialHeadDTO.getJit());
            purchaseOrderItemDTO.setCheckQuality(materialHeadDTO.getCheckQuality());
            purchaseOrderItemDTO.setId(null);
            purchaseOrderItemDTO.setHeadId(null);
            purchaseOrderItemDTO.setCreateBy(null);
            purchaseOrderItemDTO.setItemNumber(String.valueOf(count));
            purchaseOrderItemDTO.setCreateTime(null);
            purchaseOrderItemDTO.setUpdateBy(null);
            purchaseOrderItemDTO.setUpdateTime(null);
            purchaseOrderItemDTO.setSourceNumber(purchaseContractHead.getContractNumber());
            if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHead.getTargetType())) {
                purchaseOrderItemDTO.setSourceType(OrderSourceTypeEnum.AMOUNT_CONTRACT.getValue());
            } else {
                purchaseOrderItemDTO.setSourceType(OrderSourceTypeEnum.WORTH_CONTRACT.getValue());
            }
            purchaseOrderItemDTO.setSourceItemNumber(purchaseContractItem.getItemNumber());
            purchaseOrderItemDTO.setSourceId(purchaseContractHead.getId());
            purchaseOrderItemDTO.setSourceItemId(purchaseContractItem.getId());
            purchaseOrderItemList.add(purchaseOrderItemDTO);
            ++count;
        }
        return purchaseOrderItemList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseContractPromiseVO> createPromiseByItems(PurchaseContractHeadVO headVO) {
        List<ContractItemCustom1> contractItemCustom1List = headVO.getContractItemCustom1List();
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        String id = "";
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            id = contractItemCustom1List.get(0).getHeadId();
        }
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            id = purchaseContractItemList.get(0).getHeadId();
        }
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)id)));
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateAccount(headVO.getTemplateAccount());
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        List<PurchaseContractPromiseVO> purchaseContractPromises = this.contractPromiseParam(templateHeadDTO, byId, contractItemCustom1List, purchaseContractItemList);
        purchaseContractPromises.forEach(item -> this.purchaseContractPromiseService.saveMain((PurchaseContractPromise)((Object)item), item.getPurchasePromiseItemList()));
        return purchaseContractPromises;
    }

    private List<PurchaseContractPromiseVO> contractPromiseParam(TemplateHeadDTO templateHeadDTO, PurchaseContractHead purchaseContractHead, List<ContractItemCustom1> contractItemCustom1List, List<PurchaseContractItem> purchaseContractItemList) {
        ArrayList<PurchaseContractPromiseVO> contractPromiseArrayList = new ArrayList<PurchaseContractPromiseVO>();
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
            purchaseContractPromise.setSourceType(ContractPromiseSourceTypeEnum.ITEM.getValue());
            purchaseContractPromise.setTemplateAccount(templateHeadDTO.getTemplateAccount());
            purchaseContractPromise.setTemplateName(templateHeadDTO.getTemplateName());
            purchaseContractPromise.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            purchaseContractPromise.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
            purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
            purchaseContractPromise.setContractName(purchaseContractHead.getContractName());
            purchaseContractPromise.setContractDesc(purchaseContractHead.getContractDesc());
            purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
            if (ContractTypeEnum.NORMAL.getValue().equals(purchaseContractHead.getContractType())) {
                purchaseContractPromise.setContractAmount(purchaseContractHead.getTotalTaxAmount());
                purchaseContractPromise.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
            } else if (ContractTypeEnum.FRAME.getValue().equals(purchaseContractHead.getContractType())) {
                purchaseContractPromise.setContractAmount(new BigDecimal(purchaseContractHead.getTargetQuantity()));
                if (StringUtils.isEmpty((Object)purchaseContractHead.getTargetType())) {
                    purchaseContractPromise.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
                } else {
                    purchaseContractPromise.setTargetType(purchaseContractHead.getTargetType());
                }
            }
            purchaseContractPromise.setBusAccount(TenantContext.getTenant());
            purchaseContractPromise.setCreateAccount(TenantContext.getTenant());
            purchaseContractPromise.setHeadId(purchaseContractHead.getId());
            ArrayList<PurchasePromiseItem> purchasePromiseItemList = new ArrayList<PurchasePromiseItem>();
            for (PurchaseContractItem purchaseContractItem : purchaseContractItemList) {
                PurchasePromiseItem purchasePromiseItem = new PurchasePromiseItem();
                BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)((Object)purchasePromiseItem));
                purchasePromiseItem.setSourceItemId(purchaseContractItem.getId());
                purchasePromiseItem.setHeadId(null);
                purchasePromiseItem.setId(null);
                purchasePromiseItem.setCreateBy(null);
                purchasePromiseItem.setCreateTime(null);
                purchasePromiseItem.setUpdateBy(null);
                purchasePromiseItem.setUpdateTime(null);
                purchasePromiseItem.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchasePromiseItem.setContractNumber(purchaseContractHead.getContractNumber());
                purchasePromiseItem.setContractName(purchaseContractHead.getContractName());
                purchasePromiseItem.setContractDesc(purchaseContractHead.getContractDesc());
                purchasePromiseItem.setAmount(purchaseContractItem.getTaxAmount());
                purchasePromiseItemList.add(purchasePromiseItem);
            }
            purchaseContractPromise.setPurchasePromiseItemList(purchasePromiseItemList);
            if (!CollectionUtils.isEmpty(purchasePromiseItemList)) {
                BigDecimal targetQuantityArry = BigDecimal.ZERO;
                targetQuantityArry = purchasePromiseItemList.parallelStream().filter(p -> p.getAmount() != null).map(PurchasePromiseItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractPromise.setAmount(targetQuantityArry);
            }
            contractPromiseArrayList.add(purchaseContractPromise);
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
                purchaseContractPromise.setTemplateAccount(templateHeadDTO.getTemplateAccount());
                purchaseContractPromise.setTemplateName(templateHeadDTO.getTemplateName());
                purchaseContractPromise.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                purchaseContractPromise.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
                purchaseContractPromise.setSourceType(ContractPromiseSourceTypeEnum.MILESTONE.getValue());
                purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
                purchaseContractPromise.setContractName(purchaseContractHead.getContractName());
                purchaseContractPromise.setContractDesc(purchaseContractHead.getContractDesc());
                purchaseContractPromise.setTargetType(purchaseContractHead.getTargetType());
                purchaseContractPromise.setStage(contractItemCustom1.getStage());
                purchaseContractPromise.setSourceItemId(contractItemCustom1.getId());
                purchaseContractPromise.setHeadId(contractItemCustom1.getHeadId());
                purchaseContractPromise.setBusAccount(TenantContext.getTenant());
                purchaseContractPromise.setCreateAccount(TenantContext.getTenant());
                purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchaseContractPromise.setAmount(contractItemCustom1.getAmount());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseContractHead.getTargetQuantity())) {
                    purchaseContractPromise.setContractAmount(new BigDecimal(purchaseContractHead.getTargetQuantity()));
                } else {
                    purchaseContractPromise.setContractAmount(BigDecimal.ZERO);
                }
                purchaseContractPromise.setPerformanceRatio(contractItemCustom1.getPerformanceRatio());
                purchaseContractPromise.setPerformanceMatters(contractItemCustom1.getPerformanceMatters());
                contractPromiseArrayList.add(purchaseContractPromise);
            }
        }
        return contractPromiseArrayList;
    }
}

