/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.adapter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.service.PurchaseContractAcceptanceService;
import com.els.modules.contract.vo.PurchaseContractAcceptanceVO;
import com.els.modules.extend.api.dto.ApprovalPendToFanWeiVo;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="contractAcceptanceAdapter")
public class PurchaseContractAcceptanceAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseContractAcceptanceService purchaseContractAcceptanceService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        String param = StringUtils.isEmpty((Object)inputParamDTO.getParams()) ? "{}" : inputParamDTO.getParams();
        PurchaseContractAcceptanceVO headVO = (PurchaseContractAcceptanceVO)((Object)JSONObject.parseObject((String)param, PurchaseContractAcceptanceVO.class));
        headVO.setWorkFlowType(outputParamDTO.getBpmnType());
        headVO.setFbk2(AuditStatusEnum.AUDIT_DOING.getValue());
        headVO.setResultFlowId(outputParamDTO.getProcessRootId());
        this.purchaseContractAcceptanceService.updateById((Object)headVO);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
            operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
        }
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamDTO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"inspectionStandard", (String)operataion, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamDTO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"inspectionStandard", (String)operataion, (MsgParamsVO)msgParamsVO);
                String tenant = TenantContext.getTenant();
                List elsSubAccountDTOS = (List)msgParamsVO.getReceiverMap().get(tenant);
                JSONObject jsonObjectMsgParams = (JSONObject)msgParamsVO.getReceiveParamMap().get(tenant);
                String link = null;
                String taskId = jsonObjectMsgParams.getString("taskId");
                String businessType = jsonObjectMsgParams.getString("businessType");
                String businessId = jsonObjectMsgParams.getString("businessId");
                String processInstanceId = jsonObjectMsgParams.getString("processInstanceId");
                String linkParamApp = "taskId=" + taskId + "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processInstanceId;
                String linkParam = "taskId=" + taskId + "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processInstanceId + "&open=true";
                BaseRpcService baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class);
                List todoListLink = baseRpcService.queryDictItemsByCode("todo_list_link", account);
                Map<String, String> todoListLinkMap = todoListLink.stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
                link = todoListLinkMap.get(WorkFlowType.BPMN.getValue());
                if (!CollectionUtil.isNotEmpty((Collection)elsSubAccountDTOS)) continue;
                for (int i = 0; i < elsSubAccountDTOS.size(); ++i) {
                    ElsSubAccountDTO elsSubAccountDTO = (ElsSubAccountDTO)elsSubAccountDTOS.get(i);
                    String AuthUrl = this.getAuthUrl(link + "?" + linkParam, elsSubAccountDTO);
                    String Appurl = this.getAppAuthUrl(link + "&" + linkParamApp, elsSubAccountDTO);
                    ApprovalPendToFanWeiVo approvalPendToFanWeiVo = new ApprovalPendToFanWeiVo();
                    approvalPendToFanWeiVo.setPcurl(AuthUrl);
                    approvalPendToFanWeiVo.setAppurl(Appurl);
                    approvalPendToFanWeiVo.setRequestname(inputParamDTO.getAuditSubject());
                    approvalPendToFanWeiVo.setViewtype("0");
                    long timeMillis = System.currentTimeMillis();
                    approvalPendToFanWeiVo.setReceivets(String.valueOf(timeMillis));
                    approvalPendToFanWeiVo.setReceiver(((ElsSubAccountDTO)elsSubAccountDTOS.get(i)).getId());
                    approvalPendToFanWeiVo.setFlowid(String.valueOf(inputParamDTO.getRootProcessInstanceId()));
                    approvalPendToFanWeiVo.setIsremark("0");
                    Date date = new Date();
                    date.getTime();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date2 = dateFormat.format(date);
                    approvalPendToFanWeiVo.setCreatedatetime(date2);
                    approvalPendToFanWeiVo.setReceivedatetime(date2);
                    approvalPendToFanWeiVo.setWorkflowname("submitAudit");
                }
            }
        }
    }

    private String getAppAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/mobile?type=redirect&pagePath=").append(URLUtil.encodeAll((String)redirectUri));
        return url.toString();
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        PurchaseContractAcceptance head = (PurchaseContractAcceptance)((Object)this.purchaseContractAcceptanceService.getById((Serializable)((Object)inputParamDTO.getBusinessId())));
        head.setFbk2(outputParamDTO.getAuditStatus());
        this.purchaseContractAcceptanceService.updateById((Object)head);
        PurchaseContractAcceptanceVO purchaseContractAcceptanceVO = this.purchaseContractAcceptanceService.getDataById(head.getId());
        this.purchaseContractAcceptanceService.publish(head, purchaseContractAcceptanceVO.getPurchaseAttachmentList());
        this.sendMsg(inputParamDTO, outputParamDTO, "auditPass");
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(PurchaseContractAcceptance::getFbk2, (Object)outputParamDTO.getAuditStatus());
        updateWrapper.lambda().eq(BaseEntity::getId, (Object)inputParamDTO.getBusinessId());
        this.purchaseContractAcceptanceService.update((Wrapper)updateWrapper);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"inspectionStandard", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"inspectionStandard", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseContractAcceptance head = (PurchaseContractAcceptance)((Object)this.purchaseContractAcceptanceService.getById((Serializable)((Object)headId)));
        PurchaseContractAcceptanceVO headVO = new PurchaseContractAcceptanceVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

