/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.adapter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.rpc.service.ContractInvokeDeliveryWaterRpcService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.extend.api.dto.ApprovalPendToFanWeiVo;
import com.els.modules.extend.api.service.OaThirdSevice;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PurchaseContractPromiseAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractPromiseAuditOptCallBackServiceImpl.class);
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    @Lazy(value=true)
    private OaThirdSevice oaThirdSevice;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ContractInvokeDeliveryWaterRpcService contractInvokeDeliveryWaterRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            String tenant = TenantContext.getTenant();
            List elsSubAccountDTOS = (List)msgParamsVO.getReceiverMap().get(tenant);
            JSONObject jsonObjectMsgParams = (JSONObject)msgParamsVO.getReceiveParamMap().get(tenant);
            String link = null;
            String taskId = jsonObjectMsgParams.getString("taskId");
            String businessType = jsonObjectMsgParams.getString("businessType");
            String businessId = jsonObjectMsgParams.getString("businessId");
            String processInstanceId = jsonObjectMsgParams.getString("processInstanceId");
            String linkParamApp = "taskId=" + taskId + "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processInstanceId;
            String linkParam = "taskId=" + taskId + "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processInstanceId + "&open=true";
            BaseRpcService baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class);
            List todoListLink = baseRpcService.queryDictItemsByCode("todo_list_link", account);
            Map<String, String> todoListLinkMap = todoListLink.stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
            link = todoListLinkMap.get(WorkFlowType.BPMN.getValue());
            if (!CollectionUtil.isNotEmpty((Collection)elsSubAccountDTOS)) continue;
            for (int i = 0; i < elsSubAccountDTOS.size(); ++i) {
                ElsSubAccountDTO elsSubAccountDTO = (ElsSubAccountDTO)elsSubAccountDTOS.get(i);
                String AuthUrl = this.getAuthUrl(link + "?" + linkParam, elsSubAccountDTO);
                String Appurl = this.getAppAuthUrl(link + "&" + linkParamApp, elsSubAccountDTO);
                ApprovalPendToFanWeiVo approvalPendToFanWeiVo = new ApprovalPendToFanWeiVo();
                approvalPendToFanWeiVo.setPcurl(AuthUrl);
                approvalPendToFanWeiVo.setAppurl(Appurl);
                approvalPendToFanWeiVo.setRequestname(inputParamVO.getAuditSubject());
                approvalPendToFanWeiVo.setViewtype("0");
                long timeMillis = System.currentTimeMillis();
                approvalPendToFanWeiVo.setReceivets(String.valueOf(timeMillis));
                approvalPendToFanWeiVo.setReceiver(((ElsSubAccountDTO)elsSubAccountDTOS.get(i)).getId());
                approvalPendToFanWeiVo.setFlowid(String.valueOf(inputParamVO.getRootProcessInstanceId()));
                approvalPendToFanWeiVo.setIsremark("0");
                Date date = new Date();
                date.getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date2 = dateFormat.format(date);
                approvalPendToFanWeiVo.setCreatedatetime(date2);
                approvalPendToFanWeiVo.setReceivedatetime(date2);
                approvalPendToFanWeiVo.setWorkflowname("submitAudit");
            }
        }
    }

    private String getAppAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/mobile?type=redirect&pagePath=").append(URLUtil.encodeAll((String)redirectUri));
        return url.toString();
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseContractPromise byId;
        PurchaseContractPromise head = new PurchaseContractPromise();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        head.setWorkFlowType(outputParamVO.getBpmnType());
        this.purchaseContractPromiseMapper.updateById((Object)head);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseContractPromise byId2 = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
            if (byId2.getCreateAccount().equals(byId2.getBusAccount())) {
                byId2.setAuditStatus(outputParamVO.getAuditStatus());
                this.purchaseContractPromiseService.publishEvent(byId2);
            } else {
                byId2.setAuditStatus(outputParamVO.getAuditStatus());
                this.purchaseContractPromiseService.confirmedSupplier(byId2);
            }
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus()) && !(byId = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)inputParamVO.getBusinessId())))).getCreateAccount().equals(byId.getBusAccount())) {
            this.purchaseContractPromiseService.refundMain(inputParamVO.getBusinessId(), inputParamVO.getAuditOpinion());
        }
    }

    public static void main(String[] args) {
        String str = "33.33%";
        str = str.replace("%", "");
        BigDecimal bigDecimal = new BigDecimal(str).divide(new BigDecimal("100"));
        System.err.println(new BigDecimal(20).multiply(bigDecimal));
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PurchaseContractPromise head = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

