/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.contract.controller.PurchaseContractHeadHisController;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.enumerate.ContractPromiseTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.excel.PurchaseContractHeadExportServiceImpl;
import com.els.modules.contract.rpc.service.ContractInvokeOrderRpcService;
import com.els.modules.contract.service.ContractItemCustom1Service;
import com.els.modules.contract.service.ContractItemCustom2Service;
import com.els.modules.contract.service.ContractItemCustom3Service;
import com.els.modules.contract.service.ContractItemCustom4Service;
import com.els.modules.contract.service.ContractItemCustom5Service;
import com.els.modules.contract.service.PurchaseContractContentItemService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractItemService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.utils.NumberUtil;
import com.els.modules.contract.utils.PdfUtil;
import com.els.modules.contract.utils.RequestCreate;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/contract/purchaseContractHead"})
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u5934"})
public class PurchaseContractHeadController
extends BaseController<PurchaseContractHead, PurchaseContractHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractHeadController.class);
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Autowired
    private PurchaseContractItemService purchaseContractItemService;
    @Autowired
    private PurchaseContractContentItemService purchaseContractContentItemService;
    @Autowired
    private PurchaseContractHeadHisController purchaseContractHeadHisController;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ContractInvokeOrderRpcService contractInvokeOrderRpcService;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private ContractItemCustom1Service contractItemCustom1Service;
    @Autowired
    private ContractItemCustom2Service contractItemCustom2Service;
    @Autowired
    private ContractItemCustom3Service contractItemCustom3Service;
    @Autowired
    private ContractItemCustom4Service contractItemCustom4Service;
    @Autowired
    private ContractItemCustom5Service contractItemCustom5Service;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryPageList(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().ne(PurchaseContractHead::getContractType, (Object)"3");
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/listSimple"})
    @PermissionDataView(businessType="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> listSimple(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(PurchaseContractHead::getContractType, (Object)"3");
        IPage pageList = this.purchaseContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/listAll"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> listAll(PurchaseContractHead purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaseContractHead> purchaseContractHeadIPage = this.purchaseContractHeadService.getListAllPurchaseContractHeadIPage((Page<PurchaseContractHead>)page, (QueryWrapper<PurchaseContractHead>)queryWrapper);
        return Result.ok(purchaseContractHeadIPage);
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"contract#purchaseContractHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> add(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.saveMain(purchaseContractHead, purchaseContractHeadPage.getPurchaseContractItemList(), purchaseContractHeadPage.getPurchaseContractContentItemList(), purchaseContractHeadPage.getPurchaseAttachmentList(), purchaseContractHeadPage.getPurchaseContractPromiseList(), purchaseContractHeadPage.getContractItemCustom1List(), purchaseContractHeadPage.getContractItemCustom2List(), purchaseContractHeadPage.getContractItemCustom3List(), purchaseContractHeadPage.getContractItemCustom4List(), purchaseContractHeadPage.getContractItemCustom5List());
        return Result.ok((Object)((Object)purchaseContractHead));
    }

    @GetMapping(value={"/diffContractContent"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> diffContractContent(@RequestParam(name="id", required=true) String id, @RequestParam(name="newId", required=true) String newId, @RequestParam(name="type", required=true) String type) {
        PurchaseContractContentItem purchaseContractContentItem = new PurchaseContractContentItem();
        purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
        purchaseContractContentItem.setOriginalContent(this.purchaseContractHeadHisController.getHtmlById(id).toString());
        if ("head".equals(type)) {
            purchaseContractContentItem.setItemContent(this.purchaseContractHeadHisController.getHtmlById(newId).toString());
        } else {
            purchaseContractContentItem.setItemContent(this.getHtmlById(newId).toString());
        }
        return Result.ok((Object)((Object)purchaseContractContentItem));
    }

    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:edit"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> edit(@RequestBody PurchaseContractHeadVO purchaseContractHeadPage) {
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadPage), (Object)((Object)purchaseContractHead));
        this.purchaseContractHeadService.updateMain(purchaseContractHead, purchaseContractHeadPage.getPurchaseContractItemList(), purchaseContractHeadPage.getPurchaseContractContentItemList(), purchaseContractHeadPage.getPurchaseAttachmentList(), purchaseContractHeadPage.getPurchaseContractPromiseList(), purchaseContractHeadPage.getContractItemCustom1List(), purchaseContractHeadPage.getContractItemCustom2List(), purchaseContractHeadPage.getContractItemCustom3List(), purchaseContractHeadPage.getContractItemCustom4List(), purchaseContractHeadPage.getContractItemCustom5List());
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/cancel"})
    @RequiresPermissions(value={"contract#purchaseContractHead:cancel"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> cancel(@RequestBody PurchaseContractHeadVO head) {
        head.setContractStatus(ContractStatusEnum.CANCEL.getValue());
        this.purchaseContractHeadService.updateStatus(head);
        return this.commonSuccessResult(4);
    }

    @PostMapping(value={"/archive"})
    @RequiresPermissions(value={"contract#purchaseContractHead:archive"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> archive(@RequestBody PurchaseContractHeadVO head) {
        head.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
        this.purchaseContractHeadService.updateStatus(head);
        return this.commonSuccessResult(4);
    }

    @PostMapping(value={"/createOrderByItems"})
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:createOrderByItems"})
    public Result<?> createOrderByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseOrderHeadDTO> orderHeadDTOList = this.purchaseContractHeadService.createOrderByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseOrderHeadDTO purchaseOrderHeadVO : orderHeadDTOList) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getOrderNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_sItLRWLRsIttWW_dcec862d", (String)"\u8f6c\u8ba2\u5355\u6210\u529f,\u6210\u529f\u8f6c\u8ba2\u5355\u5355\u6570:") + orderHeadDTOList.size() + I18nUtil.translate((String)"i18n_alert_WtyzqLW_10983e53", (String)",\u5355\u53f7\u5206\u522b\u4e3a:") + stringBuffer.toString()));
    }

    @PostMapping(value={"/createPromiseByItems"})
    @SrmValidated
    @RequiresPermissions(value={"contract#purchaseContractHead:createPromiseByItems"})
    public Result<?> createPromiseByItems(@RequestBody PurchaseContractHeadVO headVO) {
        List<PurchaseContractPromiseVO> orderHeadDTOList = this.purchaseContractHeadService.createPromiseByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseContractPromiseVO purchaseOrderHeadVO : orderHeadDTOList) {
            stringBuffer = stringBuffer.append(" " + purchaseOrderHeadVO.getPromiseNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_sIZtLRWLRsIZttWW_44803993", (String)"\u8f6c\u5c65\u7ea6\u5355\u6210\u529f,\u6210\u529f\u8f6c\u5c65\u7ea6\u5355\u5355\u6570:") + orderHeadDTOList.size() + I18nUtil.translate((String)"i18n_alert_WtyzqLW_10983e53", (String)(",\u5355\u53f7\u5206\u522b\u4e3a:" + stringBuffer))));
    }

    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contract#purchaseContractHead:delete"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contract#purchaseContractHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseContractHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/queryById"})
    @BusinessModule(module="contract")
    @RequiresPermissions(value={"contract#purchaseContractHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        PurchaseContractHeadVO purchaseContractHeadVO = this.getData(id);
        List<PurchaseContractItem> purchaseContractItemList = purchaseContractHeadVO.getPurchaseContractItemList();
        if (ContractPromiseTypeEnum.ORDER.getValue().equals(purchaseContractHead.getPromiseType()) && !CollectionUtils.isEmpty(purchaseContractItemList)) {
            List<String> collect = purchaseContractItemList.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            List<PurchaseOrderItemDTO> purchaseOrderItemDTOList = this.contractInvokeOrderRpcService.listItemBySourceItemId(collect);
            purchaseContractHeadVO.setOrderItemList(purchaseOrderItemDTOList);
        }
        purchaseContractHeadVO.setPurchaseContractItemList(purchaseContractItemList);
        this.calculateTraget(purchaseContractHeadVO);
        return Result.ok((Object)((Object)purchaseContractHeadVO));
    }

    private PurchaseContractHeadVO getData(String id) {
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        PurchaseContractHeadVO purchaseContractHeadVO = new PurchaseContractHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHead), (Object)((Object)purchaseContractHeadVO));
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemService.selectByMainId(id);
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemService.selectByMainId(id);
        purchaseContractHeadVO.setPurchaseContractContentItemList(purchaseContractContentItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        List<PurchaseContractPromise> purchaseContractPromiseList = this.purchaseContractPromiseService.selectByMainId(id);
        List<PurchaseContractPromise> collect1 = purchaseContractPromiseList.parallelStream().filter(item -> ContractPromiseStatusEnum.CONFIRMED.getValue().equals(item.getPromiseStatus())).collect(Collectors.toList());
        purchaseContractHeadVO.setPurchaseContractPromiseList(collect1);
        List<ContractItemCustom1> contractItemCustom1List = this.contractItemCustom1Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom1List(contractItemCustom1List);
        List<ContractItemCustom2> contractItemCustom2List = this.contractItemCustom2Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom2List(contractItemCustom2List);
        List<ContractItemCustom3> contractItemCustom3List = this.contractItemCustom3Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom3List(contractItemCustom3List);
        List<ContractItemCustom4> contractItemCustom4List = this.contractItemCustom4Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom4List(contractItemCustom4List);
        List<ContractItemCustom5> contractItemCustom5List = this.contractItemCustom5Service.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom5List(contractItemCustom5List);
        purchaseContractHeadVO.setPurchaseContractItemList(purchaseContractItemList);
        return purchaseContractHeadVO;
    }

    private void calculateTraget(PurchaseContractHeadVO purchaseContractHeadVO) {
        String contractType = purchaseContractHeadVO.getContractType();
        String promiseType = purchaseContractHeadVO.getPromiseType();
        if (StringUtils.isBlank((CharSequence)contractType) || StringUtils.isBlank((CharSequence)promiseType)) {
            return;
        }
        List<PurchaseContractPromise> promiseList = purchaseContractHeadVO.getPurchaseContractPromiseList();
        if (ContractTypeEnum.NORMAL.getValue().equals(contractType)) {
            if (ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType)) {
                List<PurchaseOrderItemDTO> orderItemList = purchaseContractHeadVO.getOrderItemList();
                if (!CollectionUtils.isEmpty(orderItemList)) {
                    BigDecimal reduce = orderItemList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
                }
            } else if (!CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        } else if (ContractTypeEnum.FRAME.getValue().equals(contractType)) {
            if (ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType)) {
                List<PurchaseOrderItemDTO> orderItemList = purchaseContractHeadVO.getOrderItemList();
                if (!CollectionUtils.isEmpty(orderItemList)) {
                    Object reduce;
                    for (PurchaseContractItem purchaseContractItem : purchaseContractHeadVO.getPurchaseContractItemList()) {
                        BigDecimal total = BigDecimal.ZERO;
                        if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHeadVO.getTargetType())) {
                            BigDecimal amount = orderItemList.parallelStream().filter(item -> purchaseContractItem.getId().equals(item.getSourceItemId())).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            purchaseContractItem.setTargetQuantityAlready(amount);
                            continue;
                        }
                        BigDecimal quantity = orderItemList.parallelStream().filter(item -> purchaseContractItem.getId().equals(item.getSourceItemId())).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractItem.setTargetQuantityAlready(quantity);
                    }
                    if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHeadVO.getTargetType())) {
                        reduce = orderItemList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractHeadVO.setTargetQuantityAlready(((BigDecimal)reduce).toString());
                    } else {
                        reduce = orderItemList.parallelStream().filter(item -> item.getQuantity() != null).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchaseContractHeadVO.setTargetQuantityAlready(((BigDecimal)reduce).toString());
                    }
                }
            } else if (!CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        }
    }

    @GetMapping(value={"/getPreviewData"})
    @RequiresPermissions(value={"contract#purchaseContractHead:getPreviewData"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> getPreviewData(@RequestParam(name="id", required=true) String id) {
        return Result.ok((Object)this.getHtmlById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/getPreviewDataPdf"})
    @RequiresPermissions(value={"contract#purchaseContractHead:getPreviewData"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public void getPreviewDataPdf(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        PurchaseContractHead contractBuyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        String waterMark = contractBuyHead.getWaterMark();
        boolean b = waterMark != null && !"0".equals(waterMark);
        log.info(":::contract.waterMark:" + waterMark);
        String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), b, contractBuyHead.getWaterMarkComment(), null);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                response.addHeader("Access-Control-Allow-Origin", "*");
                response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
                response.setContentType("application/octet-stream");
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    private StringBuilder getHtmlById(String id) {
        Result<?> result = this.queryById(id);
        log.info(":::contract:\u5f00\u59cb\u6570\u636e\u5b57\u5178\u6e32\u67d3");
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText(result);
        log.info(":::contract:\u5f00\u59cb\u8f6c\u5316\u5b9e\u4f53");
        PurchaseContractHeadVO purchaseContractHeadVO = (PurchaseContractHeadVO)((Object)JSON.parseObject((String)result.getResult().toString(), PurchaseContractHeadVO.class));
        log.info(":::contract:\u5f00\u59cb\u5b9e\u4f53\u8d4b\u503c");
        JSONObject jsonObject = (JSONObject)result.getResult();
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        log.info(":::contract:\u5f00\u59cb\u6e32\u67d3\u5408\u540c");
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemList"));
        param.put("pageBreak", "<div style=\"page-break-after:always; \"></div>");
        log.info(":::contract:\u5206\u9875\u7b26\u63d2\u5165");
        List<PurchaseContractContentItem> contractBuyContentItemList = purchaseContractHeadVO.getPurchaseContractContentItemList();
        if (CollectionUtils.isEmpty(contractBuyContentItemList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_saveBeforePreview", (String)"\u8bf7\u4fdd\u5b58\u6761\u6b3e\u884c\u540e\u9884\u89c8"));
        }
        int index = 0;
        if (purchaseContractHeadVO.getTotalTaxAmount().compareTo(BigDecimal.ZERO) > 0) {
            param.put("zh_totalTaxAmount", NumberUtil.number2CNMontrayUnit(purchaseContractHeadVO.getTotalTaxAmount()));
        }
        StringBuilder html = new StringBuilder();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
                param.put("zh_index", NumberUtil.number2Chinese(index));
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"contract#purchaseContractHead:download"})
    public void download(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        PurchaseContractHead contractBuyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        String waterMark = contractBuyHead.getWaterMark();
        boolean b = waterMark != null && !"0".equals(waterMark);
        log.info(":::contract.waterMark:" + waterMark);
        String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), b, contractBuyHead.getWaterMarkComment(), null);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"contract#purchaseContractHead:copy"})
    public Result<?> copy(@RequestParam(value="id") String id) {
        PurchaseContractHeadVO data = this.getData(id);
        data.setReturnState(null);
        data.setInterfaceMsg(null);
        this.purchaseContractHeadService.copy(data);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/upgradeVersion"})
    @RequiresPermissions(value={"contract#purchaseContractHead:upgradeVersion"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> upgradeVersion(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.upgradeVersion(id);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/publish"})
    @RequiresPermissions(value={"contract#purchaseContractHead:publish"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public Result<?> publish(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadService.publish(id);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/queryPurchaseContractItemByMainId"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryPurchaseContractItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemService.selectByMainId(id);
        return Result.ok(purchaseContractItemList);
    }

    @GetMapping(value={"/queryPurchaseContractContentItemByMainId"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryPurchaseContractContentItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemService.selectByMainId(id);
        return Result.ok(purchaseContractContentItemList);
    }

    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryTabsCount(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"contract_status", "count(0) as participateQuantity"}).lambda().ne(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.groupBy((Object)"contract_status");
        List list = ((PurchaseContractHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseContractHead::getContractStatus, PurchaseContractHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "contractStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "contractStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @GetMapping(value={"/countsimple"})
    @RequiresPermissions(value={"contract#purchaseContractHead:list"})
    public Result<?> queryTabsCountSimple(PurchaseContractHead purchaseContractHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"contract_status", "count(0) as participateSimpleQuantity"}).lambda().eq(PurchaseContractHead::getContractType, (Object)"3");
        queryWrapper.groupBy((Object)"contract_status");
        List simple_list = ((PurchaseContractHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = simple_list.stream().collect(Collectors.toMap(PurchaseContractHead::getContractStatus, PurchaseContractHead::getParticipateSimpleQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "contractStatus", null, all));
        List srmReviewStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        for (DictDTO status : srmReviewStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "contractStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @GetMapping(value={"/exportXls"})
    @RequiresPermissions(value={"contract#purchaseContractHead:export"})
    @PermissionDataOpt(businessType="contract", beanClass=PurchaseContractHeadService.class)
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseContractHeadExportServiceImpl.class);
    }

    @GetMapping(value={"/getAuditResult"})
    public Result<?> getAuditResult() {
        RequestCreate requestCreate = new RequestCreate();
        Integer requestCount = requestCreate.getProcessedWorkflowRequestCount("235");
        int PageSize2 = (int)Math.ceil((double)requestCount.intValue() / 10.0);
        if (requestCount > 0) {
            for (int i = 0; i < PageSize2 + 1; ++i) {
                requestCreate.getRequest("235", String.valueOf(i));
            }
        }
        Integer requestCount2 = requestCreate.getProcessedWorkflowRequestCount("157");
        int PageSize22 = (int)Math.ceil((double)requestCount2.intValue() / 10.0);
        if (requestCount2 > 0) {
            for (int i = 0; i < PageSize22 + 1; ++i) {
                requestCreate.getRequest("157", String.valueOf(i));
            }
        }
        return Result.ok();
    }

    @GetMapping(value={"/getAuditRejectResult"})
    public Result<?> getAuditRejectResult() {
        RequestCreate requestCreate = new RequestCreate();
        Integer requestCount = requestCreate.getBeRejectWorkflowRequestCount("235");
        int PageSize2 = (int)Math.ceil((double)requestCount.intValue() / 10.0);
        if (requestCount > 0) {
            for (int i = 0; i < PageSize2 + 1; ++i) {
                requestCreate.getBeRejectWorkflowRequestList("235", String.valueOf(i));
            }
        }
        Integer requestCount2 = requestCreate.getBeRejectWorkflowRequestCount("157");
        int PageSize22 = (int)Math.ceil((double)requestCount2.intValue() / 10.0);
        if (requestCount2 > 0) {
            for (int i = 0; i < PageSize22 + 1; ++i) {
                requestCreate.getBeRejectWorkflowRequestList("157", String.valueOf(i));
            }
        }
        return Result.ok();
    }
}

