/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.SaleContractAcceptance;
import com.els.modules.contract.enums.ContractAcceptanceDocStatusEnum;
import com.els.modules.contract.mapper.PurchaseContractAcceptanceMapper;
import com.els.modules.contract.rpc.service.ContractInvokeDeliveryWaterRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeWorkFlowRpcService;
import com.els.modules.contract.service.PurchaseContractAcceptanceService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.SaleContractAcceptanceService;
import com.els.modules.contract.vo.PurchaseContractAcceptanceVO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseContractAcceptanceServiceImpl
extends BaseServiceImpl<PurchaseContractAcceptanceMapper, PurchaseContractAcceptance>
implements PurchaseContractAcceptanceService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleContractAcceptanceService saleContractAcceptanceService;
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private ContractInvokeDeliveryWaterRpcService contractInvokeDeliveryWaterRpcService;
    @Resource
    private PurchaseContractAcceptanceMapper purchaseContractAcceptanceMapper;
    @Resource
    private ContractInvokeWorkFlowRpcService contractInvokeWorkFlowRpcService;
    @Resource
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    String CONTRACT_ACCEPTANCE = "contractAcceptance";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsSubAccountDTO subAccountDTO = this.invokeAccountRpcService.getAccount(loginUser.getElsAccount(), loginUser.getSubAccount());
        PurchaseContractHead purchaseContractHead = this.purchaseContractHeadService.queryByContractNumber(purchaseContractAcceptance.getMasterContractNumber());
        if (purchaseContractAcceptance.getTaxAmount() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxOLV_9dd48201", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractAcceptance.getMasterContractNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dnetyxOLV_257e8f91", (String)"\u4e3b\u5408\u540c\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (purchaseContractAcceptance.getTaxAmount().compareTo(purchaseContractHead.getTotalTaxAmount()) == 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxjfUdnejxfHf_c1f5cdb6", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u4e3b\u5408\u540c\u7684\u542b\u7a0e\u91d1\u989d"));
        }
        purchaseContractAcceptance.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseContractAcceptance.setDocumentStatus("0");
        if (StringUtils.isNotBlank((CharSequence)subAccountDTO.getOrgCode())) {
            purchaseContractAcceptance.setAcceptanceDepartment(subAccountDTO.getOrgCode());
            String orgCategoryCode = "dept";
            PurchaseOrganizationInfoDTO organizationInfoDTO = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), orgCategoryCode, purchaseContractAcceptance.getAcceptanceDepartment());
            purchaseContractAcceptance.setAcceptanceDepartmentName(organizationInfoDTO.getOrgName());
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractAcceptance.getFbk1())) {
            purchaseContractAcceptance.setFbk1("0");
        }
        purchaseContractAcceptance.setAcceptancePeople(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        purchaseContractAcceptance.setCreateAccount(TenantContext.getTenant());
        purchaseContractAcceptance.setPurchaseName(loginUser.getEnterpriseName());
        purchaseContractAcceptance.setAcceptanceNumbers(this.invokeBaseRpcService.getNextCode("contractAcceptanceNumbers", (Object)purchaseContractAcceptance));
        ((PurchaseContractAcceptanceMapper)this.baseMapper).insert((Object)purchaseContractAcceptance);
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        PurchaseContractHead purchaseContractHead = this.purchaseContractHeadService.queryByContractNumber(purchaseContractAcceptance.getMasterContractNumber());
        if (purchaseContractAcceptance.getTaxAmount() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxOLV_9dd48201", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractAcceptance.getMasterContractNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dnetyxOLV_257e8f91", (String)"\u4e3b\u5408\u540c\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (purchaseContractAcceptance.getTaxAmount().compareTo(purchaseContractHead.getTotalTaxAmount()) == 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxjfUdnejxfHf_c1f5cdb6", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u4e3b\u5408\u540c\u7684\u542b\u7a0e\u91d1\u989d"));
        }
        ((PurchaseContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseContractAcceptance);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractAcceptance.getId());
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    @Override
    public void confirmMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseContractAcceptance.setDocumentStatus("2");
        ((PurchaseContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseContractAcceptance);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractAcceptance.getId());
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
        PurchaseDeliveryWaterDTO purchaseDeliveryWaterVO = new PurchaseDeliveryWaterDTO();
        BeanUtil.copyProperties((Object)((Object)purchaseContractAcceptance), (Object)purchaseDeliveryWaterVO, (String[])new String[0]);
        if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWaterVO)) {
            purchaseDeliveryWaterVO.setDocumentNumber(purchaseContractAcceptance.getAcceptanceNumbers());
            purchaseDeliveryWaterVO.setTotalAmount(purchaseContractAcceptance.getTaxAmount());
            purchaseDeliveryWaterVO.setTotalNonTaxAmount(purchaseContractAcceptance.getNetAmount());
            purchaseDeliveryWaterVO.setDocumentCategory("5");
            purchaseDeliveryWaterVO.setDocumentStatus("\u5df2\u786e\u8ba4");
            this.contractInvokeDeliveryWaterRpcService.insert(purchaseDeliveryWaterVO);
        }
    }

    @Override
    public void updStatus(PurchaseContractAcceptance purchaseContractAcceptance) {
        if (StringUtils.isNotBlank((CharSequence)purchaseContractAcceptance.getId()) && StringUtils.isNotBlank((CharSequence)purchaseContractAcceptance.getDocumentStatus())) {
            PurchaseContractAcceptance oldAcceptance = (PurchaseContractAcceptance)((Object)this.getById((Serializable)((Object)purchaseContractAcceptance.getId())));
            if (oldAcceptance == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
            }
            this.updateById((Object)purchaseContractAcceptance);
            SaleContractAcceptance saleAcceptance = this.saleContractAcceptanceService.getByRelationId(purchaseContractAcceptance.getId());
            if (saleAcceptance != null) {
                saleAcceptance.setDocumentStatus(purchaseContractAcceptance.getDocumentStatus());
                this.saleContractAcceptanceService.updateById((Object)saleAcceptance);
            }
            PurchaseDeliveryWaterDTO purchaseDeliveryWaterVO = new PurchaseDeliveryWaterDTO();
            BeanUtil.copyProperties((Object)((Object)oldAcceptance), (Object)purchaseDeliveryWaterVO, (String[])new String[0]);
            if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWaterVO)) {
                purchaseDeliveryWaterVO.setDocumentNumber(oldAcceptance.getAcceptanceNumbers());
                purchaseDeliveryWaterVO.setTotalAmount(oldAcceptance.getTaxAmount());
                purchaseDeliveryWaterVO.setTotalNonTaxAmount(oldAcceptance.getNetAmount());
                purchaseDeliveryWaterVO.setDocumentCategory("5");
                purchaseDeliveryWaterVO.setDocumentStatus("\u5df2\u786e\u8ba4");
                this.contractInvokeDeliveryWaterRpcService.insert(purchaseDeliveryWaterVO);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VNjsWjS_3baa9dd3", (String)"\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef\uff01"));
        }
    }

    @Override
    public PurchaseContractAcceptanceVO getDataById(String id) {
        PurchaseContractAcceptanceVO purchaseContractAcceptanceVO = new PurchaseContractAcceptanceVO();
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptance), (Object)((Object)purchaseContractAcceptanceVO));
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractAcceptanceVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseContractAcceptanceVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        ((PurchaseContractAcceptanceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            ((PurchaseContractAcceptanceMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void copyData(String id) {
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)((PurchaseContractAcceptanceMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (purchaseContractAcceptance == null) {
            return;
        }
        PurchaseContractAcceptance newContractAcceptance = new PurchaseContractAcceptance();
        newContractAcceptance.setTaxAmount(purchaseContractAcceptance.getTaxAmount());
        newContractAcceptance.setToElsAccount(purchaseContractAcceptance.getToElsAccount());
        newContractAcceptance.setCreateAccount(purchaseContractAcceptance.getCreateAccount());
        newContractAcceptance.setPurchaseName(purchaseContractAcceptance.getPurchaseName());
        newContractAcceptance.setSupplierName(purchaseContractAcceptance.getSupplierName());
        newContractAcceptance.setAcceptanceNumbers(purchaseContractAcceptance.getAcceptanceNumbers());
        newContractAcceptance.setPurchaseOrg(purchaseContractAcceptance.getPurchaseOrg());
        newContractAcceptance.setPurchaseOrgName(purchaseContractAcceptance.getPurchaseOrgName());
        newContractAcceptance.setPurchaseGroup(purchaseContractAcceptance.getPurchaseGroup());
        newContractAcceptance.setPurchaseGroupName(purchaseContractAcceptance.getPurchaseGroupName());
        newContractAcceptance.setCompany(purchaseContractAcceptance.getCompany());
        newContractAcceptance.setAcceptanceInstructions(purchaseContractAcceptance.getAcceptanceInstructions());
        newContractAcceptance.setAcceptanceProject(purchaseContractAcceptance.getAcceptanceProject());
        newContractAcceptance.setAcceptanceProjectName(purchaseContractAcceptance.getAcceptanceProjectName());
        newContractAcceptance.setAcceptanceDepartment(purchaseContractAcceptance.getAcceptanceDepartment());
        newContractAcceptance.setAcceptanceDepartmentName(purchaseContractAcceptance.getAcceptanceDepartmentName());
        newContractAcceptance.setAcceptancePeople(purchaseContractAcceptance.getAcceptancePeople());
        newContractAcceptance.setTaxCode(purchaseContractAcceptance.getTaxCode());
        newContractAcceptance.setTaxRate(purchaseContractAcceptance.getTaxRate());
        newContractAcceptance.setCurrency(purchaseContractAcceptance.getCurrency());
        newContractAcceptance.setLocalCurrency(purchaseContractAcceptance.getLocalCurrency());
        newContractAcceptance.setExchangeRate(purchaseContractAcceptance.getExchangeRate());
        newContractAcceptance.setSign(purchaseContractAcceptance.getSign());
        newContractAcceptance.setOnlineSealed(purchaseContractAcceptance.getOnlineSealed());
        newContractAcceptance.setMasterContractNumber(purchaseContractAcceptance.getMasterContractNumber());
        newContractAcceptance.setContractType(purchaseContractAcceptance.getContractType());
        newContractAcceptance.setContractName(purchaseContractAcceptance.getContractName());
        newContractAcceptance.setContractDesc(purchaseContractAcceptance.getContractDesc());
        newContractAcceptance.setContractParties(purchaseContractAcceptance.getContractParties());
        newContractAcceptance.setContractPromise(purchaseContractAcceptance.getContractPromise());
        newContractAcceptance.setContractDrawer(purchaseContractAcceptance.getContractDrawer());
        newContractAcceptance.setContractReceiver(purchaseContractAcceptance.getContractReceiver());
        newContractAcceptance.setTemplateNumber(purchaseContractAcceptance.getTemplateNumber());
        newContractAcceptance.setTemplateVersion(purchaseContractAcceptance.getTemplateVersion());
        newContractAcceptance.setTemplateName(purchaseContractAcceptance.getTemplateName());
        newContractAcceptance.setTemplateAccount(purchaseContractAcceptance.getTemplateAccount());
        newContractAcceptance.setNeedToConfirm(purchaseContractAcceptance.getNeedToConfirm());
        this.saveMain(newContractAcceptance, new ArrayList<PurchaseAttachmentDTO>());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)this.purchaseContractAcceptanceMapper.selectById((Serializable)((Object)id)));
        if (purchaseContractAcceptance == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        purchaseContractAcceptance.setDocumentStatus("4");
        this.purchaseContractAcceptanceMapper.updateById((Object)purchaseContractAcceptance);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void submit(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.updateMain(purchaseContractAcceptance, purchaseAttachmentList);
        if ("0".equals(purchaseContractAcceptance.getFbk1())) {
            purchaseContractAcceptance.setFbk2(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            this.publish(purchaseContractAcceptance, purchaseAttachmentList);
        } else {
            String subject = "\u5408\u540c\u9a8c\u6536\u5ba1\u6279,\u5355\u53f7\uff1a" + purchaseContractAcceptance.getAcceptanceNumbers();
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(purchaseContractAcceptance.getId());
            dto.setBusinessType(this.CONTRACT_ACCEPTANCE);
            dto.setAuditSubject(subject);
            dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseContractAcceptance)));
            this.contractInvokeWorkFlowRpcService.submit(dto);
        }
    }

    private void insertData(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setSendStatus("0");
                entity.setHeadId(purchaseContractAcceptance.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseContractAcceptance);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void publish(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseContractAcceptance.setDocumentStatus(ContractAcceptanceDocStatusEnum.WAITING_CONFIRM.getValue());
        if ("0".equals(purchaseContractAcceptance.getNeedToConfirm())) {
            this.confirmMain(purchaseContractAcceptance, purchaseAttachmentList);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        TenantContext.setTenant((String)purchaseContractAcceptance.getToElsAccount());
        queryWrapper.lambda().eq(SaleContractAcceptance::getRelationId, (Object)purchaseContractAcceptance.getId());
        SaleContractAcceptance saleContractAcceptance = (SaleContractAcceptance)((Object)this.saleContractAcceptanceService.getOne((Wrapper)queryWrapper));
        TenantContext.setTenant((String)purchaseContractAcceptance.getElsAccount());
        if (Objects.isNull((Object)saleContractAcceptance)) {
            saleContractAcceptance = new SaleContractAcceptance();
            BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptance), (Object)((Object)saleContractAcceptance));
            saleContractAcceptance.setElsAccount(purchaseContractAcceptance.getToElsAccount());
            saleContractAcceptance.setBusAccount(purchaseContractAcceptance.getElsAccount());
            saleContractAcceptance.setPurchaseName(purchaseContractAcceptance.getPurchaseName());
            saleContractAcceptance.setToElsAccount(purchaseContractAcceptance.getElsAccount());
            saleContractAcceptance.setSupplierName(purchaseContractAcceptance.getSupplierName());
            saleContractAcceptance.setCreateAccount(purchaseContractAcceptance.getCreateAccount());
            saleContractAcceptance.setRelationId(purchaseContractAcceptance.getId());
            saleContractAcceptance.setId(null);
            this.saleContractAcceptanceService.save((Object)saleContractAcceptance);
        } else {
            saleContractAcceptance.setDocumentStatus(purchaseContractAcceptance.getDocumentStatus());
            this.saleContractAcceptanceService.updateById((Object)saleContractAcceptance);
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleContractAcceptance.getId());
        }
        purchaseContractAcceptance.setRelationId(saleContractAcceptance.getId());
        this.updateById((Object)purchaseContractAcceptance);
        ArrayList<SaleAttachmentDTO> saleAttachmentDTOList = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO dto : purchaseAttachmentList) {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)dto, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setId(null);
            saleAttachmentDTO.setHeadId(saleContractAcceptance.getId());
            saleAttachmentDTOList.add(saleAttachmentDTO);
        }
        if (!saleAttachmentDTOList.isEmpty() && saleAttachmentDTOList.size() > 0) {
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
        }
        String urlParam = "id=" + purchaseContractAcceptance.getRelationId() + "&templateNumber=" + purchaseContractAcceptance.getTemplateNumber() + "&templateAccount=" + purchaseContractAcceptance.getTemplateAccount() + "&templateVersion=" + purchaseContractAcceptance.getTemplateVersion() + "&open=true";
        super.sendMsg(purchaseContractAcceptance.getElsAccount(), purchaseContractAcceptance.getToElsAccount(), (Object)purchaseContractAcceptance, urlParam, this.CONTRACT_ACCEPTANCE, "publish");
    }
}

