/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class Base64Tool {
    private static final String UPLOAD_PATH = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.path.upload");
    private static final Base64.Decoder DECODER_64 = Base64.getDecoder();
    private static final Base64.Encoder ENCODER_64 = Base64.getEncoder();

    public String fileToBase64Str(String filePath) {
        File file = new File(UPLOAD_PATH + filePath);
        String base64Str = null;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            bin = new BufferedInputStream(fin);
            baos = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            int len = bin.read(buffer);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, len);
                len = bin.read(buffer);
            }
            ((BufferedOutputStream)bout).flush();
            byte[] bytes = baos.toByteArray();
            base64Str = ENCODER_64.encodeToString(bytes).trim();
        }
        catch (IOException e) {
            e.getMessage();
            throw new ELSBootException("\u6587\u4ef6\u8f6cbase64\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            try {
                fin.close();
                bin.close();
                bout.close();
            }
            catch (IOException e) {
                e.getMessage();
            }
        }
        return base64Str;
    }
}

