/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;

public class HttpManager {
    private static final Log logger = LogFactory.getLog(HttpManager.class);
    public CookieStore cookieStore = new BasicCookieStore();

    private CloseableHttpClient getHttpClientSSL() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = null;
        try {
            sslcontext = this.createIgnoreVerifySSL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Registry socketFactoryRegistry = sslcontext != null ? RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build() : RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).setStaleConnectionCheckEnabled(true).build();
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore(this.cookieStore).setDefaultRequestConfig(defaultRequestConfig).build();
        return client;
    }

    private CloseableHttpClient getHttpClient() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = this.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).setStaleConnectionCheckEnabled(true).build();
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore(this.cookieStore).setDefaultRequestConfig(defaultRequestConfig).build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData(String url, Map<String, String> param, Map<String, String> headers) {
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry<String, String> string : param.entrySet()) {
                builder.addParameter(string.getKey(), string.getValue());
            }
            HttpGet get = new HttpGet(builder.build());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)get)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getData(String url, Map<String, String> param) {
        return this.getData(url, param, null);
    }

    public String getDataSSL(String url, Map<String, String> param) throws KeyManagementException, NoSuchAlgorithmException {
        return this.getDataSSL(url, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataSSL(String url, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry<String, String> string : param.entrySet()) {
                builder.addParameter(string.getKey(), string.getValue());
            }
            HttpGet get = new HttpGet(builder.build());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)get)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (URISyntaxException | ClientProtocolException | HttpHostConnectException e) {
            logger.error((Object)("\u8bf7\u6c42\u5730\u5740:" + url + ",\u8bf7\u6c42\u53c2\u6570\uff1a" + param + ",\u54cd\u5e94\u6570\u636e\uff1a" + result));
            e.printStackTrace();
            throw new KeyManagementException(e);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u5730\u5740:" + url + ",\u8bf7\u6c42\u53c2\u6570\uff1a" + param + ",\u54cd\u5e94\u6570\u636e\uff1a" + result));
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataSSLUrl(String url, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        CloseableHttpResponse response = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    stringBuilder.append(entry.getKey());
                    if (entry.getValue() != null) {
                        stringBuilder.append("=").append(entry.getValue());
                    }
                    stringBuilder.append("&");
                }
            }
            if (stringBuilder.length() > 0) {
                url = HttpManager.addUrlParam(url, stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            URIBuilder builder = new URIBuilder(url);
            HttpGet get = new HttpGet(builder.build());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)get)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                result = this.entityToString(entity);
            }
            Iterator<Map.Entry<String, String>> iterator = result;
            return iterator;
        }
        catch (URISyntaxException | ClientProtocolException | HttpHostConnectException e) {
            logger.error((Object)("\u8bf7\u6c42\u5730\u5740:" + url + ",\u8bf7\u6c42\u53c2\u6570\uff1a" + param + ",\u54cd\u5e94\u6570\u636e\uff1a" + result));
            e.printStackTrace();
            throw new KeyManagementException(e);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u5730\u5740:" + url + ",\u8bf7\u6c42\u53c2\u6570\uff1a" + param + ",\u54cd\u5e94\u6570\u636e\uff1a" + result));
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String patchDataSSL(String url, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry<String, String> string : param.entrySet()) {
                builder.addParameter(string.getKey(), string.getValue());
            }
            HttpPatch patch = new HttpPatch(builder.build());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    patch.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)patch)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putDataSSL(String url, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry<String, String> string : param.entrySet()) {
                builder.addParameter(string.getKey(), string.getValue());
            }
            HttpPut put = new HttpPut(builder.build());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    put.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)put)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteDataSSL(String url, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry<String, String> string : param.entrySet()) {
                builder.addParameter(string.getKey(), string.getValue());
            }
            HttpDelete delete = new HttpDelete(builder.build());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    delete.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)delete)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postData(String url, Map<String, String> param, Map<String, String> headers) {
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : param.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        CloseableHttpResponse response = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)post)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (ClientProtocolException clientProtocolException) {
            clientProtocolException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public String postData(String url, Map<String, String> param) {
        return this.postData(url, param, null);
    }

    public String postDataSSL(String url, Map<String, String> param) throws KeyManagementException, NoSuchAlgorithmException {
        return this.postDataSSL(url, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postDataSSL(String url, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : param.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        CloseableHttpResponse response = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)post)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = this.entityToString(httpEntity);
            }
            String string = result;
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (ClientProtocolException clientProtocolException) {
            clientProtocolException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public String postJsonData(String url, String jsonString) {
        return this.postJsonData(url, jsonString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postJsonData(String url, String jsonString, Map<String, String> headers) {
        Object result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            post.setEntity((HttpEntity)new ByteArrayEntity(jsonString.getBytes("UTF-8")));
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)post)) != null && response.getStatusLine().getStatusCode() == 200) {
                entity = response.getEntity();
                result = this.entityToString(entity);
            }
            entity = result;
            return entity;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String postJsonDataSSL(String url, String jsonString) throws KeyManagementException, NoSuchAlgorithmException {
        return this.postJsonDataSSL(url, jsonString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postJsonDataSSL(String url, String jsonString, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        Object result = null;
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            post.setEntity((HttpEntity)new ByteArrayEntity(jsonString.getBytes("UTF-8")));
            post.setHeader("Content-type", "application/json");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)post)) != null && response.getStatusLine().getStatusCode() == 200) {
                entity = response.getEntity();
                result = this.entityToString(entity);
            }
            entity = result;
            return entity;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String entityToString(HttpEntity entity) throws IOException {
        String result = null;
        if (entity != null) {
            long lenth = entity.getContentLength();
            if (lenth != -1L && lenth < 2048L) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            } else {
                int l;
                InputStreamReader reader1 = new InputStreamReader(entity.getContent(), "UTF-8");
                CharArrayBuffer buffer = new CharArrayBuffer(2048);
                char[] tmp = new char[1024];
                while ((l = reader1.read(tmp)) != -1) {
                    buffer.append(tmp, 0, l);
                }
                result = buffer.toString();
            }
        }
        return result;
    }

    public SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSLv3");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String url, String filePath, String contentType, String filekey, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        String result = "";
        try {
            File file = new File(filePath);
            FileInputStream inStream = new FileInputStream(file);
            result = this.uploadFile(url, inStream, file.getName(), contentType, filekey, param, headers);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String url, InputStream inStream, String fileName, String contentType, String filekey, Map<String, String> param, Map<String, String> headers) throws KeyManagementException, NoSuchAlgorithmException {
        CloseableHttpClient httpClient = this.getHttpClientSSL();
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody(filekey, inStream, ContentType.create((String)contentType), fileName);
            for (Map.Entry<String, String> item : param.entrySet()) {
                builder.addTextBody(item.getKey(), item.getValue());
            }
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String getFileName(HttpResponse response) {
        NameValuePair param;
        HeaderElement[] values;
        Header contentHeader = response.getFirstHeader("Content-Disposition");
        String filename = null;
        if (contentHeader != null && (values = contentHeader.getElements()).length == 1 && (param = values[0].getParameterByName("filename")) != null) {
            try {
                filename = new String(param.getValue().toString().getBytes("ISO-8859-1"), "GBK");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getbytes(InputStream is) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] b = new byte[2048];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public boolean downloadFile(String url, OutputStream stream, Map<String, String> param, Map<String, String> headers) {
        try {
            CloseableHttpClient httpClient = this.getHttpClientSSL();
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            InputStream is = entity.getContent();
            byte[] buffer = new byte[10240];
            int ch = 0;
            while ((ch = is.read(buffer)) != -1) {
                stream.write(buffer, 0, ch);
            }
            is.close();
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean downloadFile(String url, String filepath, Map<String, String> param, Map<String, String> headers) {
        try {
            CloseableHttpClient httpClient = this.getHttpClientSSL();
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            InputStream is = entity.getContent();
            File file = new File(filepath);
            file.getParentFile().mkdirs();
            FileOutputStream fileout = new FileOutputStream(file);
            byte[] buffer = new byte[10240];
            int ch = 0;
            while ((ch = is.read(buffer)) != -1) {
                fileout.write(buffer, 0, ch);
            }
            is.close();
            fileout.flush();
            fileout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String addUrlParam(String url, String ... param) {
        if (param != null) {
            for (String str : param) {
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                url = url.indexOf("?") >= 0 ? url + "&" + str : url + "?" + str;
            }
        }
        return url;
    }
}

