/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.modules.contract.utils.HttpManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import weaver.rsa.security.RSA;

@Service
public class IdentityVerifyUtil {
    private static final Logger log = LoggerFactory.getLogger(IdentityVerifyUtil.class);
    public static final String APPID = "EEAA1234-5678-4BE0-8C6C-89E9D88805EA";
    private String HOST = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.oaHost");
    private String SPK = null;
    private String SECRET = null;
    private static IdentityVerifyUtil instance;

    public static synchronized IdentityVerifyUtil getInstance() {
        if (instance == null) {
            instance = new IdentityVerifyUtil();
            instance.regist();
        }
        return instance;
    }

    private IdentityVerifyUtil() {
    }

    private void regist() {
        HttpManager http = new HttpManager();
        HashMap<String, String> heads = new HashMap<String, String>();
        new RSA();
        String cpk = RSA.getRSA_PUB();
        heads.put("appid", APPID);
        heads.put("cpk", cpk);
        log.info("******************************************cpk*****\u8fd4\u56de\u53c2\u6570*****" + cpk);
        try {
            JSONObject result;
            log.info("******************************************regist()***\u53c2\u6570*****" + heads);
            log.info("******************************************regist()***HOST*****" + this.HOST);
            String data = http.postDataSSL(this.HOST + "/api/ec/dev/auth/regist", new HashMap<String, String>(), heads);
            log.info("******************************************regist*return*data***\u8fd4\u56de\u53c2\u6570*****" + data);
            if (data != null && "true".equals((result = JSON.parseObject((String)data)).getString("status"))) {
                this.SPK = result.getString("spk");
                this.SECRET = result.getString("secrit");
                log.info("****************************SECRET**************data***\u8fd4\u56de\u53c2\u6570*****" + this.SECRET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getToken() {
        String getToken;
        block4: {
            getToken = null;
            HttpManager http = new HttpManager();
            HashMap<String, String> heads = new HashMap<String, String>();
            RSA rsa = new RSA();
            String secret = rsa.encrypt(null, this.SECRET, null, "utf-8", this.SPK, false);
            heads.put("appid", APPID);
            heads.put("secret", secret);
            try {
                String data = http.postDataSSL(this.HOST + "/api/ec/dev/auth/applytoken", new HashMap<String, String>(), heads);
                if (data != null) {
                    JSONObject res = JSON.parseObject((String)data);
                    if ("true".equals(res.getString("status"))) {
                        log.info("****************\u8fd4\u56de********OAtoken*************" + res.getString("token"));
                        getToken = res.getString("token");
                    }
                    break block4;
                }
                throw new ELSBootException("\u65e0\u6cd5\u8fde\u63a5OA\u7cfb\u7edf\u63a5\u53e3\uff0c\u8bf7\u8054\u7cfbOA\u4eba\u5458");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return getToken;
    }

    public static Map<String, String> getHttpHeads(String token, String userid, String spk) {
        HashMap<String, String> heads = new HashMap<String, String>();
        heads.put("token", token);
        heads.put("appid", APPID);
        RSA rsa = new RSA();
        log.info("***************************\u52a0\u5bc6\u524d\u7684userid***********************" + userid);
        String secretUserid = rsa.encrypt(null, userid, null, "utf-8", spk, false);
        log.info("***************************\u52a0\u5bc6\u540e\u7684userid***********************" + secretUserid);
        heads.put("userid", secretUserid);
        return heads;
    }

    public String getSPK() {
        return this.SPK;
    }

    public String getSECRET() {
        return this.SECRET;
    }
}

