/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class PdfUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfUtil.class);

    public static String htmlToPdf(String fileRootPath, String html, final String fileName, boolean water, final String waterString, PageSize pageSize) throws Exception {
        File saveDirFile;
        if (fileRootPath == null) {
            fileRootPath = "D:\\pdf";
        }
        if (StrUtil.isBlank((CharSequence)html)) {
            return null;
        }
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        if (!(saveDirFile = new File(fileRootPath)).exists()) {
            saveDirFile.mkdirs();
        }
        String filePath = fileRootPath + "/" + fileName + ".pdf";
        PdfWriter pdfWriter = new PdfWriter(new File(fileRootPath + "/", FilenameUtils.getName((String)(fileName + ".pdf"))));
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pageSize);
        ConverterProperties pro = new ConverterProperties();
        DefaultFontProvider fontProvider = new DefaultFontProvider();
        fontProvider.addDirectory("/usr/share/fonts/chinese");
        Collection fonts = fontProvider.getFontSet().getFonts();
        log.info(":::contract font path: /usr/share/fonts/chinese/\u5b57\u4f53\u5217\u8868" + JSONArray.toJSONString((Object)fonts));
        pro.setFontProvider((FontProvider)fontProvider);
        IEventHandler handlerStartPage = new IEventHandler(){

            public void handleEvent(Event event) {
                PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                PdfDocument pdf = docEvent.getDocument();
                PdfPage page = docEvent.getPage();
                PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                int height = (int)page.getPageSize().getHeight();
                int width = (int)page.getPageSize().getWidth();
                Rectangle rect = new Rectangle((float)width / 2.0f - 10.0f, 10.0f, 36.0f, 32.0f);
                Canvas canvas = new Canvas(pdfCanvas, rect);
                canvas.add((IBlockElement)new Paragraph(String.valueOf(pdf.getNumberOfPages())).setFontSize(12.0f));
                canvas.showTextAligned("NO.:" + fileName, (float)width - 170.0f, (float)height - 25.0f, TextAlignment.LEFT);
                canvas.close();
            }
        };
        pdfDocument.addEventHandler("StartPdfPage", handlerStartPage);
        if (water) {
            IEventHandler handlerEndPage = new IEventHandler(){

                public void handleEvent(Event event) {
                    PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                    PdfDocument pdf = docEvent.getDocument();
                    PdfPage page = docEvent.getPage();
                    PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                    PdfFont font = null;
                    try {
                        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
                        if (path.startsWith("file:/")) {
                            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("static/simfang.ttf");
                            font = PdfFontFactory.createFont((byte[])PdfUtil.toByteArray(resourceAsStream), (String)"Identity-H", (boolean)false);
                        } else {
                            log.info(":::contract font path:" + path + "static/simfang.ttf");
                            font = PdfFontFactory.createFont((String)(path + "static/simfang.ttf"), (String)"Identity-H", (boolean)false);
                        }
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    ((Canvas)((Canvas)((Canvas)((Canvas)new Canvas(pdfCanvas, pdf, page.getPageSize()).setFontSize(36.0f)).setOpacity(Float.valueOf(0.2f))).setFont(font)).setFontColor((Color)new DeviceRgb(255, 0, 0))).showTextAligned(new Paragraph(waterString), 298.0f, 421.0f, pdf.getPageNumber(page), TextAlignment.CENTER, VerticalAlignment.MIDDLE, 45.0f);
                }
            };
            pdfDocument.addEventHandler("EndPdfPage", handlerEndPage);
        }
        HtmlConverter.convertToPdf((String)html.replaceAll("\u21b5", "").replaceAll("<!-- pagebreak -->", "<div style=\"page-break-after: always;\">&nbsp;</div>").replaceAll("<table border=\"1\" style=\"border-collapse: collapse; width: 100%; border-color: #000000;\" .*?>", "<table border=\"1\" style=\"border-collapse: collapse; width: 100%; border-color: #000000;\">"), (PdfDocument)pdfDocument, (ConverterProperties)pro);
        return filePath;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static String changeTemplate(String html) {
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        StringBuilder newHtml = new StringBuilder();
        if (center.length() != 0) {
            newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        } else {
            newHtml.append(html);
        }
        return newHtml.toString();
    }

    public static void main(String[] args) throws Exception {
        String html = "<h4>${zh_index}\u3001\u7269\u6599\u6e05\u5355\u5217\u8868</h4>\r\n<table style=\"border-collapse: collapse; width: 99.1736%; height: 40px;\" border=\"1\">\r\n<tbody>\r\n<p><span style=\"font-family: Akpdmi-n;\">\u4f60\u597d</span></p>\n<p><span style=\"font-family: Broadway;\">NI Hao</span></p>\n<p><span style=\"font-family: Broadway;\">\u60a8\u597d</span></p>\n<p><span style=\"font-family: Algerian;\">NI Hao</span></p>\n<p><span style=\"font-family: Algerian;\">\u60a8\u597d</span></p>\n<p><span style=\"font-family: Calibri;\">NI Hao</span></p>\n<p><span style=\"font-family: Calibri;\">\u60a8\u597d</span></p>\n<p>\u5fae\u8f6f \u96c5\u9ed1<span style=\"font-family: \u5fae\u8f6f\u96c5\u9ed1;\">NI Hao</span></p>\n<p> \u5b8b \u4f53<span style=\"font-family: \u5b8b\u4f53;\">\u4f60\u597d</span></p>\n<p> \u9ed1 \u4f53<span style=\"font-family: \u9ed1\u4f53;\">\u4f60\u597d</span></p>\n<p> \u4eff \u5b8b<span style=\"font-family: \u4eff\u5b8b;\">\u4f60\u597d</span></p>\n<p>GB2312<span style=\"font-family: \u6977\u4f53-GB2312;\">\u4f60\u597d</span></p>\n<p> \u6977 \u4f53<span style=\"font-family: \u6977\u4f53;\">\u4f60\u597d</span></p>\n<p> \u65b0 \u5b8b\u4f53<span style=\"font-family: \u65b0\u5b8b\u4f53;\">\u4f60\u597d</span></p>\n<p><span style=\"font-family: \u4e91\u5cf0\u9759\u9f99\u884c\u4e66;\">\u6d4b\u8bd5</span></p>\n<p><span style=\"font-family: yctets;\">\u4f60\u597d</span></p>\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">\u7269\u6599\u7f16\u7801</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">\u7269\u6599\u63cf\u8ff0</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">\u89c4\u683c</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">\u6570\u91cf</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">\u5355\u4ef7</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">\u91d1\u989d</td>\r\n</tr>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">${(item.materialCode)!''}</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">${(item.materialDesc)!''}</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">${(item.materialSpec)!''}</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">${(item.quantity)!''}</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">${(item.price)!''}</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">${(item.taxAmount)!''}</td>\r\n</tr>\r\n</tbody>\r\n</table>";
        html = html.replace("\u65b0\u5b8b\u4f53", "NSimSun");
        html = html.replace("\u5fae\u8f6f\u96c5\u9ed1", "Microsoft YaHei");
        html = html.replace("\u5b8b\u4f53", "SimSun");
        html = html.replace("\u9ed1\u4f53", "SimHei");
        html = html.replace("\u4eff\u5b8b", "FangSong");
        html = html.replace("\u6977\u4f53-GB2312", "KaiTi_GB2312");
        html = html.replace("\u6977\u4f53", "KaiTi");
        html = html.replace("\u4e91\u5cf0\u9759\u9f99\u884c\u4e66", "YUNFENGJINGLONGXINGSHU-");
        html = html.replace("yctets", "REEJI-ZhenyanGB2.0-Bold");
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        System.out.println(head);
        System.out.println("----------------------------------------");
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        System.out.println(center);
        System.out.println("----------------------------------------");
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        System.out.println(last);
        System.out.println("----------------------------------------");
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        System.out.println(newHtml);
        PdfUtil.htmlToPdf(null, newHtml.toString(), "CN200901901_1.pdf", false, "", PageSize.A4);
    }
}

