/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.project.entity.PurchaseProjectInitiationHead;
import com.els.modules.project.mapper.PurchaseProjectInitiationHeadMapper;
import com.els.modules.project.service.PurchaseProjectInitiationHeadService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseProjectInitiationHeadServiceImpl
extends BaseServiceImpl<PurchaseProjectInitiationHeadMapper, PurchaseProjectInitiationHead>
implements PurchaseProjectInitiationHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseProjectInitiationHeadServiceImpl.class);
    @Value(value="${oa.systemid}")
    private String systemid;
    @Value(value="${oa.password}")
    private String password;
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;
    @Autowired
    private PurchaseProjectInitiationHeadMapper PurchaseProjectInitiationHeadMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseProjectInitiationHead purchaseProjectInitiationHead) {
        ((PurchaseProjectInitiationHeadMapper)this.baseMapper).insert((Object)purchaseProjectInitiationHead);
        super.setHeadDefaultValue((BaseEntity)purchaseProjectInitiationHead);
        this.insertData(purchaseProjectInitiationHead);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseProjectInitiationHead purchaseProjectInitiationHead) {
        int count = ((PurchaseProjectInitiationHeadMapper)this.baseMapper).updateById((Object)purchaseProjectInitiationHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(purchaseProjectInitiationHead);
    }

    private void insertData(PurchaseProjectInitiationHead purchaseProjectInitiationHead) {
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        ((PurchaseProjectInitiationHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            ((PurchaseProjectInitiationHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void getProjectInitiationFormOA(int pageNo) {
        String srmInterfaceCode = "getProjectInitiationFormOA";
        String elsAccount = TenantContext.getTenant();
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)srmInterfaceCode);
        JSONObject body = new JSONObject();
        body.put("datajson", (Object)this.parameterAssemble(pageNo));
        param.put("body", (Object)body);
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        log.info("\u62c9\u53d6OA\u9879\u76ee\u6d88\u606f\u5f00\u59cb \u5165\u53c2:" + param);
        JSONObject resultObj = interfaceUtil.callInterface(elsAccount, null, param, null);
        log.info("\u62c9\u53d6OA\u9879\u76ee\u6d88\u606f\u7ed3\u675f \u51fa\u53c2:" + resultObj);
        JSONObject result = resultObj.getJSONObject("result");
        JSONArray resultArray = result.getJSONArray("result");
        List templateList = this.baseRpcService.getDefaultTemplateByType("projectInitiation");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u9879\u76ee\u4fe1\u606f\u6a21\u677f"));
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        List dbProjectList = ((PurchaseProjectInitiationHeadMapper)this.baseMapper).selectList(null);
        Map<String, String> map = dbProjectList.stream().collect(Collectors.toMap(PurchaseProjectInitiationHead::getProjectNumber, BaseEntity::getId));
        QueryWrapper purchaseOrganizationInfoQueryWrapper = new QueryWrapper();
        purchaseOrganizationInfoQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        purchaseOrganizationInfoQueryWrapper.eq((Object)"is_deleted", (Object)"0");
        List purchaseOrganizationInfoList = this.purchaseOrganizationInfoService.list((Wrapper)purchaseOrganizationInfoQueryWrapper);
        ArrayList<PurchaseProjectInitiationHead> projectInitiationHeadList = new ArrayList<PurchaseProjectInitiationHead>();
        for (int i = 0; i < resultArray.size(); ++i) {
            JSONObject item = resultArray.getJSONObject(i);
            String mainTable = item.getString("mainTable");
            mainTable = mainTable.replace("\\\"", "");
            PurchaseProjectInitiationHead purchaseProjectInitiationHead = (PurchaseProjectInitiationHead)((Object)JSON.parseObject((String)mainTable, PurchaseProjectInitiationHead.class));
            purchaseProjectInitiationHead.setTemplateAccount(template.getElsAccount());
            purchaseProjectInitiationHead.setTemplateName(template.getTemplateName());
            purchaseProjectInitiationHead.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
            purchaseProjectInitiationHead.setTemplateNumber(template.getTemplateNumber());
            purchaseProjectInitiationHead.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseProjectInitiationHead.setElsAccount(SysUtil.getPurchaseAccount());
            purchaseProjectInitiationHead.setBusAccount(SysUtil.getPurchaseAccount());
            ElsSubAccountService elsSubAccountService = (ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class);
            ElsSubAccount account = (ElsSubAccount)elsSubAccountService.getById((Serializable)((Object)purchaseProjectInitiationHead.getCreateById()));
            if (account == null) {
                account = (ElsSubAccount)elsSubAccountService.getById((Serializable)((Object)"738"));
                purchaseProjectInitiationHead.setProjectLeader("738");
            }
            ElsSubAccount ProjectLeader = (ElsSubAccount)elsSubAccountService.getById((Serializable)((Object)purchaseProjectInitiationHead.getProjectLeader()));
            if (purchaseOrganizationInfoList.size() > 0) {
                List collect = purchaseOrganizationInfoList.stream().filter(p -> p.getSourceId().equals(purchaseProjectInitiationHead.getAffiliatedCompany())).collect(Collectors.toList());
                List collect2 = purchaseOrganizationInfoList.stream().filter(p -> p.getSourceId().equals(purchaseProjectInitiationHead.getProjectDeptCompany())).collect(Collectors.toList());
                if (collect.size() > 0) {
                    purchaseProjectInitiationHead.setAffiliatedCompanyName(((PurchaseOrganizationInfo)collect.get(0)).getOrgName());
                }
                if (collect2.size() > 0) {
                    purchaseProjectInitiationHead.setProjectDeptCompanyName(((PurchaseOrganizationInfo)collect2.get(0)).getOrgName());
                }
            }
            if (account != null) {
                purchaseProjectInitiationHead.setCreateBy(account.getSubAccount());
                purchaseProjectInitiationHead.setUpdateBy(account.getSubAccount() + "_" + account.getRealname());
                purchaseProjectInitiationHead.setCreateBy(account.getSubAccount() + "_" + account.getRealname());
            }
            if (ProjectLeader != null) {
                purchaseProjectInitiationHead.setProjectLeaderName(ProjectLeader.getRealname());
            }
            purchaseProjectInitiationHead.setUpdateById(purchaseProjectInitiationHead.getCreateById());
            purchaseProjectInitiationHead.setCreateTime(new Date());
            purchaseProjectInitiationHead.setUpdateTime(new Date());
            if (map.containsKey(purchaseProjectInitiationHead.getProjectNumber())) {
                purchaseProjectInitiationHead.setId(map.get(purchaseProjectInitiationHead.getProjectNumber()));
                ((PurchaseProjectInitiationHeadMapper)this.baseMapper).updateById((Object)purchaseProjectInitiationHead);
                continue;
            }
            projectInitiationHeadList.add(purchaseProjectInitiationHead);
        }
        if (!CollectionUtils.isEmpty(projectInitiationHeadList)) {
            ((PurchaseProjectInitiationHeadMapper)this.baseMapper).insertBatchSomeColumn(projectInitiationHeadList);
        }
    }

    private JSONObject parameterAssemble(int i) {
        JSONObject operationinfo = new JSONObject();
        operationinfo.put("operator", (Object)(SysUtil.getLoginUser() != null ? SysUtil.getLoginUser().getId() : "738"));
        JSONObject mainTable = new JSONObject();
        JSONObject pageInfo = new JSONObject();
        pageInfo.put("pageNo", (Object)String.valueOf(i));
        pageInfo.put("pageSize", (Object)"80");
        JSONObject header = this.assembleHeader(new Date());
        JSONObject datajson = new JSONObject();
        datajson.put("operationinfo", (Object)operationinfo);
        datajson.put("mainTable", (Object)mainTable);
        datajson.put("pageInfo", (Object)pageInfo);
        datajson.put("header", (Object)header);
        return datajson;
    }

    private JSONObject parameterAssemble2() {
        JSONObject operationinfo = new JSONObject();
        operationinfo.put("operator", (Object)(SysUtil.getLoginUser() != null ? SysUtil.getLoginUser().getId() : "738"));
        JSONObject mainTable = new JSONObject();
        mainTable.put("id", (Object)"");
        mainTable.put("xmzt", (Object)"1");
        JSONObject header = this.assembleHeader(new Date());
        JSONObject datajson = new JSONObject();
        datajson.put("operationinfo", (Object)operationinfo);
        datajson.put("mainTable", (Object)mainTable);
        datajson.put("header", (Object)header);
        return datajson;
    }

    private JSONObject assembleHeader(Date date) {
        JSONObject header = new JSONObject();
        header.put("systemid", (Object)this.systemid);
        header.put("currentDateTime", (Object)DateUtils.formatDate((Date)date, (String)"yyyyMMddHHmmss"));
        header.put("Md5", (Object)MD5.create().digestHex(this.systemid + this.password + DateUtils.formatDate((Date)date, (String)"yyyyMMddHHmmss")));
        return header;
    }

    @Override
    public Integer getProjectTotalFormOA() {
        String srmInterfaceCode = "getProjectTotalFormOA";
        String elsAccount = TenantContext.getTenant();
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)srmInterfaceCode);
        JSONObject body = new JSONObject();
        body.put("datajson", (Object)this.parameterAssemble2());
        param.put("body", (Object)body);
        try {
            InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
            log.info("\u62c9\u53d6OA\u9879\u76ee\u603b\u6570\u5f00\u59cb \u5165\u53c2:" + param);
            JSONObject resultObj = interfaceUtil.callInterface(elsAccount, null, param, null);
            log.info("\u62c9\u53d6OA\u9879\u76ee\u603b\u6570\u7ed3\u675f \u51fa\u53c2:" + resultObj);
            JSONObject result = resultObj.getJSONObject("result");
            JSONObject parse = JSONObject.parseObject((String)result.getString("result"));
            String pageCount = parse.getString("pageCount");
            int parseInt = Integer.parseInt(pageCount);
            return parseInt;
        }
        catch (Exception e) {
            throw new ELSBootException("\u62c9\u53d6\u9879\u76ee\u603b\u6570\u5931\u8d25:" + e);
        }
    }

    @Override
    public PurchaseProjectInitiationHead getProjectByProjectNumber(String projectNumber) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PurchaseProjectInitiationHead::getProjectNumber, (Object)projectNumber);
        return (PurchaseProjectInitiationHead)((Object)this.getOne((Wrapper)queryWrapper));
    }

    @Override
    public PurchaseProjectInitiationHead getProjectByProjectNumber2(String projectNumber) {
        PurchaseProjectInitiationHead purchaseProjectInitiationHead = new PurchaseProjectInitiationHead();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_number", (Object)projectNumber);
        List list = this.PurchaseProjectInitiationHeadMapper.selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            purchaseProjectInitiationHead = (PurchaseProjectInitiationHead)((Object)list.get(0));
        }
        return purchaseProjectInitiationHead;
    }
}

