/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;

public class Htm2WordUtil {
    private static final Logger log = LoggerFactory.getLogger(Htm2WordUtil.class);

    public static String html2Word(String html, String fileRootPath, String wordFileName) {
        String wordFilePath = fileRootPath + "/" + wordFileName;
        byte[] htmlBytes = html.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(htmlBytes);
        POIFSFileSystem poifs = new POIFSFileSystem();
        DirectoryNode directory = poifs.getRoot();
        DocumentEntry documentEntry = directory.createDocument("WordDocument", (InputStream)inputStream);
        FileOutputStream outputStream = new FileOutputStream(wordFilePath);
        poifs.writeFilesystem((OutputStream)outputStream);
        inputStream.close();
        outputStream.close();
        return wordFilePath;
    }

    public static String htmlWord(String html, String fileRootPath, String wordFileName) {
        String charset2;
        Template template = null;
        String wordFilePath = fileRootPath + "/" + wordFileName;
        String charset = Htm2WordUtil.getCharset(html);
        if (!"utf-8".equals(charset) && StringUtils.isNotBlank((String)charset)) {
            html = html.replaceAll(charset, "utf-8");
        }
        if (!"utf-8".equals(charset2 = Htm2WordUtil.getCharset2(html)) && StringUtils.isNotBlank((String)charset2)) {
            html = html.replaceAll(charset2, "utf-8");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(wordFilePath), "UTF-8");
        FreeMarkerConfigurationFactory configurationFactory = new FreeMarkerConfigurationFactory();
        Configuration cfg = configurationFactory.createConfiguration();
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("contract", html);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        template = cfg.getTemplate("contract", "UTF-8");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("html", html);
        template.process(data, (Writer)writer);
        writer.flush();
        writer.close();
        return wordFilePath;
    }

    private static String getCharset(String content) {
        String charset = "";
        String regex = "charset='(.*?)'";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        if (m.find()) {
            charset = m.group(1);
        }
        return charset;
    }

    private static String getCharset2(String content) {
        String charset = "";
        String regex = "charset=3D(.[\\s\\S]*?)'";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        if (m.find()) {
            charset = m.group(1);
        }
        return charset;
    }
}

