/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.SaleContractAcceptance;
import com.els.modules.contract.mapper.PurchaseContractAcceptanceMapper;
import com.els.modules.contract.rpc.service.ContractInvokeDeliveryWaterRpcService;
import com.els.modules.contract.service.PurchaseContractAcceptanceService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.SaleContractAcceptanceService;
import com.els.modules.contract.vo.PurchaseContractAcceptanceVO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseContractAcceptanceServiceImpl
extends BaseServiceImpl<PurchaseContractAcceptanceMapper, PurchaseContractAcceptance>
implements PurchaseContractAcceptanceService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleContractAcceptanceService saleContractAcceptanceService;
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private ContractInvokeDeliveryWaterRpcService contractInvokeDeliveryWaterRpcService;
    @Resource
    private PurchaseContractAcceptanceMapper purchaseContractAcceptanceMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkContractAcceptance(purchaseContractAcceptance);
        purchaseContractAcceptance.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseContractAcceptance.setDocumentStatus("1");
        purchaseContractAcceptance.setCreateAccount(TenantContext.getTenant());
        purchaseContractAcceptance.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        purchaseContractAcceptance.setAcceptanceNumbers(this.invokeBaseRpcService.getNextCode("contractAcceptanceNumbers", (Object)purchaseContractAcceptance));
        ((PurchaseContractAcceptanceMapper)this.baseMapper).insert((Object)purchaseContractAcceptance);
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    private void checkContractAcceptance(PurchaseContractAcceptance purchaseContractAcceptance) {
        PurchaseContractHead purchaseContractHead = this.purchaseContractHeadService.queryByContractNumber(purchaseContractAcceptance.getMasterContractNumber());
        if (purchaseContractAcceptance.getTaxAmount() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxOLV_9dd48201", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractAcceptance.getMasterContractNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dnetyxOLV_257e8f91", (String)"\u4e3b\u5408\u540c\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (purchaseContractHead != null && purchaseContractAcceptance.getTaxAmount().compareTo(purchaseContractHead.getTotalTaxAmount()) > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CSBSxfHfxjfUdnejxfHf_c1f5cdb6", (String)"\u52b3\u52a1\u670d\u52a1\u542b\u7a0e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u4e3b\u5408\u540c\u7684\u542b\u7a0e\u91d1\u989d"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkContractAcceptance(purchaseContractAcceptance);
        BigDecimal tax = new BigDecimal(0);
        BigDecimal netAccount = new BigDecimal(0);
        if (StringUtils.isNotBlank((CharSequence)purchaseContractAcceptance.getTaxRate()) && BigDecimal.ZERO.compareTo(tax = BigDecimal.valueOf(1.0 + Double.valueOf(purchaseContractAcceptance.getTaxRate()) / 100.0)) != 0) {
            netAccount = purchaseContractAcceptance.getTaxAmount().divide(tax, 5, 4);
        }
        purchaseContractAcceptance.setNetAmount(netAccount);
        ((PurchaseContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseContractAcceptance);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractAcceptance.getId());
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    @Override
    public void confirmMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseContractAcceptance.setDocumentStatus("2");
        ((PurchaseContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseContractAcceptance);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractAcceptance.getId());
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
        PurchaseDeliveryWaterDTO purchaseDeliveryWaterVO = new PurchaseDeliveryWaterDTO();
        BeanUtil.copyProperties((Object)((Object)purchaseContractAcceptance), (Object)purchaseDeliveryWaterVO, (String[])new String[0]);
        if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWaterVO)) {
            purchaseDeliveryWaterVO.setDocumentNumber(purchaseContractAcceptance.getAcceptanceNumbers());
            purchaseDeliveryWaterVO.setTotalAmount(purchaseContractAcceptance.getTaxAmount());
            purchaseDeliveryWaterVO.setTotalNonTaxAmount(purchaseContractAcceptance.getNetAmount());
            purchaseDeliveryWaterVO.setDocumentCategory("5");
            purchaseDeliveryWaterVO.setDocumentStatus("\u5df2\u786e\u8ba4");
            this.contractInvokeDeliveryWaterRpcService.insert(purchaseDeliveryWaterVO);
        }
    }

    @Override
    public void updStatus(PurchaseContractAcceptance purchaseContractAcceptance) {
        if (StringUtils.isNotBlank((CharSequence)purchaseContractAcceptance.getId()) && StringUtils.isNotBlank((CharSequence)purchaseContractAcceptance.getDocumentStatus())) {
            PurchaseContractAcceptance oldAcceptance = (PurchaseContractAcceptance)((Object)this.getById((Serializable)((Object)purchaseContractAcceptance.getId())));
            if (oldAcceptance == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
            }
            this.updateById((Object)purchaseContractAcceptance);
            SaleContractAcceptance saleAcceptance = this.saleContractAcceptanceService.getByRelationId(purchaseContractAcceptance.getId());
            if (saleAcceptance != null) {
                saleAcceptance.setDocumentStatus(purchaseContractAcceptance.getDocumentStatus());
                this.saleContractAcceptanceService.updateById((Object)saleAcceptance);
            }
            PurchaseDeliveryWaterDTO purchaseDeliveryWaterVO = new PurchaseDeliveryWaterDTO();
            BeanUtil.copyProperties((Object)((Object)oldAcceptance), (Object)purchaseDeliveryWaterVO, (String[])new String[0]);
            if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWaterVO)) {
                purchaseDeliveryWaterVO.setDocumentNumber(oldAcceptance.getAcceptanceNumbers());
                purchaseDeliveryWaterVO.setTotalAmount(oldAcceptance.getTaxAmount());
                purchaseDeliveryWaterVO.setTotalNonTaxAmount(oldAcceptance.getNetAmount());
                purchaseDeliveryWaterVO.setDocumentCategory("5");
                purchaseDeliveryWaterVO.setDocumentStatus("\u5df2\u786e\u8ba4");
                this.contractInvokeDeliveryWaterRpcService.insert(purchaseDeliveryWaterVO);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VNjsWjS_3baa9dd3", (String)"\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef\uff01"));
        }
    }

    @Override
    public PurchaseContractAcceptanceVO getDataById(String id) {
        PurchaseContractAcceptanceVO purchaseContractAcceptanceVO = new PurchaseContractAcceptanceVO();
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptance), (Object)((Object)purchaseContractAcceptanceVO));
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractAcceptanceVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseContractAcceptanceVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        ((PurchaseContractAcceptanceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            ((PurchaseContractAcceptanceMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void copyData(String id) {
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)((PurchaseContractAcceptanceMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        purchaseContractAcceptance.setId(null);
        purchaseContractAcceptance.setAcceptanceNumbers(null);
        purchaseContractAcceptance.setElsAccount(TenantContext.getTenant());
        purchaseContractAcceptance.setDocumentStatus("0");
        purchaseContractAcceptance.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        purchaseContractAcceptance.setCreateById(SysUtil.getLoginUser().getId());
        purchaseContractAcceptance.setCreateTime(new Date());
        purchaseContractAcceptance.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        purchaseContractAcceptance.setUpdateById(SysUtil.getLoginUser().getId());
        purchaseContractAcceptance.setUpdateTime(null);
        this.saveMain(purchaseContractAcceptance, new ArrayList<PurchaseAttachmentDTO>());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)this.purchaseContractAcceptanceMapper.selectById((Serializable)((Object)id)));
        if (purchaseContractAcceptance == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        purchaseContractAcceptance.setDocumentStatus("4");
        this.purchaseContractAcceptanceMapper.updateById((Object)purchaseContractAcceptance);
    }

    private void insertData(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setSendStatus("0");
                entity.setHeadId(purchaseContractAcceptance.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseContractAcceptance);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }
}

