/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.mapper.PurchaseContractItemMapper;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.contract.service.ContractGeneratePriceService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractGeneratePriceServiceImpl
implements ContractGeneratePriceService {
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Autowired
    private PurchaseContractItemMapper purchaseContractItemMapper;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;

    @Override
    public List<PurchaseInformationRecordsDTO> generatePrice(PurchaseContractHeadVO headVO) {
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        PurchaseContractHead dbHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)headVO.getId())));
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        List collect = purchaseContractItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseContractItems = this.purchaseContractItemMapper.selectBatchIds(collect);
        List<PurchaseInformationRecordsDTO> purchaseInformationRecordsDTOS = new ArrayList<PurchaseInformationRecordsDTO>();
        if (dbHead.getBusinessType().equals("0") && dbHead.getContractType().equals("2")) {
            purchaseInformationRecordsDTOS = this.contractInvokeMainDataRpcService.generatePrice(templateHeadDTO, dbHead, purchaseContractItems);
        } else if (dbHead.getBusinessType().equals("1")) {
            purchaseInformationRecordsDTOS = this.contractInvokeMainDataRpcService.generatePrice(templateHeadDTO, dbHead, purchaseContractItems);
        } else if (dbHead.getBusinessType().equals("2") && dbHead.getContractType().equals("2")) {
            purchaseInformationRecordsDTOS = this.contractInvokeMainDataRpcService.generatePrice(templateHeadDTO, dbHead, purchaseContractItems);
        }
        return purchaseInformationRecordsDTOS;
    }
}

