/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.enumerate.ContractItemSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractItemService;
import com.els.modules.contract.vo.PurchaseContractHeadOaVO;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.extend.api.dto.ExtendAuditInputParamDTO;
import com.els.modules.extend.api.oa.OaReqDto;
import com.els.modules.extend.api.oa.OaUtils;
import com.els.modules.extend.api.service.ExtendPurchaseOrderHeadService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseContractHeadAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractHeadAuditOptCallBackServiceImpl.class);
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private PurchaseContractItemService purchaseContractItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO) {
        log.info("start PurchaseContractHeadAuditOptCallBackServiceImpl.startCallBack() ,BusinessId[{}]", (Object)inputParamVO.getBusinessId());
        PurchaseContractHeadVO headVO = (PurchaseContractHeadVO)((Object)JSONObject.parseObject((String)inputParamVO.getParams(), PurchaseContractHeadVO.class));
        ExtendAuditInputParamDTO dto = (ExtendAuditInputParamDTO)SysUtil.copyProperties((Object)inputParamVO, ExtendAuditInputParamDTO.class);
        dto.setParams(null);
        OaUtils oaUtils = (OaUtils)SpringContextUtils.getBean(OaUtils.class);
        String userCode = headVO.getCreateBy();
        String account = oaUtils.getUserIdByAccount(headVO.getCreateBy());
        headVO.setCreateBy(account);
        String companyId = oaUtils.getCompanyIdByAccount(userCode);
        headVO.setFbk12(companyId);
        try {
            List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("paymentTerm", headVO.getElsAccount());
            String conditionName = dictDTOS.stream().filter(info -> StrUtil.equals((CharSequence)info.getValue(), (CharSequence)headVO.getPaymentCondition())).findFirst().get().getText();
            headVO.setPaymentCondition(conditionName);
        }
        catch (Exception e) {
            log.error("\u5408\u540c\u8f6c\u6362\u4ed8\u6b3e\u6761\u4ef6\u7f16\u7801\u9519\u8bef");
        }
        OaReqDto oaReqDto = PurchaseContractHeadOaVO.convert(headVO, dto);
        log.debug("\u5408\u540c\u7ba1\u7406\u5ba1\u6279\u5230oa\u7684\u6570\u636e:" + oaReqDto);
        JSONObject jsonObject = oaUtils.callInterface((Object)oaReqDto, account);
        List orderItemList = headVO.getPurchaseContractItemList().stream().filter(p -> ContractItemSourceTypeEnum.ORDER.getValue().equals(p.getSourceType())).peek(item -> item.setFbk1("1")).collect(Collectors.toList());
        this.purchaseContractItemService.updateBatchById(orderItemList);
        ExtendPurchaseOrderHeadService extendPurchaseOrderHeadService = (ExtendPurchaseOrderHeadService)SpringContextUtils.getBean(ExtendPurchaseOrderHeadService.class);
        List orderItemIds = orderItemList.stream().map(PurchaseContractItem::getSourceItemId).distinct().collect(Collectors.toList());
        extendPurchaseOrderHeadService.updatePurchaseOrderHeadByContractCreate(orderItemIds);
        PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
        purchaseContractHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseContractHead.setId(inputParamVO.getBusinessId());
        purchaseContractHead.setFlowId(jsonObject.getString("requestid"));
        this.purchaseContractHeadService.updateById((Object)purchaseContractHead);
        log.info("update purchaseContractHead AuditStatus  AUDIT_NEW to AUDIT_DOING success");
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamVO) {
        PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)inputParamDTO.getBusinessId())));
        contractHead.setFlowId(outputParamVO.getProcessRootId());
        contractHead.setAuditOpinion(outputParamVO.getOpinion());
        contractHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
        this.purchaseContractHeadService.updateById((Object)contractHead);
        List<PurchaseContractItem> itemList = this.purchaseContractItemService.selectByMainId(inputParamDTO.getBusinessId());
        List orderItem = itemList.stream().filter(p -> ContractItemSourceTypeEnum.ORDER.getValue().equals(p.getSourceType())).peek(item -> item.setFbk2("1")).collect(Collectors.toList());
        this.purchaseContractItemService.updateBatchById(itemList);
        List orderItemIds = orderItem.stream().map(PurchaseContractItem::getSourceItemId).distinct().collect(Collectors.toList());
        ExtendPurchaseOrderHeadService extendPurchaseOrderHeadService = (ExtendPurchaseOrderHeadService)SpringContextUtils.getBean(ExtendPurchaseOrderHeadService.class);
        extendPurchaseOrderHeadService.updatePurchaseOrderHeadByContractFinish(orderItemIds);
        log.info("workflow complete...update purchaseContractHead:{}", (Object)JSONObject.toJSONString((Object)((Object)contractHead)));
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamVO) {
        PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)inputParamDTO.getBusinessId())));
        contractHead.setFlowId(outputParamVO.getProcessRootId());
        contractHead.setAuditOpinion(outputParamVO.getOpinion());
        contractHead.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
        contractHead.setContractStatus(ContractStatusEnum.CONTRACT_NEW.getValue());
        this.purchaseContractHeadService.updateById((Object)contractHead);
        log.info("workflow reject...update purchaseContractHead AuditStatus AUDIT_DOING to AUDIT_NEW");
    }

    public void cancelCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
    }

    public JSONObject getDataById(String s) {
        return null;
    }
}

