/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.vo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.extend.api.dto.ExtendAuditInputParamDTO;
import com.els.modules.extend.api.oa.OaReqDto;
import com.els.modules.extend.api.oa.WorkFlowId;
import com.els.modules.extend.api.utils.ExtendTenantContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PurchaseContractHeadOaVO {
    public static OaReqDto convert(PurchaseContractHeadVO headVO, ExtendAuditInputParamDTO extendParam) {
        ArrayList<JSONObject> files = new ArrayList<JSONObject>();
        for (PurchaseAttachmentDTO attachmentDTO : headVO.getPurchaseAttachmentList()) {
            String fileUrl = ExtendTenantContext.getDefaultConfigServiceAddr() + "/els/attachment/purchaseAttachment/noToken/download?id=" + attachmentDTO.getId() + "&fullfilename=" + attachmentDTO.getFileName();
            JSONObject file = new JSONObject();
            file.set("fileName", (Object)attachmentDTO.getFileName());
            file.set("filePath", (Object)fileUrl);
            files.add(file);
        }
        OaReqDto oaReqDto = new OaReqDto();
        oaReqDto.setAccount(headVO.getCreateBy());
        oaReqDto.setWorkflowId(WorkFlowId.CONTRACT_APPROVAL);
        oaReqDto.setRequestName(headVO.getContractName());
        ArrayList dataList = CollUtil.newArrayList((Object[])new OaReqDto.data[0]);
        dataList.add(new OaReqDto.data("extendparam", (Object)extendParam));
        dataList.add(new OaReqDto.data("jbr", (Object)headVO.getCreateBy()));
        dataList.add(new OaReqDto.data("sqrq", (Object)DateUtil.format((Date)headVO.getCreateTime(), (String)"yyyy-MM-dd")));
        dataList.add(new OaReqDto.data("htbh", (Object)headVO.getContractNumber()));
        dataList.add(new OaReqDto.data("htzt0", (Object)headVO.getFbk12()));
        dataList.add(new OaReqDto.data("gys", (Object)headVO.getSupplierName()));
        dataList.add(new OaReqDto.data("cplhtlx", (Object)headVO.getContractType()));
        dataList.add(new OaReqDto.data("cplhtxl", (Object)headVO.getFbk2()));
        dataList.add(new OaReqDto.data("htsx1", (Object)headVO.getFbk3()));
        dataList.add(new OaReqDto.data("htsx2", (Object)headVO.getFbk4()));
        dataList.add(new OaReqDto.data("htsx3", (Object)headVO.getFbk5()));
        dataList.add(new OaReqDto.data("htsx4", (Object)headVO.getFbk6()));
        dataList.add(new OaReqDto.data("jkxb", (Object)headVO.getFbk7()));
        dataList.add(new OaReqDto.data("htqdlx", (Object)headVO.getFbk8()));
        dataList.add(new OaReqDto.data("htzje", (Object)headVO.getTotalTaxAmount()));
        dataList.add(new OaReqDto.data("bzzl", (Object)headVO.getCurrency()));
        dataList.add(new OaReqDto.data("fkfs0", (Object)headVO.getPaymentCondition()));
        dataList.add(new OaReqDto.data("kpfs", (Object)headVO.getPaymentType()));
        dataList.add(new OaReqDto.data("zqlx", (Object)headVO.getFbk9()));
        dataList.add(new OaReqDto.data("htsxrq", (Object)DateUtil.format((Date)headVO.getEffectiveDate(), (String)"yyyy-MM-dd")));
        dataList.add(new OaReqDto.data("htjsrq", (Object)DateUtil.format((Date)headVO.getExpiryDate(), (String)"yyyy-MM-dd")));
        dataList.add(new OaReqDto.data("splx", (Object)headVO.getFbk10()));
        dataList.add(new OaReqDto.data("fqfkbl", (Object)headVO.getFbk11()));
        dataList.add(new OaReqDto.data("qtzl", files));
        oaReqDto.setMainData(JSONUtil.toJsonStr((Object)dataList));
        ArrayList detailDataList = CollUtil.newArrayList((Object[])new OaReqDto.detailData[0]);
        OaReqDto.detailData detailData2 = new OaReqDto.detailData();
        detailData2.setTableDBName("formtable_main_26_dt1");
        ArrayList workflowRequestTableRecords = CollUtil.newArrayList((Object[])new OaReqDto.WorkflowRequestTableRecord[0]);
        for (PurchaseContractItem purchaseContractItem : headVO.getPurchaseContractItemList()) {
            OaReqDto.WorkflowRequestTableRecord workflowRequestTableRecord = new OaReqDto.WorkflowRequestTableRecord();
            ArrayList workflowRequestTableFields = CollUtil.newArrayList((Object[])new OaReqDto.data[0]);
            workflowRequestTableFields.add(new OaReqDto.data("cgddh", (Object)purchaseContractItem.getSourceNumber()));
            workflowRequestTableFields.add(new OaReqDto.data("PROJECT_NAME", (Object)purchaseContractItem.getFbk3()));
            workflowRequestTableFields.add(new OaReqDto.data("Project_no", (Object)purchaseContractItem.getFbk4()));
            workflowRequestTableFields.add(new OaReqDto.data("material_name", (Object)purchaseContractItem.getMaterialName()));
            workflowRequestTableFields.add(new OaReqDto.data("jg1", (Object)purchaseContractItem.getTaxAmount()));
            workflowRequestTableFields.add(new OaReqDto.data("sfwxp", (Object)purchaseContractItem.getFbk5()));
            workflowRequestTableRecord.setWorkflowRequestTableFields((List)workflowRequestTableFields);
            workflowRequestTableRecords.add(workflowRequestTableRecord);
        }
        detailData2.setWorkflowRequestTableRecords((List)workflowRequestTableRecords);
        detailDataList.add(detailData2);
        oaReqDto.setDetailData(JSONUtil.toJsonStr((Object)detailDataList));
        return oaReqDto;
    }
}

