/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.mapper.SaleContractPromiseMapper;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.vo.PurchaseContractHeadExternalVO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import eunmerate.ContractSourceEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseContactCreateServiceImpl
implements OpenApiRpcService {
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Resource
    private SaleContractHeadService saleContractHeadService;
    @Resource
    private SaleContractPromiseMapper saleContractPromiseMapper;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public JSONObject doCreateInvoke(JSONArray jsonArray, TemplateHeadDTO templateHeadDTO, Map<String, String> map, Map<String, String> map1) {
        String elsAccount = TenantContext.getTenant();
        for (Object obj : jsonArray) {
            TemplateHeadDTO templateHeadDTONew;
            JSONObject object = (JSONObject)obj;
            PurchaseContractHeadExternalVO headVO = (PurchaseContractHeadExternalVO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)object), PurchaseContractHeadExternalVO.class));
            PurchaseContractHead purchaseContractHead = new PurchaseContractHead();
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseContractHead));
            this.handleCheckInfo(purchaseContractHead, elsAccount);
            List templateList = this.invokeBaseRpcService.getTemplateByType("contract");
            if (!CollectionUtils.isEmpty((Collection)templateList) && null != (templateHeadDTONew = (TemplateHeadDTO)templateList.stream().filter(v -> v.getTemplateNumber().equals("TC2022092102")).findAny().orElse(null))) {
                purchaseContractHead.setTemplateId(templateHeadDTONew.getId());
                purchaseContractHead.setTemplateNumber(templateHeadDTONew.getTemplateNumber());
                purchaseContractHead.setTemplateName(templateHeadDTONew.getTemplateName());
                purchaseContractHead.setTemplateVersion(templateHeadDTONew.getTemplateVersion().toString());
                purchaseContractHead.setTemplateAccount(templateHeadDTONew.getElsAccount());
            }
            if (!CollectionUtils.isEmpty(headVO.getPurchaseAttachmentList())) {
                templateHeadDTONew = headVO.getPurchaseAttachmentList().iterator();
                while (templateHeadDTONew.hasNext()) {
                    PurchaseAttachmentDTO attachment = (PurchaseAttachmentDTO)templateHeadDTONew.next();
                    LoginUser sysUser = SysUtil.getLoginUser();
                    attachment.setFileType("5");
                    attachment.setSourceType("2");
                    attachment.setUploadTime(new Date());
                    attachment.setUploadSubAccount(sysUser.getRealname());
                    attachment.setUploadElsAccount(elsAccount);
                }
            }
            purchaseContractHead.setFbk11(ContractSourceEnum.CONTRACT_SYSTEM.getValue());
            this.purchaseContractHeadService.saveMain(purchaseContractHead, headVO.getItemList(), null, headVO.getPurchaseAttachmentList(), headVO.getContractItemCustom1List(), null, null, null, null, null);
            SaleContractHead saleContractHead = new SaleContractHead();
            BeanUtils.copyProperties((Object)((Object)purchaseContractHead), (Object)((Object)saleContractHead));
            saleContractHead.setId(null);
            saleContractHead.setRelationId(purchaseContractHead.getId());
            saleContractHead.setToElsAccount(elsAccount);
            saleContractHead.setElsAccount(purchaseContractHead.getToElsAccount());
            ArrayList<SaleContractItem> saleContractItemList = new ArrayList<SaleContractItem>();
            if (!CollectionUtils.isEmpty(headVO.getItemList())) {
                List<PurchaseContractItem> itemList = headVO.getItemList();
                for (PurchaseContractItem purchaseContractItem : itemList) {
                    SaleContractItem saleItem = new SaleContractItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)((Object)saleItem));
                    saleItem.setElsAccount(saleContractHead.getElsAccount());
                    saleContractItemList.add(saleItem);
                }
            }
            ArrayList<SaleAttachmentDTO> saleAttachmentList = new ArrayList<SaleAttachmentDTO>();
            if (!CollectionUtils.isEmpty(headVO.getPurchaseAttachmentList())) {
                List<PurchaseAttachmentDTO> purchaseAttachmentList = headVO.getPurchaseAttachmentList();
                for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                    SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                    BeanUtils.copyProperties((Object)attachment, (Object)saleAttachment);
                    saleAttachment.setElsAccount(saleContractHead.getElsAccount());
                    saleAttachmentList.add(saleAttachment);
                }
            }
            ArrayList<SaleContractPromise> salePromiseList = new ArrayList<SaleContractPromise>();
            if (!CollectionUtils.isEmpty(headVO.getContractItemCustom1List())) {
                List<PurchaseContractPromise> list = headVO.getContractItemCustom1List();
                for (PurchaseContractPromise promise : list) {
                    SaleContractPromise saleContractPromise = new SaleContractPromise();
                    BeanUtils.copyProperties((Object)((Object)promise), (Object)((Object)saleContractPromise));
                    saleContractPromise.setElsAccount(saleContractHead.getElsAccount());
                    saleContractPromise.setToElsAccount(elsAccount);
                    saleContractPromise.setBusAccount(elsAccount);
                    salePromiseList.add(saleContractPromise);
                }
            }
            this.saleContractHeadService.createContract(saleContractHead, saleContractItemList, null, saleAttachmentList, salePromiseList);
        }
        return null;
    }

    void handleCheckInfo(PurchaseContractHead purchaseContractHead, String elsAccount) {
        String purchaseOrg;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SupplierMasterData::getSupplierCode, (Object)purchaseContractHead.getSupplierCode());
        List supplierList = this.supplierMasterDataService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)supplierList)) {
            throw new ELSBootException("\u8be5\u4f9b\u5e94\u5546\u5728SRM\u4e2d\u4e0d\u5b58\u5728");
        }
        SupplierMasterData supplierMasterData = (SupplierMasterData)supplierList.get(0);
        purchaseContractHead.setToElsAccount(supplierMasterData.getToElsAccount());
        String purchaseGroup = purchaseContractHead.getPurchaseGroup();
        if (!StringUtils.isEmpty((Object)purchaseGroup)) {
            PurchaseOrganizationInfoDTO purchaseGroupInfo = this.findOrgInfoByCode(elsAccount, "purchaseGroup", purchaseGroup);
            if (null != purchaseGroupInfo) {
                purchaseContractHead.setPurchaseGroupName(purchaseGroupInfo.getOrgName());
            } else {
                throw new ELSBootException("\u91c7\u8d2d\u7ec4" + purchaseGroup + "\u5728SRM\u7ec4\u7ec7\u67b6\u6784\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
            }
        }
        if (!StringUtils.isEmpty((Object)(purchaseOrg = purchaseContractHead.getPurchaseOrg()))) {
            PurchaseOrganizationInfoDTO purchaseOrgInfo = this.findOrgInfoByCode(elsAccount, "purchaseOrganization", purchaseOrg);
            if (null != purchaseOrgInfo) {
                purchaseContractHead.setPurchaseOrgName(purchaseOrgInfo.getOrgName());
            } else {
                throw new ELSBootException("\u91c7\u8d2d\u7ec4\u7ec7" + purchaseOrg + "\u5728SRM\u7ec4\u7ec7\u67b6\u6784\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
            }
        }
        String company = purchaseContractHead.getCompany();
    }

    PurchaseOrganizationInfoDTO findOrgInfoByCode(String elsAccount, String orgType, String orgCode) {
        PurchaseOrganizationInfoDTO orgInfo = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(elsAccount, orgType, orgCode);
        return orgInfo;
    }

    public void doParamCheck(JSONArray jsonArray, TemplateHeadDTO templateHeadDTO, Map<String, String> map, Map<String, String> map1, List<TemplateConfigHeadDTO> list, List<TemplateConfigItemDTO> list1) {
    }

    public String getBusinessType() {
        return "order";
    }
}

