/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractContentItemHis;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractHeadHis;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractItemHis;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.entity.SaleContractContentItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.enumerate.ContractPromiseSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.mapper.ContractItemCustom1Mapper;
import com.els.modules.contract.mapper.ContractItemCustom2Mapper;
import com.els.modules.contract.mapper.ContractItemCustom3Mapper;
import com.els.modules.contract.mapper.ContractItemCustom4Mapper;
import com.els.modules.contract.mapper.ContractItemCustom5Mapper;
import com.els.modules.contract.mapper.PurchaseContractContentItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractContentItemMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadHisMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractItemMapper;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.mapper.SaleContractContentItemMapper;
import com.els.modules.contract.mapper.SaleContractHeadMapper;
import com.els.modules.contract.mapper.SaleContractItemMapper;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeOrderRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeSupplierRpcService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.order.api.service.PurchaseOrderNewRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import eunmerate.ContractSourceEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseContractHeadServiceImpl
extends BaseServiceImpl<PurchaseContractHeadMapper, PurchaseContractHead>
implements PurchaseContractHeadService {
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Resource
    private PurchaseContractItemMapper purchaseContractItemMapper;
    @Resource
    private PurchaseContractContentItemMapper purchaseContractContentItemMapper;
    @Resource
    private PurchaseContractHeadHisMapper purchaseContractHeadHisMapper;
    @Resource
    private PurchaseContractItemHisMapper purchaseContractItemHisMapper;
    @Resource
    private PurchaseContractContentItemHisMapper purchaseContractContentItemHisMapper;
    @Resource
    private SaleContractHeadMapper saleContractHeadMapper;
    @Resource
    private SaleContractItemMapper saleContractItemMapper;
    @Resource
    private SaleContractContentItemMapper saleContractContentItemMapper;
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Resource
    private ContractItemCustom1Mapper contractItemCustom1Mapper;
    @Resource
    private ContractItemCustom2Mapper contractItemCustom2Mapper;
    @Resource
    private ContractItemCustom3Mapper contractItemCustom3Mapper;
    @Resource
    private ContractItemCustom4Mapper contractItemCustom4Mapper;
    @Resource
    private ContractItemCustom5Mapper contractItemCustom5Mapper;
    @Autowired
    private ContractInvokeOrderRpcService contractInvokeOrderRpcService;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private ContractInvokeSupplierRpcService contractInvokeSupplierRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Resource
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Resource
    private PurchaseOrderNewRpcService purchaseOrderNewRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        this.checkPrice(purchaseContractHead, purchaseContractItemList, contractItemCustom2List);
        if (StringUtils.isBlank((CharSequence)purchaseContractHead.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractNumber", (Object)purchaseContractHead);
            purchaseContractHead.setContractNumber(nextCode);
        } else {
            List one = this.purchaseContractHeadMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(PurchaseContractHead::getContractNumber, (Object)purchaseContractHead.getContractNumber()));
            if (!CollectionUtils.isEmpty((Collection)one)) {
                purchaseContractHead.setId(((PurchaseContractHead)((Object)one.get(0))).getId());
                purchaseContractHead.setElsAccount(TenantContext.getTenant());
                this.updateMain(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
                return;
            }
        }
        if (null != purchaseContractHead.getExpiryDate() && null != purchaseContractHead.getEffectiveDate() && purchaseContractHead.getExpiryDate().before(purchaseContractHead.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_neKXBAxOQUnejXAKBA_a225d91b", (String)"\u5408\u540c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5408\u540c\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        purchaseContractHead.setBusAccount(TenantContext.getTenant());
        super.setHeadDefaultValue((BaseEntity)purchaseContractHead);
        if (StringUtils.isBlank((CharSequence)purchaseContractHead.getFbk11()) || !ContractSourceEnum.CONTRACT_SYSTEM.getValue().equals(purchaseContractHead.getFbk11())) {
            this.calculateAmount(purchaseContractHead, purchaseContractItemList, contractItemCustom1List);
        }
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        purchaseContractHead.setFbk8("0");
        purchaseContractHead.setFbk10(StringUtils.isBlank((CharSequence)purchaseContractHead.getFbk10()) ? purchaseContractHead.getFbk9() : String.valueOf(Integer.parseInt(purchaseContractHead.getFbk10()) - 1));
        this.purchaseContractHeadMapper.insert((Object)purchaseContractHead);
        this.insertData(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
        this.checkPrice(purchaseContractHead, purchaseContractItemList, contractItemCustom2List);
    }

    private void calculateAmount(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<ContractItemCustom1> contractItemCustom1List) {
        if (CollectionUtil.isNotEmpty(purchaseContractItemList)) {
            BigDecimal taxAmount = new BigDecimal(0L);
            BigDecimal netAmount = new BigDecimal(0L);
            BigDecimal targetQuantity = new BigDecimal(0L);
            for (PurchaseContractItem item : purchaseContractItemList) {
                if (null != item.getPrice() && null != item.getQuantity()) {
                    BigDecimal temAmount = item.getPrice().multiply(item.getQuantity()).setScale(4, 4);
                    item.setTaxAmount(temAmount);
                    taxAmount = taxAmount.add(temAmount).setScale(4, 4);
                }
                if (null != item.getPrice() && null != item.getQuantity() && null != item.getTaxRate()) {
                    BigDecimal tax = BigDecimal.valueOf(1.0 - Double.valueOf(item.getTaxRate()) / 100.0);
                    BigDecimal netPrice = item.getPrice().multiply(tax).setScale(4, 4);
                    BigDecimal temAmount = netPrice.multiply(item.getQuantity()).setScale(4, 4);
                    item.setNetPrice(netPrice);
                    item.setNetAmount(temAmount);
                    netAmount = netAmount.add(temAmount).setScale(4, 4);
                }
                targetQuantity = purchaseContractItemList.parallelStream().filter(i -> i.getTargetQuantity() != null).map(PurchaseContractItem::getTargetQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            purchaseContractHead.setTotalNetAmount(netAmount);
            purchaseContractHead.setTotalTaxAmount(taxAmount);
            purchaseContractHead.setTargetQuantity(targetQuantity.toString());
        }
        if (CollectionUtil.isEmpty(purchaseContractItemList) && CollectionUtil.isNotEmpty(contractItemCustom1List)) {
            BigDecimal targetQuantity = new BigDecimal(0L);
            targetQuantity = contractItemCustom1List.parallelStream().filter(i -> i.getAmount() != null).map(ContractItemCustom1::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseContractHead.setTargetQuantity(targetQuantity.toString());
        }
    }

    void checkPrice(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<ContractItemCustom2> contractItemCustom2List) {
        String templateName = purchaseContractHead.getTemplateName();
        String contractType = purchaseContractHead.getContractType();
        String contractNumber = purchaseContractHead.getContractNumber();
        if (StringUtils.isNotBlank((CharSequence)templateName) && "\u94c5\u5408\u540c\u6a21\u677f".equals(templateName)) {
            if (StringUtils.isNotBlank((CharSequence)contractType) && contractType.equals("1")) {
                Date expiryDate = purchaseContractHead.getExpiryDate();
                LocalDate today = LocalDate.now();
                if (null != expiryDate) {
                    LocalDate expiryDateLocal = expiryDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    boolean a = expiryDateLocal.isEqual(today);
                    boolean b = today.isAfter(expiryDateLocal);
                    if (a || b) {
                        this.purchaseOrderNewRpcService.changeOrderPrice(contractNumber);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)contractType) && contractType.equals("2") && !CollectionUtils.isEmpty(contractItemCustom2List)) {
                BigDecimal quantity;
                BigDecimal sumFbk1 = new BigDecimal(0);
                for (ContractItemCustom2 var : contractItemCustom2List) {
                    sumFbk1 = sumFbk1.add(null != var.getFbk1() ? var.getFbk1() : new BigDecimal(0));
                }
                if (!CollectionUtils.isEmpty(purchaseContractItemList) && (quantity = purchaseContractItemList.get(0).getQuantity()).compareTo(sumFbk1) == 0) {
                    this.purchaseOrderNewRpcService.changeOrderPricePoint(contractNumber);
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        this.checkPrice(purchaseContractHead, purchaseContractItemList, contractItemCustom2List);
        PurchaseContractHead dbPurchaseContractHead = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)purchaseContractHead.getId())));
        if ("1".equals(purchaseContractHead.getFbk8()) && !dbPurchaseContractHead.getToElsAccount().equals(purchaseContractHead.getToElsAccount())) {
            throw new ELSBootException("\u5df2\u5efa\u8ba2\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u5408\u540c\u4f9b\u5e94\u5546");
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractHead.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractNumber", (Object)purchaseContractHead);
            purchaseContractHead.setContractNumber(nextCode);
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseContractHead.getContractNumber()) && CollectionUtil.isNotEmpty(purchaseContractItemList)) {
            BigDecimal toOrderQuantity = this.purchaseContractItemMapper.selectQuantityByContractNumber(purchaseContractHead.getContractNumber());
            BigDecimal updateQuantity = purchaseContractItemList.stream().map(PurchaseContractItem::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (null != toOrderQuantity && toOrderQuantity.compareTo(updateQuantity) == 1) {
                throw new ELSBootException("\u5df2\u8f6c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u5f53\u524d\u5408\u540c\u6240\u4fee\u6539\u7684\u6570\u91cf,\u4e0d\u5141\u8bb8\u4fee\u6539");
            }
        }
        if (CollectionUtil.isNotEmpty(contractItemCustom2List)) {
            BigDecimal pointQuantity = contractItemCustom2List.stream().map(ContractItemCustom2::getFbk1).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (purchaseContractItemList.get(0).getQuantity().compareTo(pointQuantity) == -1) {
                throw new ELSBootException("\u5269\u4f59\u70b9\u4ef7\u6570\u91cf\u4e0d\u8db3");
            }
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractHead.getFbk11()) || !ContractSourceEnum.CONTRACT_SYSTEM.getValue().equals(purchaseContractHead.getFbk11())) {
            this.calculateAmount(purchaseContractHead, purchaseContractItemList, contractItemCustom1List);
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseContractHead.getFbk10()) && StringUtils.equals((CharSequence)purchaseContractHead.getFbk10(), (CharSequence)"0")) {
            throw new ELSBootException("\u5269\u4f59\u70b9\u4ef7\u6b21\u6570\u4e3a\u96f6\uff0c\u65e0\u6cd5\u4fdd\u5b58\u70b9\u4ef7\u8bb0\u5f55\uff01");
        }
        purchaseContractHead.setFbk10(StringUtils.isBlank((CharSequence)purchaseContractHead.getFbk10()) ? purchaseContractHead.getFbk9() : String.valueOf(Integer.parseInt(purchaseContractHead.getFbk10()) - 1));
        int count = this.purchaseContractHeadMapper.updateById((Object)purchaseContractHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (null != purchaseContractHead.getExpiryDate() && null != purchaseContractHead.getEffectiveDate() && purchaseContractHead.getExpiryDate().before(purchaseContractHead.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_neKXBAxOQUnejXAKBA_a225d91b", (String)"\u5408\u540c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5408\u540c\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        this.purchaseContractItemMapper.deleteByMainId(purchaseContractHead.getId());
        this.purchaseContractContentItemMapper.deleteByMainId(purchaseContractHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractHead.getId());
        this.purchaseContractPromiseMapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom1Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom2Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom3Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom4Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom5Mapper.deleteByMainId(purchaseContractHead.getId());
        this.insertData(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
        this.checkPrice(purchaseContractHead, purchaseContractItemList, contractItemCustom2List);
    }

    public static void main(String[] args) {
        boolean a = LocalDate.of(2020, 6, 10).isAfter(LocalDate.of(2020, 6, 9));
        System.out.println(a);
    }

    @Override
    public void checkMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        this.checkPrice(purchaseContractHead, purchaseContractItemList, contractItemCustom2List);
        List one = this.purchaseContractHeadMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(PurchaseContractHead::getContractNumber, (Object)purchaseContractHead.getContractNumber()));
        purchaseContractHead.setContractStatus("8");
        if (CollectionUtil.isNotEmpty((Collection)one)) {
            this.updateMain(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
        } else {
            this.saveMain(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
        }
        this.checkPrice(purchaseContractHead, purchaseContractItemList, contractItemCustom2List);
    }

    private void insertData(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        int count;
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            count = 1;
            for (PurchaseContractItem purchaseContractItem : purchaseContractItemList) {
                if (!purchaseContractHead.getTemplateName().contains("\u94c5")) {
                    String materialNumber;
                    String storageLocation;
                    String factory = purchaseContractItem.getFactory();
                    if (StringUtils.isNotBlank((CharSequence)factory)) {
                        PurchaseOrganizationInfoDTO factoryInfo = this.findOrgInfoByCode(TenantContext.getTenant(), "factory", factory);
                        if (null != factoryInfo) {
                            purchaseContractItem.setFactoryName(factoryInfo.getOrgName());
                        } else {
                            throw new ELSBootException("\u5de5\u5382" + purchaseContractItem.getFactory() + "\u5728SRM\u7ec4\u7ec7\u67b6\u6784\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)(storageLocation = purchaseContractItem.getStorageLocation()))) {
                        PurchaseOrganizationInfoDTO locationInfo = this.findOrgInfoByCode(TenantContext.getTenant(), "location", storageLocation);
                        if (null != locationInfo) {
                            purchaseContractItem.setStorageLocationName(locationInfo.getOrgName());
                        } else {
                            throw new ELSBootException("\u5e93\u5b58\u5730\u70b9" + purchaseContractItem.getStorageLocation() + "\u5728SRM\u7ec4\u7ec7\u67b6\u6784\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)(materialNumber = purchaseContractItem.getMaterialNumber())) && StringUtils.isNotBlank((CharSequence)factory)) {
                        QueryWrapper materialWrapper = new QueryWrapper();
                        materialWrapper.eq((Object)"material_number", (Object)materialNumber);
                        materialWrapper.eq((Object)"factory", (Object)factory);
                        PurchaseMaterialItem one = (PurchaseMaterialItem)this.purchaseMaterialItemService.getOne((Wrapper)materialWrapper);
                        if (one == null) {
                            throw new ELSBootException("SRM\u7269\u6599\u4e3b\u6570\u636e\u4e2d\u8be5\u5de5\u5382:" + factory + "\u4e0b\u65e0\u8be5\u7269\u6599:" + materialNumber + "\uff0c\u8bf7\u786e\u8ba4!");
                        }
                        purchaseContractItem.setMaterialDesc(one.getMaterialDesc());
                    }
                }
                purchaseContractItem.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractItem, (BaseEntity)purchaseContractHead);
                purchaseContractItem.setElsAccount(TenantContext.getTenant());
                purchaseContractItem.setItemNumber(count + "");
                ++count;
            }
            if (!purchaseContractItemList.isEmpty()) {
                this.purchaseContractItemMapper.insertBatchSomeColumn(purchaseContractItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseContractContentItemList)) {
            count = 1;
            for (PurchaseContractContentItem purchaseContractContentItem : purchaseContractContentItemList) {
                purchaseContractContentItem.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractContentItem, (BaseEntity)purchaseContractHead);
                purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
                purchaseContractContentItem.setItemNumber(count);
                ++count;
            }
            if (!purchaseContractContentItemList.isEmpty()) {
                this.purchaseContractContentItemMapper.insertBatchSomeColumn(purchaseContractContentItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(purchaseContractHead.getId());
                purchaseAttachmentDTO.setRelationId(IdWorker.getIdStr());
                purchaseAttachmentDTO.setUploadElsAccount(purchaseContractHead.getElsAccount());
                purchaseAttachmentDTO.setBusinessType("contract");
                purchaseAttachmentDTO.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseContractHead);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            for (PurchaseContractPromise purchaseContractPromise : purchaseContractPromiseList) {
                purchaseContractPromise.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractPromise, (BaseEntity)purchaseContractHead);
                purchaseContractPromise.setElsAccount(TenantContext.getTenant());
                purchaseContractPromise.setBusAccount(TenantContext.getTenant());
                purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
                purchaseContractPromise.setPromiseStatus(ContractPromiseStatusEnum.CONFIRMED.getValue());
            }
            if (!purchaseContractPromiseList.isEmpty()) {
                this.purchaseContractPromiseMapper.insertBatchSomeColumn(purchaseContractPromiseList);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            int count2 = 1;
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                contractItemCustom1.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom1, (BaseEntity)purchaseContractHead);
                contractItemCustom1.setContractNumber(purchaseContractHead.getContractNumber());
                contractItemCustom1.setElsAccount(TenantContext.getTenant());
                contractItemCustom1.setItemNumber(count2 + "");
                ++count2;
            }
            if (!contractItemCustom1List.isEmpty()) {
                this.contractItemCustom1Mapper.insertBatchSomeColumn(contractItemCustom1List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom2List)) {
            for (ContractItemCustom2 contractItemCustom2 : contractItemCustom2List) {
                contractItemCustom2.setHeadId(purchaseContractHead.getId());
                contractItemCustom2.setElsAccount(TenantContext.getTenant());
                contractItemCustom2.setDeleted(0);
                if (contractItemCustom2.getCreateBy() == null || "".equals(contractItemCustom2.getCreateBy())) {
                    contractItemCustom2.setCreateBy(SysUtil.getLoginUser().getSubAccount());
                } else {
                    contractItemCustom2.setCreateBy(contractItemCustom2.getCreateBy());
                }
                contractItemCustom2.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
                if (null == contractItemCustom2.getCreateTime()) {
                    contractItemCustom2.setCreateTime(new Date());
                } else {
                    contractItemCustom2.setCreateTime(contractItemCustom2.getCreateTime());
                }
                contractItemCustom2.setUpdateTime(new Date());
            }
            if (!contractItemCustom2List.isEmpty()) {
                this.contractItemCustom2Mapper.insertBatchSomeColumn(contractItemCustom2List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom3List)) {
            for (ContractItemCustom3 contractItemCustom3 : contractItemCustom3List) {
                contractItemCustom3.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom3, (BaseEntity)purchaseContractHead);
                contractItemCustom3.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom3List.isEmpty()) {
                this.contractItemCustom3Mapper.insertBatchSomeColumn(contractItemCustom3List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom4List)) {
            for (ContractItemCustom4 contractItemCustom4 : contractItemCustom4List) {
                contractItemCustom4.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom4, (BaseEntity)purchaseContractHead);
                contractItemCustom4.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom4List.isEmpty()) {
                this.contractItemCustom4Mapper.insertBatchSomeColumn(contractItemCustom4List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom5List)) {
            for (ContractItemCustom5 contractItemCustom5 : contractItemCustom5List) {
                contractItemCustom5.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom5, (BaseEntity)purchaseContractHead);
                contractItemCustom5.setElsAccount(TenantContext.getTenant());
            }
            if (!contractItemCustom5List.isEmpty()) {
                this.contractItemCustom5Mapper.insertBatchSomeColumn(contractItemCustom5List);
            }
        }
    }

    PurchaseOrganizationInfoDTO findOrgInfoByCode(String elsAccount, String orgType, String orgCode) {
        PurchaseOrganizationInfoDTO orgInfo = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(elsAccount, orgType, orgCode);
        return orgInfo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseContractItemMapper.deleteByMainId(id);
        this.purchaseContractContentItemMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseContractPromiseMapper.deleteByMainId(id);
        this.contractItemCustom1Mapper.deleteByMainId(id);
        this.contractItemCustom2Mapper.deleteByMainId(id);
        this.contractItemCustom3Mapper.deleteByMainId(id);
        this.contractItemCustom4Mapper.deleteByMainId(id);
        this.contractItemCustom5Mapper.deleteByMainId(id);
        this.purchaseContractHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseContractItemMapper.deleteByMainId(serializable.toString());
            this.purchaseContractContentItemMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseContractPromiseMapper.deleteByMainId(serializable.toString());
            this.contractItemCustom1Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom2Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom3Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom4Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom5Mapper.deleteByMainId(serializable.toString());
            this.purchaseContractHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        PurchaseContractHead buyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseContractContentItem> contractBuyContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        List<PurchaseContractItem> contractBuyItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseContractHead updateBuyHead = new PurchaseContractHead();
        updateBuyHead.setContractStatus(ContractStatusEnum.CONTRACT_CONFIRMING.getValue());
        updateBuyHead.setId(id);
        int count = this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        SaleContractHead saleHead = new SaleContractHead();
        BeanUtils.copyProperties((Object)((Object)buyHead), (Object)((Object)saleHead));
        saleHead.setContractStatus(ContractStatusEnum.CONTRACT_CONFIRMING.getValue());
        saleHead.setRelationId(id);
        if (StrUtil.isBlank((CharSequence)buyHead.getRelationId())) {
            saleHead.setId(null);
            saleHead.setElsAccount(buyHead.getToElsAccount());
            saleHead.setToElsAccount(buyHead.getElsAccount());
            this.saleContractHeadMapper.insert((Object)saleHead);
        } else {
            saleHead.setId(buyHead.getRelationId());
            saleHead.setToElsAccount(buyHead.getElsAccount());
            saleHead.setElsAccount(buyHead.getToElsAccount());
            this.saleContractHeadMapper.updateById((Object)saleHead);
            this.saleContractContentItemMapper.deleteByMainId(buyHead.getRelationId());
            this.saleContractItemMapper.deleteByMainId(buyHead.getRelationId());
        }
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleHead.getId());
        ArrayList<SaleContractContentItem> saleContentItemList = new ArrayList<SaleContractContentItem>();
        for (PurchaseContractContentItem purchaseContractContentItem : contractBuyContentItemList) {
            SaleContractContentItem saleItem = new SaleContractContentItem();
            BeanUtils.copyProperties((Object)((Object)purchaseContractContentItem), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleContentItemList.add(saleItem);
        }
        if (!saleContentItemList.isEmpty()) {
            this.saleContractContentItemMapper.insertBatchSomeColumn(saleContentItemList);
        }
        ArrayList<SaleContractItem> saleItemList = new ArrayList<SaleContractItem>();
        for (PurchaseContractItem item : contractBuyItemList) {
            SaleContractItem saleItem = new SaleContractItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItemList.add(saleItem);
        }
        if (!saleItemList.isEmpty()) {
            this.saleContractItemMapper.insertBatchSomeColumn(saleItemList);
        }
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            ArrayList<SaleAttachmentDTO> arrayList = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : purchaseAttachmentList) {
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(purchaseAttachment.getRelationId());
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(buyHead.getToElsAccount());
                saleAttachment.setHeadId(saleHead.getId());
                arrayList.add(saleAttachment);
            }
            if (CollectionUtil.isNotEmpty(arrayList)) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(arrayList);
            }
        }
        String string = "id=" + saleHead.getId();
        if (Integer.parseInt(buyHead.getContractType()) == 1 || Integer.parseInt(buyHead.getContractType()) == 2) {
            super.sendMsg(buyHead.getElsAccount(), buyHead.getToElsAccount(), (Object)buyHead, string, "contract", "publish");
        } else {
            super.sendMsg(buyHead.getElsAccount(), buyHead.getToElsAccount(), (Object)buyHead, string, "contractSimple", "publish");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void upgradeVersion(String id) {
        PurchaseContractHead buyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseContractContentItem> contractBuyContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        List<PurchaseContractItem> contractBuyItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseContractHead updateHead = new PurchaseContractHead();
        updateHead.setId(id);
        updateHead.setContractStatus(ContractStatusEnum.CONTRACT_NEW.getValue());
        String contractVersion = buyHead.getContractVersion();
        if (StrUtil.isBlank((CharSequence)contractVersion)) {
            int version = 1;
            updateHead.setContractVersion(version + "");
        } else {
            updateHead.setContractVersion(contractVersion);
        }
        PurchaseContractHeadHis buyHeadHis = new PurchaseContractHeadHis();
        BeanUtils.copyProperties((Object)((Object)buyHead), (Object)((Object)buyHeadHis));
        buyHeadHis.setId(null);
        buyHeadHis.setContractId(id);
        updateHead.setContractVersion(Integer.parseInt(updateHead.getContractVersion()) + 1 + "");
        this.purchaseContractHeadMapper.updateById((Object)updateHead);
        this.purchaseContractHeadHisMapper.insert((Object)buyHeadHis);
        ArrayList<PurchaseContractContentItemHis> contentItemHisList = new ArrayList<PurchaseContractContentItemHis>();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            PurchaseContractContentItemHis itemHis = new PurchaseContractContentItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(buyHeadHis.getId());
            contentItemHisList.add(itemHis);
        }
        if (!contentItemHisList.isEmpty()) {
            this.purchaseContractContentItemHisMapper.insertBatchSomeColumn(contentItemHisList);
        }
        ArrayList<PurchaseContractItemHis> itemHisList = new ArrayList<PurchaseContractItemHis>();
        for (PurchaseContractItem item : contractBuyItemList) {
            PurchaseContractItemHis itemHis = new PurchaseContractItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(buyHeadHis.getId());
            itemHisList.add(itemHis);
        }
        if (!itemHisList.isEmpty()) {
            this.purchaseContractItemHisMapper.insertBatchSomeColumn(itemHisList);
        }
        if (!CollectionUtils.isEmpty((Collection)purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setHeadId(buyHeadHis.getId());
                attachment.setUploadElsAccount(buyHeadHis.getElsAccount());
                attachment.setBusinessType("contract");
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)buyHeadHis);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseContractHead head) {
        PurchaseContractHead updateBuyHead = new PurchaseContractHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setContractStatus(head.getContractStatus());
        this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(SaleContractHead::getRelationId, (Object)head.getId())).set(SaleContractHead::getContractStatus, (Object)head.getContractStatus());
        this.saleContractHeadMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseOrderHeadDTO> createOrderByItems(PurchaseContractHeadVO headVO) {
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        List<PurchaseContractItem> collect = purchaseContractItemList.parallelStream().filter(p -> !"order".equals(p.getSourceType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw new ELSBootException("\u4e3a\u60a8\u8fc7\u6ee4\u6389\u6765\u6e90\u4e3a\u8ba2\u5355\u7684\u884c\u540e,\u884c\u9879\u76ee\u4e3a\u7a7a");
        }
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)((PurchaseContractItem)((Object)collect.get(0))).getHeadId())));
        List<String> idList = collect.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List<PurchaseOrderItemDTO> purchaseOrderItemDTOList = this.contractInvokeOrderRpcService.listItemBySourceItemId(idList);
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = new PurchaseOrderHeadDTO();
        List<PurchaseOrderItemDTO> purchaseOrderItemDTOListNew = this.contractToOrderOnItem(byId, collect, purchaseOrderItemDTOList);
        ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanDTOS = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
        if (CollectionUtil.isNotEmpty(purchaseOrderItemDTOListNew)) {
            int deliveryItemCount = 1;
            for (PurchaseOrderItemDTO orderItem : purchaseOrderItemDTOListNew) {
                if (!StringUtils.isNotBlank((CharSequence)orderItem.getJit()) && !"0".equals(orderItem.getJit())) continue;
                PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
                orderDeliveryPlan.setItemNumber(deliveryItemCount + "");
                orderDeliveryPlan.setOrderItemNumber(orderItem.getItemNumber());
                orderDeliveryPlan.setQuantity(orderItem.getQuantity());
                orderDeliveryPlan.setPlanDeliveryQuantity(orderItem.getQuantity());
                orderDeliveryPlan.setPlanDeliveryDate(orderItem.getRequireDate());
                orderDeliveryPlan.setRequireDate(orderItem.getRequireDate());
                ++deliveryItemCount;
                purchaseOrderDeliveryPlanDTOS.add(orderDeliveryPlan);
            }
        }
        BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseOrderHeadDTO);
        purchaseOrderHeadDTO.setTemplateAccount(headVO.getTemplateAccount());
        purchaseOrderHeadDTO.setTemplateName(headVO.getTemplateName());
        purchaseOrderHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        purchaseOrderHeadDTO.setTemplateVersion(headVO.getTemplateVersion());
        purchaseOrderHeadDTO.setContractNumber(byId.getContractNumber());
        purchaseOrderHeadDTO.setContractName(byId.getContractName());
        if (ContractTargetTypeEnum.MONEY.getValue().equals(byId.getTargetType())) {
            purchaseOrderHeadDTO.setSourceType(OrderSourceTypeEnum.AMOUNT_CONTRACT.getValue());
        } else {
            purchaseOrderHeadDTO.setSourceType(OrderSourceTypeEnum.WORTH_CONTRACT.getValue());
        }
        purchaseOrderHeadDTO.setId(null);
        purchaseOrderHeadDTO.setRelationId(null);
        purchaseOrderHeadDTO.setCreateBy(null);
        purchaseOrderHeadDTO.setCreateTime(null);
        purchaseOrderHeadDTO.setUpdateBy(null);
        purchaseOrderHeadDTO.setUpdateTime(null);
        SupplierMasterDataDTO byAccount = this.contractInvokeSupplierRpcService.getByAccount(byId.getElsAccount(), byId.getToElsAccount());
        if (byAccount != null) {
            purchaseOrderHeadDTO.setIsTeamwork(byAccount.getNeedCoordination());
        }
        purchaseOrderHeadDTO = this.contractInvokeOrderRpcService.contractCreateOrder(purchaseOrderHeadDTO, purchaseOrderItemDTOListNew, purchaseOrderDeliveryPlanDTOS);
        return Arrays.asList(purchaseOrderHeadDTO);
    }

    private List<PurchaseOrderItemDTO> contractToOrderOnItem(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItems, List<PurchaseOrderItemDTO> purchaseOrderItemDTOList) {
        ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
        int count = 1;
        List<String> collect = purchaseContractItems.parallelStream().map(PurchaseContractItem::getMaterialNumber).distinct().collect(Collectors.toList());
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.contractInvokeMainDataRpcService.listByMaterialNumbers(collect);
        Map collect1 = purchaseMaterialHeadDTOS.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
        for (PurchaseContractItem purchaseContractItem : purchaseContractItems) {
            BigDecimal targetQuantity = purchaseContractItem.getTargetQuantity();
            BigDecimal targetQuantityArry = BigDecimal.ZERO;
            targetQuantityArry = ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHead.getTargetType()) ? purchaseOrderItemDTOList.parallelStream().filter(p -> purchaseContractItem.getId().equals(p.getSourceItemId())).map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : purchaseOrderItemDTOList.parallelStream().filter(p -> purchaseContractItem.getId().equals(p.getSourceItemId())).map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurchaseOrderItemDTO purchaseOrderItemDTO = new PurchaseOrderItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)purchaseOrderItemDTO);
            PurchaseMaterialHeadDTO materialHeadDTO = (PurchaseMaterialHeadDTO)collect1.get(purchaseContractItem.getMaterialNumber());
            purchaseOrderItemDTO.setCateCode(materialHeadDTO.getCateCode());
            purchaseOrderItemDTO.setCateName(materialHeadDTO.getCateName());
            purchaseOrderItemDTO.setMaterialGroup(materialHeadDTO.getMaterialGroup());
            purchaseOrderItemDTO.setMaterialSpec(materialHeadDTO.getMaterialSpec());
            purchaseOrderItemDTO.setPurchaseCycle(materialHeadDTO.getPurchaseCycle());
            purchaseOrderItemDTO.setPurchaseUnit(materialHeadDTO.getPurchaseUnit());
            purchaseOrderItemDTO.setJit(materialHeadDTO.getJit());
            purchaseOrderItemDTO.setCheckQuality(materialHeadDTO.getCheckQuality());
            purchaseOrderItemDTO.setId(null);
            purchaseOrderItemDTO.setHeadId(null);
            purchaseOrderItemDTO.setCreateBy(null);
            purchaseOrderItemDTO.setItemNumber(count + "");
            purchaseOrderItemDTO.setCreateTime(null);
            purchaseOrderItemDTO.setUpdateBy(null);
            purchaseOrderItemDTO.setUpdateTime(null);
            purchaseOrderItemDTO.setSourceNumber(purchaseContractHead.getContractNumber());
            if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHead.getTargetType())) {
                purchaseOrderItemDTO.setSourceType(OrderSourceTypeEnum.AMOUNT_CONTRACT.getValue());
            } else {
                purchaseOrderItemDTO.setSourceType(OrderSourceTypeEnum.WORTH_CONTRACT.getValue());
            }
            purchaseOrderItemDTO.setSourceItemNumber(purchaseContractItem.getItemNumber());
            purchaseOrderItemDTO.setSourceId(purchaseContractHead.getId());
            purchaseOrderItemDTO.setSourceItemId(purchaseContractItem.getId());
            purchaseOrderItemList.add(purchaseOrderItemDTO);
            ++count;
        }
        return purchaseOrderItemList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseContractPromiseVO> createPromiseByItems(PurchaseContractHeadVO headVO) {
        List<ContractItemCustom1> contractItemCustom1List = headVO.getContractItemCustom1List();
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        String id = "";
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            id = contractItemCustom1List.get(0).getHeadId();
        }
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            id = purchaseContractItemList.get(0).getHeadId();
        }
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)id)));
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateAccount(headVO.getTemplateAccount());
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        List<PurchaseContractPromiseVO> purchaseContractPromises = this.contractPromiseParam(templateHeadDTO, byId, contractItemCustom1List, purchaseContractItemList);
        purchaseContractPromises.forEach(item -> this.purchaseContractPromiseService.saveMain((PurchaseContractPromise)((Object)item), item.getPurchasePromiseItemList()));
        return purchaseContractPromises;
    }

    @Override
    public IPage<PurchaseContractHead> selectModalList(Page<PurchaseContractHead> page, QueryWrapper<PurchaseContractHead> queryWrapper) {
        return this.purchaseContractHeadMapper.selectModalList(page, queryWrapper);
    }

    @Override
    public IPage<PurchaseContractHead> pageListNew(Page<PurchaseContractHead> page, QueryWrapper<PurchaseContractHead> queryWrapper) {
        return this.purchaseContractHeadMapper.pageListNew(page, queryWrapper);
    }

    private List<PurchaseContractPromiseVO> contractPromiseParam(TemplateHeadDTO templateHeadDTO, PurchaseContractHead purchaseContractHead, List<ContractItemCustom1> contractItemCustom1List, List<PurchaseContractItem> purchaseContractItemList) {
        ArrayList<PurchaseContractPromiseVO> contractPromiseArrayList = new ArrayList<PurchaseContractPromiseVO>();
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
            purchaseContractPromise.setSourceType(ContractPromiseSourceTypeEnum.ITEM.getValue());
            purchaseContractPromise.setTemplateAccount(templateHeadDTO.getTemplateAccount());
            purchaseContractPromise.setTemplateName(templateHeadDTO.getTemplateName());
            purchaseContractPromise.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            purchaseContractPromise.setTemplateVersion(templateHeadDTO.getTemplateVersion() + "");
            purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
            purchaseContractPromise.setContractName(purchaseContractHead.getContractName());
            purchaseContractPromise.setContractDesc(purchaseContractHead.getContractDesc());
            purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
            if (ContractTypeEnum.NORMAL.getValue().equals(purchaseContractHead.getContractType())) {
                purchaseContractPromise.setContractAmount(purchaseContractHead.getTotalTaxAmount());
                purchaseContractPromise.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
            } else if (ContractTypeEnum.FRAME.getValue().equals(purchaseContractHead.getContractType())) {
                purchaseContractPromise.setContractAmount(new BigDecimal(purchaseContractHead.getTargetQuantity()));
                if (org.springframework.util.StringUtils.isEmpty((Object)purchaseContractHead.getTargetType())) {
                    purchaseContractPromise.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
                } else {
                    purchaseContractPromise.setTargetType(purchaseContractHead.getTargetType());
                }
            }
            purchaseContractPromise.setBusAccount(TenantContext.getTenant());
            purchaseContractPromise.setCreateAccount(TenantContext.getTenant());
            purchaseContractPromise.setHeadId(purchaseContractHead.getId());
            ArrayList<PurchasePromiseItem> purchasePromiseItemList = new ArrayList<PurchasePromiseItem>();
            for (PurchaseContractItem purchaseContractItem : purchaseContractItemList) {
                PurchasePromiseItem purchasePromiseItem = new PurchasePromiseItem();
                BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)((Object)purchasePromiseItem));
                purchasePromiseItem.setSourceItemId(purchaseContractItem.getId());
                purchasePromiseItem.setHeadId(null);
                purchasePromiseItem.setId(null);
                purchasePromiseItem.setCreateBy(null);
                purchasePromiseItem.setCreateTime(null);
                purchasePromiseItem.setUpdateBy(null);
                purchasePromiseItem.setUpdateTime(null);
                purchasePromiseItem.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchasePromiseItem.setContractNumber(purchaseContractHead.getContractNumber());
                purchasePromiseItem.setContractName(purchaseContractHead.getContractName());
                purchasePromiseItem.setContractDesc(purchaseContractHead.getContractDesc());
                purchasePromiseItem.setAmount(purchaseContractItem.getTaxAmount());
                purchasePromiseItemList.add(purchasePromiseItem);
            }
            purchaseContractPromise.setPurchasePromiseItemList(purchasePromiseItemList);
            if (!CollectionUtils.isEmpty(purchasePromiseItemList)) {
                BigDecimal targetQuantityArry = BigDecimal.ZERO;
                targetQuantityArry = purchasePromiseItemList.parallelStream().filter(p -> p.getAmount() != null).map(PurchasePromiseItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractPromise.setAmount(targetQuantityArry);
            }
            contractPromiseArrayList.add(purchaseContractPromise);
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
                purchaseContractPromise.setTemplateAccount(templateHeadDTO.getTemplateAccount());
                purchaseContractPromise.setTemplateName(templateHeadDTO.getTemplateName());
                purchaseContractPromise.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                purchaseContractPromise.setTemplateVersion(templateHeadDTO.getTemplateVersion() + "");
                purchaseContractPromise.setSourceType(ContractPromiseSourceTypeEnum.MILESTONE.getValue());
                purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
                purchaseContractPromise.setContractName(purchaseContractHead.getContractName());
                purchaseContractPromise.setContractDesc(purchaseContractHead.getContractDesc());
                purchaseContractPromise.setTargetType(purchaseContractHead.getTargetType());
                purchaseContractPromise.setStage(contractItemCustom1.getStage());
                purchaseContractPromise.setSourceItemId(contractItemCustom1.getId());
                purchaseContractPromise.setHeadId(contractItemCustom1.getHeadId());
                purchaseContractPromise.setBusAccount(TenantContext.getTenant());
                purchaseContractPromise.setCreateAccount(TenantContext.getTenant());
                purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchaseContractPromise.setAmount(contractItemCustom1.getAmount());
                if (StringUtils.isNotBlank((CharSequence)purchaseContractHead.getTargetQuantity())) {
                    purchaseContractPromise.setContractAmount(new BigDecimal(purchaseContractHead.getTargetQuantity()));
                } else if (purchaseContractHead.getTotalTaxAmount() != null) {
                    purchaseContractPromise.setContractAmount(purchaseContractHead.getTotalTaxAmount());
                } else {
                    purchaseContractPromise.setContractAmount(BigDecimal.ZERO);
                }
                purchaseContractPromise.setPerformanceRatio(contractItemCustom1.getPerformanceRatio());
                purchaseContractPromise.setPerformanceMatters(contractItemCustom1.getPerformanceMatters());
                contractPromiseArrayList.add(purchaseContractPromise);
            }
        }
        return contractPromiseArrayList;
    }
}

