/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractContentItemHis;
import com.els.modules.contract.entity.PurchaseContractHeadHis;
import com.els.modules.contract.entity.PurchaseContractItemHis;
import com.els.modules.contract.mapper.PurchaseContractContentItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadHisMapper;
import com.els.modules.contract.mapper.PurchaseContractItemHisMapper;
import com.els.modules.contract.service.PurchaseContractHeadHisService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseContractHeadHisServiceImpl
extends ServiceImpl<PurchaseContractHeadHisMapper, PurchaseContractHeadHis>
implements PurchaseContractHeadHisService {
    @Resource
    private PurchaseContractHeadHisMapper purchaseContractHeadHisMapper;
    @Resource
    private PurchaseContractItemHisMapper purchaseContractItemHisMapper;
    @Resource
    private PurchaseContractContentItemHisMapper purchaseContractContentItemHisMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractHeadHis purchaseContractHeadHis, List<PurchaseContractItemHis> purchaseContractItemHisList, List<PurchaseContractContentItemHis> purchaseContractContentItemHisList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.purchaseContractHeadHisMapper.insert((Object)purchaseContractHeadHis);
        this.insertData(purchaseContractHeadHis, purchaseContractItemHisList, purchaseContractContentItemHisList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractHeadHis purchaseContractHeadHis, List<PurchaseContractItemHis> purchaseContractItemHisList, List<PurchaseContractContentItemHis> purchaseContractContentItemHisList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.purchaseContractHeadHisMapper.updateById((Object)purchaseContractHeadHis);
        this.purchaseContractItemHisMapper.deleteByMainId(purchaseContractHeadHis.getId());
        this.purchaseContractContentItemHisMapper.deleteByMainId(purchaseContractHeadHis.getId());
        this.insertData(purchaseContractHeadHis, purchaseContractItemHisList, purchaseContractContentItemHisList, purchaseAttachmentList);
    }

    private void insertData(PurchaseContractHeadHis purchaseContractHeadHis, List<PurchaseContractItemHis> purchaseContractItemHisList, List<PurchaseContractContentItemHis> purchaseContractContentItemHisList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        for (PurchaseContractItemHis purchaseContractItemHis : purchaseContractItemHisList) {
            purchaseContractItemHis.setHeadId(purchaseContractHeadHis.getId());
            SysUtil.setSysParam((BaseEntity)purchaseContractItemHis, (BaseEntity)purchaseContractHeadHis);
        }
        if (!purchaseContractItemHisList.isEmpty()) {
            this.purchaseContractItemHisMapper.insertBatchSomeColumn(purchaseContractItemHisList);
        }
        for (PurchaseContractContentItemHis purchaseContractContentItemHis : purchaseContractContentItemHisList) {
            purchaseContractContentItemHis.setHeadId(purchaseContractHeadHis.getId());
            SysUtil.setSysParam((BaseEntity)purchaseContractContentItemHis, (BaseEntity)purchaseContractHeadHis);
        }
        if (!purchaseContractContentItemHisList.isEmpty()) {
            this.purchaseContractContentItemHisMapper.insertBatchSomeColumn(purchaseContractContentItemHisList);
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(purchaseContractHeadHis.getId());
                purchaseAttachmentDTO.setUploadElsAccount(purchaseContractHeadHis.getElsAccount());
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseContractHeadHis);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseContractItemHisMapper.deleteByMainId(id);
        this.purchaseContractContentItemHisMapper.deleteByMainId(id);
        this.purchaseContractHeadHisMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseContractItemHisMapper.deleteByMainId(serializable.toString());
            this.purchaseContractContentItemHisMapper.deleteByMainId(serializable.toString());
            this.purchaseContractHeadHisMapper.deleteById(serializable);
        }
    }
}

