/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.contract.dto.PurchaseContractPromiseDTO;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.mapper.PurchasePromiseItemMapper;
import com.els.modules.contract.service.PurchasePromiseItemService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchasePromiseItemServiceImpl
extends BaseServiceImpl<PurchasePromiseItemMapper, PurchasePromiseItem>
implements PurchasePromiseItemService {
    @Resource
    private PurchasePromiseItemMapper purchasePromiseItemMapper;

    @Override
    public List<PurchasePromiseItem> selectByMainId(String mainId) {
        return this.purchasePromiseItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<PurchaseContractPromiseDTO> listPurchaseContractPromiseDTO(PurchaseContractPromiseDTO dto) {
        return this.purchasePromiseItemMapper.listPurchaseContractPromiseDTO(dto);
    }

    @Override
    public List<PurchaseContractPromiseDTO> checkHasReconciliation(Set<String> voucherNumbers) {
        if (CollectionUtils.isEmpty(voucherNumbers)) {
            return new ArrayList<PurchaseContractPromiseDTO>();
        }
        HashSet<String> businessNumbers = new HashSet<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String voucherNumber : voucherNumbers) {
            String[] businessNumber = voucherNumber.split("-");
            businessNumbers.add(businessNumber[0]);
            map.put(businessNumber[0] + "-" + businessNumber[1], voucherNumber);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(PurchasePromiseItem::getPromiseNumber, businessNumbers);
        List purchasePromiseItems = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)purchasePromiseItems)) {
            return new ArrayList<PurchaseContractPromiseDTO>();
        }
        ArrayList<PurchaseContractPromiseDTO> list = new ArrayList<PurchaseContractPromiseDTO>();
        for (PurchasePromiseItem purchasePromiseItem : purchasePromiseItems) {
            String hasExist = (String)map.get(purchasePromiseItem.getPromiseNumber() + "-" + purchasePromiseItem.getItemNumber());
            if (StringUtils.isEmpty((Object)hasExist)) continue;
            PurchaseContractPromiseDTO dto = new PurchaseContractPromiseDTO();
            BeanUtils.copyProperties((Object)((Object)purchasePromiseItem), (Object)dto);
            dto.setPromiseNumberItem(purchasePromiseItem.getItemNumber());
            list.add(dto);
        }
        return list;
    }
}

