/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.common.validator.SrmLength;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.SaleContractContentItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.enumerate.ContractPromiseTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.service.ContractItemCustom1Service;
import com.els.modules.contract.service.ContractItemCustom2Service;
import com.els.modules.contract.service.ContractItemCustom3Service;
import com.els.modules.contract.service.ContractItemCustom4Service;
import com.els.modules.contract.service.ContractItemCustom5Service;
import com.els.modules.contract.service.SaleContractContentItemService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.service.SaleContractItemService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.utils.Htm2WordUtil;
import com.els.modules.contract.utils.NumberUtil;
import com.els.modules.contract.utils.PdfUtil;
import com.els.modules.contract.vo.SaleContractHeadVO;
import com.els.modules.contract.vo.SaleContractPromiseVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contract/saleContractHead"})
@Api(tags={"\u9500\u552e\u5408\u540c\u5934"})
public class SaleContractHeadController
extends BaseController<SaleContractHead, SaleContractHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleContractHeadController.class);
    @Autowired
    private SaleContractHeadService saleContractHeadService;
    @Autowired
    private SaleContractItemService saleContractItemService;
    @Autowired
    private SaleContractContentItemService saleContractContentItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Autowired
    private ContractItemCustom1Service contractItemCustom1Service;
    @Autowired
    private ContractItemCustom2Service contractItemCustom2Service;
    @Autowired
    private ContractItemCustom3Service contractItemCustom3Service;
    @Autowired
    private ContractItemCustom4Service contractItemCustom4Service;
    @Autowired
    private ContractItemCustom5Service contractItemCustom5Service;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contract#saleContractHead:list"})
    public Result<?> queryPageList(SaleContractHead saleContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        saleContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleContractHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"contract#saleContractHead:add"})
    public Result<?> add(@RequestBody SaleContractHeadVO saleContractHeadPage) {
        SaleContractHead saleContractHead = new SaleContractHead();
        BeanUtils.copyProperties((Object)((Object)saleContractHeadPage), (Object)((Object)saleContractHead));
        this.saleContractHeadService.saveMain(saleContractHead, saleContractHeadPage.getPurchaseContractItemList(), saleContractHeadPage.getPurchaseContractContentItemList(), saleContractHeadPage.getSaleAttachmentList());
        return Result.ok((Object)((Object)saleContractHead));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contract#saleContractHead:edit"})
    public Result<?> edit(@RequestBody SaleContractHeadVO saleContractHeadPage) {
        SaleContractHead saleContractHead = new SaleContractHead();
        BeanUtils.copyProperties((Object)((Object)saleContractHeadPage), (Object)((Object)saleContractHead));
        this.saleContractHeadService.updateMain(saleContractHead, saleContractHeadPage.getPurchaseContractItemList(), saleContractHeadPage.getPurchaseContractContentItemList(), saleContractHeadPage.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e")
    @GetMapping(value={"/getPreviewData"})
    @RequiresPermissions(value={"contract#saleContractHead:getPreviewData"})
    public Result<?> getPreviewData(@RequestParam(name="id", required=true) String id) {
        return Result.ok((Object)this.getHtmlById(id));
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7\u5173\u8054id\u83b7\u53d6\u9884\u89c8\u6570\u636e")
    @GetMapping(value={"/getPreviewDataByRelationId"})
    @RequiresPermissions(value={"contract#saleContractHead:getPreviewDataByRelationId"})
    public Result<?> getPreviewDataByRelationId(@RequestParam(name="id", required=true) String id) {
        SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleContractHead::getRelationId, (Object)id)));
        if (ObjectUtil.isNotNull((Object)((Object)saleContractHead))) {
            return Result.ok((Object)this.getHtmlById(saleContractHead.getId()));
        }
        return Result.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"contract#saleContractHead:download"})
    public void download(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        SaleContractHead contractBuyHead = (SaleContractHead)((Object)this.saleContractHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        String waterMark = "";
        boolean b = false;
        log.info(":::contract.waterMark:" + waterMark);
        String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), b, "\u4f01\u4f01\u901a", null);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadDoc"})
    @RequiresPermissions(value={"contract#saleContractHead:download"})
    public void downloadDoc(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String html = this.getHtmlById(id).toString();
        SaleContractHead contractBuyHead = (SaleContractHead)((Object)this.saleContractHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String path = Htm2WordUtil.html2Word(html, this.uploadpath, contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion());
            log.info("path=" + path);
            File file = new File(path);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }

    private StringBuilder getHtmlById(String id) {
        Result<?> result = this.queryById(id);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText(result);
        SaleContractHeadVO purchaseContractHeadVO = (SaleContractHeadVO)((Object)JSON.parseObject((String)result.getResult().toString(), SaleContractHeadVO.class));
        JSONObject jsonObject = (JSONObject)result.getResult();
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemList"));
        List<SaleContractContentItem> contractBuyContentItemList = purchaseContractHeadVO.getPurchaseContractContentItemList();
        int index = 0;
        StringBuilder html = new StringBuilder();
        for (SaleContractContentItem item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
                param.put("zh_index", NumberUtil.number2Chinese(index));
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html;
    }

    @SrmValidated
    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u786e\u8ba4")
    @ApiOperation(value="\u901a\u8fc7id\u786e\u8ba4", notes="\u901a\u8fc7id\u786e\u8ba4")
    @GetMapping(value={"/confirmed"})
    @RequiresPermissions(value={"contract#saleContractHead:confirmed"})
    public Result<?> confirmed(@RequestParam(name="id", required=true) String id, @RequestParam(name="saleRemark") @SrmLength(max=1000, scopeTitle="\u4f9b\u5e94\u5546\u5907\u6ce8", scopeI18key="i18n_title_saleRemarks") String saleRemark) {
        this.saleContractHeadService.confirmedMain(id, saleRemark);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u9000\u56de")
    @ApiOperation(value="\u901a\u8fc7id\u9000\u56de", notes="\u901a\u8fc7id\u9000\u56de")
    @GetMapping(value={"/refund"})
    @SrmValidated
    @RequiresPermissions(value={"contract#saleContractHead:refund"})
    public Result<?> refund(@RequestParam(name="id", required=true) String id, @RequestParam(name="refundRemark") @SrmLength(max=1000, scopeTitle="\u9000\u56de\u5907\u6ce8", scopeI18key="") String refundRemark, @RequestParam(name="saleRemark") @SrmLength(max=1000, scopeTitle="\u4f9b\u5e94\u5546\u5907\u6ce8", scopeI18key="i18n_title_saleRemarks") String saleRemark) {
        this.saleContractHeadService.refundMain(id, refundRemark, saleRemark);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contract#saleContractHead:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.saleContractHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contract#saleContractHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.saleContractHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contract#saleContractHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleContractHeadVO saleContractHeadVO = new SaleContractHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleContractHead), (Object)((Object)saleContractHeadVO));
        List<SaleContractItem> saleContractItemList = this.saleContractItemService.selectByMainId(id);
        saleContractHeadVO.setPurchaseContractItemList(saleContractItemList);
        List<SaleContractContentItem> saleContractContentItemList = this.saleContractContentItemService.selectByMainId(id);
        saleContractHeadVO.setPurchaseContractContentItemList(saleContractContentItemList);
        List saleAttachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleContractHeadVO.setSaleAttachmentList(saleAttachments);
        List<SaleContractPromise> saleContractPromiseList = this.saleContractPromiseService.selectByMainId(id);
        List<SaleContractPromise> collect1 = saleContractPromiseList.parallelStream().filter(item -> ContractPromiseStatusEnum.CONFIRMED.getValue().equals(item.getPromiseStatus())).collect(Collectors.toList());
        saleContractHeadVO.setPurchaseContractPromiseList(collect1);
        String relationId = saleContractHeadVO.getRelationId();
        if (StringUtils.isNotBlank((CharSequence)relationId)) {
            List<ContractItemCustom1> contractItemCustom1List = this.contractItemCustom1Service.selectByMainId(relationId);
            saleContractHeadVO.setContractItemCustom1List(contractItemCustom1List);
            List<ContractItemCustom2> contractItemCustom2List = this.contractItemCustom2Service.selectByMainId(relationId);
            saleContractHeadVO.setContractItemCustom2List(contractItemCustom2List);
            List<ContractItemCustom3> contractItemCustom3List = this.contractItemCustom3Service.selectByMainId(relationId);
            saleContractHeadVO.setContractItemCustom3List(contractItemCustom3List);
            List<ContractItemCustom4> contractItemCustom4List = this.contractItemCustom4Service.selectByMainId(relationId);
            saleContractHeadVO.setContractItemCustom4List(contractItemCustom4List);
            List<ContractItemCustom5> contractItemCustom5List = this.contractItemCustom5Service.selectByMainId(relationId);
            saleContractHeadVO.setContractItemCustom5List(contractItemCustom5List);
        }
        this.calculateTraget(saleContractHeadVO);
        return Result.ok((Object)((Object)saleContractHeadVO));
    }

    private void calculateTraget(SaleContractHeadVO purchaseContractHeadVO) {
        String contractType = purchaseContractHeadVO.getContractType();
        String promiseType = purchaseContractHeadVO.getPromiseType();
        if (StringUtils.isBlank((CharSequence)contractType) || StringUtils.isBlank((CharSequence)promiseType)) {
            return;
        }
        List<SaleContractPromise> promiseList = purchaseContractHeadVO.getPurchaseContractPromiseList();
        if (ContractTypeEnum.NORMAL.getValue().equals(contractType)) {
            if (!ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType) && !CollectionUtils.isEmpty(promiseList)) {
                BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(SaleContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
            }
        } else if (ContractTypeEnum.FRAME.getValue().equals(contractType) && !ContractPromiseTypeEnum.ORDER.getValue().equals(promiseType) && !CollectionUtils.isEmpty(promiseList)) {
            BigDecimal reduce = promiseList.parallelStream().filter(item -> item.getAmount() != null).map(SaleContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseContractHeadVO.setTargetQuantityAlready(reduce.toString());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u5408\u540c\u5934id\u67e5\u8be2\u9500\u552e\u5408\u540c\u884c", notes="\u901a\u8fc7\u9500\u552e\u5408\u540c\u5934id\u67e5\u8be2\u9500\u552e\u5408\u540c\u884c")
    @GetMapping(value={"/querySaleContractItemByMainId"})
    @RequiresPermissions(value={"contract#saleContractHead:list"})
    public Result<?> querySaleContractItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleContractItem> saleContractItemList = this.saleContractItemService.selectByMainId(id);
        return Result.ok(saleContractItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u5408\u540c\u5934id\u67e5\u8be2\u9500\u552e\u5408\u540c\u6761\u6b3e\u884c", notes="\u901a\u8fc7\u9500\u552e\u5408\u540c\u5934id\u67e5\u8be2\u9500\u552e\u5408\u540c\u6761\u6b3e\u884c")
    @GetMapping(value={"/querySaleContractContentItemByMainId"})
    @RequiresPermissions(value={"contract#saleContractHead:list"})
    public Result<?> querySaleContractContentItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleContractContentItem> saleContractContentItemList = this.saleContractContentItemService.selectByMainId(id);
        return Result.ok(saleContractContentItemList);
    }

    @ApiOperation(value="\u9500\u552e\u5408\u540c-\u521b\u5efa\u5c65\u7ea6\u5355", notes="\u9500\u552e\u5408\u540c-\u521b\u5efa\u5c65\u7ea6\u5355")
    @PostMapping(value={"/createPromiseByItems"})
    @SrmValidated
    @AutoLog(busModule="\u5408\u540c\u7ba1\u7406", value="\u521b\u5efa\u5c65\u7ea6")
    @RequiresPermissions(value={"contract#saleContractHead:createPromiseByItems"})
    public Result<?> createPromiseByItems(@RequestBody SaleContractHeadVO headVO) {
        List<SaleContractPromiseVO> saleContractPromiseVOList = this.saleContractHeadService.createPromiseByItems(headVO);
        StringBuffer stringBuffer = new StringBuffer();
        for (SaleContractPromiseVO saleContractPromiseVO : saleContractPromiseVOList) {
            stringBuffer = stringBuffer.append(" " + saleContractPromiseVO.getPromiseNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_sIZtLRWLRsIttW_31f231b6", (String)"\u8f6c\u5c65\u7ea6\u5355\u6210\u529f,\u6210\u529f\u8f6c\u8ba2\u5355\u5355\u6570:") + saleContractPromiseVOList.size() + I18nUtil.translate((String)"i18n_alert_tyzqL_bdb5df73", (String)",\u5355\u53f7\u5206\u522b\u4e3a:") + stringBuffer.toString()));
    }
}

