/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.service.PurchaseContractOAService;
import com.els.modules.extend.api.service.OaTokenUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseContractOAServiceImpl
implements PurchaseContractOAService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractOAServiceImpl.class);
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${SYS.OA.auth.appId}")
    private String appId;
    @Value(value="${SYS.OA.flowParam.purchaseContract.id}")
    private String workFlowId;
    @Value(value="${SYS.OA.flowParam.purchaseContract.title}")
    private String workFlowTitle;
    @Autowired
    private OaTokenUtil oaTokenUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public JSONObject pushPurchaseContractToOA(PurchaseContractHead buyHead, List<PurchaseContractContentItem> contractBuyContentItemList, List<PurchaseContractItem> contractBuyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject baseInfo = new JSONObject();
        baseInfo.put("workflowId", (Object)this.workFlowId);
        baseInfo.put("requestName", (Object)this.workFlowTitle);
        baseInfo.put("mainData", this.getMainData(buyHead, loginUser));
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)this.appId);
        headParam.put("token", (Object)this.oaTokenUtil.getOAtoken(buyHead.getElsAccount()));
        String spk = (String)this.redisUtil.get("oa_spk");
        RSA rsa = new RSA(null, spk);
        String encryptUserid = rsa.encryptBase64(loginUser.getSubAccount(), CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        headParam.put("userid", (Object)encryptUserid);
        JSONObject root = new JSONObject();
        root.put("bus_account", (Object)elsAccount);
        root.put("srm_interface_code", (Object)"purchaseContract_push_oa");
        root.put("header_param", (Object)headParam);
        root.put("body", (Object)baseInfo);
        JSONObject jsonObject = this.interfaceUtil.callInterface(elsAccount, null, root, null);
        log.error("result=={}", (Object)JSONObject.toJSONString((Object)jsonObject));
        return jsonObject;
    }

    private void put(String key, Object value, List<Map<String, Object>> fields) {
        HashMap<String, Object> zzhMap = new HashMap<String, Object>();
        zzhMap.put("fieldName", key);
        zzhMap.put("fieldValue", value);
        fields.add(zzhMap);
    }

    private void put(String key, Object value, List<Map<String, Object>> fields, String name) {
        HashMap<String, Object> zzhMap = new HashMap<String, Object>();
        zzhMap.put("fieldName", key);
        zzhMap.put(name, value);
        fields.add(zzhMap);
    }

    private List<Map<String, Object>> getMainData(PurchaseContractHead buyHead, LoginUser loginUser) {
        ArrayList<Map<String, Object>> mainData = new ArrayList<Map<String, Object>>();
        this.put("htbh", buyHead.getContractNumber(), mainData);
        this.put("htmc", buyHead.getContractName(), mainData);
        this.put("htlx", buyHead.getContractType(), mainData);
        this.put("bz", buyHead.getPurchaseRemark(), mainData);
        this.put("dfztsfjsdzz", buyHead.getSign(), mainData);
        this.put("wfqyzt3", buyHead.getCompany(), mainData);
        this.put("yjzx", buyHead.getFbk2(), mainData);
        this.put("ejzx", buyHead.getFbk3(), mainData);
        this.put("yywjsfyyj", buyHead.getFbk4(), mainData);
        this.put("stzyywcsfxyjhfqr", buyHead.getFbk5(), mainData);
        this.put("sfgsmbht", buyHead.getFbk6(), mainData);
        this.put("htjesfqd", buyHead.getFbk7(), mainData);
        this.put("htqxsfqd", buyHead.getFbk8(), mainData);
        this.put("sl", buyHead.getFbk9(), mainData);
        this.put("pl", buyHead.getFbk10(), mainData);
        this.put("fs", buyHead.getFbk11(), mainData);
        this.put("yzmc2", buyHead.getFbk12(), mainData);
        this.put("gzyq", buyHead.getFbk13(), mainData);
        this.put("yysy1", buyHead.getFbk14(), mainData);
        this.put("sfnkht", buyHead.getFbk15(), mainData);
        this.put("wjlkr", buyHead.getFbk16(), mainData);
        this.put("htje", buyHead.getTotalTaxAmount(), mainData);
        this.put("htqsrq", buyHead.getEffectiveDate(), mainData);
        this.put("htjsrq", buyHead.getExpiryDate(), mainData);
        this.put("xdfqyzt", buyHead.getSupplierCode(), mainData);
        this.put("sjrxm", buyHead.getFbk17(), mainData);
        this.put("dfqyztlxfs", buyHead.getSupplierPhone(), mainData);
        this.put("sjrdh", buyHead.getFbk18(), mainData);
        this.put("sjdz", buyHead.getFbk19(), mainData);
        return mainData;
    }
}

