/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnRemoveRq;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.mapper.PurchaseEsignV3OrgPsnMapper;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.vo.PurchaseV3OrgPsnVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEsignV3OrgPsnServiceImpl
extends BaseServiceImpl<PurchaseEsignV3OrgPsnMapper, PurchaseEsignV3OrgPsn>
implements PurchaseEsignV3OrgPsnService {
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private PurchaseEsignV3PersonalService personalService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        PurchaseEsignV3Personal personal = (PurchaseEsignV3Personal)((Object)this.personalService.getById((Serializable)((Object)purchaseEsignV3OrgPsn.getPsnId())));
        OrgPsnAdminRq.Members members = new OrgPsnAdminRq.Members();
        members.setPsnId(purchaseEsignV3OrgPsn.getPsnCode());
        members.setMemberName(personal.getPsnName());
        members.setRole(purchaseEsignV3OrgPsn.getRole());
        OrgPsnAdminRq orgPsnAdminRq = OrgPsnAdminRq.builder().base(new OrgPsnAdminRq.Base(purchaseEsignV3OrgPsn.getOrgCode())).body(new OrgPsnAdminRq.Body(Arrays.asList(members))).build();
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnAdminRq, "e3-org-psn-add", OrgPsnAdminRp.class);
        if (!rp.getAddedMembers().contains(personal.getPsnId())) {
            if (CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_EPsyVIHVKHRvj_d3e483a9", (String)"E\u7b7e\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).insert((Object)purchaseEsignV3OrgPsn);
    }

    @Override
    public void edit(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        int count = ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)purchaseEsignV3OrgPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void delete(String id) {
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<PurchaseV3OrgPsnVo> pageVo(Page<PurchaseV3OrgPsnVo> page, String orgId, boolean notAdmin, String sealId) {
        return ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).pageVo(page, orgId, notAdmin, sealId);
    }

    @Override
    public void removeStaff(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        PurchaseEsignV3OrgPsn pev = (PurchaseEsignV3OrgPsn)((Object)this.getById((Serializable)((Object)purchaseEsignV3OrgPsn.getId())));
        OrgPsnRemoveRq orgPsnRemoveRq = new OrgPsnRemoveRq();
        orgPsnRemoveRq.getBase().setOrgId(pev.getOrgCode());
        orgPsnRemoveRq.getBase().setMemberPsnIds(pev.getPsnCode());
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnRemoveRq, "e3-org-psn-remove", OrgPsnAdminRp.class);
        if (!rp.getDeletedMembers().contains(pev.getPsnCode())) {
            if (CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_EPsyVIHVKHRvj_d3e483a9", (String)"E\u7b7e\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        this.removeById((Serializable)((Object)purchaseEsignV3OrgPsn.getId()));
    }
}

