/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.UUIDGenerator;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import com.els.modules.electronsign.fadada.util.FileUtils;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FadadaCallUtil {
    private static final Logger log = LoggerFactory.getLogger(FadadaCallUtil.class);
    private Map<String, String> configMap = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    public String host = this.configMap.get("service.address");
    private Map<String, String> ipaasMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.ipaasMap.get("service");
    public String businessId = this.ipaasMap.get("fadada.businessId");
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String BIZ_PATH = "files";
    private static final String STR_FORMAT = "yyyyMMdd";
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private FileRpcService fileRpcService;

    public FadadaSignAttachmenPurchase getFile(File file, FadadaSignTaskPurchase signTaskPurchase) {
        String fileName = (StringUtils.isNotBlank((CharSequence)signTaskPurchase.getSignTaskSubject()) ? signTaskPurchase.getSignTaskSubject() : signTaskPurchase.getBusNumber()) + ".pdf";
        byte[] bytes = FileUtils.getBytes(file, STR_FORMAT, this.uploadpath, signTaskPurchase.getElsAccount(), fileName);
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String documentLocation = File.separator + BIZ_PATH + File.separator + signTaskPurchase.getElsAccount() + File.separator + nowDay + File.separator + fileName;
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        if (documentLocation.startsWith("\\")) {
            documentLocation.replace("\\", "");
        }
        if (documentLocation.startsWith("/")) {
            documentLocation = documentLocation.substring(1);
        }
        this.fileRpcService.uploadFiles(bytes, documentLocation, fileName, "oss");
        PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
        purchaseAttachmentDTO.setElsAccount(signTaskPurchase.getElsAccount());
        purchaseAttachmentDTO.setHeadId(signTaskPurchase.getId());
        purchaseAttachmentDTO.setBusinessType("fadada");
        purchaseAttachmentDTO.setFileType("5");
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseAttachmentDTO.setUploadElsAccount(loginUser.getElsAccount());
        purchaseAttachmentDTO.setUploadSubAccount(loginUser.getSubAccount());
        purchaseAttachmentDTO.setUploadTime(new Date());
        purchaseAttachmentDTO.setFileName(fileName);
        purchaseAttachmentDTO.setFilePath(documentLocation);
        purchaseAttachmentDTO.setSourceType("2");
        purchaseAttachmentDTO.setSaveType("oss");
        purchaseAttachmentDTO.setId(UUIDGenerator.generate());
        this.invokeBaseRpcService.insertPurchaseAttachment(purchaseAttachmentDTO);
        FadadaSignAttachmenPurchase signAttachmenPurchase = (FadadaSignAttachmenPurchase)((Object)SysUtil.copyProperties((Object)purchaseAttachmentDTO, FadadaSignAttachmenPurchase.class));
        signAttachmenPurchase.setAbsoluteFilePath(this.fileRpcService.getRealPath(documentLocation, "oss", false));
        return signAttachmenPurchase;
    }

    public String getByUrl(String headId, String elsAccount, JSONObject object) {
        if (StringUtils.isNotBlank((CharSequence)object.getString("picFileUrl"))) {
            String fileName = object.getString("sealId") + ".pdf";
            byte[] bytes = FileUtils.getBytes(object.getString("picFileUrl"), STR_FORMAT, this.uploadpath, elsAccount, fileName);
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
            String nowDay = dtf.format(time);
            String documentLocation = File.separator + BIZ_PATH + File.separator + elsAccount + File.separator + nowDay + File.separator + fileName;
            if (documentLocation.contains("\\")) {
                documentLocation = documentLocation.replace("\\", "/");
            }
            if (documentLocation.startsWith("\\")) {
                documentLocation.replace("\\", "");
            }
            if (documentLocation.startsWith("/")) {
                documentLocation = documentLocation.substring(1);
            }
            this.fileRpcService.uploadFiles(bytes, documentLocation, fileName, "oss");
            return this.fileRpcService.getRealPath(documentLocation, "oss", false);
        }
        return null;
    }

    public String getFileByUrl(String headId, String elsAccount, String fileUrl, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
            byte[] bytes = FileUtils.getBytes(fileUrl, STR_FORMAT, this.uploadpath, elsAccount, fileName);
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
            String nowDay = dtf.format(time);
            String documentLocation = File.separator + BIZ_PATH + File.separator + elsAccount + File.separator + nowDay + File.separator + fileName;
            if (documentLocation.contains("\\")) {
                documentLocation = documentLocation.replace("\\", "/");
            }
            if (documentLocation.startsWith("\\")) {
                documentLocation.replace("\\", "");
            }
            if (documentLocation.startsWith("/")) {
                documentLocation = documentLocation.substring(1);
            }
            this.fileRpcService.uploadFiles(bytes, documentLocation, fileName, "oss");
            return this.fileRpcService.getRealPath(documentLocation, "oss", false);
        }
        return null;
    }

    public String getRedirectUrl() {
        return this.host.endsWith("/") ? this.host + "els/electronsign/fadada/fadadaCallBack/noToken/callback" : this.host + "/els/electronsign/fadada/fadadaCallBack/noToken/callback";
    }

    public JSONObject call(String requestStr, String srmInterfaceCode) {
        JSONObject response = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)requestStr), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(srmInterfaceCode));
        log.debug("\u63a5\u53e3\u8bf7\u6c42\u51fa\u53c2\u4e3a\uff1a" + response);
        if (response.getBoolean("success").booleanValue()) {
            JSONObject data = response.getJSONObject("data");
            if ("100000".equals(data.getString("code")) || "210002".equals(data.getString("code"))) {
                if (StringUtils.isBlank((CharSequence)data.getString("data"))) {
                    return data;
                }
                try {
                    return data.getJSONObject("data");
                }
                catch (Exception e) {
                    return data;
                }
            }
            log.error("\uff08\u6cd5\u5927\u5927\uff09\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a" + data.getString("msg"));
            throw new ELSBootException("\uff08\u6cd5\u5927\u5927\uff09\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a" + data.getString("msg"));
        }
        log.error("\uff08ipaas\uff09\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a" + response.getString("message"));
        throw new ELSBootException("\uff08ipaas\uff09\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a" + response.getString("message"));
    }

    public String arrayToString(JSONArray array) {
        if (array != null && array.size() > 0) {
            String returnStr = "";
            for (Object string : array) {
                returnStr = returnStr + string.toString() + ",";
            }
            return returnStr.substring(0, returnStr.length() - 1);
        }
        return null;
    }
}

