/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.mapper.PurchaseContractAcceptanceMapper;
import com.els.modules.contract.service.PurchaseContractAcceptanceService;
import com.els.modules.contract.vo.PurchaseContractAcceptanceVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseContractAcceptanceServiceImpl
extends BaseServiceImpl<PurchaseContractAcceptanceMapper, PurchaseContractAcceptance>
implements PurchaseContractAcceptanceService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseContractAcceptance.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseContractAcceptance.setDocumentStatus("1");
        purchaseContractAcceptance.setCreateAccount(TenantContext.getTenant());
        purchaseContractAcceptance.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        purchaseContractAcceptance.setAcceptanceNumbers(this.invokeBaseRpcService.getNextCode("contractAcceptanceNumbers", (Object)purchaseContractAcceptance));
        ((PurchaseContractAcceptanceMapper)this.baseMapper).insert((Object)purchaseContractAcceptance);
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        ((PurchaseContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseContractAcceptance);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractAcceptance.getId());
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    @Override
    public void confirmMain(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseContractAcceptance.setDocumentStatus("2");
        ((PurchaseContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseContractAcceptance);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractAcceptance.getId());
        this.insertData(purchaseContractAcceptance, purchaseAttachmentList);
    }

    @Override
    public PurchaseContractAcceptanceVO getDataById(String id) {
        PurchaseContractAcceptanceVO purchaseContractAcceptanceVO = new PurchaseContractAcceptanceVO();
        PurchaseContractAcceptance purchaseContractAcceptance = (PurchaseContractAcceptance)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptance), (Object)((Object)purchaseContractAcceptanceVO));
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractAcceptanceVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseContractAcceptanceVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        ((PurchaseContractAcceptanceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            ((PurchaseContractAcceptanceMapper)this.baseMapper).deleteById(serializable);
        }
    }

    private void insertData(PurchaseContractAcceptance purchaseContractAcceptance, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setSendStatus("0");
                entity.setHeadId(purchaseContractAcceptance.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseContractAcceptance);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }
}

