/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import cn.hutool.core.util.StrUtil;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class PdfUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfUtil.class);

    public static String htmlToPdf(String fileRootPath, String html, final String fileName, boolean water, final String waterString, PageSize pageSize) throws Exception {
        File saveDirFile;
        if (fileRootPath == null) {
            fileRootPath = "D:\\pdf";
        }
        if (StrUtil.isBlank((CharSequence)html)) {
            return null;
        }
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        if (!(saveDirFile = new File(fileRootPath)).exists()) {
            saveDirFile.mkdirs();
        }
        String filePath = fileRootPath + "/" + fileName + ".pdf";
        PdfWriter pdfWriter = new PdfWriter(new File(fileRootPath + "/", FilenameUtils.getName((String)(fileName + ".pdf"))));
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pageSize);
        ConverterProperties pro = new ConverterProperties();
        DefaultFontProvider fontProvider = new DefaultFontProvider();
        fontProvider.addSystemFonts();
        pro.setFontProvider((FontProvider)fontProvider);
        IEventHandler handlerStartPage = new IEventHandler(){

            public void handleEvent(Event event) {
                PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                PdfDocument pdf = docEvent.getDocument();
                PdfPage page = docEvent.getPage();
                PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                int height = (int)page.getPageSize().getHeight();
                int width = (int)page.getPageSize().getWidth();
                Rectangle rect = new Rectangle((float)width / 2.0f - 10.0f, 10.0f, 36.0f, 32.0f);
                Canvas canvas = new Canvas(pdfCanvas, rect);
                canvas.add((IBlockElement)new Paragraph(String.valueOf(pdf.getNumberOfPages())).setFontSize(12.0f));
                canvas.showTextAligned("NO.:" + fileName, (float)width - 170.0f, (float)height - 25.0f, TextAlignment.LEFT);
                canvas.close();
            }
        };
        pdfDocument.addEventHandler("StartPdfPage", handlerStartPage);
        if (water) {
            IEventHandler handlerEndPage = new IEventHandler(){

                public void handleEvent(Event event) {
                    PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                    PdfDocument pdf = docEvent.getDocument();
                    PdfPage page = docEvent.getPage();
                    PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                    PdfFont font = null;
                    try {
                        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
                        if (path.startsWith("file:/")) {
                            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("static/simfang.ttf");
                            font = PdfFontFactory.createFont((byte[])PdfUtil.toByteArray(resourceAsStream), (String)"Identity-H", (boolean)false);
                        } else {
                            log.info(":::contract font path:" + path + "static/simfang.ttf");
                            font = PdfFontFactory.createFont((String)(path + "static/simfang.ttf"), (String)"Identity-H", (boolean)false);
                        }
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    ((Canvas)((Canvas)((Canvas)((Canvas)new Canvas(pdfCanvas, pdf, page.getPageSize()).setFontSize(36.0f)).setOpacity(Float.valueOf(0.2f))).setFont(font)).setFontColor((Color)new DeviceRgb(255, 0, 0))).showTextAligned(new Paragraph(waterString), 298.0f, 421.0f, pdf.getPageNumber(page), TextAlignment.CENTER, VerticalAlignment.MIDDLE, 45.0f);
                }
            };
            pdfDocument.addEventHandler("EndPdfPage", handlerEndPage);
        }
        HtmlConverter.convertToPdf((String)html.replaceAll("\u21b5", "").replaceAll("<!-- pagebreak -->", "<div style=\"page-break-after: always;\">&nbsp;</div>").replaceAll("<table border=\"1\" style=\"border-collapse: collapse; width: 100%; border-color: #000000;\" .*?>", "<table border=\"1\" style=\"border-collapse: collapse; width: 100%; border-color: #000000;\">"), (PdfDocument)pdfDocument, (ConverterProperties)pro);
        return filePath;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static String changeTemplate(String html) {
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        return newHtml.toString();
    }

    public static void main(String[] args) throws Exception {
        String html = "<h4>${zh_index}\u3001\u7269\u6599\u6e05\u5355\u5217\u8868</h4>\r\n<table style=\"border-collapse: collapse; width: 99.1736%; height: 40px;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">\u7269\u6599\u7f16\u7801</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">\u7269\u6599\u63cf\u8ff0</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">\u89c4\u683c</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">\u6570\u91cf</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">\u5355\u4ef7</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">\u91d1\u989d</td>\r\n</tr>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">${(item.materialCode)!''}</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">${(item.materialDesc)!''}</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">${(item.materialSpec)!''}</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">${(item.quantity)!''}</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">${(item.price)!''}</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">${(item.taxAmount)!''}</td>\r\n</tr>\r\n</tbody>\r\n</table>";
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        System.out.println(head);
        System.out.println("----------------------------------------");
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        System.out.println(center);
        System.out.println("----------------------------------------");
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        System.out.println(last);
        System.out.println("----------------------------------------");
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        System.out.println(newHtml);
    }
}

