/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.contract.entity.PurchaseContractAcceptance;
import com.els.modules.contract.service.PurchaseContractAcceptanceService;
import com.els.modules.contract.vo.PurchaseContractAcceptanceVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u5408\u540c\u9a8c\u6536"})
@RestController
@RequestMapping(value={"/contract/purchaseContractAcceptance"})
public class PurchaseContractAcceptanceController
extends BaseController<PurchaseContractAcceptance, PurchaseContractAcceptanceService> {
    @Autowired
    private PurchaseContractAcceptanceService purchaseContractAcceptanceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseContractAcceptance purchaseContractAcceptance, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractAcceptance), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseContractAcceptanceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> counts(PurchaseContractAcceptance purchaseContractAcceptance, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractAcceptance), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"document_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"document_status");
        List list = ((PurchaseContractAcceptanceService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseContractAcceptance::getDocumentStatus, PurchaseContractAcceptance::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "documentStatus", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("contractAcceptanceStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "documentStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractAcceptance#purchaseContractAcceptance:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseContractAcceptanceVO purchaseContractAcceptanceVO = this.purchaseContractAcceptanceService.getDataById(id);
        return Result.ok((Object)((Object)purchaseContractAcceptanceVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"contractAcceptance#purchaseContractAcceptance:add"})
    public Result<?> add(@RequestBody PurchaseContractAcceptanceVO purchaseContractAcceptancePage) {
        PurchaseContractAcceptance purchaseContractAcceptance = new PurchaseContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptancePage), (Object)((Object)purchaseContractAcceptance));
        this.purchaseContractAcceptanceService.saveMain(purchaseContractAcceptance, purchaseContractAcceptancePage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseContractAcceptance));
    }

    @AutoLog(value="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contractAcceptance#purchaseContractAcceptance:edit"})
    public Result<?> edit(@RequestBody PurchaseContractAcceptanceVO purchaseContractAcceptancePage) {
        PurchaseContractAcceptance purchaseContractAcceptance = new PurchaseContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptancePage), (Object)((Object)purchaseContractAcceptance));
        this.purchaseContractAcceptanceService.updateMain(purchaseContractAcceptance, purchaseContractAcceptancePage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @SrmValidated
    public Result<?> confirm(@RequestBody PurchaseContractAcceptanceVO purchaseContractAcceptancePage) {
        PurchaseContractAcceptance purchaseContractAcceptance = new PurchaseContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)purchaseContractAcceptancePage), (Object)((Object)purchaseContractAcceptance));
        this.purchaseContractAcceptanceService.confirmMain(purchaseContractAcceptance, purchaseContractAcceptancePage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u8be6\u60c5\u91cc\u9762\u7684\u786e\u8ba4", value="\u8be6\u60c5\u91cc\u9762\u7684\u786e\u8ba4")
    @ApiOperation(value="\u8be6\u60c5\u91cc\u9762\u7684\u786e\u8ba4", notes="\u8be6\u60c5\u91cc\u9762\u7684\u786e\u8ba4")
    @PostMapping(value={"/purchaseConfirm"})
    @SrmValidated
    public Result<?> purchaseConfirm(@RequestBody PurchaseContractAcceptance purchaseContractAcceptance) {
        this.purchaseContractAcceptanceService.updStatus(purchaseContractAcceptance);
        return Result.ok((Object)((Object)purchaseContractAcceptance));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u8be6\u60c5\u91cc\u9762\u7684\u62d2\u7edd", value="\u8be6\u60c5\u91cc\u9762\u7684\u62d2\u7edd")
    @ApiOperation(value="\u8be6\u60c5\u91cc\u9762\u7684\u62d2\u7edd", notes="\u8be6\u60c5\u91cc\u9762\u7684\u62d2\u7edd")
    @PostMapping(value={"/purchaseRefuse"})
    @SrmValidated
    public Result<?> purchaseRefuse(@RequestBody PurchaseContractAcceptance purchaseContractAcceptance) {
        this.purchaseContractAcceptanceService.updStatus(purchaseContractAcceptance);
        return Result.ok((Object)((Object)purchaseContractAcceptance));
    }

    @AutoLog(value="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractAcceptance#purchaseContractAcceptance:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseContractAcceptanceService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseContractAcceptanceService.delBatchMain(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"contractAcceptance#purchaseContractAcceptance:copy"})
    public Result<?> copyData(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractAcceptanceService.copyData(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u5408\u540c\u9a8c\u6536-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @PostMapping(value={"/invalid"})
    public Result<?> cancel(@RequestBody PurchaseContractAcceptance purchaseContractAcceptance) {
        String id = purchaseContractAcceptance.getId();
        this.purchaseContractAcceptanceService.cancellation(id);
        return this.commonSuccessResult(4);
    }
}

