/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.esignv3.dto.AuthRp;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.OrgAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgGetAuthRp;
import com.els.modules.electronsign.esignv3.dto.OrgQueryRp;
import com.els.modules.electronsign.esignv3.dto.OrgQueryRq;
import com.els.modules.electronsign.esignv3.dto.OrgRq;
import com.els.modules.electronsign.esignv3.dto.PersonalRq;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.enums.AuthCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.RealNameStatusEnum;
import com.els.modules.electronsign.esignv3.enums.RoleEnum;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3OrgMapper;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.util.IpassUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3OrgServiceImpl
extends BaseServiceImpl<SaleEsignV3OrgMapper, SaleEsignV3Org>
implements SaleEsignV3OrgService {
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private SaleEsignV3PersonalService personalService;
    @Autowired
    private SaleEsignV3OrgPsnService esignV3OrgPsnService;
    @Autowired
    private EsignV3Properties esignV3Properties;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(SaleEsignV3Org saleEsignV3Org) {
        saleEsignV3Org.setBusAccount(TenantContext.getTenant());
        this.handleDbBefore(saleEsignV3Org);
        ((SaleEsignV3OrgMapper)this.baseMapper).insert((Object)saleEsignV3Org);
        this.processNewCompany(saleEsignV3Org);
    }

    public void processNewCompany(SaleEsignV3Org saleEsignV3Org) {
        block9: {
            OrgQueryRq rq = new OrgQueryRq();
            rq.setOrgName(saleEsignV3Org.getOrgName());
            IpassUtil.setNullValue(rq);
            boolean throwE = false;
            try {
                OrgQueryRp orgQueryRp = this.ipassUtil.sendBaseRequest(rq, "e3-query-auth-org", OrgQueryRp.class);
                if (!RealNameStatusEnum.REAL_NAME.getValue().equals(orgQueryRp.getRealnameStatus())) break block9;
                BeanUtil.copyProperties((Object)orgQueryRp.getOrgInfo(), (Object)((Object)saleEsignV3Org), (String[])new String[0]);
                saleEsignV3Org.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
                saleEsignV3Org.setOrgId(orgQueryRp.getOrgId());
                saleEsignV3Org.setOrgName(orgQueryRp.getOrgName());
                saleEsignV3Org.setAuthorizeUserInfo(orgQueryRp.getAuthorizeUserInfo() != false ? "1" : "0");
                this.updateById((Object)saleEsignV3Org);
                if (!orgQueryRp.getAuthorizeUserInfo().booleanValue()) break block9;
                OrgQueryRq orgQueryRq = new OrgQueryRq();
                orgQueryRq.setOrgId(saleEsignV3Org.getOrgId());
                OrgGetAuthRp orgGetAuthRp = this.ipassUtil.sendBaseRequest(orgQueryRq, "e3-get-auth-info", OrgGetAuthRp.class);
                if (CollUtil.isNotEmpty(orgGetAuthRp.getAuthorizedInfo())) {
                    saleEsignV3Org.setAuthorizedScopes(orgGetAuthRp.getAuthorizedInfo().stream().map(x -> x.getAuthorizedScope()).distinct().collect(Collectors.joining(",")));
                    this.updateById((Object)saleEsignV3Org);
                    if (saleEsignV3Org.getAuthorizedScopes().contains("manage_org_resource")) {
                        OrgAdminRp rp = this.ipassUtil.sendBaseRequest(orgQueryRq, "e3-query-org-admin", OrgAdminRp.class);
                        if (ObjectUtil.isNotEmpty((Object)rp)) {
                            List<OrgAdminRp.Administrator> administrators = rp.getAdministrators();
                            boolean check = true;
                            for (OrgAdminRp.Administrator administrator : administrators) {
                                if (!StrUtil.equals((CharSequence)saleEsignV3Org.getPsnId(), (CharSequence)administrator.getPsnId()) && (!ObjectUtil.isNotEmpty((Object)administrator.getPsnAccount()) || (!StrUtil.isNotBlank((CharSequence)administrator.getPsnAccount().getAccountMobile()) || !saleEsignV3Org.getPsnAccount().equals(administrator.getPsnAccount().getAccountMobile())) && (!StrUtil.isNotBlank((CharSequence)administrator.getPsnAccount().getAccountEmail()) || !administrator.getPsnAccount().getAccountEmail().equals(saleEsignV3Org.getPsnAccount())))) continue;
                                check = false;
                                if (!StrUtil.equals((CharSequence)administrator.getPsnName(), (CharSequence)saleEsignV3Org.getPsnName())) {
                                    throwE = true;
                                    throw new ELSBootException("\u6b64\u4f01\u4e1a\u5df2\u8ba4\u8bc1\uff0c\u5bf9\u5e94\u7684\u7ba1\u7406\u5458\u4e3a[" + administrator.getPsnName() + ",\u7ecf\u529e\u4eba\u8d26\u53f7\u6807\u8bc6:" + Optional.ofNullable(administrator.getPsnAccount().getAccountMobile()).orElse(administrator.getPsnAccount().getAccountEmail()) + "],\u8bf7\u68c0\u67e5\u5355\u636e\u7684\u7ecf\u529e\u4eba\u662f\u5426\u6b63\u786e");
                                }
                                this.handleOrgAndPsn(saleEsignV3Org, administrator.getPsnId());
                                break;
                            }
                            if (check) {
                                throwE = true;
                                OrgAdminRp.Administrator administrator = rp.getAdministrators().get(0);
                                throw new ELSBootException("\u6b64\u4f01\u4e1a\u5df2\u8ba4\u8bc1\uff0c\u5bf9\u5e94\u7684\u7ba1\u7406\u5458\u4e3a[" + administrator.getPsnName() + ",\u7ecf\u529e\u4eba\u8d26\u53f7\u6807\u8bc6:" + Optional.ofNullable(administrator.getPsnAccount().getAccountMobile()).orElse(administrator.getPsnAccount().getAccountEmail()) + "],\u8bf7\u68c0\u67e5\u5355\u636e\u7684\u7ecf\u529e\u4eba\u662f\u5426\u6b63\u786e");
                            }
                        }
                        break block9;
                    }
                    throwE = true;
                    throw new ELSBootException("\u6b64\u4f01\u4e1a\u5df2\u8ba4\u8bc1\uff0c\u672a\u6388\u6743\u8d44\u6e90\u7ba1\u7406\u6743\u9650\uff0c\u65e0\u6cd5\u81ea\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458\uff0c\u8bf7\u6388\u6743\u540e\u624b\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458");
                }
                throwE = true;
                throw new ELSBootException("\u6b64\u4f01\u4e1a\u5df2\u8ba4\u8bc1\uff0c\u672a\u6388\u6743\u5e94\u7528\uff0c\u65e0\u6cd5\u81ea\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458\uff0c\u8bf7\u6388\u6743\u540e\u624b\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458");
            }
            catch (Exception e) {
                if (throwE) {
                    throw e;
                }
                this.log.error("processNewCompany error", (Throwable)e);
            }
        }
    }

    private void handleOrgAndPsn(SaleEsignV3Org org, String psnId) {
        TenantContext.setTenant((String)org.getElsAccount());
        SaleEsignV3Personal psn = this.personalService.getByPsnId(psnId, org.getElsAccount());
        if (ObjectUtil.isEmpty((Object)((Object)psn))) {
            psn = this.personalService.getByPsnAccount(org.getPsnAccount());
        }
        if (ObjectUtil.isEmpty((Object)((Object)psn))) {
            psn = new SaleEsignV3Personal();
            psn.setSubAccount(org.getSubAccount());
            psn.setPsnName(org.getPsnName());
            psn.setPsnAccount(org.getPsnAccount());
            psn.setPsnMobile(org.getPsnMobile());
            psn.setPsnIdCardNum(org.getPsnIdCardNum());
            psn.setPsnIdCardType(org.getPsnIdCardType());
            psn.setBankCardNum(org.getBankCardNum());
            psn.setPsnDefaultAuthMode(org.getPsnDefaultAuthmode());
            psn.setPsnAvailableAuthModes(org.getPsnAvailableAuthmodes());
            psn.setPsnEditableFields(org.getPsnEditableFields());
        }
        psn.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
        psn.setPsnId(psnId);
        this.personalService.saveOrUpdate((Object)psn);
        this.saveOrgAndPsn(org, psn);
        TenantContext.clear();
    }

    private void saveOrgAndPsn(SaleEsignV3Org org, SaleEsignV3Personal psn) {
        SaleEsignV3OrgPsn elsEsignV3OrgPsn = new SaleEsignV3OrgPsn();
        elsEsignV3OrgPsn.setOrgId(org.getId());
        elsEsignV3OrgPsn.setOrgCode(org.getOrgId());
        elsEsignV3OrgPsn.setPsnId(psn.getId());
        elsEsignV3OrgPsn.setPsnCode(psn.getPsnId());
        elsEsignV3OrgPsn.setElsAccount(org.getElsAccount());
        elsEsignV3OrgPsn.setRole(RoleEnum.ADMIN.getCode());
        SaleEsignV3OrgPsn db = (SaleEsignV3OrgPsn)((Object)this.esignV3OrgPsnService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3OrgPsn::getOrgId, (Object)org.getOrgId())).eq(SaleEsignV3OrgPsn::getPsnId, (Object)org.getPsnId())).eq(BaseEntity::getElsAccount, (Object)org.getElsAccount())).eq(BaseEntity::getDeleted, (Object)"0")));
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            this.esignV3OrgPsnService.save((Object)elsEsignV3OrgPsn);
        }
    }

    private void handleDbBefore(SaleEsignV3Org org) {
        if ("1".equals(org.getLoadingOrg())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", org.getOrgCode());
            Assert.notNull((Object)organizationInfo, (String)I18nUtil.translate((String)"i18n_field_tRcodeIH_b9e65e2d", (String)"\u673a\u6784code\u5f02\u5e38"));
            org.setOrgName(organizationInfo.getOrgName());
        }
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Org::getOrgName, (Object)org.getOrgName())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).ne(BaseEntity::getId, (Object)org.getId())).eq(BaseEntity::getElsAccount, (Object)org.getElsAccount())) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_rAEIMK_369fd5a4", (String)"\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728"));
    }

    @Override
    public void edit(SaleEsignV3Org saleEsignV3Org) {
        int count = ((SaleEsignV3OrgMapper)this.baseMapper).updateById((Object)saleEsignV3Org);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleEsignV3OrgMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3OrgMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public SaleEsignV3Org submitCertification(SaleEsignV3Org org, String needSave) {
        if ("1".equals(needSave)) {
            if (StrUtil.isBlank((CharSequence)org.getId())) {
                this.add(org);
            } else {
                this.edit(org);
            }
        } else {
            org = (SaleEsignV3Org)((Object)this.getById((Serializable)((Object)org.getId())));
        }
        OrgRq.OrgAuthConfig orgAuthConfig = new OrgRq.OrgAuthConfig();
        BeanUtil.copyProperties((Object)((Object)org), (Object)orgAuthConfig, (String[])new String[0]);
        IpassUtil.setNullValue(orgAuthConfig);
        OrgRq.OrgInfo orgInfo = new OrgRq.OrgInfo();
        orgInfo.setOrgIDCardNum(org.getOrgIdCardNum());
        orgInfo.setOrgIDCardType(org.getOrgIdCardType());
        orgInfo.setLegalRepName(org.getLegalRepName());
        orgInfo.setLegalRepIDCardNum(org.getLegalRepIdCardNum());
        orgInfo.setLegalRepIDCardType(org.getLegalRepIdCardType());
        IpassUtil.setNullValue(orgInfo);
        orgAuthConfig.setOrgInfo(orgInfo);
        PersonalRq.PsnAuthConfig transactorInfo = new PersonalRq.PsnAuthConfig();
        if (StrUtil.isNotBlank((CharSequence)org.getPsnId())) {
            transactorInfo.setPsnId(org.getPsnId());
        } else {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)org.getPsnAccount()), (String)I18nUtil.translate((String)"11", (String)"\u7ecf\u529e\u4eba\u8d26\u53f7\u6807\u8bc6\uff08\u624b\u673a\u53f7\u6216\u90ae\u7bb1\uff09"));
            transactorInfo.setPsnAccount(org.getPsnAccount());
            PersonalRq.PsnInfo psnInfo = new PersonalRq.PsnInfo();
            BeanUtil.copyProperties((Object)((Object)org), (Object)psnInfo, (String[])new String[0]);
            IpassUtil.setNullValue(psnInfo);
            transactorInfo.setPsnInfo(psnInfo);
            PersonalRq.PsnAuthPageConfig psnAuthPageConfig = new PersonalRq.PsnAuthPageConfig();
            psnAuthPageConfig.setPsnDefaultAuthMode(org.getPsnDefaultAuthmode());
            if (StrUtil.isNotBlank((CharSequence)org.getPsnAvailableAuthmodes())) {
                psnAuthPageConfig.setPsnAvailableAuthModes(Arrays.asList(org.getPsnAvailableAuthmodes().split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)org.getPsnEditableFields())) {
                psnAuthPageConfig.setPsnEditableFields(Arrays.asList(org.getPsnEditableFields().split(",")));
            }
            orgAuthConfig.setTransactorAuthPageConfig(psnAuthPageConfig);
        }
        orgAuthConfig.setTransactorInfo(transactorInfo);
        OrgRq.OrgAuthPageConfig orgAuthPageConfig = new OrgRq.OrgAuthPageConfig();
        BeanUtil.copyProperties((Object)((Object)org), (Object)orgAuthPageConfig, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)org.getOrgAvailableAuthModes())) {
            orgAuthPageConfig.setOrgAvailableAuthModes(Arrays.asList(org.getOrgAvailableAuthModes().split(",")));
        }
        if (StrUtil.isNotBlank((CharSequence)org.getOrgEditableFields())) {
            orgAuthPageConfig.setOrgEditableFields(Arrays.asList(org.getOrgEditableFields().split(",")));
        }
        IpassUtil.setNullValue(orgAuthPageConfig);
        orgAuthConfig.setOrgAuthPageConfig(orgAuthPageConfig);
        String notifyUrl = this.esignV3Properties.getCallBackUrl() + "/esignv3/saleEsignV3Org/noToken/callback";
        OrgRq orgRq = OrgRq.builder().orgAuthConfig(orgAuthConfig).notifyUrl(notifyUrl).build();
        if (StrUtil.isNotBlank((CharSequence)org.getAuthorizedScopes())) {
            OrgRq.AuthorizeConfig authorizeConfig = new OrgRq.AuthorizeConfig();
            authorizeConfig.setAuthorizedScopes(Arrays.asList(org.getAuthorizedScopes().split(",")));
            orgRq.setAuthorizeConfig(authorizeConfig);
        }
        IpassUtil.setNullValue(orgRq);
        AuthRp rp = this.ipassUtil.sendRequest(orgRq, "e3-get-auth-org", AuthRp.class);
        org.setAuthFlowId(rp.getAuthFlowId());
        org.setAuthUrl(rp.getAuthUrl());
        org.setAuthShortYrl(rp.getAuthShortUrl());
        this.updateById((Object)org);
        return org;
    }

    @Override
    public void handleCallBack(CallBackDto.OrgAuth params) {
        SaleEsignV3Org org;
        if (AuthCallBackEnum.AUTH_PASS.getCode().equals(params.getAction()) && ObjectUtil.isNotEmpty((Object)((Object)(org = ((SaleEsignV3OrgMapper)this.baseMapper).selectByRequestId(params.getAuthFlowId()))))) {
            this.handleAuthSuccess(org, params.getOrganization().getOrgId(), params.getOrganization().getOrgName(), params.getOrganization().getTransactor().getPsnId());
        }
    }

    @Override
    public void refreshRealNameStatus(String id) {
        SaleEsignV3Org org = (SaleEsignV3Org)((Object)this.getById((Serializable)((Object)id)));
        OrgQueryRq rq = new OrgQueryRq();
        rq.setOrgName(org.getOrgName());
        IpassUtil.setNullValue(rq);
        OrgQueryRp orgQueryRp = this.ipassUtil.sendBaseRequest(rq, "e3-query-auth-org", OrgQueryRp.class);
        if (RealNameStatusEnum.REAL_NAME.getValue().equals(orgQueryRp.getRealnameStatus())) {
            BeanUtil.copyProperties((Object)orgQueryRp.getOrgInfo(), (Object)((Object)org), (String[])new String[0]);
            org.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
            org.setOrgId(orgQueryRp.getOrgId());
            org.setOrgName(orgQueryRp.getOrgName());
            org.setAuthorizeUserInfo(orgQueryRp.getAuthorizeUserInfo() != false ? "1" : "0");
            this.updateById((Object)org);
            if (StrUtil.isBlank((CharSequence)org.getPsnId())) {
                PersonalRq.QueryAuth queryAuth = new PersonalRq.QueryAuth();
                queryAuth.setPsnAccount(org.getPsnAccount());
                IpassUtil.setNullValue(queryAuth);
                AuthRp.QueryRp queryRp = this.ipassUtil.sendBaseRequest(queryAuth, "e3-query-auth-personal", AuthRp.QueryRp.class);
                if (RealNameStatusEnum.REAL_NAME.getCode().equals(queryRp.getRealnameStatus())) {
                    org.setPsnId(queryRp.getPsnId());
                } else {
                    throw new ELSBootException("\u8bf7\u68c0\u67e5\u7ecf\u529e\u4eba\u662f\u5426\u548c\u8ba4\u8bc1\u65f6\u7684\u7ecf\u529e\u4eba\u4e00\u81f4");
                }
            }
            this.handleOrgAndPsn(org, org.getPsnId());
        }
    }

    @Override
    public SaleEsignV3Org getByOrgId(String orgId) {
        return (SaleEsignV3Org)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Org::getOrgId, (Object)orgId), false));
    }

    @Override
    public String getAuth(SaleEsignV3Org org) {
        SaleEsignV3Org db = (SaleEsignV3Org)((Object)this.getById((Serializable)((Object)org.getId())));
        if (StrUtil.isNotBlank((CharSequence)db.getAuthorizedScopes())) {
            List<String> old = Arrays.asList(db.getAuthorizedScopes().split(","));
            List<String> n = Arrays.asList(org.getAuthorizedScopes().split(","));
            ArrayList end = Lists.newArrayList();
            end.addAll(old);
            end.addAll(n);
            db.setAuthorizedScopes(end.stream().distinct().collect(Collectors.joining(",")));
        } else {
            db.setAuthorizedScopes(org.getAuthorizedScopes());
        }
        db = this.submitCertification(db, "1");
        return db.getAuthUrl();
    }

    private void handleAuthSuccess(SaleEsignV3Org org, String orgId, String orgName, String psnId) {
        org.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
        org.setOrgId(orgId);
        org.setOrgName(Optional.ofNullable(orgName).orElse(org.getOrgName()));
        psnId = Optional.ofNullable(psnId).orElse(org.getPsnId());
        if (StrUtil.isNotBlank((CharSequence)psnId)) {
            org.setPsnId(psnId);
        }
        this.updateById((Object)org);
        TenantContext.setTenant((String)org.getElsAccount());
        SaleEsignV3Personal psn = this.personalService.getByPsnId(psnId, org.getElsAccount());
        if (ObjectUtil.isEmpty((Object)((Object)psn))) {
            psn = this.personalService.getByPsnAccount(org.getPsnAccount());
        }
        if (ObjectUtil.isEmpty((Object)((Object)psn))) {
            psn = new SaleEsignV3Personal();
            psn.setSubAccount(org.getSubAccount());
            psn.setPsnName(org.getPsnName());
            psn.setPsnAccount(org.getPsnAccount());
            psn.setPsnMobile(org.getPsnMobile());
            psn.setPsnIdCardNum(org.getPsnIdCardNum());
            psn.setPsnIdCardType(org.getPsnIdCardType());
            psn.setBankCardNum(org.getBankCardNum());
            psn.setPsnDefaultAuthMode(org.getPsnDefaultAuthmode());
            psn.setPsnAvailableAuthModes(org.getPsnAvailableAuthmodes());
            psn.setPsnEditableFields(org.getPsnEditableFields());
        }
        psn.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
        psn.setPsnId(psnId);
        this.personalService.saveOrUpdate((Object)psn);
        SaleEsignV3OrgPsn elsEsignV3OrgPsn = new SaleEsignV3OrgPsn();
        elsEsignV3OrgPsn.setOrgId(org.getId());
        elsEsignV3OrgPsn.setOrgCode(org.getOrgId());
        elsEsignV3OrgPsn.setPsnId(psn.getId());
        elsEsignV3OrgPsn.setPsnCode(psn.getPsnId());
        elsEsignV3OrgPsn.setRole(RoleEnum.ADMIN.getCode());
        SaleEsignV3OrgPsn db = (SaleEsignV3OrgPsn)((Object)this.esignV3OrgPsnService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3OrgPsn::getOrgId, (Object)org.getOrgId())).eq(SaleEsignV3OrgPsn::getPsnId, (Object)org.getPsnId())).eq(BaseEntity::getDeleted, (Object)"0")));
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            this.esignV3OrgPsnService.save((Object)elsEsignV3OrgPsn);
        }
    }
}

