/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.util;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.http.HttpResponse;
import com.els.common.exception.ELSBootException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static byte[] getBytes(String filePath) {
        File file = new File(filePath);
        InputStream inputStream = null;
        byte[] data = null;
        if (!file.exists()) {
            URLConnection conn = null;
            try {
                URL url = new URL(filePath);
                conn = url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                inputStream = conn.getInputStream();
            }
            catch (Exception e) {
                throw new ELSBootException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25" + e.getMessage());
            }
        }
        try {
            inputStream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ELSBootException("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25:" + e.getMessage());
        }
        if (inputStream != null) {
            try {
                data = new byte[((InputStream)inputStream).available()];
                ((InputStream)inputStream).read(data);
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                throw new ELSBootException("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return data;
    }

    public static byte[] getBytes(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new ELSBootException("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25:" + e.getMessage());
        }
        byte[] data = null;
        if (inputStream != null) {
            try {
                data = new byte[((InputStream)inputStream).available()];
                ((InputStream)inputStream).read(data);
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                throw new ELSBootException("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return data;
    }

    public static void writeToLocal(String destination, InputStream input) throws IOException {
        int index;
        byte[] bytes = new byte[1024];
        FileOutputStream downloadFile = new FileOutputStream(destination);
        while ((index = input.read(bytes)) != -1) {
            downloadFile.write(bytes, 0, index);
            downloadFile.flush();
        }
        input.close();
        downloadFile.close();
    }

    public static File getFile(String filePath, String dateFormat, String uploadpath, String elsAccount, String name) {
        File file = new File(filePath);
        InputStream inputStream = null;
        if (!file.exists()) {
            URLConnection conn = null;
            try {
                URL url = new URL(filePath);
                conn = url.openConnection();
                conn.setConnectTimeout(300000);
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                inputStream = conn.getInputStream();
                String bizPath = "files";
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormat);
                String nowDay = dtf.format(time);
                String path = uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
                file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                String fileName = path + File.separator + name;
                FileUtils.writeToLocal(fileName, inputStream);
                File file2 = new File(fileName);
                return file2;
            }
            catch (Exception e) {
                log.error("ExceptionKey\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a", (Throwable)e);
                throw new ELSBootException("ExceptionKey\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e2) {
                        log.error("\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e2);
                    }
                }
            }
        }
        return file;
    }

    public static File getFile(File file, String dateFormat, String uploadpath, String elsAccount, String name) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            String bizPath = "files";
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormat);
            String nowDay = dtf.format(time);
            String path = uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
            file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileName = path + File.separator + name;
            FileUtils.writeToLocal(fileName, inputStream);
            File file2 = new File(fileName);
            return file2;
        }
        catch (Exception e) {
            log.error("ExceptionKey\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a", (Throwable)e);
            throw new ELSBootException("ExceptionKey\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e2) {
                    log.error("\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e2);
                }
            }
        }
    }

    public static byte[] getBytes(String filePath, String dateFormat, String uploadpath, String elsAccount, String name) {
        File file = null;
        FileInputStream stream = null;
        try {
            file = FileUtils.getFile(filePath, dateFormat, uploadpath, elsAccount, name);
            stream = new FileInputStream(file);
            byte[] data = new byte[stream.available()];
            stream.read(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            log.error("\u5b57\u8282\u83b7\u53d6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ELSBootException("\u5b57\u8282\u83b7\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error("\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static byte[] getBytes(File file, String dateFormat, String uploadpath, String elsAccount, String name) {
        FileInputStream stream = null;
        try {
            file = FileUtils.getFile(file, dateFormat, uploadpath, elsAccount, name);
            stream = new FileInputStream(file);
            byte[] data = new byte[stream.available()];
            stream.read(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            log.error("\u5b57\u8282\u83b7\u53d6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ELSBootException("\u5b57\u8282\u83b7\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error("\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static String getFileUrl(HttpResponse response, String fileName, String elsAccount, String uploadpath) {
        InputStream stream = response.bodyStream();
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowDay = dtf.format(time);
        String path = uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        String filePath = path + File.separator + fileName;
        try {
            FileUtils.writeToLocal(filePath, stream);
        }
        catch (IOException e) {
            log.error("\u5951\u7ea6\u9501--\u6587\u6863\u4e0b\u8f7d\u4fdd\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
        return filePath;
    }

    public static String base64Tofile(String base64String, String elsAccount, String uploadpath, String fileName) {
        ByteArrayInputStream stream = null;
        try {
            byte[] bytes = Base64Decoder.decode((CharSequence)base64String);
            stream = new ByteArrayInputStream(bytes);
            String bizPath = "files";
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
            String nowDay = dtf.format(time);
            String path = uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            String filePath = path + File.separator + fileName;
            try {
                FileUtils.writeToLocal(filePath, stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return filePath;
        }
        catch (Exception e) {
            log.error("\u8d8a\u5bcc\u5609\u9a70-\u7535\u5b50\u7b7e\u7ea6--base64\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ELSBootException("\u8d8a\u5bcc\u5609\u9a70-\u7535\u5b50\u7b7e\u7ea6--base64\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static String streamToBase64(InputStream in) {
        byte[] data = null;
        try {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = in.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            data = swapStream.toByteArray();
        }
        catch (IOException e) {
            log.error("streamToBase64--\u6587\u4ef6\u4e0b\u8f7d\u5904\u7406\u5931\u8d25\uff1a", (Throwable)e);
            throw new ELSBootException("streamToBase64--\u6587\u4ef6\u4e0b\u8f7d\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("streamToBase64--base64\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                    throw new ELSBootException("streamToBase64--\u6587\u4ef6\u4e0b\u8f7d\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        FileUtils.deleteFile(file);
    }

    public static void deleteFile(File file) {
        if (file == null || !file.exists()) {
            log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25,\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                file.delete();
            } else {
                for (File f : files) {
                    if (f.isDirectory()) {
                        FileUtils.deleteFile(f);
                        continue;
                    }
                    f.delete();
                }
            }
        }
    }

    public static InputStream getStream(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            URLConnection conn = null;
            try {
                URL url = new URL(filePath);
                conn = url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                return conn.getInputStream();
            }
            catch (Exception e) {
                log.error("getStream\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e);
                throw new ELSBootException("getStream\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e.getMessage());
            }
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error("getStream\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e);
            throw new ELSBootException("getStream\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e.getMessage());
        }
    }

    public static String getWebFile(String filePath, String dateFormat, String uploadpath, String elsAccount) {
        InputStream inputStream = null;
        URLConnection conn = null;
        try {
            System.setProperty("com.sun.security.enableAIAcaIssuers", "true");
            URL url = new URL(filePath);
            conn = url.openConnection();
            conn.setConnectTimeout(300000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            int index = filePath.lastIndexOf("/");
            String bizPath = "files";
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormat);
            String nowDay = dtf.format(time);
            String path = uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileName = path + File.separator + filePath.substring(index + 1);
            FileUtils.writeToLocal(fileName, inputStream);
            String string = fileName;
            return string;
        }
        catch (Exception e) {
            log.error("ExceptionKey\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a", (Throwable)e);
            throw new ELSBootException("ExceptionKey\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25 \uff1a" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e2) {
                    log.error("\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e2);
                }
            }
        }
    }

    public static String streamSave(InputStream in, String dateFormat, String uploadpath, String elsAccount, String fileName) {
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormat);
        String nowDay = dtf.format(time);
        String path = uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        String savePath = path + File.separator + fileName;
        try {
            FileUtils.writeToLocal(savePath, in);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            throw new ELSBootException("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e, new String[0]);
        }
        return savePath;
    }
}

