/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.modules.contract.entity.PurchaseContractParam;
import com.els.modules.contract.mapper.PurchaseContractParamMapper;
import com.els.modules.contract.service.PurchaseContractParamService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseContractParamServiceImpl
extends ServiceImpl<PurchaseContractParamMapper, PurchaseContractParam>
implements PurchaseContractParamService {
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void savePurchaseContractParam(PurchaseContractParam purchaseContractParam) {
        this.extracted(purchaseContractParam);
        ((PurchaseContractParamMapper)this.baseMapper).insert((Object)purchaseContractParam);
    }

    @Override
    public void updatePurchaseContractParam(PurchaseContractParam purchaseContractParam) {
        this.extracted(purchaseContractParam);
        ((PurchaseContractParamMapper)this.baseMapper).updateById((Object)purchaseContractParam);
    }

    private void extracted(PurchaseContractParam purchaseContractParam) {
        if (StringUtils.isBlank((CharSequence)purchaseContractParam.getParamNameI18nKey())) {
            String paramName = purchaseContractParam.getParamName();
            Map map = this.baseRpcService.checkAndAdd(Arrays.asList(paramName));
            purchaseContractParam.setParamNameI18nKey((String)map.get(paramName));
        }
    }

    @Override
    public void delPurchaseContractParam(String id) {
        ((PurchaseContractParamMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void refreshExcelI18n() {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(PurchaseContractParam::getParamNameI18nKey)).or()).eq(PurchaseContractParam::getParamNameI18nKey, (Object)""))).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<Object> collect = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getParamName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map stringStringMap = this.baseRpcService.checkAndAdd(collect);
            list.forEach(item -> item.setParamNameI18nKey((String)stringStringMap.get(item.getParamName())));
            this.updateBatchById(list);
        }
    }

    @Override
    public void delBatchPurchaseContractParam(List<String> idList) {
        ((PurchaseContractParamMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void copyToElsAccount(List<PurchaseContractParam> copyList, String elsAccount) {
        if (CollectionUtil.isEmpty(copyList)) {
            return;
        }
        for (PurchaseContractParam param : copyList) {
            param.setId(IdWorker.getIdStr());
            param.setElsAccount(elsAccount);
        }
        this.saveBatch(copyList);
    }
}

