/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaGetPersonAuthUrlDTO;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaPersonal;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaPersonalService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseFadadaPersonalServiceImpl
extends BaseServiceImpl<PurchaseFadadaPersonalMapper, PurchaseFadadaPersonal>
implements PurchaseFadadaPersonalService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;

    @Override
    public void add(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        if ("mobile".equals(purchaseFadadaPersonal.getAccountType())) {
            purchaseFadadaPersonal.setAccountName(purchaseFadadaPersonal.getMobile());
        } else {
            purchaseFadadaPersonal.setAccountName(purchaseFadadaPersonal.getEmail());
        }
        this.saveFlag(purchaseFadadaPersonal);
        ((PurchaseFadadaPersonalMapper)this.baseMapper).insert((Object)purchaseFadadaPersonal);
    }

    public void saveFlag(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        QueryWrapper personalQueryWrapper = new QueryWrapper();
        personalQueryWrapper.eq((Object)"sub_account", (Object)purchaseFadadaPersonal.getSubAccount());
        personalQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (this.getOne((Wrapper)personalQueryWrapper) != null) {
            throw new ELSBootException(purchaseFadadaPersonal.getSubAccount() + "\u7ed1\u5b9a\u7684\u6388\u6743\u7528\u6237\u5df2\u7ecf\u88ab\u521b\u5efa\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\uff01");
        }
        purchaseFadadaPersonal.setClientUserId(purchaseFadadaPersonal.getAccountName());
    }

    @Override
    public void edit(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        if ("mobile".equals(purchaseFadadaPersonal.getAccountType())) {
            purchaseFadadaPersonal.setAccountName(purchaseFadadaPersonal.getMobile());
        } else {
            purchaseFadadaPersonal.setAccountName(purchaseFadadaPersonal.getEmail());
        }
        this.editFlag(purchaseFadadaPersonal);
        int count = ((PurchaseFadadaPersonalMapper)this.baseMapper).updateById((Object)purchaseFadadaPersonal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editFlag(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        QueryWrapper personalQueryWrapper = new QueryWrapper();
        personalQueryWrapper.eq((Object)"sub_account", (Object)purchaseFadadaPersonal.getSubAccount());
        personalQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        PurchaseFadadaPersonal personal = (PurchaseFadadaPersonal)((Object)this.getOne((Wrapper)personalQueryWrapper));
        if (personal != null && !purchaseFadadaPersonal.getId().equals(personal.getId())) {
            throw new ELSBootException(purchaseFadadaPersonal.getSubAccount() + "\u7ed1\u5b9a\u7684\u6388\u6743\u7528\u6237\u5df2\u88ab\u521b\u5efa\uff0c\u53ef\u6362\u5176\u4ed6\u5b50\u8d26\u53f7");
        }
        purchaseFadadaPersonal.setClientUserId(purchaseFadadaPersonal.getAccountName());
    }

    @Override
    public void delete(String id) {
        ((PurchaseFadadaPersonalMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseFadadaPersonalMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        if ("mobile".equals(purchaseFadadaPersonal.getAccountType())) {
            purchaseFadadaPersonal.setAccountName(purchaseFadadaPersonal.getMobile());
        } else {
            purchaseFadadaPersonal.setAccountName(purchaseFadadaPersonal.getEmail());
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseFadadaPersonal.getId())) {
            this.editFlag(purchaseFadadaPersonal);
            int count = ((PurchaseFadadaPersonalMapper)this.baseMapper).updateById((Object)purchaseFadadaPersonal);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        } else {
            this.saveFlag(purchaseFadadaPersonal);
            ((PurchaseFadadaPersonalMapper)this.baseMapper).insert((Object)purchaseFadadaPersonal);
        }
        String redirectUrl = this.fadadaCallUtil.getRedirectUrl();
        FadadaGetPersonAuthUrlDTO fadadaGetPersonAuthUrlDTO = new FadadaGetPersonAuthUrlDTO(purchaseFadadaPersonal, redirectUrl);
        String requestStr = JSONObject.toJSONString((Object)fadadaGetPersonAuthUrlDTO);
        JSONObject response = this.fadadaCallUtil.call(requestStr, "fadada_get_personal_auth_url");
        if ("210002".equals(response.getString("code"))) {
            purchaseFadadaPersonal.setAuthFailedReason("exist");
            this.getAuthInfo(purchaseFadadaPersonal);
        } else {
            purchaseFadadaPersonal.setAuthUrl(response.getString("authUrl"));
            ((PurchaseFadadaPersonalMapper)this.baseMapper).updateById((Object)purchaseFadadaPersonal);
        }
    }

    @Override
    public void updateAuthStatus(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("clientUserId", (Object)purchaseFadadaPersonal.getClientUserId());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_auth_info");
        purchaseFadadaPersonal.setAuthResult(response.getString("bindingStatus"));
        purchaseFadadaPersonal.setIdentProcessStatus(response.getString("identStatus"));
        purchaseFadadaPersonal.setAvailableStatus(response.getString("availableStatus"));
        this.updateById((Object)purchaseFadadaPersonal);
    }

    @Override
    public void getAuthInfo(PurchaseFadadaPersonal purchaseFadadaPersonal) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("clientUserId", (Object)purchaseFadadaPersonal.getClientUserId());
        JSONObject authInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_auth_info");
        purchaseFadadaPersonal.setClientUserId(authInfo.getString("clientUserId"));
        purchaseFadadaPersonal.setOpenUserId(authInfo.getString("openUserId"));
        purchaseFadadaPersonal.setAuthResult(authInfo.getString("bindingStatus"));
        purchaseFadadaPersonal.setIdentProcessStatus(authInfo.getString("identStatus"));
        purchaseFadadaPersonal.setAvailableStatus(authInfo.getString("availableStatus"));
        if (StringUtils.isNotBlank((CharSequence)authInfo.getString("authScope"))) {
            JSONArray array = authInfo.getJSONArray("authScope");
            Object authScope = "";
            for (Object object : array) {
                authScope = (String)authScope + object.toString() + ",";
            }
            purchaseFadadaPersonal.setAuthScopes((String)authScope);
        }
        requestObject = new JSONObject();
        requestObject.put("openUserId", (Object)purchaseFadadaPersonal.getOpenUserId());
        JSONObject identInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_ident_info");
        purchaseFadadaPersonal.setIdentMethod(identInfo.getString("identMethod"));
        JSONObject userIdentInfo = identInfo.getJSONObject("userIdentInfo");
        purchaseFadadaPersonal.setUserName(userIdentInfo.getString("userName"));
        purchaseFadadaPersonal.setUserIdentType(userIdentInfo.getString("identType"));
        purchaseFadadaPersonal.setUserIdentNo(userIdentInfo.getString("identNo"));
        JSONObject userIdentInfoExtend = identInfo.getJSONObject("userIdentInfoExtend");
        purchaseFadadaPersonal.setBankAccountNo(userIdentInfoExtend.getString("userIdentInfoExtend"));
        purchaseFadadaPersonal.setMobile(userIdentInfoExtend.getString("mobile"));
        purchaseFadadaPersonal.setAuthFailedReason("");
        this.updateById((Object)purchaseFadadaPersonal);
    }
}

