/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnRemoveRq;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3OrgPsnMapper;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.vo.SaleV3OrgPsnVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3OrgPsnServiceImpl
extends BaseServiceImpl<SaleEsignV3OrgPsnMapper, SaleEsignV3OrgPsn>
implements SaleEsignV3OrgPsnService {
    @Autowired
    private SaleEsignV3PersonalService personalService;
    @Autowired
    private IpassUtil ipassUtil;

    @Override
    public void add(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        SaleEsignV3OrgPsn orgPsn;
        SaleEsignV3Personal personal = (SaleEsignV3Personal)((Object)this.personalService.getById((Serializable)((Object)saleEsignV3OrgPsn.getPsnId())));
        OrgPsnAdminRp rp = this.sendEsignAdd(saleEsignV3OrgPsn, personal.getPsnName());
        if (!rp.getAddedMembers().contains(personal.getPsnId()) && CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
            if ("\u7528\u6237\u5df2\u7ecf\u662f\u5f53\u524d\u4f01\u4e1a\u6210\u5458".equals(rp.getUnaddedMembers().get(0).getFailedReason())) {
                this.handleEsignRemove(saleEsignV3OrgPsn.getOrgCode(), saleEsignV3OrgPsn.getPsnCode());
                rp = this.sendEsignAdd(saleEsignV3OrgPsn, personal.getPsnName());
                if (!rp.getAddedMembers().contains(personal.getPsnId()) && CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                    throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
                }
            } else {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)((Object)(orgPsn = (SaleEsignV3OrgPsn)((Object)((SaleEsignV3OrgPsnMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3OrgPsn::getPsnId, (Object)saleEsignV3OrgPsn.getPsnId())).eq(SaleEsignV3OrgPsn::getOrgCode, (Object)saleEsignV3OrgPsn.getOrgCode())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getDeleted, (Object)"0"))))))) {
            orgPsn.setRole(saleEsignV3OrgPsn.getRole());
            ((SaleEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)orgPsn);
        } else {
            ((SaleEsignV3OrgPsnMapper)this.baseMapper).insert((Object)saleEsignV3OrgPsn);
        }
    }

    public OrgPsnAdminRp sendEsignAdd(SaleEsignV3OrgPsn saleEsignV3OrgPsn, String psnName) {
        OrgPsnAdminRq.Members members = new OrgPsnAdminRq.Members();
        members.setPsnId(saleEsignV3OrgPsn.getPsnCode());
        members.setMemberName(psnName);
        members.setRole(saleEsignV3OrgPsn.getRole());
        OrgPsnAdminRq orgPsnAdminRq = OrgPsnAdminRq.builder().base(new OrgPsnAdminRq.Base(saleEsignV3OrgPsn.getOrgCode())).body(new OrgPsnAdminRq.Body(Arrays.asList(members))).build();
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnAdminRq, "e3-org-psn-add", OrgPsnAdminRp.class);
        return rp;
    }

    @Override
    public void edit(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        int count = ((SaleEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)saleEsignV3OrgPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3OrgPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<SaleV3OrgPsnVo> pageVo(Page<SaleV3OrgPsnVo> page, String orgId, boolean notAdmin, String sealId) {
        return ((SaleEsignV3OrgPsnMapper)this.baseMapper).pageVo(page, orgId, notAdmin, sealId);
    }

    @Override
    @SrmTransaction
    public void removeStaff(SaleEsignV3OrgPsn saleEsignV3OrgPsn) {
        SaleEsignV3OrgPsn pev = (SaleEsignV3OrgPsn)((Object)this.getById((Serializable)((Object)saleEsignV3OrgPsn.getId())));
        this.handleEsignRemove(pev.getOrgCode(), pev.getPsnCode());
        this.removeById((Serializable)((Object)pev.getId()));
    }

    public void handleEsignRemove(String orgCode, String psnCode) {
        OrgPsnRemoveRq orgPsnRemoveRq = new OrgPsnRemoveRq();
        orgPsnRemoveRq.getBase().setOrgId(orgCode);
        orgPsnRemoveRq.getBase().setMemberPsnIds(psnCode);
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnRemoveRq, "e3-org-psn-remove", OrgPsnAdminRp.class);
        if (!rp.getDeletedMembers().contains(psnCode)) {
            if (CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_EPsyVIHVKHRvj_d3e483a9", (String)"E\u7b7e\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
    }
}

