/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.electronsign.fadada.dto.FadadaGetOrgAuthUrlDTO;
import com.els.modules.electronsign.fadada.entity.SaleFadadaOrg;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealPsnMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.service.SaleFadadaOrgService;
import com.els.modules.electronsign.fadada.service.SaleFadadaSealService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaOrgServiceImpl
extends BaseServiceImpl<SaleFadadaOrgMapper, SaleFadadaOrg>
implements SaleFadadaOrgService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private SaleFadadaOrgPsnMapper saleFadadaOrgPsnMapper;
    @Autowired
    private SaleFadadaSealMapper saleFadadaSealMapper;
    @Autowired
    private SaleFadadaSealPsnMapper saleFadadaSealPsnMapper;
    @Autowired
    private SaleFadadaOrgPsnService saleFadadaOrgPsnService;
    @Autowired
    private SaleFadadaSealService saleFadadaSealService;

    @Override
    public void add(SaleFadadaOrg saleFadadaOrg) {
        this.handleOrgCode(saleFadadaOrg);
        this.saveFlag(saleFadadaOrg);
        ((SaleFadadaOrgMapper)this.baseMapper).insert((Object)saleFadadaOrg);
    }

    public SaleFadadaOrg handleOrgCode(SaleFadadaOrg saleFadadaOrg) {
        saleFadadaOrg.setCorpNonEditableInfo("corpName,corpIdentType,corpIdentNo");
        if ("1".equals(saleFadadaOrg.getLoadingOrg())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", saleFadadaOrg.getOrgCode());
            Assert.isTrue((boolean)true, (String)I18nUtil.translate((String)"i18n_alert_RCIH_264a3c82", (String)"\u516c\u53f8\u5f02\u5e38"));
            if (organizationInfo != null) {
                saleFadadaOrg.setCorpName(organizationInfo.getOrgName());
            }
        }
        saleFadadaOrg.setClientCorpId(saleFadadaOrg.getCorpIdentNo());
        return saleFadadaOrg;
    }

    public void saveFlag(SaleFadadaOrg saleFadadaOrg) {
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"corp_name", (Object)saleFadadaOrg.getCorpName());
        saleFadadaOrgQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrg.getBusAccount());
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (this.getOne((Wrapper)saleFadadaOrgQueryWrapper) != null) {
            throw new ELSBootException("\u673a\u6784\u3010" + saleFadadaOrg.getCorpName() + "\u3011\u5df2\u88ab\u521b\u5efa\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
    }

    @Override
    public void edit(SaleFadadaOrg saleFadadaOrg) {
        this.handleOrgCode(saleFadadaOrg);
        this.editFlag(saleFadadaOrg);
        int count = ((SaleFadadaOrgMapper)this.baseMapper).updateById((Object)saleFadadaOrg);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editFlag(SaleFadadaOrg saleFadadaOrg) {
        QueryWrapper saleFadadaOrgQueryWrapper = new QueryWrapper();
        saleFadadaOrgQueryWrapper.eq((Object)"corp_name", (Object)saleFadadaOrg.getCorpName());
        saleFadadaOrgQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaOrg.getBusAccount());
        saleFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        SaleFadadaOrg fadadaOrg = (SaleFadadaOrg)((Object)this.getOne((Wrapper)saleFadadaOrgQueryWrapper));
        if (fadadaOrg != null && !fadadaOrg.getId().equals(saleFadadaOrg.getId())) {
            throw new ELSBootException(saleFadadaOrg.getCorpName() + "\u5df2\u88ab\u521b\u5efa\uff0c\u53ef\u6362\u5176\u4ed6\u673a\u6784");
        }
    }

    @Override
    public void delete(String id) {
        ((SaleFadadaOrgMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleFadadaOrgMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(SaleFadadaOrg saleFadadaOrg) {
        if (StringUtils.isBlank((CharSequence)saleFadadaOrg.getId())) {
            this.add(saleFadadaOrg);
        } else {
            this.edit(saleFadadaOrg);
        }
        String redirectUrl = this.fadadaCallUtil.getRedirectUrl();
        FadadaGetOrgAuthUrlDTO fadadaGetOrgAuthUrlDTO = new FadadaGetOrgAuthUrlDTO(saleFadadaOrg, redirectUrl);
        String requestStr = JSONObject.toJSONString((Object)fadadaGetOrgAuthUrlDTO);
        JSONObject requestObject = JSONObject.parseObject((String)requestStr);
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_url");
        if ("210002".equals(response.getString("code"))) {
            saleFadadaOrg.setAuthFailedReason("exist");
            this.getAuthInfo(saleFadadaOrg);
        } else {
            saleFadadaOrg.setAuthUrl(response.getString("authUrl"));
            ((SaleFadadaOrgMapper)this.baseMapper).updateById((Object)saleFadadaOrg);
        }
    }

    @Override
    public void getAuthInfo(SaleFadadaOrg saleFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("corpIdentNo", (Object)saleFadadaOrg.getCorpIdentNo());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject authInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_info");
        saleFadadaOrg.setAvailableStatus(authInfo.getString("availableStatus"));
        saleFadadaOrg.setRealnameStatus(authInfo.getString("identStatus"));
        saleFadadaOrg.setAuthResult(authInfo.getString("bindingStatus"));
        saleFadadaOrg.setOpenCorpId(authInfo.getString("openCorpId"));
        requestObject = new JSONObject();
        requestObject.put("openCorpId", (Object)saleFadadaOrg.getOpenCorpId());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject identInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_ident_info");
        if ("legal_rep".equals(identInfo.getString("corpIdentMethod"))) {
            saleFadadaOrg.setCorpIdentMethod("legalRep");
        } else {
            saleFadadaOrg.setCorpIdentMethod(identInfo.getString("corpIdentMethod"));
        }
        JSONObject corpIdentInfo = identInfo.getJSONObject("corpIdentInfo");
        saleFadadaOrg.setCorpName(corpIdentInfo.getString("corpName"));
        saleFadadaOrg.setCorpIdentType(corpIdentInfo.getString("corpIdentType"));
        saleFadadaOrg.setCorpIdentNo(corpIdentInfo.getString("corpIdentNo"));
        saleFadadaOrg.setLegalRepName(corpIdentInfo.getString("legalRepName"));
        JSONObject corpIdentInfoExtend = identInfo.getJSONObject("corpIdentInfoExtend");
        saleFadadaOrg.setBankAccountNo(corpIdentInfoExtend.getString("bankAccountNo"));
        saleFadadaOrg.setAuthFailedReason("");
        saleFadadaOrg.setAuthTime(saleFadadaOrg.getAuthTime() + 1);
        this.updateById((Object)saleFadadaOrg);
        this.saleFadadaOrgPsnService.refreshOrgPsnList(saleFadadaOrg.getId());
        this.saleFadadaSealService.refreshSealList(saleFadadaOrg.getId());
    }

    @Override
    public void updateAuthStatus(SaleFadadaOrg saleFadadaOrg) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("corpIdentNo", (Object)saleFadadaOrg.getCorpIdentNo());
        requestObject.put("currentAccount", (Object)saleFadadaOrg.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_org_auth_info");
        saleFadadaOrg.setAvailableStatus(response.getString("availableStatus"));
        saleFadadaOrg.setRealnameStatus(response.getString("identStatus"));
        saleFadadaOrg.setAuthResult(response.getString("bindingStatus"));
        saleFadadaOrg.setClientCorpId(response.getString("clientCorpId"));
        saleFadadaOrg.setOpenCorpId(response.getString("openCorpId"));
        this.updateById((Object)saleFadadaOrg);
    }
}

