/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.electronsign.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.order.api.enumerate.OrderEsignStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ESignUtil {
    private static final Logger log = LoggerFactory.getLogger(ESignUtil.class);
    @Resource
    private EsignInvokeOrderRpcService orderRpcService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private SaleContractHeadService saleContractHeadService;

    public void handleBusType(String busType, String relationId, String signStatus, CLBusTypeEnum type, String signType) {
        switch (busType) {
            case "contract": {
                this.handleContractStatus(relationId, signStatus, type, signType);
                break;
            }
            case "order": {
                this.handleOrderStatus(relationId, type, signType);
                break;
            }
        }
    }

    private void handleContractStatus(String relationId, String signStatus, CLBusTypeEnum type, String signType) {
        PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)relationId)));
        if (contractHead != null) {
            if ("1".equals(contractHead.getStartSign()) && CLBusTypeEnum.isAdd(type)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            contractHead.setEndSign(signStatus);
            if (CLBusTypeEnum.isAdd(type)) {
                contractHead.setStartSign("1");
                contractHead.setSignType(signType);
            }
            if (CLBusTypeEnum.isFINISH(type)) {
                contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
            }
            if (CLBusTypeEnum.isReturn(type)) {
                contractHead.setStartSign("0");
                contractHead.setEndSign("");
            }
            this.purchaseContractHeadService.updateById((Object)contractHead);
            SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getById((Serializable)((Object)contractHead.getRelationId())));
            if (saleContractHead != null) {
                saleContractHead.setEndSign(contractHead.getEndSign());
                if (CLBusTypeEnum.isAdd(type)) {
                    saleContractHead.setStartSign("1");
                }
                if (CLBusTypeEnum.isFINISH(type)) {
                    saleContractHead.setContractStatus(contractHead.getContractStatus());
                }
                this.saleContractHeadService.updateById((Object)saleContractHead);
            }
        }
    }

    private void handleOrderStatus(String relationId, CLBusTypeEnum type, String singType) {
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderRpcService.getPurchaseOrderById(relationId);
        if (purchaseOrderHeadDTO != null) {
            if (CLBusTypeEnum.isAdd(type) && (OrderEsignStatusEnum.START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()) || OrderEsignStatusEnum.CHANGED_START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()))) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.START_END.getValue() : OrderEsignStatusEnum.CHANGED_START_END.getValue());
                purchaseOrderHeadDTO.setSignType(singType);
            }
            if (CLBusTypeEnum.isReturn(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.NO_START.getValue() : OrderEsignStatusEnum.CHANGED_NO_START.getValue());
            }
        }
        if (CLBusTypeEnum.isFINISH(type)) {
            purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
            this.orderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
        }
        this.orderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
    }

    public String getOnlineSealed(String busType, String toElsAccount) {
        List list = this.baseRpcService.getCompanySetList(toElsAccount);
        JSONObject object = this.getObjBySet(list);
        if (object == null || StringUtils.isBlank((CharSequence)object.getString("electronicSignature"))) {
            return "0";
        }
        List<String> rules = Arrays.asList(object.getString("electronicSignature").split(","));
        return rules.contains(busType) ? "1" : "0";
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }

    public static boolean matchingMobilePhones(String var1, String var2) {
        Pattern pattern = Pattern.compile("^(.{3}).*(.{4})$");
        Matcher matcher = pattern.matcher(var1);
        Matcher matcher2 = pattern.matcher(var2);
        if (matcher.matches() && matcher2.matches()) {
            String firstThree = matcher.group(1);
            String firstThree2 = matcher2.group(1);
            String lastFour = matcher.group(2);
            String lastFour2 = matcher2.group(2);
            if (StrUtil.equals((CharSequence)firstThree, (CharSequence)firstThree2) && StrUtil.equals((CharSequence)lastFour, (CharSequence)lastFour2)) {
                return true;
            }
        }
        return false;
    }

    public static boolean matchingEmail(String var1, String var2) {
        String firstVar1 = var1.substring(0, 1);
        String firstVar2 = var2.substring(0, 1);
        String endVar = var1.substring(var1.lastIndexOf("@") - 1);
        String endVar2 = var1.substring(var2.lastIndexOf("@") - 1);
        return StrUtil.equals((CharSequence)firstVar1, (CharSequence)firstVar2) && StrUtil.equals((CharSequence)endVar, (CharSequence)endVar2);
    }

    public static void main(String[] args) {
        String var1 = "chenan@51qq.com";
        String firstVar1 = var1.substring(0, 1);
        String firstVar2 = var1.substring(var1.lastIndexOf("@") - 1);
        System.out.println(firstVar1);
        System.out.println(firstVar2);
    }
}

