/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.electronsign.esign.entity.ElsEsign;
import com.els.modules.electronsign.esign.entity.ElsSigners;
import com.els.modules.electronsign.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.electronsign.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.electronsign.esign.enumerate.EsignStatusEmun;
import com.els.modules.electronsign.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.electronsign.esign.enums.ModifyPersonEnum;
import com.els.modules.electronsign.esign.mapper.ElsEsignMapper;
import com.els.modules.electronsign.esign.mapper.ElsSignersMapper;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeFinanceRpcService;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.electronsign.esign.service.ElsEsignService;
import com.els.modules.electronsign.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.electronsign.esign.util.EsignResultAnalysisUtil;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.order.api.enumerate.OrderEsignStatusEnum;
import com.els.modules.reconciliation.api.dto.ReconciliationConfirmationDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsEsignServiceImpl
extends BaseServiceImpl<ElsEsignMapper, ElsEsign>
implements ElsEsignService {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Resource
    private ElsEsignMapper elsEsignMapper;
    @Resource
    private ElsSignersMapper elsSignersMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private EsignInvokeOrderRpcService esignInvokeOrderRpcService;
    @Resource
    private EsignInvokeFinanceRpcService esignInvokeFinanceRpcService;
    @Autowired
    private ElsSubaccountCertificationInfoService subaccountCertificationInfoService;
    @Autowired
    private ESignUtil eSignUtil;
    @Resource
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private SaleContractHeadService saleContractHeadService;
    @Resource
    private InvokeAccountRpcService accountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsEsign elsEsign, List<ElsSigners> purchaseSignersList, List<ElsSigners> saleSignersList) {
        ReconciliationConfirmationDTO confirmation;
        ElsEnterpriseInfoDTO enterpriseInfo;
        elsEsign.setBusAccount("100000");
        elsEsign.setDeleted(CommonConstant.DEL_FLAG_0);
        elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        elsEsign.setAutoArchiving("1");
        elsEsign.setAutoInitiate("1");
        if (StringUtils.isBlank((CharSequence)elsEsign.getPurchaseName()) && (enterpriseInfo = this.accountRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            elsEsign.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)elsEsign.getSupplierName()) && (enterpriseInfo = this.accountRpcService.getByElsAccount(elsEsign.getToElsAccount())) != null) {
            elsEsign.setSupplierName(enterpriseInfo.getName());
        }
        elsEsign.setOnlineSealed(this.eSignUtil.getOnlineSealed(elsEsign.getBusType(), elsEsign.getToElsAccount()));
        this.elsEsignMapper.insert((Object)elsEsign);
        if (EsignBusTypeEnum.CONTRACT.getValue().equals(elsEsign.getBusType())) {
            PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)elsEsign.getRelationId())));
            if (contractHead != null) {
                if ("1".equals(contractHead.getStartSign())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
                }
                contractHead.setStartSign("1");
                this.purchaseContractHeadService.updateById((Object)contractHead);
                SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getById((Serializable)((Object)contractHead.getRelationId())));
                if (saleContractHead != null) {
                    saleContractHead.setStartSign("1");
                    this.saleContractHeadService.updateById((Object)saleContractHead);
                }
            }
        } else if (EsignBusTypeEnum.ORDER.getValue().equals(elsEsign.getBusType())) {
            PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(elsEsign.getRelationId());
            if (purchaseOrderHeadDTO != null) {
                if (OrderEsignStatusEnum.START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()) || OrderEsignStatusEnum.CHANGED_START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
                }
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.START_END.getValue() : OrderEsignStatusEnum.CHANGED_START_END.getValue());
                this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
            }
        } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(elsEsign.getBusType()) && (confirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(elsEsign.getRelationId())) != null) {
            ReconciliationConfirmationDTO saleConfirmation;
            if (ConfirmEsignStatusEnum.START_END.getValue().equals(confirmation.getSignStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            confirmation.setSignStatus(ConfirmEsignStatusEnum.START_END.getValue());
            confirmation.setSignInitiate("1");
            this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(confirmation);
            if (!StringUtils.isEmpty((CharSequence)confirmation.getRelationId()) && (saleConfirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(confirmation.getRelationId())) != null) {
                saleConfirmation.setSignStatus(ConfirmEsignStatusEnum.START_END.getValue());
                saleConfirmation.setSignInitiate("1");
                this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(saleConfirmation);
            }
        }
        this.insertData(elsEsign, purchaseSignersList, saleSignersList, null);
    }

    private void check(List<ElsSigners> signers) {
        if (CollUtil.isNotEmpty(signers)) {
            signers.forEach(row -> {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)row.getAutoArchive())) {
                    ElsSubaccountCertificationInfo info = (ElsSubaccountCertificationInfo)((Object)((Object)this.subaccountCertificationInfoService.getOne((Wrapper)Wrappers.lambdaQuery().eq(ElsSubaccountCertificationInfo::getAccountId, (Object)row.getAccountId()))));
                    Assert.notNull((Object)((Object)info), (String)I18nUtil.translate((String)"i18n_alert_PWLIH_75ce77c", (String)"\u7b7e\u7f72\u4eba\u5f02\u5e38"));
                    Assert.isTrue(("1".equals(info.getSilentAuthStatus()) && "1".equals(info.getCertificationStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_JOWePWLlTjILinIOClb_b4463c13", (String)"\u81ea\u52a8\u843d\u7ae0\u7b7e\u7f72\u4eba\u5fc5\u987b\u5f97\u5df2\u8ba4\u8bc1\u548c\u5df2\u9759\u9ed8\u6388\u6743"));
                    Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)row.getSignArea()), (String)I18nUtil.translate((String)"i18n_alert_JOWePWLlTGRPWMU_733e304", (String)"\u81ea\u52a8\u843d\u7ae0\u7b7e\u7f72\u4eba\u5fc5\u987b\u8bbe\u7f6e\u7b7e\u7f72\u533a\u57df"));
                }
            });
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsEsign elsEsign, List<ElsSigners> purchaseSignersList, List<ElsSigners> saleSignersList, List<SaleAttachmentDTO> attachments) {
        this.check(purchaseSignersList);
        this.check(saleSignersList);
        if (!"1".equals(elsEsign.getAutoInitiate())) {
            elsEsign.setInitiate("0");
        }
        if (!"1".equals(elsEsign.getAutoArchiving())) {
            elsEsign.setArchiving("0");
        }
        this.elsEsignMapper.updateById((Object)elsEsign);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)elsEsign.getId());
        wrapper.eq((Object)"role_type", (Object)elsEsign.getModifyPerson());
        this.elsSignersMapper.delete((Wrapper)wrapper);
        this.insertData(elsEsign, purchaseSignersList, saleSignersList, attachments);
        if ("1".equals(elsEsign.getSendStatus())) {
            this.sendMsg(elsEsign);
        }
    }

    private void sendMsg(ElsEsign elsEsign) {
        if (StringUtils.isEmpty((CharSequence)elsEsign.getOperateType())) {
            return;
        }
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(elsEsign.getToElsAccount());
        String url = "id=" + elsEsign.getId();
        ModifyPersonEnum modifyPersonEnum = ModifyPersonEnum.get(elsEsign.getModifyPerson());
        if (modifyPersonEnum == null) {
            return;
        }
        String elsAccount = elsEsign.getElsAccount();
        String operateType = "publish";
        if (ModifyPersonEnum.SUPPLIER.equals((Object)modifyPersonEnum)) {
            toElsAccountList.clear();
            toElsAccountList.add(elsEsign.getElsAccount());
            elsAccount = elsEsign.getToElsAccount();
            operateType = "supplierEsignPublish";
        }
        super.sendMessage(elsAccount, "esign", operateType, elsEsign.getId(), "esignBusDataServiceImpl", toElsAccountList);
    }

    private void insertData(ElsEsign elsEsign, List<ElsSigners> purchaseSignersList, List<ElsSigners> saleSignersList, List<SaleAttachmentDTO> attachments) {
        boolean purchaseFlag = false;
        boolean saleFlag = false;
        if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsEsign.getModifyPerson())) {
            if (purchaseSignersList != null) {
                for (ElsSigners entity : purchaseSignersList) {
                    entity.setId(null);
                    entity.setHeadId(elsEsign.getId());
                    entity.setFilesId(elsEsign.getFilesId());
                    entity.setFilesName(elsEsign.getFilesName());
                    entity.setFlowId(elsEsign.getFlowId());
                    entity.setRoleType("0");
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEsign);
                }
                if (!purchaseSignersList.isEmpty()) {
                    this.elsSignersMapper.insertBatchSomeColumn(purchaseSignersList);
                    purchaseFlag = true;
                }
            }
            if (saleSignersList != null && saleSignersList.size() > 0) {
                saleFlag = true;
            }
        } else {
            if (saleSignersList != null) {
                for (ElsSigners entity : saleSignersList) {
                    entity.setId(null);
                    entity.setHeadId(elsEsign.getId());
                    entity.setFilesId(elsEsign.getFilesId());
                    entity.setFilesName(elsEsign.getFilesName());
                    entity.setRoleType("1");
                    entity.setFlowId(elsEsign.getFlowId());
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEsign);
                }
                if (!saleSignersList.isEmpty()) {
                    this.elsSignersMapper.insertBatchSomeColumn(saleSignersList);
                    saleFlag = true;
                }
            }
            if (purchaseSignersList != null && purchaseSignersList.size() > 0) {
                purchaseFlag = true;
            }
        }
        if (attachments != null) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(elsEsign.getId());
            for (SaleAttachmentDTO saleAttachment : attachments) {
                PurchaseAttachmentDTO attachment = (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)saleAttachment, PurchaseAttachmentDTO.class);
                attachment.setElsAccount(elsEsign.getElsAccount());
                attachment.setHeadId(elsEsign.getId());
                attachment.setRelationId(saleAttachment.getId());
                this.invokeBaseRpcService.insertPurchaseAttachment(attachment);
                saleAttachment.setRelationId(attachment.getId());
                saleAttachment.setSendStatus("1");
                this.invokeBaseRpcService.updateSaleAttachment(saleAttachment);
            }
        }
        if ("1".equals(elsEsign.getOnlineSealed())) {
            if (!purchaseFlag && !saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
            } else if (purchaseFlag && saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            } else if (!purchaseFlag && saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            } else if (purchaseFlag && !saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
            }
        } else {
            if (!purchaseFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            } else if (purchaseFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            }
            if (!EsignRoleTypeEnum.PURCHASE.getValue().equals(elsEsign.getModifyPerson())) {
                elsEsign.setSaleEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
            }
        }
        this.elsEsignMapper.updateById((Object)elsEsign);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsSignersMapper.deleteByMainId(id);
        this.elsEsignMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsSignersMapper.deleteByMainId(serializable.toString());
            this.elsEsignMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> sendBack(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            ReconciliationConfirmationDTO confirmation;
            if ("1".equals(esign.getLaunch())) {
                return Result.ok((String)I18nUtil.translate((String)"i18n_alert_PWQLIhAWShYM_a3d2ed05", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de"));
            }
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)esign.getRelationId())));
                if (contractHead != null) {
                    contractHead.setStartSign("0");
                    this.purchaseContractHeadService.updateById((Object)contractHead);
                    SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getById((Serializable)((Object)contractHead.getRelationId())));
                    if (saleContractHead != null) {
                        saleContractHead.setStartSign(contractHead.getStartSign());
                        this.saleContractHeadService.updateById((Object)saleContractHead);
                    }
                }
            } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType())) {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId());
                if (purchaseOrderHeadDTO != null) {
                    purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.NO_START.getValue() : OrderEsignStatusEnum.CHANGED_NO_START.getValue());
                    this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
                }
            } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType()) && (confirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(esign.getRelationId())) != null) {
                ReconciliationConfirmationDTO saleConfirmation;
                confirmation.setSignStatus(ConfirmEsignStatusEnum.BACK.getValue());
                confirmation.setSignInitiate("0");
                this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(confirmation);
                if (!StringUtils.isEmpty((CharSequence)confirmation.getRelationId()) && (saleConfirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(confirmation.getRelationId())) != null) {
                    saleConfirmation.setSignStatus(ConfirmEsignStatusEnum.BACK.getValue());
                    saleConfirmation.setSignInitiate("0");
                    this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(saleConfirmation);
                }
            }
        } else {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
        }
        esign.setSendBack("1");
        this.updateById((Object)esign);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_YMLR_42c7b9ed", (String)"\u9000\u56de\u6210\u529f"));
    }

    @Override
    public Result<?> backout(String id, String reason) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            PurchaseContractHead contractHead;
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject body = new JSONObject();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)esign.getId());
            wrapper.eq((Object)"role_type", (Object)"0");
            List purhcaseSigners = this.elsSignersMapper.selectList((Wrapper)wrapper);
            if (purhcaseSigners != null) {
                body.put("operatorId", (Object)((ElsSigners)((Object)purhcaseSigners.get(0))).getAccountId());
            }
            body.put("revokeReason", (Object)reason);
            requestJSON.put("body", (Object)body);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-backout"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_qXKmW_cf51a52a", (String)"\u64a4\u9500\u5931\u8d25:") + response.getMessage()));
            }
            esign.setEsignStatus(EsignStatusEmun.UNDONE.getValue());
            if (!"1".equals(esign.getAutoInitiate())) {
                esign.setInitiate("0");
            }
            esign.setPurchaseEsignStatus(EsignSignerStatusEmun.UNDONE.getValue());
            esign.setArchiving("0");
            esign.setSaleEsignStatus(EsignSignerStatusEmun.UNDONE.getValue());
            esign.setReason(reason);
            this.updateById((Object)esign);
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType()) && (contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)esign.getRelationId())))) != null) {
                contractHead.setEndSign(esign.getEsignStatus());
                this.purchaseContractHeadService.updateById((Object)contractHead);
                SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getById((Serializable)((Object)contractHead.getRelationId())));
                if (saleContractHead != null) {
                    saleContractHead.setEndSign(contractHead.getEndSign());
                    this.saleContractHeadService.updateById((Object)saleContractHead);
                }
            }
        } else {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_qXLR_2ffb306b", (String)"\u64a4\u9500\u6210\u529f"));
    }

    @Override
    public Result<?> signFileDownload(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-file-download"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLQAIKKySMKmW_255987a8", (String)"\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:") + response.getMessage()));
            }
            JSONObject object = (JSONObject)response.getResult();
            return Result.ok((Object)object.getJSONArray("docs"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }

    @Override
    public Result<?> viewEsignFile(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("fileId", (Object)esign.getFilesId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("view-pdf-file-detail"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_oPWQIKySMKmW_f379e718", (String)"\u5f85\u7b7e\u7f72\u6587\u4ef6\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:") + response.getMessage()));
            }
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }

    @Override
    public Result<?> busSignFileDownload(String id, String busType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"relation_id", (Object)id);
        wrapper.eq((Object)"bus_type", (Object)busType);
        wrapper.eq((Object)"is_archiving", (Object)"1");
        wrapper.eq((Object)"is_send_back", (Object)"0");
        wrapper.eq((Object)"is_deleted", (Object)"0");
        List esigns = this.list((Wrapper)wrapper);
        if (!esigns.isEmpty()) {
            return this.signFileDownload(((ElsEsign)((Object)esigns.get(0))).getId());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_PeQLxMKSIQG_286d25f1", (String)"\u7b7e\u7ae0\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664"));
    }

    @Override
    public Result<?> flowQuery(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("query-esign-flow"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_PWQLmhKmW_8344aceb", (String)"\u7b7e\u7f72\u6d41\u7a0b\u67e5\u8be2\u5931\u8d25:") + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("flowStatus");
            if (EsignStatusEmun.FINISHED.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
                if ("1".equals(esign.getAutoArchiving())) {
                    PurchaseOrderHeadDTO purchaseOrderHeadDTO;
                    esign.setArchiving("1");
                    if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                        PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)esign.getRelationId())));
                        if (contractHead != null) {
                            contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                            this.purchaseContractHeadService.updateById((Object)contractHead);
                            SaleContractHead saleContractHead = (SaleContractHead)((Object)this.saleContractHeadService.getById((Serializable)((Object)contractHead.getRelationId())));
                            if (saleContractHead != null) {
                                saleContractHead.setContractStatus(contractHead.getContractStatus());
                                this.saleContractHeadService.updateById((Object)saleContractHead);
                            }
                        }
                    } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && (purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId())) != null) {
                        purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
                        this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
                        this.esignInvokeOrderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
                    }
                    this.handleConfirmStatus(esign, ConfirmEsignStatusEnum.ARCHIVED.getValue(), ConfirmElectronicSignStatusEmun.FINISH.getValue());
                } else {
                    this.handleConfirmStatus(esign, ConfirmEsignStatusEnum.FINISH.getValue(), ConfirmElectronicSignStatusEmun.FINISH.getValue());
                }
            }
            if (EsignStatusEmun.EXPIRED.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.EXPIRED.getValue());
                this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.EXPIRED.getValue());
            }
            if (EsignStatusEmun.REFUSAL.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.REFUSAL.getValue());
                this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.REFUSAL.getValue());
            }
            ((ElsEsignMapper)this.baseMapper).updateById((Object)esign);
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }

    @Override
    public JSONObject getDataById(String id) {
        ElsEsign elsEsign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)elsEsign));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private void handleConfirmStatus(ElsEsign esign, String signStatus, String electronicSignStatus) {
        if (!EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType())) {
            return;
        }
        ReconciliationConfirmationDTO confirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(esign.getRelationId());
        if (confirmation == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)signStatus)) {
            confirmation.setSignStatus(signStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
            confirmation.setElectronicSignStatus(electronicSignStatus);
        }
        this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(confirmation);
        if (StringUtils.isEmpty((CharSequence)confirmation.getRelationId())) {
            return;
        }
        ReconciliationConfirmationDTO saleConfirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(confirmation.getRelationId());
        if (saleConfirmation == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)signStatus)) {
            saleConfirmation.setSignStatus(signStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
            saleConfirmation.setElectronicSignStatus(electronicSignStatus);
        }
        this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(saleConfirmation);
    }
}

