/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.xwpf.converter.core.FileImageExtractor;
import org.apache.poi.xwpf.converter.core.FileURIResolver;
import org.apache.poi.xwpf.converter.core.IImageExtractor;
import org.apache.poi.xwpf.converter.core.IURIResolver;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.xhtml.XHTMLConverter;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class WordToHtmlUtil {
    private static WordToHtmlUtil instance = new WordToHtmlUtil();
    private static final Logger logger = LoggerFactory.getLogger(WordToHtmlUtil.class);

    private WordToHtmlUtil() {
    }

    public static WordToHtmlUtil getInstance() {
        return instance;
    }

    public String word2007ToHtml(File file) {
        FileInputStream inStream = null;
        XWPFDocument document = null;
        try {
            inStream = new FileInputStream(file);
            document = new XWPFDocument((InputStream)inStream);
            File imgPath = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)));
            XHTMLOptions options = XHTMLOptions.create().URIResolver((IURIResolver)new FileURIResolver(imgPath)).setIgnoreStylesIfUnused(true);
            options.setExtractor((IImageExtractor)new FileImageExtractor(imgPath));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XHTMLConverter.getInstance().convert(document, (OutputStream)outStream, (Options)options);
            String content = new String(outStream.toByteArray(), "UTF-8");
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
            if (outStream != null) {
                outStream.close();
            }
            String string = this.doFilter(content);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
                if (document != null) {
                    document.close();
                }
            }
            catch (Exception e) {
                logger.error("IOException close error!", (Throwable)e);
            }
        }
    }

    public String word2003ToHtml(File file) {
        FileInputStream istream = null;
        HWPFDocument document = null;
        try {
            istream = new FileInputStream(file);
            document = new HWPFDocument((InputStream)istream);
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                    return suggestedName;
                }
            });
            wordToHtmlConverter.processDocument((HWPFDocumentCore)document);
            List pictures = document.getPicturesTable().getAllPictures();
            if (pictures != null && pictures.size() > 0) {
                String imgPath = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)) + File.separator + "word" + File.separator + "media" + File.separator;
                File imgPathFile = new File(imgPath);
                if (!imgPathFile.exists()) {
                    imgPathFile.mkdirs();
                }
                for (Picture pic : pictures) {
                    pic.writeImageContent((OutputStream)new FileOutputStream(imgPath + File.separator + pic.suggestFullFileName()));
                }
            }
            Document htmlDocument = wordToHtmlConverter.getDocument();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource domSource = new DOMSource(htmlDocument);
            StreamResult streamResult = new StreamResult(outputStream);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            serializer.transform(domSource, streamResult);
            String content = new String(outputStream.toByteArray());
            if (istream != null) {
                ((InputStream)istream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            String string = this.doFilter(content);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (istream != null) {
                    ((InputStream)istream).close();
                }
                if (document != null) {
                    document.close();
                }
            }
            catch (Exception e) {
                logger.error("IOException close error!", (Throwable)e);
            }
        }
    }

    public String doFilter(String content) {
        String regex = "\\$\\{.*?\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        while (m.find()) {
            String dist = this.delHTMLTag(m.group());
            if ("${}".equalsIgnoreCase(dist)) {
                dist = "${r'${}'}";
            }
            content = content.replace(m.group(), dist);
        }
        return content;
    }

    public String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }
}

