/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.BigDecimalUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.bidding.api.dto.PurchaseBiddingItemDTO;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.ContractItemCustom2;
import com.els.modules.contract.entity.ContractItemCustom3;
import com.els.modules.contract.entity.ContractItemCustom4;
import com.els.modules.contract.entity.ContractItemCustom5;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractContentItemHis;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractHeadHis;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.PurchaseContractItemHis;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.entity.SaleContractContentItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.enumerate.ContractCalculatePrecedenceEnum;
import com.els.modules.contract.enumerate.ContractItemSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractPromiseSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.mapper.ContractItemCustom1Mapper;
import com.els.modules.contract.mapper.ContractItemCustom2Mapper;
import com.els.modules.contract.mapper.ContractItemCustom3Mapper;
import com.els.modules.contract.mapper.ContractItemCustom4Mapper;
import com.els.modules.contract.mapper.ContractItemCustom5Mapper;
import com.els.modules.contract.mapper.PurchaseContractContentItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractContentItemMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadHisMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractItemHisMapper;
import com.els.modules.contract.mapper.PurchaseContractItemMapper;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.mapper.SaleContractContentItemMapper;
import com.els.modules.contract.mapper.SaleContractHeadMapper;
import com.els.modules.contract.mapper.SaleContractItemMapper;
import com.els.modules.contract.rpc.service.ContractInvokeInquiryRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeOrderRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeSupplierRpcService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.vo.PurchaseContractHeadVO;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.ebidding.api.dto.PurchaseEbiddingHeadDTO;
import com.els.modules.ebidding.api.dto.PurchaseEbiddingItemDTO;
import com.els.modules.ebidding.api.dto.PurchaseEbiddingItemHisDTO;
import com.els.modules.enquiry.api.dto.PurchaseEnquiryItemDTO;
import com.els.modules.exchange.rpc.dto.BpExchangeRateDTO;
import com.els.modules.integrated.api.dto.IntegratedSerachConditionDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseContractHeadServiceImpl
extends BaseServiceImpl<PurchaseContractHeadMapper, PurchaseContractHead>
implements PurchaseContractHeadService {
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Resource
    private PurchaseContractItemMapper purchaseContractItemMapper;
    @Resource
    private PurchaseContractContentItemMapper purchaseContractContentItemMapper;
    @Resource
    private PurchaseContractHeadHisMapper purchaseContractHeadHisMapper;
    @Resource
    private PurchaseContractItemHisMapper purchaseContractItemHisMapper;
    @Resource
    private PurchaseContractContentItemHisMapper purchaseContractContentItemHisMapper;
    @Resource
    private SaleContractHeadMapper saleContractHeadMapper;
    @Resource
    private SaleContractItemMapper saleContractItemMapper;
    @Resource
    private SaleContractContentItemMapper saleContractContentItemMapper;
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Resource
    private ContractItemCustom1Mapper contractItemCustom1Mapper;
    @Resource
    private ContractItemCustom2Mapper contractItemCustom2Mapper;
    @Resource
    private ContractItemCustom3Mapper contractItemCustom3Mapper;
    @Resource
    private ContractItemCustom4Mapper contractItemCustom4Mapper;
    @Resource
    private ContractItemCustom5Mapper contractItemCustom5Mapper;
    @Autowired
    private ContractInvokeOrderRpcService contractInvokeOrderRpcService;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private ContractInvokeSupplierRpcService contractInvokeSupplierRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ContractInvokeInquiryRpcService contractInvokeInquiryRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        if (StrUtil.isBlank((CharSequence)purchaseContractHead.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractNumber", (Object)purchaseContractHead);
            purchaseContractHead.setContractNumber(nextCode);
        }
        if (null != purchaseContractHead.getExpiryDate() && null != purchaseContractHead.getEffectiveDate() && purchaseContractHead.getExpiryDate().before(purchaseContractHead.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_neKXBAxOQUnejXAKBA_a225d91b", (String)"\u5408\u540c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5408\u540c\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        purchaseContractHead.setBusAccount(TenantContext.getTenant());
        BigDecimal totalTaxAmount = purchaseContractHead.getTotalTaxAmount();
        BigDecimal totalNetAmount = purchaseContractHead.getTotalNetAmount();
        super.setHeadDefaultValue((BaseEntity)purchaseContractHead);
        purchaseContractHead.setTotalTaxAmount(totalTaxAmount);
        purchaseContractHead.setTotalNetAmount(totalNetAmount);
        this.calculateAmount(purchaseContractHead, purchaseContractItemList, contractItemCustom1List);
        if (StrUtil.isBlank((CharSequence)purchaseContractHead.getContractStatus())) {
            purchaseContractHead.setContractStatus(ContractStatusEnum.CONTRACT_NEW.getValue());
        }
        if (StrUtil.isBlank((CharSequence)purchaseContractHead.getContractVersion())) {
            purchaseContractHead.setContractVersion("1");
        }
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            List collectHeadID;
            List collect = purchaseContractItemList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getDocumentId())).map(PurchaseContractItem::getDocumentId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                String join = String.join((CharSequence)",", collect);
                purchaseContractHead.setDocumentId(join);
            }
            if (!CollectionUtils.isEmpty(collectHeadID = purchaseContractItemList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getSourceId())).map(PurchaseContractItem::getHeadId).distinct().collect(Collectors.toList()))) {
                purchaseContractHead.setDocumentParentId(String.join((CharSequence)",", collectHeadID));
            }
        }
        this.purchaseContractHeadMapper.insert((Object)purchaseContractHead);
        this.insertData(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
        this.sendLink(purchaseContractHead, purchaseContractItemList);
    }

    private void calculateAmount(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<ContractItemCustom1> contractItemCustom1List) {
        if (CollectionUtil.isNotEmpty(purchaseContractItemList)) {
            BigDecimal taxAmount = new BigDecimal(0L);
            BigDecimal netAmount = new BigDecimal(0L);
            BigDecimal targetQuantity = new BigDecimal(0L);
            for (PurchaseContractItem item : purchaseContractItemList) {
                BigDecimal temAmount;
                if (null != item.getPrice() && null != item.getQuantity()) {
                    temAmount = BigDecimal.ZERO;
                    temAmount = StrUtil.isNotBlank((CharSequence)item.getPriceUnit()) ? item.getPrice().divide(new BigDecimal(item.getPriceUnit())).multiply(item.getQuantity()).setScale(4, 4) : item.getPrice().multiply(item.getQuantity()).setScale(4, 4);
                    item.setTaxAmount(temAmount);
                    taxAmount = taxAmount.add(temAmount).setScale(4, 4);
                }
                if (null != item.getPrice() && null != item.getQuantity()) {
                    temAmount = null;
                    if (StrUtil.isNotBlank((CharSequence)item.getTaxRate())) {
                        BigDecimal tax = BigDecimal.valueOf(1.0 + Double.valueOf(item.getTaxRate()) / 100.0);
                        BigDecimal netPrice = item.getPrice().divide(tax, 6, 4);
                        temAmount = StrUtil.isNotBlank((CharSequence)item.getPriceUnit()) ? netPrice.divide(new BigDecimal(item.getPriceUnit())).multiply(item.getQuantity()).setScale(4, 4) : item.getTaxAmount().divide(tax, 6, 4);
                        item.setNetPrice(netPrice);
                        item.setNetAmount(temAmount);
                        netAmount = netAmount.add(temAmount).setScale(4, 4);
                    }
                }
                targetQuantity = purchaseContractItemList.parallelStream().filter(i -> i.getTargetQuantity() != null).map(PurchaseContractItem::getTargetQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            purchaseContractHead.setTotalNetAmount(netAmount.compareTo(BigDecimal.ZERO) == 0 ? purchaseContractHead.getTotalNetAmount() : netAmount);
            purchaseContractHead.setTotalTaxAmount(taxAmount.compareTo(BigDecimal.ZERO) == 0 ? purchaseContractHead.getTotalTaxAmount() : taxAmount);
            purchaseContractHead.setTargetQuantity(targetQuantity.toString());
        }
        if (CollectionUtil.isEmpty(purchaseContractItemList) && CollectionUtil.isNotEmpty(contractItemCustom1List)) {
            BigDecimal targetQuantity = new BigDecimal(0L);
            targetQuantity = contractItemCustom1List.parallelStream().filter(i -> i.getAmount() != null).map(ContractItemCustom1::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseContractHead.setTargetQuantity(targetQuantity.toString());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        int count;
        if (StrUtil.isBlank((CharSequence)purchaseContractHead.getContractNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractNumber", (Object)purchaseContractHead);
            purchaseContractHead.setContractNumber(nextCode);
        }
        this.calculateAmount(purchaseContractHead, purchaseContractItemList, contractItemCustom1List);
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            Object collectHeadID;
            List collect = purchaseContractItemList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getDocumentId())).map(PurchaseContractItem::getDocumentId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                String join = String.join((CharSequence)",", collect);
                purchaseContractHead.setDocumentId(join);
            }
            if (!CollectionUtils.isEmpty((Collection)(collectHeadID = purchaseContractItemList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getSourceId())).map(PurchaseContractItem::getHeadId).distinct().collect(Collectors.toList())))) {
                purchaseContractHead.setDocumentParentId(String.join((CharSequence)",", (Iterable<? extends CharSequence>)collectHeadID));
            }
        }
        if ((count = this.purchaseContractHeadMapper.updateById((Object)purchaseContractHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (null != purchaseContractHead.getExpiryDate() && null != purchaseContractHead.getEffectiveDate() && purchaseContractHead.getExpiryDate().before(purchaseContractHead.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_neKXBAxOQUnejXAKBA_a225d91b", (String)"\u5408\u540c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5408\u540c\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        for (PurchaseContractItem item : purchaseContractItemList) {
            PurchaseEnquiryItemDTO purchaseEnquiryItemDB;
            if (item.getQuantity() == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u7269\u6599\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (BigDecimal.valueOf(0L).compareTo(item.getQuantity()) != -1) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLcWRxOXUSEUW_ef00365f", (String)"\u7269\u6599\u884c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0"));
            }
            String sourceType = item.getSourceType();
            BigDecimal realQuantity = null;
            if (ContractItemSourceTypeEnum.PURCHAS_REQUEST.getValue().equals(sourceType)) {
                PurchaseRequestItemDTO requestItemById = this.contractInvokeInquiryRpcService.getRequestItemById(item.getSourceItemId());
                if (requestItemById != null) {
                    realQuantity = requestItemById.getQuantity();
                }
            } else if (ContractItemSourceTypeEnum.ORDER.getValue().equals(sourceType)) {
                PurchaseOrderItemDTO purchaseOrderItemDB = this.contractInvokeOrderRpcService.getItemById(item.getSourceItemId());
                if (purchaseOrderItemDB != null) {
                    realQuantity = purchaseOrderItemDB.getQuantity();
                }
            } else if (ContractItemSourceTypeEnum.BIDDING.getValue().equals(sourceType)) {
                PurchaseBiddingItemDTO purchaseBiddingItemDB = this.contractInvokeInquiryRpcService.getBiddingItemById(item.getSourceItemId());
                if (purchaseBiddingItemDB != null) {
                    realQuantity = purchaseBiddingItemDB.getRequireQuantity();
                }
            } else if (ContractItemSourceTypeEnum.EBIDDING.getValue().equals(sourceType)) {
                PurchaseEbiddingHeadDTO dbHead = this.contractInvokeInquiryRpcService.getEbiddingHeadById(item.getSourceId());
                String DUTCH = "2";
                String SINGLE = "1";
                if (dbHead != null && DUTCH.equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && SINGLE.equals(dbHead.getEbiddingWay())) {
                    PurchaseEbiddingItemHisDTO purchaseBiddingItemHisDB = this.contractInvokeInquiryRpcService.getEbiddingItemHisById(item.getSourceItemId());
                    if (purchaseBiddingItemHisDB != null) {
                        realQuantity = purchaseBiddingItemHisDB.getRequireQuantity();
                    }
                } else {
                    PurchaseEbiddingItemDTO purchaseEbiddingItemDB = this.contractInvokeInquiryRpcService.getEbiddingItemById(item.getSourceItemId());
                    if (purchaseEbiddingItemDB != null) {
                        realQuantity = purchaseEbiddingItemDB.getRequireQuantity();
                    }
                }
            } else if (ContractItemSourceTypeEnum.ENQUIRY.getValue().equals(sourceType) && (purchaseEnquiryItemDB = this.contractInvokeInquiryRpcService.getEnquiryItemById(item.getSourceItemId())) != null) {
                realQuantity = purchaseEnquiryItemDB.getRequireQuantity();
            }
            if (realQuantity == null || realQuantity.compareTo(item.getQuantity()) != -1) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLcWRBRefR_d1161058", (String)"\u7269\u6599\u884c\u6570\u91cf\u8d85\u8fc7\u6700\u5927\u503c"));
        }
        List<PurchaseContractItem> itemList = this.purchaseContractItemMapper.selectByMainId(purchaseContractHead.getId());
        if (!CollectionUtils.isEmpty(itemList)) {
            List stringList = itemList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            MqUtil.sendIntegrateDataLinkMsg(null, stringList, null);
        }
        this.purchaseContractItemMapper.deleteByMainId(purchaseContractHead.getId());
        this.purchaseContractContentItemMapper.deleteByMainId(purchaseContractHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseContractHead.getId());
        this.purchaseContractPromiseMapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom1Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom2Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom3Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom4Mapper.deleteByMainId(purchaseContractHead.getId());
        this.contractItemCustom5Mapper.deleteByMainId(purchaseContractHead.getId());
        this.insertData(purchaseContractHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
        this.sendLink(purchaseContractHead, purchaseContractItemList);
    }

    private void sendLink(PurchaseContractHead headVO, List<PurchaseContractItem> itemList) {
        JSONArray objects = new JSONArray();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        JSONObject object = new JSONObject();
        if (headVO != null) {
            object.put("integratedId", (Object)headVO.getDocumentId());
            object.put("elsAccount", (Object)TenantContext.getTenant());
            object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("businessType", (Object)"contract");
            object.put("businessParentType", null);
            object.put("businessId", (Object)headVO.getId());
            object.put("businessParentId", (Object)headVO.getDocumentParentId());
            object.put("businessDataType", (Object)"head");
            objects.add((Object)object);
        }
        if (!CollectionUtils.isEmpty(itemList)) {
            for (PurchaseContractItem item : itemList) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("integratedId", (Object)item.getDocumentItemId());
                objectItem.put("elsAccount", (Object)TenantContext.getTenant());
                objectItem.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("businessType", (Object)"contract");
                objectItem.put("businessParentType", null);
                objectItem.put("businessId", (Object)item.getId());
                objectItem.put("businessParentId", (Object)item.getDocumentParentId());
                objectItem.put("businessDataType", (Object)"item");
                objects.add((Object)objectItem);
            }
        }
        if (!objects.isEmpty()) {
            MqUtil.sendIntegrateDataLinkMsg((JSONArray)objects, null, null);
        }
    }

    private void insertData(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItemList, List<PurchaseContractContentItem> purchaseContractContentItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseContractPromise> purchaseContractPromiseList, List<ContractItemCustom1> contractItemCustom1List, List<ContractItemCustom2> contractItemCustom2List, List<ContractItemCustom3> contractItemCustom3List, List<ContractItemCustom4> contractItemCustom4List, List<ContractItemCustom5> contractItemCustom5List) {
        int count;
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            count = 1;
            for (PurchaseContractItem purchaseContractItem : purchaseContractItemList) {
                purchaseContractItem.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractItem, (BaseEntity)purchaseContractHead);
                purchaseContractItem.setElsAccount(TenantContext.getTenant());
                purchaseContractItem.setItemNumber("" + count);
                purchaseContractItem.setId(null);
                ++count;
            }
            if (!purchaseContractItemList.isEmpty()) {
                this.purchaseContractItemMapper.insertBatchSomeColumn(purchaseContractItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseContractContentItemList)) {
            count = 1;
            for (PurchaseContractContentItem purchaseContractContentItem : purchaseContractContentItemList) {
                purchaseContractContentItem.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractContentItem, (BaseEntity)purchaseContractHead);
                purchaseContractContentItem.setElsAccount(TenantContext.getTenant());
                purchaseContractContentItem.setItemNumber(count);
                purchaseContractContentItem.setId(null);
                ++count;
            }
            if (!purchaseContractContentItemList.isEmpty()) {
                this.purchaseContractContentItemMapper.insertBatchSomeColumn(purchaseContractContentItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(purchaseContractHead.getId());
                purchaseAttachmentDTO.setRelationId(IdWorker.getIdStr());
                purchaseAttachmentDTO.setUploadElsAccount(purchaseAttachmentDTO.getUploadElsAccount());
                purchaseAttachmentDTO.setBusinessType(purchaseAttachmentDTO.getBusinessType());
                purchaseAttachmentDTO.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseContractHead);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            for (PurchaseContractPromise purchaseContractPromise : purchaseContractPromiseList) {
                purchaseContractPromise.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseContractPromise, (BaseEntity)purchaseContractHead);
                purchaseContractPromise.setElsAccount(TenantContext.getTenant());
                purchaseContractPromise.setId(null);
            }
            if (!purchaseContractPromiseList.isEmpty()) {
                this.purchaseContractPromiseMapper.insertBatchSomeColumn(purchaseContractPromiseList);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                contractItemCustom1.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom1, (BaseEntity)purchaseContractHead);
                contractItemCustom1.setContractNumber(purchaseContractHead.getContractNumber());
                contractItemCustom1.setElsAccount(TenantContext.getTenant());
                contractItemCustom1.setId(null);
                if (!CollectionUtil.isNotEmpty(purchaseContractItemList)) continue;
                String string = contractItemCustom1.getPrecedence();
                if (ContractTypeEnum.NORMAL.getValue().equals(purchaseContractHead.getContractType())) {
                    this.calculateNormalItemCustom1(purchaseContractHead, contractItemCustom1, string);
                    continue;
                }
                if (!ContractTypeEnum.FRAME.getValue().equals(purchaseContractHead.getContractType())) continue;
                this.calculateFrameItemCustom1(purchaseContractHead, contractItemCustom1, string);
            }
            if (!contractItemCustom1List.isEmpty()) {
                this.contractItemCustom1Mapper.insertBatchSomeColumn(contractItemCustom1List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom2List)) {
            for (ContractItemCustom2 contractItemCustom2 : contractItemCustom2List) {
                contractItemCustom2.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom2, (BaseEntity)purchaseContractHead);
                contractItemCustom2.setElsAccount(TenantContext.getTenant());
                contractItemCustom2.setId(null);
            }
            if (!contractItemCustom2List.isEmpty()) {
                this.contractItemCustom2Mapper.insertBatchSomeColumn(contractItemCustom2List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom3List)) {
            for (ContractItemCustom3 contractItemCustom3 : contractItemCustom3List) {
                contractItemCustom3.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom3, (BaseEntity)purchaseContractHead);
                contractItemCustom3.setElsAccount(TenantContext.getTenant());
                contractItemCustom3.setId(null);
            }
            if (!contractItemCustom3List.isEmpty()) {
                this.contractItemCustom3Mapper.insertBatchSomeColumn(contractItemCustom3List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom4List)) {
            for (ContractItemCustom4 contractItemCustom4 : contractItemCustom4List) {
                contractItemCustom4.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom4, (BaseEntity)purchaseContractHead);
                contractItemCustom4.setElsAccount(TenantContext.getTenant());
                contractItemCustom4.setId(null);
            }
            if (!contractItemCustom4List.isEmpty()) {
                this.contractItemCustom4Mapper.insertBatchSomeColumn(contractItemCustom4List);
            }
        }
        if (!CollectionUtils.isEmpty(contractItemCustom5List)) {
            for (ContractItemCustom5 contractItemCustom5 : contractItemCustom5List) {
                contractItemCustom5.setHeadId(purchaseContractHead.getId());
                SysUtil.setSysParam((BaseEntity)contractItemCustom5, (BaseEntity)purchaseContractHead);
                contractItemCustom5.setElsAccount(TenantContext.getTenant());
                contractItemCustom5.setId(null);
            }
            if (!contractItemCustom5List.isEmpty()) {
                this.contractItemCustom5Mapper.insertBatchSomeColumn(contractItemCustom5List);
            }
        }
    }

    private void calculateFrameItemCustom1(PurchaseContractHead purchaseContractHead, ContractItemCustom1 entity, String precedence) {
        boolean flag;
        boolean bl = flag = purchaseContractHead.getTargetQuantity() != null && new BigDecimal(purchaseContractHead.getTargetQuantity()).compareTo(BigDecimal.ZERO) != 0;
        if (!flag) {
            return;
        }
        if (!StrUtil.isBlank((CharSequence)precedence)) {
            String performanceRatio = entity.getPerformanceRatio();
            if (ContractCalculatePrecedenceEnum.PERFORMANCE_RATIO.getValue().equals(precedence) && !StrUtil.isBlank((CharSequence)performanceRatio)) {
                String performanceRatioStr = entity.getPerformanceRatio().replace("%", "");
                BigDecimal amount = new BigDecimal(purchaseContractHead.getTargetQuantity()).multiply(new BigDecimal(performanceRatioStr)).multiply(new BigDecimal("0.01"));
                entity.setAmount(amount);
                entity.setPerformanceRatio(new BigDecimal(performanceRatioStr).setScale(3, 1).toString());
            } else if (ContractCalculatePrecedenceEnum.AMOUNT.getValue().equals(precedence) && entity.getAmount() != null) {
                BigDecimal divide = entity.getAmount().multiply(new BigDecimal(100)).divide(new BigDecimal(purchaseContractHead.getTargetQuantity()), 6, 4);
                entity.setPerformanceRatio(divide.toString());
            }
        } else if (entity.getAmount() != null) {
            BigDecimal divide = entity.getAmount().multiply(new BigDecimal(100)).divide(new BigDecimal(purchaseContractHead.getTargetQuantity()), 6, 4);
            entity.setPerformanceRatio(divide.toString());
        }
    }

    private void calculateNormalItemCustom1(PurchaseContractHead purchaseContractHead, ContractItemCustom1 entity, String precedence) {
        boolean flag;
        boolean bl = flag = purchaseContractHead.getTotalTaxAmount() != null && purchaseContractHead.getTotalTaxAmount().compareTo(BigDecimal.ZERO) != 0;
        if (!flag) {
            return;
        }
        if (!StrUtil.isBlank((CharSequence)precedence)) {
            String performanceRatio = entity.getPerformanceRatio();
            if (ContractCalculatePrecedenceEnum.PERFORMANCE_RATIO.getValue().equals(precedence) && !StrUtil.isBlank((CharSequence)performanceRatio)) {
                String performanceRatioStr = entity.getPerformanceRatio().replace("%", "");
                BigDecimal amount = purchaseContractHead.getTotalTaxAmount().multiply(new BigDecimal(performanceRatioStr)).multiply(new BigDecimal("0.01"));
                entity.setAmount(amount);
                entity.setPerformanceRatio(new BigDecimal(performanceRatioStr).setScale(3, 1).toString());
            } else if (ContractCalculatePrecedenceEnum.AMOUNT.getValue().equals(precedence) && entity.getAmount() != null) {
                BigDecimal divide = entity.getAmount().multiply(new BigDecimal(100)).divide(purchaseContractHead.getTotalTaxAmount(), 6, 4);
                entity.setPerformanceRatio(divide.toString());
            }
        } else if (entity.getAmount() != null) {
            BigDecimal divide = entity.getAmount().multiply(new BigDecimal(100)).divide(purchaseContractHead.getTotalTaxAmount(), 6, 4);
            entity.setPerformanceRatio(divide.toString());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseContractItemMapper.deleteByMainId(id);
        this.purchaseContractContentItemMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseContractPromiseMapper.deleteByMainId(id);
        this.contractItemCustom1Mapper.deleteByMainId(id);
        this.contractItemCustom2Mapper.deleteByMainId(id);
        this.contractItemCustom3Mapper.deleteByMainId(id);
        this.contractItemCustom4Mapper.deleteByMainId(id);
        this.contractItemCustom5Mapper.deleteByMainId(id);
        this.purchaseContractHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseContractItemMapper.deleteByMainId(serializable.toString());
            this.purchaseContractContentItemMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseContractPromiseMapper.deleteByMainId(serializable.toString());
            this.contractItemCustom1Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom2Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom3Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom4Mapper.deleteByMainId(serializable.toString());
            this.contractItemCustom5Mapper.deleteByMainId(serializable.toString());
            this.purchaseContractHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        PurchaseContractHead buyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseContractContentItem> contractBuyContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        List<PurchaseContractItem> contractBuyItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseContractHead updateBuyHead = new PurchaseContractHead();
        if (StrUtil.isNotBlank((CharSequence)buyHead.getSupplement()) && buyHead.getSupplement().equals("1")) {
            updateBuyHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
        } else {
            updateBuyHead.setContractStatus(ContractStatusEnum.CONTRACT_CONFIRMING.getValue());
        }
        updateBuyHead.setId(id);
        int count = this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        SaleContractHead saleHead = new SaleContractHead();
        BeanUtils.copyProperties((Object)((Object)buyHead), (Object)((Object)saleHead));
        if (StrUtil.isNotBlank((CharSequence)buyHead.getSupplement()) && buyHead.getSupplement().equals("1")) {
            saleHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
        } else {
            saleHead.setContractStatus(ContractStatusEnum.CONTRACT_CONFIRMING.getValue());
        }
        saleHead.setRelationId(id);
        if (StrUtil.isBlank((CharSequence)buyHead.getRelationId())) {
            saleHead.setId(null);
            saleHead.setElsAccount(buyHead.getToElsAccount());
            saleHead.setToElsAccount(buyHead.getElsAccount());
            this.saleContractHeadMapper.insert((Object)saleHead);
        } else {
            saleHead.setId(buyHead.getRelationId());
            saleHead.setToElsAccount(buyHead.getElsAccount());
            saleHead.setElsAccount(buyHead.getToElsAccount());
            this.saleContractHeadMapper.updateById((Object)saleHead);
            this.saleContractContentItemMapper.deleteByMainId(buyHead.getRelationId());
            this.saleContractItemMapper.deleteByMainId(buyHead.getRelationId());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseContractHead::getRelationId, (Object)saleHead.getId())).eq(BaseEntity::getId, (Object)id)).update((Object)new PurchaseContractHead());
        this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleHead.getId());
        ArrayList<SaleContractContentItem> saleContentItemList = new ArrayList<SaleContractContentItem>();
        for (PurchaseContractContentItem purchaseContractContentItem : contractBuyContentItemList) {
            SaleContractContentItem saleItem = new SaleContractContentItem();
            BeanUtils.copyProperties((Object)((Object)purchaseContractContentItem), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleContentItemList.add(saleItem);
        }
        if (!saleContentItemList.isEmpty()) {
            this.saleContractContentItemMapper.insertBatchSomeColumn(saleContentItemList);
        }
        ArrayList<SaleContractItem> saleItemList = new ArrayList<SaleContractItem>();
        for (PurchaseContractItem item : contractBuyItemList) {
            SaleContractItem saleItem = new SaleContractItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItemList.add(saleItem);
        }
        if (!saleItemList.isEmpty()) {
            this.saleContractItemMapper.insertBatchSomeColumn(saleItemList);
        }
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            ArrayList<SaleAttachmentDTO> arrayList = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : purchaseAttachmentList) {
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(purchaseAttachment.getRelationId());
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(buyHead.getToElsAccount());
                saleAttachment.setHeadId(saleHead.getId());
                arrayList.add(saleAttachment);
            }
            if (CollectionUtil.isNotEmpty(arrayList)) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(arrayList);
            }
        }
        super.sendMessage(TenantContext.getTenant(), "contract", "publish", id, "contractBusDataServiceImpl", Arrays.asList(buyHead.getToElsAccount()));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void upgradeVersion(String id) {
        PurchaseContractHead buyHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchaseContractContentItem> contractBuyContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        List<PurchaseContractItem> contractBuyItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseContractHead updateHead = new PurchaseContractHead();
        updateHead.setId(id);
        updateHead.setContractStatus(ContractStatusEnum.CHANGE_UN_PUBLISH.getValue());
        updateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        updateHead.setFlowId("");
        String contractVersion = buyHead.getContractVersion();
        if (StrUtil.isBlank((CharSequence)contractVersion)) {
            int version = 1;
            updateHead.setContractVersion("" + version);
        } else {
            updateHead.setContractVersion(contractVersion);
        }
        PurchaseContractHeadHis buyHeadHis = new PurchaseContractHeadHis();
        BeanUtils.copyProperties((Object)((Object)buyHead), (Object)((Object)buyHeadHis));
        buyHeadHis.setId(null);
        buyHeadHis.setContractId(id);
        updateHead.setContractVersion("" + (Integer.parseInt(updateHead.getContractVersion()) + 1));
        this.purchaseContractHeadMapper.updateById((Object)updateHead);
        this.purchaseContractHeadHisMapper.insert((Object)buyHeadHis);
        ArrayList<PurchaseContractContentItemHis> contentItemHisList = new ArrayList<PurchaseContractContentItemHis>();
        for (PurchaseContractContentItem item : contractBuyContentItemList) {
            PurchaseContractContentItemHis itemHis = new PurchaseContractContentItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(buyHeadHis.getId());
            contentItemHisList.add(itemHis);
        }
        if (!contentItemHisList.isEmpty()) {
            this.purchaseContractContentItemHisMapper.insertBatchSomeColumn(contentItemHisList);
        }
        ArrayList<PurchaseContractItemHis> itemHisList = new ArrayList<PurchaseContractItemHis>();
        for (PurchaseContractItem item : contractBuyItemList) {
            PurchaseContractItemHis itemHis = new PurchaseContractItemHis();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)itemHis));
            itemHis.setId(null);
            itemHis.setHeadId(buyHeadHis.getId());
            itemHisList.add(itemHis);
        }
        if (!itemHisList.isEmpty()) {
            this.purchaseContractItemHisMapper.insertBatchSomeColumn(itemHisList);
        }
        if (!CollectionUtils.isEmpty((Collection)purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setHeadId(buyHeadHis.getId());
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)buyHeadHis);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    public void copy(PurchaseContractHeadVO id) {
        PurchaseContractHead purchaseBiddingHead = (PurchaseContractHead)((Object)SysUtil.copyProperties((Object)((Object)id), PurchaseContractHead.class));
        this.builderHead(purchaseBiddingHead);
        List<PurchaseContractItem> purchaseContractItemList = id.getPurchaseContractItemList();
        purchaseContractItemList.forEach(item -> item.setId(null));
        List<PurchaseContractContentItem> purchaseContractContentItemList = id.getPurchaseContractContentItemList();
        purchaseContractContentItemList.forEach(item -> item.setId(null));
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentList = new ArrayList<PurchaseAttachmentDTO>();
        ArrayList<PurchaseContractPromise> purchaseContractPromiseList = new ArrayList<PurchaseContractPromise>();
        purchaseContractPromiseList.forEach(item -> item.setId(null));
        List<ContractItemCustom1> contractItemCustom1List = id.getContractItemCustom1List();
        contractItemCustom1List.forEach(item -> item.setId(null));
        List<ContractItemCustom2> contractItemCustom2List = id.getContractItemCustom2List();
        contractItemCustom2List.forEach(item -> item.setId(null));
        List<ContractItemCustom3> contractItemCustom3List = id.getContractItemCustom3List();
        contractItemCustom3List.forEach(item -> item.setId(null));
        List<ContractItemCustom4> contractItemCustom4List = id.getContractItemCustom4List();
        contractItemCustom4List.forEach(item -> item.setId(null));
        List<ContractItemCustom5> contractItemCustom5List = id.getContractItemCustom5List();
        contractItemCustom5List.forEach(item -> item.setId(null));
        this.saveMain(purchaseBiddingHead, purchaseContractItemList, purchaseContractContentItemList, purchaseAttachmentList, purchaseContractPromiseList, contractItemCustom1List, contractItemCustom2List, contractItemCustom3List, contractItemCustom4List, contractItemCustom5List);
    }

    public void builderHead(PurchaseContractHead purchaseContractHead) {
        purchaseContractHead.setId(null);
        purchaseContractHead.setContractNumber(null);
        purchaseContractHead.setCreateBy(null);
        purchaseContractHead.setCreateById(null);
        purchaseContractHead.setCreateTime(null);
        purchaseContractHead.setUpdateBy(null);
        purchaseContractHead.setUpdateById(null);
        purchaseContractHead.setUpdateTime(null);
        purchaseContractHead.setContractVersion("1");
        purchaseContractHead.setAuditStatus("0");
        purchaseContractHead.setContractStatus("1");
        purchaseContractHead.setRefundRemark(null);
        purchaseContractHead.setAuditRemark(null);
        purchaseContractHead.setFlowId(null);
        purchaseContractHead.setStartSign(null);
        purchaseContractHead.setEndSign(null);
        purchaseContractHead.setRelationId(null);
        purchaseContractHead.setSaleRemark(null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseContractHead head) {
        PurchaseContractHead updateBuyHead = new PurchaseContractHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setContractStatus(head.getContractStatus());
        this.purchaseContractHeadMapper.updateById((Object)updateBuyHead);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(SaleContractHead::getRelationId, (Object)head.getId())).set(SaleContractHead::getContractStatus, (Object)head.getContractStatus());
        this.saleContractHeadMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseOrderHeadDTO> createOrderByItems(PurchaseContractHeadVO headVO) {
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        List<PurchaseContractItem> collect = purchaseContractItemList.parallelStream().filter(p -> !"order".equals(p.getSourceType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LLRIDwjLItjcSWcdILV_4958ac37", (String)"\u4e3a\u60a8\u8fc7\u6ee4\u6389\u6765\u6e90\u4e3a\u8ba2\u5355\u7684\u884c\u540e,\u884c\u9879\u76ee\u4e3a\u7a7a"));
        }
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)((PurchaseContractItem)((Object)collect.get(0))).getHeadId())));
        List idList = collect.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = new PurchaseOrderHeadDTO();
        List<PurchaseOrderItemDTO> purchaseOrderItemDTOListNew = this.contractToOrderOnItem(byId, collect, null);
        ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanDTOS = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
        if (CollectionUtil.isNotEmpty(purchaseOrderItemDTOListNew)) {
            int deliveryItemCount = 1;
            for (PurchaseOrderItemDTO orderItem : purchaseOrderItemDTOListNew) {
                if (!StrUtil.isNotBlank((CharSequence)orderItem.getJit()) && !"0".equals(orderItem.getJit())) continue;
                PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
                orderDeliveryPlan.setItemNumber("" + deliveryItemCount);
                orderDeliveryPlan.setOrderItemNumber(orderItem.getItemNumber());
                orderDeliveryPlan.setQuantity(orderItem.getQuantity());
                orderDeliveryPlan.setPlanDeliveryQuantity(orderItem.getQuantity());
                orderDeliveryPlan.setPlanDeliveryDate(orderItem.getRequireDate());
                orderDeliveryPlan.setRequireDate(orderItem.getRequireDate());
                ++deliveryItemCount;
                purchaseOrderDeliveryPlanDTOS.add(orderDeliveryPlan);
            }
        }
        BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseOrderHeadDTO);
        purchaseOrderHeadDTO.setTemplateAccount(headVO.getTemplateAccount());
        purchaseOrderHeadDTO.setTemplateName(headVO.getTemplateName());
        purchaseOrderHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        purchaseOrderHeadDTO.setTemplateVersion(headVO.getTemplateVersion());
        purchaseOrderHeadDTO.setContractNumber(byId.getContractNumber());
        purchaseOrderHeadDTO.setContractName(byId.getContractName());
        if (ContractTargetTypeEnum.MONEY.getValue().equals(byId.getTargetType())) {
            purchaseOrderHeadDTO.setSourceType(OrderSourceTypeEnum.AMOUNT_CONTRACT.getValue());
        } else {
            purchaseOrderHeadDTO.setSourceType(OrderSourceTypeEnum.WORTH_CONTRACT.getValue());
        }
        purchaseOrderHeadDTO.setId(null);
        purchaseOrderHeadDTO.setRelationId(null);
        purchaseOrderHeadDTO.setCreateBy(null);
        purchaseOrderHeadDTO.setCreateById(null);
        purchaseOrderHeadDTO.setCreateTime(null);
        purchaseOrderHeadDTO.setUpdateBy(null);
        purchaseOrderHeadDTO.setUpdateTime(null);
        SupplierMasterDataDTO byAccount = this.contractInvokeSupplierRpcService.getByAccount(byId.getElsAccount(), byId.getToElsAccount());
        if (byAccount != null) {
            purchaseOrderHeadDTO.setIsTeamwork(byAccount.getNeedCoordination());
        }
        purchaseOrderHeadDTO = this.contractInvokeOrderRpcService.contractCreateOrder(purchaseOrderHeadDTO, purchaseOrderItemDTOListNew, purchaseOrderDeliveryPlanDTOS);
        return Arrays.asList(purchaseOrderHeadDTO);
    }

    @Override
    public List<PurchaseContractHead> generateContract(List<PurchaseContractHead> headList, List<PurchaseContractItem> itemList, List<PurchaseContractContentItem> purchaseContractLibraries, List<PurchaseAttachmentDTO> purchaseAttachmentDTOList) {
        ArrayList<PurchaseContractHead> arrayList = new ArrayList<PurchaseContractHead>();
        if (headList != null && !CollectionUtil.isEmpty(headList)) {
            Map collect = headList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map<String, List> collectItem = null;
            if (itemList != null) {
                collectItem = itemList.stream().collect(Collectors.toMap(PurchaseContractItem::getHeadId, p -> {
                    ArrayList<PurchaseContractItem> getNameList = new ArrayList<PurchaseContractItem>();
                    getNameList.add((PurchaseContractItem)((Object)p));
                    return getNameList;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
            }
            Map<String, List> collectConten = null;
            if (purchaseContractLibraries != null) {
                collectConten = purchaseContractLibraries.stream().collect(Collectors.toMap(PurchaseContractContentItem::getHeadId, p -> {
                    ArrayList<PurchaseContractContentItem> getNameList = new ArrayList<PurchaseContractContentItem>();
                    getNameList.add((PurchaseContractContentItem)((Object)p));
                    return getNameList;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
            }
            Map collectAttachment = null;
            if (purchaseAttachmentDTOList != null) {
                purchaseAttachmentDTOList.stream().collect(Collectors.toMap(PurchaseAttachmentDTO::getHeadId, p -> {
                    ArrayList<PurchaseAttachmentDTO> getNameList = new ArrayList<PurchaseAttachmentDTO>();
                    getNameList.add((PurchaseAttachmentDTO)p);
                    return getNameList;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
            }
            for (String next : collect.keySet()) {
                PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)collect.get(next));
                List purchaseContractItems = collectItem != null && collectItem.containsKey(next) ? collectItem.get(next) : null;
                List purchaseContractContentItems = collectConten != null && collectConten.containsKey(next) ? collectConten.get(next) : null;
                List attachmentDTOS = collectAttachment != null && collectAttachment.containsKey(next) ? (List)collectAttachment.get(next) : null;
                this.saveMain(purchaseContractHead, purchaseContractItems, purchaseContractContentItems, attachmentDTOS, null, null, null, null, null, null);
                arrayList.add(purchaseContractHead);
            }
        }
        return arrayList;
    }

    private List<PurchaseOrderItemDTO> contractToOrderOnItem(PurchaseContractHead purchaseContractHead, List<PurchaseContractItem> purchaseContractItems, List<PurchaseOrderItemDTO> purchaseOrderItemDTOList) {
        ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
        int count = 1;
        List<String> collect = purchaseContractItems.parallelStream().map(PurchaseContractItem::getMaterialId).distinct().collect(Collectors.toList());
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.contractInvokeMainDataRpcService.listByMaterialIds(collect);
        Map<Object, Object> itemMaterialMap = new HashMap();
        if (CollectionUtil.isNotEmpty(purchaseMaterialHeadDTOS)) {
            itemMaterialMap = purchaseMaterialHeadDTOS.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        }
        for (PurchaseContractItem purchaseContractItem : purchaseContractItems) {
            BigDecimal targetQuantity = purchaseContractItem.getTargetQuantity();
            BigDecimal targetQuantityArry = BigDecimal.ZERO;
            PurchaseOrderItemDTO purchaseOrderItemDTO = new PurchaseOrderItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)purchaseOrderItemDTO);
            PurchaseMaterialHeadDTO materialHeadDTO = (PurchaseMaterialHeadDTO)itemMaterialMap.get(purchaseContractItem.getMaterialId());
            if (materialHeadDTO != null) {
                purchaseOrderItemDTO.setCateCode(materialHeadDTO.getCateCode());
                purchaseOrderItemDTO.setCateName(materialHeadDTO.getCateName());
                purchaseOrderItemDTO.setMaterialGroup(materialHeadDTO.getMaterialGroup());
                purchaseOrderItemDTO.setMaterialSpec(materialHeadDTO.getMaterialSpec());
                purchaseOrderItemDTO.setPurchaseCycle(materialHeadDTO.getPurchaseCycle());
                purchaseOrderItemDTO.setPurchaseUnit(materialHeadDTO.getPurchaseUnit());
                purchaseOrderItemDTO.setJit(materialHeadDTO.getJit());
                purchaseOrderItemDTO.setCheckQuality(materialHeadDTO.getCheckQuality());
            }
            purchaseOrderItemDTO.setId(null);
            purchaseOrderItemDTO.setHeadId(null);
            purchaseOrderItemDTO.setCreateBy(null);
            purchaseOrderItemDTO.setCreateById(null);
            purchaseOrderItemDTO.setItemNumber("" + count);
            purchaseOrderItemDTO.setCreateTime(null);
            purchaseOrderItemDTO.setUpdateBy(null);
            purchaseOrderItemDTO.setUpdateTime(null);
            purchaseOrderItemDTO.setSourceNumber(purchaseContractHead.getContractNumber());
            if (ContractTargetTypeEnum.MONEY.getValue().equals(purchaseContractHead.getTargetType())) {
                purchaseOrderItemDTO.setSourceType(OrderSourceTypeEnum.AMOUNT_CONTRACT.getValue());
            } else {
                purchaseOrderItemDTO.setSourceType(OrderSourceTypeEnum.WORTH_CONTRACT.getValue());
            }
            purchaseOrderItemDTO.setSourceItemNumber(purchaseContractItem.getItemNumber());
            purchaseOrderItemDTO.setSourceId(purchaseContractHead.getId());
            purchaseOrderItemDTO.setSourceItemId(purchaseContractItem.getId());
            purchaseOrderItemList.add(purchaseOrderItemDTO);
            ++count;
        }
        return purchaseOrderItemList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseContractPromiseVO> createPromiseByItems(PurchaseContractHeadVO headVO) {
        List<ContractItemCustom1> contractItemCustom1List = headVO.getContractItemCustom1List();
        if (CollUtil.isNotEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                contractItemCustom1.getPerformanceRatio();
            }
        }
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        String id = "";
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            id = contractItemCustom1List.get(0).getHeadId();
        }
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            id = purchaseContractItemList.get(0).getHeadId();
        }
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)id)));
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        templateHeadDTO.setElsAccount(headVO.getTemplateAccount());
        List<PurchaseContractPromiseVO> purchaseContractPromises = this.contractPromiseParam(templateHeadDTO, byId, contractItemCustom1List, purchaseContractItemList);
        purchaseContractPromises.forEach(item -> this.purchaseContractPromiseService.saveMain((PurchaseContractPromise)((Object)item), item.getPurchasePromiseItemList()));
        List<PurchaseContractPromise> purchaseContractPromiseList = this.purchaseContractPromiseService.selectByMainId(id);
        purchaseContractPromiseList = purchaseContractPromiseList.stream().filter(pro -> !Arrays.asList(ContractPromiseStatusEnum.CANCEL.getValue(), ContractPromiseStatusEnum.REFUND.getValue()).contains(pro.getPromiseStatus())).collect(Collectors.toList());
        BigDecimal checkRatio = BigDecimal.ZERO;
        BigDecimal checkAmt = BigDecimal.ZERO;
        BigDecimal targetValue = new BigDecimal(100);
        List stateList = purchaseContractPromiseList.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getStage())).map(x -> Integer.valueOf(x.getStage())).sorted().collect(Collectors.toList());
        Integer i = 1;
        for (Integer state : stateList) {
            if (state.equals(i - 1)) continue;
            Assert.isTrue((boolean)state.equals(i), (String)I18nUtil.translate((String)"i18n_field_xOHRvLqIZ_f8f7d704", (String)"\u4e0d\u80fd\u8de8\u8fc7\u91cc\u7a0b\u7891\u5c65\u7ea6"), (Object[])new Object[0]);
            Integer n = i;
            i = i + 1;
        }
        for (PurchaseContractPromise purchaseContractPromise : purchaseContractPromiseList) {
            BigDecimal performanceRatio = new BigDecimal(purchaseContractPromise.getPerformanceRatio().replace("%", ""));
            checkRatio = checkRatio.add(performanceRatio);
            checkAmt = checkAmt.add(purchaseContractPromise.getAmount());
            Assert.isTrue((BigDecimalUtils.lessEqual((BigDecimal)checkRatio, (BigDecimal)targetValue) && BigDecimalUtils.lessEqual((BigDecimal)checkAmt, (BigDecimal)byId.getTotalTaxAmount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_IZlvfu100SIZHffUneEVHjxfHfxiTbLnRneIZt_e20eff18", (String)"\u5c65\u7ea6\u6bd4\u4f8b\u8fbe\u5230100%\u6216\u5c65\u7ea6\u91d1\u989d\u5927\u4e8e\u5408\u540c\u884c\u4fe1\u606f\u7684\u542b\u7a0e\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u91c7\u8d2d\u5408\u540c\u5c65\u7ea6\u5355"), (Object[])new Object[0]);
        }
        return purchaseContractPromises;
    }

    @Override
    public PurchaseContractHead queryByContractNumber(String contractNumber) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseContractHead::getContractNumber, (Object)contractNumber);
        return (PurchaseContractHead)((Object)((PurchaseContractHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public IPage<PurchaseContractHead> getListAllPurchaseContractHeadIPage(Page<PurchaseContractHead> page, QueryWrapper<PurchaseContractHead> queryWrapper) {
        return ((PurchaseContractHeadMapper)this.baseMapper).getListAllPurchaseContractHeadIPage(page, queryWrapper);
    }

    @Override
    public JSONObject getContractDataById(String id) {
        PurchaseContractHeadVO purchaseContractHeadVO = this.getMessageById(id);
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseContractHeadVO, new DictTranslateAspectParam());
    }

    @Override
    public JSONArray getContractDataById(List<String> ids) {
        JSONArray array = new JSONArray();
        DictTranslateAspectParam param = new DictTranslateAspectParam();
        ids.forEach(id -> {
            JSONObject obj = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)this.getMessageById((String)id), param);
            array.add((Object)obj);
        });
        return array;
    }

    @Override
    public JSONArray getContractDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseContractHead::getContractNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        List purchaseContractHeads = ((PurchaseContractHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        JSONArray array = new JSONArray();
        DictTranslateAspectParam param = new DictTranslateAspectParam();
        purchaseContractHeads.forEach(item -> {
            JSONObject obj = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)this.getMessageById(item.getId()), param);
            array.add((Object)obj);
        });
        return array;
    }

    @Override
    public List<PurchaseInformationRecordsDTO> createPriceByItems(PurchaseContractHeadVO headVO) {
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setElsAccount(headVO.getTemplateAccount());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        PurchaseContractHead byId = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)headVO.getId())));
        List<PurchaseContractItem> purchaseContractItemList = headVO.getPurchaseContractItemList();
        List collect = purchaseContractItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseContractItems = this.purchaseContractItemMapper.selectBatchIds(collect);
        return this.contractInvokeMainDataRpcService.generatePrice(templateHeadDTO, byId, purchaseContractItems);
    }

    @Override
    public List<PurchaseContractHead> selectTenderContractBySubpackageId(String subpackageId, List<String> supplierAccountList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseContractHead::getSubpackageId, (Object)subpackageId);
        queryWrapper.in(PurchaseContractHead::getToElsAccount, supplierAccountList);
        return ((PurchaseContractHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public IPage<PurchaseContractHead> listByAccept(Page<PurchaseContractHead> page, QueryWrapper<PurchaseContractHead> queryWrapper) {
        return ((PurchaseContractHeadMapper)this.baseMapper).listByAccept(page, queryWrapper);
    }

    @Override
    public String checkClose(PurchaseContractHeadVO head) {
        List<PurchaseContractPromise> purchaseContractPromiseList = this.purchaseContractPromiseMapper.selectByMainId(head.getId());
        String promiseNumber = purchaseContractPromiseList.stream().filter(x -> !Arrays.asList(ContractPromiseStatusEnum.CANCEL.getValue()).contains(x.getPromiseStatus())).map(x -> x.getPromiseNumber()).collect(Collectors.joining("\uff0c"));
        List<PurchaseOrderHeadDTO> purchaseOrderHeadDTOS = this.contractInvokeOrderRpcService.queryOrderByContractNumberAndId(head.getContractNumber(), head.getId());
        String orderNumber = null;
        if (CollUtil.isNotEmpty(purchaseOrderHeadDTOS)) {
            orderNumber = purchaseOrderHeadDTOS.stream().map(x -> x.getOrderNumber()).distinct().collect(Collectors.joining("\uff0c"));
        }
        if (StrUtil.isBlank((CharSequence)promiseNumber) && StrUtil.isBlank(orderNumber)) {
            return null;
        }
        return (StrUtil.isNotBlank((CharSequence)promiseNumber) ? String.format("\u5df2\u6709\u5c65\u7ea6\u5355\u636e\uff1a[%s]", promiseNumber) : "") + (StrUtil.isNotBlank(orderNumber) ? String.format("\u5df2\u6709\u8ba2\u5355\u5355\u636e\uff1a[%s]", orderNumber) : "") + "\uff0c\u662f\u5426\u786e\u8ba4\u5173\u95ed\u5408\u540c\uff1f";
    }

    private PurchaseContractHeadVO getMessageById(String id) {
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseContractHeadVO purchaseContractHeadVO = new PurchaseContractHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHead), (Object)((Object)purchaseContractHeadVO));
        List<PurchaseContractItem> purchaseContractItemList = this.purchaseContractItemMapper.selectByMainId(id);
        List<PurchaseContractContentItem> purchaseContractContentItemList = this.purchaseContractContentItemMapper.selectByMainId(id);
        purchaseContractHeadVO.setPurchaseContractContentItemList(purchaseContractContentItemList);
        List<PurchaseContractPromise> purchaseContractPromiseList = this.purchaseContractPromiseService.selectByMainId(id);
        List<PurchaseContractPromise> collect1 = purchaseContractPromiseList.parallelStream().filter(item -> ContractPromiseStatusEnum.CONFIRMED.getValue().equals(item.getPromiseStatus())).collect(Collectors.toList());
        purchaseContractHeadVO.setPurchaseContractPromiseList(collect1);
        List<ContractItemCustom1> contractItemCustom1List = this.contractItemCustom1Mapper.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom1List(contractItemCustom1List);
        List<ContractItemCustom2> contractItemCustom2List = this.contractItemCustom2Mapper.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom2List(contractItemCustom2List);
        List<ContractItemCustom3> contractItemCustom3List = this.contractItemCustom3Mapper.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom3List(contractItemCustom3List);
        List<ContractItemCustom4> contractItemCustom4List = this.contractItemCustom4Mapper.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom4List(contractItemCustom4List);
        List<ContractItemCustom5> contractItemCustom5List = this.contractItemCustom5Mapper.selectByMainId(id);
        purchaseContractHeadVO.setContractItemCustom5List(contractItemCustom5List);
        purchaseContractHeadVO.setPurchaseContractItemList(purchaseContractItemList);
        return purchaseContractHeadVO;
    }

    private List<PurchaseContractPromiseVO> contractPromiseParam(TemplateHeadDTO templateHeadDTO, PurchaseContractHead purchaseContractHead, List<ContractItemCustom1> contractItemCustom1List, List<PurchaseContractItem> purchaseContractItemList) {
        ArrayList<PurchaseContractPromiseVO> contractPromiseArrayList = new ArrayList<PurchaseContractPromiseVO>();
        Map exchangeRateDTOMap = this.contractInvokeMainDataRpcService.getEffectiveRateByCurrencys(Arrays.asList(purchaseContractHead.getCurrency())).parallelStream().collect(Collectors.toMap(dto -> dto.getOriginalCurrency() + "_" + dto.getTargetCurrency(), Function.identity(), (o1, o2) -> o2));
        if (!CollectionUtils.isEmpty(purchaseContractItemList)) {
            PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
            purchaseContractPromise.setSourceType(ContractPromiseSourceTypeEnum.ITEM.getValue());
            purchaseContractPromise.setTemplateAccount(templateHeadDTO.getElsAccount());
            purchaseContractPromise.setTemplateName(templateHeadDTO.getTemplateName());
            purchaseContractPromise.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            purchaseContractPromise.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
            purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
            purchaseContractPromise.setContractName(purchaseContractHead.getContractName());
            purchaseContractPromise.setContractDesc(purchaseContractHead.getContractDesc());
            purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
            if (ContractTypeEnum.NORMAL.getValue().equals(purchaseContractHead.getContractType())) {
                purchaseContractPromise.setContractAmount(purchaseContractHead.getTotalTaxAmount());
                purchaseContractPromise.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
            } else if (ContractTypeEnum.FRAME.getValue().equals(purchaseContractHead.getContractType())) {
                purchaseContractPromise.setContractAmount(new BigDecimal(purchaseContractHead.getTargetQuantity()));
                if (StrUtil.isBlank((CharSequence)purchaseContractHead.getTargetType())) {
                    purchaseContractPromise.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
                } else {
                    purchaseContractPromise.setTargetType(purchaseContractHead.getTargetType());
                }
            }
            purchaseContractPromise.setPurchasePrincipal(purchaseContractHead.getPurchasePrincipal());
            purchaseContractPromise.setSalePrincipal(purchaseContractHead.getSalePrincipal());
            purchaseContractPromise.setBusAccount(TenantContext.getTenant());
            purchaseContractPromise.setCreateAccount(TenantContext.getTenant());
            purchaseContractPromise.setHeadId(purchaseContractHead.getId());
            purchaseContractPromise.setPurchaseOrg(purchaseContractHead.getPurchaseOrg());
            purchaseContractPromise.setPurchaseGroup(purchaseContractHead.getPurchaseGroup());
            purchaseContractPromise.setCompany(purchaseContractHead.getCompany());
            purchaseContractPromise.setPurchasePrincipal(purchaseContractHead.getPurchasePrincipal());
            purchaseContractPromise.setCurreny(purchaseContractHead.getCurrency());
            purchaseContractPromise.setLocalCurrency(purchaseContractHead.getLocalCurrency());
            if (purchaseContractHead.getCurrency().equals(purchaseContractHead.getLocalCurrency())) {
                purchaseContractPromise.setExchangeRate("1");
            } else if (exchangeRateDTOMap.containsKey(purchaseContractHead.getCurrency() + "_" + purchaseContractHead.getLocalCurrency())) {
                BpExchangeRateDTO rateDTO = (BpExchangeRateDTO)exchangeRateDTOMap.get(purchaseContractHead.getCurrency() + "_" + purchaseContractHead.getLocalCurrency());
                purchaseContractPromise.setExchangeRate(rateDTO.getExchanged().toPlainString());
            }
            ArrayList<PurchasePromiseItem> purchasePromiseItemList = new ArrayList<PurchasePromiseItem>();
            for (PurchaseContractItem purchaseContractItem : purchaseContractItemList) {
                PurchasePromiseItem purchasePromiseItem = new PurchasePromiseItem();
                BeanUtils.copyProperties((Object)((Object)purchaseContractItem), (Object)((Object)purchasePromiseItem));
                purchasePromiseItem.setSourceItemId(purchaseContractItem.getId());
                purchasePromiseItem.setHeadId(null);
                purchasePromiseItem.setId(null);
                purchasePromiseItem.setItemNumber(purchaseContractItem.getItemNumber());
                purchasePromiseItem.setCreateBy(null);
                purchasePromiseItem.setCreateById(null);
                purchasePromiseItem.setCreateTime(null);
                purchasePromiseItem.setUpdateBy(null);
                purchasePromiseItem.setUpdateById(null);
                purchasePromiseItem.setUpdateTime(null);
                purchasePromiseItem.setCurreny(purchaseContractItem.getCurrency());
                purchasePromiseItem.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchasePromiseItem.setContractNumber(purchaseContractHead.getContractNumber());
                purchasePromiseItem.setContractName(purchaseContractHead.getContractName());
                purchasePromiseItem.setContractDesc(purchaseContractHead.getContractDesc());
                if ("quantity".equals(purchaseContractHead.getTargetType())) {
                    purchasePromiseItem.setAmount(purchaseContractItem.getTargetQuantity());
                } else {
                    purchasePromiseItem.setAmount(purchaseContractItem.getTaxAmount());
                }
                purchasePromiseItemList.add(purchasePromiseItem);
            }
            purchaseContractPromise.setPurchasePromiseItemList(purchasePromiseItemList);
            if (!CollectionUtils.isEmpty(purchasePromiseItemList)) {
                BigDecimal targetQuantityArry = BigDecimal.ZERO;
                targetQuantityArry = purchasePromiseItemList.parallelStream().filter(p -> p.getAmount() != null).map(PurchasePromiseItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseContractPromise.setAmount(targetQuantityArry);
            }
            contractPromiseArrayList.add(purchaseContractPromise);
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            Date planFinishDate = contractItemCustom1List.stream().map(ContractItemCustom1::getPlanFinishDate).filter(Objects::nonNull).max(Comparator.naturalOrder()).get();
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                PurchaseContractPromiseVO purchaseContractPromise = new PurchaseContractPromiseVO();
                purchaseContractPromise.setTemplateAccount(templateHeadDTO.getElsAccount());
                purchaseContractPromise.setTemplateName(templateHeadDTO.getTemplateName());
                purchaseContractPromise.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                purchaseContractPromise.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
                purchaseContractPromise.setSourceType(ContractPromiseSourceTypeEnum.MILESTONE.getValue());
                purchaseContractPromise.setContractNumber(purchaseContractHead.getContractNumber());
                purchaseContractPromise.setContractName(purchaseContractHead.getContractName());
                purchaseContractPromise.setContractDesc(purchaseContractHead.getContractDesc());
                purchaseContractPromise.setTargetType(purchaseContractHead.getTargetType());
                purchaseContractPromise.setStage(contractItemCustom1.getStage());
                purchaseContractPromise.setStageName(contractItemCustom1.getStageName());
                purchaseContractPromise.setSourceItemId(contractItemCustom1.getId());
                purchaseContractPromise.setHeadId(contractItemCustom1.getHeadId());
                purchaseContractPromise.setBusAccount(TenantContext.getTenant());
                purchaseContractPromise.setCreateAccount(TenantContext.getTenant());
                purchaseContractPromise.setToElsAccount(purchaseContractHead.getToElsAccount());
                purchaseContractPromise.setAmount(contractItemCustom1.getAmount());
                if (StrUtil.isNotBlank((CharSequence)purchaseContractHead.getTargetQuantity())) {
                    purchaseContractPromise.setContractAmount(new BigDecimal(purchaseContractHead.getTargetQuantity()));
                } else if (purchaseContractHead.getTotalTaxAmount() != null) {
                    purchaseContractPromise.setContractAmount(purchaseContractHead.getTotalTaxAmount());
                } else {
                    purchaseContractPromise.setContractAmount(BigDecimal.ZERO);
                }
                purchaseContractPromise.setPerformanceMatters(contractItemCustom1.getPerformanceMatters());
                purchaseContractPromise.setPlanFinishDate(planFinishDate);
                purchaseContractPromise.setLedgerAccount(purchaseContractHead.getLedgerAccount());
                purchaseContractPromise.setCostCenter(purchaseContractHead.getCostCenter());
                contractPromiseArrayList.add(purchaseContractPromise);
            }
        }
        return contractPromiseArrayList;
    }
}

