/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.BigDecimalUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.SaleContractContentItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.entity.SalePromiseItem;
import com.els.modules.contract.enumerate.ContractPromiseSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.enumerate.ContractTypeEnum;
import com.els.modules.contract.mapper.PurchaseContractContentItemMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractItemMapper;
import com.els.modules.contract.mapper.SaleContractContentItemMapper;
import com.els.modules.contract.mapper.SaleContractHeadMapper;
import com.els.modules.contract.mapper.SaleContractItemMapper;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.vo.SaleContractHeadVO;
import com.els.modules.contract.vo.SaleContractPromiseVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleContractHeadServiceImpl
extends BaseServiceImpl<SaleContractHeadMapper, SaleContractHead>
implements SaleContractHeadService {
    @Resource
    private SaleContractHeadMapper saleContractHeadMapper;
    @Resource
    private SaleContractItemMapper saleContractItemMapper;
    @Resource
    private SaleContractContentItemMapper saleContractContentItemMapper;
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Resource
    private PurchaseContractItemMapper purchaseContractItemMapper;
    @Resource
    private PurchaseContractContentItemMapper purchaseContractContentItemMapper;
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleContractHead saleContractHead, List<SaleContractItem> saleContractItemList, List<SaleContractContentItem> saleContractContentItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleContractHeadMapper.insert((Object)saleContractHead);
        this.insertData(saleContractHead, saleContractItemList, saleContractContentItemList, saleAttachmentList);
        this.checkContractPromise(saleContractHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleContractHead saleContractHead, List<SaleContractItem> saleContractItemList, List<SaleContractContentItem> saleContractContentItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleContractHeadMapper.updateById((Object)saleContractHead);
        this.saleContractItemMapper.deleteByMainId(saleContractHead.getId());
        this.saleContractContentItemMapper.deleteByMainId(saleContractHead.getId());
        this.insertData(saleContractHead, saleContractItemList, saleContractContentItemList, saleAttachmentList);
        this.checkContractPromise(saleContractHead);
    }

    private void insertData(SaleContractHead saleContractHead, List<SaleContractItem> saleContractItemList, List<SaleContractContentItem> saleContractContentItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        for (SaleContractItem saleContractItem : saleContractItemList) {
            saleContractItem.setHeadId(saleContractHead.getId());
            SysUtil.setSysParam((BaseEntity)saleContractItem, (BaseEntity)saleContractHead);
        }
        if (!saleContractItemList.isEmpty()) {
            this.saleContractItemMapper.insertBatchSomeColumn(saleContractItemList);
        }
        for (SaleContractContentItem saleContractContentItem : saleContractContentItemList) {
            saleContractContentItem.setHeadId(saleContractHead.getId());
            SysUtil.setSysParam((BaseEntity)saleContractContentItem, (BaseEntity)saleContractHead);
        }
        if (!saleContractContentItemList.isEmpty()) {
            this.saleContractContentItemMapper.insertBatchSomeColumn(saleContractContentItemList);
        }
        if (!CollectionUtils.isEmpty(saleAttachmentList)) {
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentList) {
                saleAttachmentDTO.setId(null);
                saleAttachmentDTO.setHeadId(saleContractHead.getId());
                saleAttachmentDTO.setUploadElsAccount(saleContractHead.getElsAccount());
                saleAttachmentDTO.setBusinessType("contract");
                saleAttachmentDTO.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)saleAttachmentDTO, (BaseEntity)saleContractHead);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleContractItemMapper.deleteByMainId(id);
        this.saleContractContentItemMapper.deleteByMainId(id);
        this.saleContractHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmedMain(String id, String saleRemark) {
        this.publishPurchase(id, ContractStatusEnum.CONFIRMED.getValue(), null, saleRemark);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void refundMain(String id, String refundRemark, String saleRemark) {
        this.publishPurchase(id, ContractStatusEnum.REFUND.getValue(), refundRemark, saleRemark);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishPurchase(String id, String status, String refundRemark, String saleRemark) {
        SaleContractHead saleHead = (SaleContractHead)((Object)this.saleContractHeadMapper.selectById((Serializable)((Object)id)));
        if (ContractStatusEnum.CANCEL.getValue().equals(saleHead.getContractStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_contractDisabled", (String)"\u5408\u540c\u5df2\u4f5c\u5e9f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\uff01"));
        }
        List<SaleContractContentItem> saleContractContentItems = this.saleContractContentItemMapper.selectByMainId(id);
        List<SaleContractItem> saleContractItems = this.saleContractItemMapper.selectByMainId(id);
        List saleAttachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        String urlParam = "id=" + saleHead.getRelationId();
        String opt = null;
        SaleContractHead updateBuyHead = new SaleContractHead();
        if (status.equals(ContractStatusEnum.CONFIRMED.getValue())) {
            updateBuyHead.setContractStatus(ContractStatusEnum.CONFIRMED.getValue());
            updateBuyHead.setId(id);
            opt = "confirm";
            if (StrUtil.isNotBlank((CharSequence)refundRemark)) {
                updateBuyHead.setRefundRemark(refundRemark);
            }
            if (StrUtil.isNotBlank((CharSequence)saleRemark)) {
                updateBuyHead.setSaleRemark(saleRemark);
            }
        } else if (status.equals(ContractStatusEnum.REFUND.getValue())) {
            updateBuyHead.setContractStatus(ContractStatusEnum.REFUND.getValue());
            updateBuyHead.setId(id);
            opt = "refund";
            if (StrUtil.isNotBlank((CharSequence)refundRemark)) {
                updateBuyHead.setRefundRemark(refundRemark);
            }
            if (StrUtil.isNotBlank((CharSequence)saleRemark)) {
                updateBuyHead.setSaleRemark(saleRemark);
            }
        } else if (status.equals(ContractStatusEnum.CLOSED.getValue())) {
            updateBuyHead.setContractStatus(ContractStatusEnum.CLOSED.getValue());
            updateBuyHead.setId(id);
            opt = "close";
            if (StrUtil.isNotBlank((CharSequence)refundRemark)) {
                updateBuyHead.setRefundRemark(refundRemark);
            }
            if (StrUtil.isNotBlank((CharSequence)saleRemark)) {
                updateBuyHead.setSaleRemark(saleRemark);
            }
        }
        if (Integer.parseInt(saleHead.getContractType()) == 1 || Integer.parseInt(saleHead.getContractType()) == 2) {
            super.sendMessage(saleHead.getBusAccount(), "contract", opt, saleHead.getId(), "contractBusDataServiceImpl", Arrays.asList(saleHead.getToElsAccount()));
        } else {
            super.sendMessage(saleHead.getBusAccount(), "contractSimple", opt, saleHead.getId(), "contractBusDataServiceImpl", Arrays.asList(saleHead.getToElsAccount()));
        }
        this.saleContractHeadMapper.updateById((Object)updateBuyHead);
        PurchaseContractHead purchaseHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)saleHead), (Object)((Object)purchaseHead));
        if (!StrUtil.isBlank((CharSequence)updateBuyHead.getSaleRemark())) {
            purchaseHead.setSaleRemark(updateBuyHead.getSaleRemark());
        }
        purchaseHead.setContractStatus(updateBuyHead.getContractStatus());
        purchaseHead.setRelationId(id);
        purchaseHead.setRefundRemark(refundRemark);
        if (StrUtil.isBlank((CharSequence)saleHead.getRelationId())) {
            purchaseHead.setId(null);
            purchaseHead.setElsAccount(saleHead.getToElsAccount());
            this.purchaseContractHeadMapper.insert((Object)purchaseHead);
        } else {
            purchaseHead.setId(saleHead.getRelationId());
            purchaseHead.setElsAccount(saleHead.getBusAccount());
            purchaseHead.setToElsAccount(saleHead.getElsAccount());
            this.purchaseContractHeadMapper.updateById((Object)purchaseHead);
            this.purchaseContractContentItemMapper.deleteByMainId(saleHead.getRelationId());
            this.purchaseContractItemMapper.deleteByMainId(saleHead.getRelationId());
        }
        ArrayList<PurchaseContractContentItem> purchaseContractContentItemList = new ArrayList<PurchaseContractContentItem>();
        for (SaleContractContentItem saleContractContentItem : saleContractContentItems) {
            PurchaseContractContentItem purchaseContractContentItem = new PurchaseContractContentItem();
            BeanUtils.copyProperties((Object)((Object)saleContractContentItem), (Object)((Object)purchaseContractContentItem));
            purchaseContractContentItem.setId(null);
            purchaseContractContentItem.setElsAccount(purchaseHead.getElsAccount());
            purchaseContractContentItem.setHeadId(purchaseHead.getId());
            purchaseContractContentItemList.add(purchaseContractContentItem);
        }
        if (!purchaseContractContentItemList.isEmpty()) {
            this.purchaseContractContentItemMapper.insertBatchSomeColumn(purchaseContractContentItemList);
        }
        ArrayList<PurchaseContractItem> purchaseContractItemList = new ArrayList<PurchaseContractItem>();
        for (SaleContractItem item : saleContractItems) {
            PurchaseContractItem purchaseContractItem = new PurchaseContractItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseContractItem));
            purchaseContractItem.setId(null);
            purchaseContractItem.setElsAccount(purchaseHead.getElsAccount());
            purchaseContractItem.setHeadId(purchaseHead.getId());
            purchaseContractItemList.add(purchaseContractItem);
        }
        if (!purchaseContractItemList.isEmpty()) {
            this.purchaseContractItemMapper.insertBatchSomeColumn(purchaseContractItemList);
        }
        ArrayList<PurchaseAttachmentDTO> arrayList = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO item : saleAttachments) {
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)item, (Object)purchaseAttachment);
            item.setSendStatus("1");
            purchaseAttachment.setElsAccount(purchaseHead.getElsAccount());
            purchaseAttachment.setHeadId(purchaseHead.getId());
            arrayList.add(purchaseAttachment);
        }
        if (!arrayList.isEmpty()) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseHead.getId());
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(arrayList);
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleContractItemMapper.deleteByMainId(serializable.toString());
            this.saleContractContentItemMapper.deleteByMainId(serializable.toString());
            this.saleContractHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<SaleContractPromiseVO> createPromiseByItems(SaleContractHeadVO headVO) {
        List<ContractItemCustom1> contractItemCustom1List = headVO.getContractItemCustom1List();
        List<SaleContractItem> saleContractItemList = headVO.getPurchaseContractItemList();
        String id = "";
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)contractItemCustom1List.get(0).getHeadId())));
            id = purchaseContractHead.getRelationId();
        }
        if (!CollectionUtils.isEmpty(saleContractItemList)) {
            id = saleContractItemList.get(0).getHeadId();
        }
        SaleContractHead byId = (SaleContractHead)((Object)this.getById((Serializable)((Object)id)));
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        templateHeadDTO.setElsAccount(headVO.getTemplateAccount());
        List<SaleContractPromiseVO> saleContractPromiseVOS = this.contractPromiseParam(templateHeadDTO, byId, contractItemCustom1List, saleContractItemList);
        saleContractPromiseVOS.forEach(item -> this.saleContractPromiseService.saveMain((SaleContractPromise)((Object)item), item.getPurchasePromiseItemList()));
        this.checkContractPromise(byId);
        return saleContractPromiseVOS;
    }

    private void checkContractPromise(SaleContractHead saleContractHead) {
        List<SaleContractPromise> saleContractPromisesList = this.saleContractPromiseService.selectByMainId(saleContractHead.getId());
        saleContractPromisesList = saleContractPromisesList.stream().filter(pro -> !Arrays.asList(ContractPromiseStatusEnum.CANCEL.getValue(), ContractPromiseStatusEnum.REFUND.getValue()).contains(pro.getPromiseStatus())).collect(Collectors.toList());
        BigDecimal checkRatio = BigDecimal.ZERO;
        BigDecimal checkAmt = BigDecimal.ZERO;
        BigDecimal targetValue = new BigDecimal(100);
        List stateList = saleContractPromisesList.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getStage())).map(x -> Integer.valueOf(x.getStage())).sorted().collect(Collectors.toList());
        Integer i = 1;
        for (Integer state : stateList) {
            if (state.equals(i - 1)) continue;
            Assert.isTrue((boolean)state.equals(i), (String)I18nUtil.translate((String)"i18n_field_xOHRvLqIZ_f8f7d704", (String)"\u4e0d\u80fd\u8de8\u8fc7\u91cc\u7a0b\u7891\u5c65\u7ea6"), (Object[])new Object[0]);
            Integer n = i;
            i = i + 1;
        }
        for (SaleContractPromise purchaseContractPromise : saleContractPromisesList) {
            BigDecimal performanceRatio = new BigDecimal(purchaseContractPromise.getPerformanceRatio().replace("%", ""));
            checkRatio = checkRatio.add(performanceRatio);
            checkAmt = checkAmt.add(purchaseContractPromise.getAmount());
            Assert.isTrue((BigDecimalUtils.lessEqual((BigDecimal)checkRatio, (BigDecimal)targetValue) && BigDecimalUtils.lessEqual((BigDecimal)checkAmt, (BigDecimal)saleContractHead.getTotalTaxAmount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_IZlvfu100SIZHffUneEVHjxfHfxiTbLnRneIZt_e20eff18", (String)"\u5c65\u7ea6\u6bd4\u4f8b\u8fbe\u5230100%\u6216\u5c65\u7ea6\u91d1\u989d\u5927\u4e8e\u5408\u540c\u884c\u4fe1\u606f\u7684\u542b\u7a0e\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u91c7\u8d2d\u5408\u540c\u5c65\u7ea6\u5355"), (Object[])new Object[0]);
        }
    }

    @Override
    public SaleContractHead queryByContractNumber(String contractNumber) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SaleContractHead::getContractNumber, (Object)contractNumber);
        return (SaleContractHead)((Object)((SaleContractHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public void confirmedClose(String id, String saleRemark) {
        this.publishPurchase(id, ContractStatusEnum.CLOSED.getValue(), null, saleRemark);
    }

    @Override
    public IPage<SaleContractHead> listByAccept(Page<SaleContractHead> page, QueryWrapper<SaleContractHead> queryWrapper) {
        return ((SaleContractHeadMapper)this.baseMapper).listByAccept(page, queryWrapper);
    }

    private List<SaleContractPromiseVO> contractPromiseParam(TemplateHeadDTO templateHeadDTO, SaleContractHead saleContractHead, List<ContractItemCustom1> contractItemCustom1List, List<SaleContractItem> saleContractItemList) {
        ArrayList<SaleContractPromiseVO> contractPromiseArrayList = new ArrayList<SaleContractPromiseVO>();
        if (!CollectionUtils.isEmpty(saleContractItemList)) {
            SaleContractPromiseVO saleContractPromiseVO = new SaleContractPromiseVO();
            saleContractPromiseVO.setSourceType(ContractPromiseSourceTypeEnum.ITEM.getValue());
            saleContractPromiseVO.setTemplateAccount(templateHeadDTO.getElsAccount());
            saleContractPromiseVO.setTemplateName(templateHeadDTO.getTemplateName());
            saleContractPromiseVO.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            saleContractPromiseVO.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
            saleContractPromiseVO.setContractAmount(saleContractHead.getTotalTaxAmount());
            saleContractPromiseVO.setContractNumber(saleContractHead.getContractNumber());
            saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
            if (ContractTypeEnum.NORMAL.getValue().equals(saleContractHead.getContractType())) {
                saleContractPromiseVO.setContractAmount(saleContractHead.getTotalTaxAmount());
                saleContractPromiseVO.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
            } else if (ContractTypeEnum.FRAME.getValue().equals(saleContractHead.getContractType())) {
                saleContractPromiseVO.setContractAmount(new BigDecimal(saleContractHead.getTargetQuantity()));
                if (StrUtil.isBlank((CharSequence)saleContractHead.getTargetType())) {
                    saleContractPromiseVO.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
                } else {
                    saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
                }
            }
            saleContractPromiseVO.setContractName(saleContractHead.getContractName());
            saleContractPromiseVO.setContractDesc(saleContractHead.getContractDesc());
            saleContractPromiseVO.setToElsAccount(saleContractHead.getToElsAccount());
            saleContractPromiseVO.setBusAccount(saleContractHead.getBusAccount());
            saleContractPromiseVO.setCreateAccount(TenantContext.getTenant());
            saleContractPromiseVO.setHeadId(saleContractHead.getId());
            ArrayList<SalePromiseItem> salePromiseItemList = new ArrayList<SalePromiseItem>();
            for (SaleContractItem saleContractItem : saleContractItemList) {
                SalePromiseItem salePromiseItem = new SalePromiseItem();
                BeanUtils.copyProperties((Object)((Object)saleContractItem), (Object)((Object)salePromiseItem));
                salePromiseItem.setSourceItemId(saleContractItem.getId());
                salePromiseItem.setHeadId(null);
                salePromiseItem.setId(null);
                salePromiseItem.setCreateBy(null);
                salePromiseItem.setCreateById(null);
                salePromiseItem.setCreateTime(null);
                salePromiseItem.setUpdateBy(null);
                salePromiseItem.setUpdateById(null);
                salePromiseItem.setUpdateTime(null);
                salePromiseItem.setToElsAccount(saleContractHead.getToElsAccount());
                salePromiseItem.setContractNumber(saleContractHead.getContractNumber());
                salePromiseItem.setContractName(saleContractHead.getContractName());
                salePromiseItem.setContractDesc(saleContractHead.getContractDesc());
                salePromiseItem.setAmount(saleContractItem.getTaxAmount());
                salePromiseItem.setCurreny(saleContractItem.getCurrency());
                if ("quantity".equals(saleContractHead.getTargetType())) {
                    salePromiseItem.setAmount(saleContractItem.getTargetQuantity());
                } else {
                    salePromiseItem.setAmount(saleContractItem.getTaxAmount());
                }
                salePromiseItemList.add(salePromiseItem);
            }
            saleContractPromiseVO.setPurchasePromiseItemList(salePromiseItemList);
            if (!CollectionUtils.isEmpty(salePromiseItemList)) {
                BigDecimal targetQuantityArry = BigDecimal.ZERO;
                targetQuantityArry = salePromiseItemList.parallelStream().filter(p -> p.getAmount() != null).map(SalePromiseItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                saleContractPromiseVO.setAmount(targetQuantityArry);
            }
            contractPromiseArrayList.add(saleContractPromiseVO);
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                SaleContractPromiseVO saleContractPromiseVO = new SaleContractPromiseVO();
                saleContractPromiseVO.setTemplateAccount(templateHeadDTO.getElsAccount());
                saleContractPromiseVO.setTemplateName(templateHeadDTO.getTemplateName());
                saleContractPromiseVO.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                saleContractPromiseVO.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
                saleContractPromiseVO.setSourceType(ContractPromiseSourceTypeEnum.MILESTONE.getValue());
                saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
                saleContractPromiseVO.setContractNumber(saleContractHead.getContractNumber());
                saleContractPromiseVO.setContractName(saleContractHead.getContractName());
                saleContractPromiseVO.setContractDesc(saleContractHead.getContractDesc());
                saleContractPromiseVO.setStage(contractItemCustom1.getStage());
                saleContractPromiseVO.setSourceItemId(contractItemCustom1.getId());
                saleContractPromiseVO.setHeadId(saleContractHead.getId());
                saleContractPromiseVO.setBusAccount(saleContractHead.getBusAccount());
                saleContractPromiseVO.setCreateAccount(TenantContext.getTenant());
                saleContractPromiseVO.setToElsAccount(saleContractHead.getToElsAccount());
                saleContractPromiseVO.setAmount(contractItemCustom1.getAmount());
                saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
                if (StrUtil.isNotBlank((CharSequence)saleContractHead.getTargetQuantity())) {
                    saleContractPromiseVO.setContractAmount(new BigDecimal(saleContractHead.getTargetQuantity()));
                } else if (saleContractHead.getTotalTaxAmount() != null) {
                    saleContractPromiseVO.setContractAmount(saleContractHead.getTotalTaxAmount());
                } else {
                    saleContractPromiseVO.setContractAmount(BigDecimal.ZERO);
                }
                saleContractPromiseVO.setPerformanceRatio(contractItemCustom1.getPerformanceRatio());
                saleContractPromiseVO.setPerformanceMatters(contractItemCustom1.getPerformanceMatters());
                contractPromiseArrayList.add(saleContractPromiseVO);
            }
        }
        return contractPromiseArrayList;
    }
}

